/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCampfire;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.Entity;

public class BlockCampfire
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<BlockCampfire> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("spawn_particles").forGetter(blockcampfire -> blockcampfire.i), (App)Codec.intRange((int)0, (int)1000).fieldOf("fire_damage").forGetter(blockcampfire -> blockcampfire.j), BlockCampfire.t()).apply((Applicative)instance, BlockCampfire::new));
    protected static final VoxelShape b = Block.a(0.0, 0.0, 0.0, 16.0, 7.0, 16.0);
    public static final BlockStateBoolean c = BlockProperties.r;
    public static final BlockStateBoolean d = BlockProperties.z;
    public static final BlockStateBoolean e = BlockProperties.D;
    public static final BlockStateEnum<EnumDirection> f = BlockProperties.S;
    private static final VoxelShape g = Block.a(6.0, 0.0, 6.0, 10.0, 16.0, 10.0);
    private static final int h = 5;
    private final boolean i;
    private final int j;

    public MapCodec<BlockCampfire> a() {
        return a;
    }

    public BlockCampfire(boolean emitsParticles, int fireDamage, BlockBase.Info settings) {
        super(settings);
        this.i = emitsParticles;
        this.j = fireDamage;
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.F.b().b(c, true)).b(d, false)).b(e, false)).b(f, EnumDirection.c));
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof TileEntityCampfire) {
            TileEntityCampfire tileentitycampfire = (TileEntityCampfire)tileentity;
            ItemStack itemstack1 = player.b(hand);
            if (world.P().a(RecipePropertySet.h).a(itemstack1)) {
                WorldServer worldserver;
                if (world instanceof WorldServer && tileentitycampfire.a(worldserver = (WorldServer)world, player, itemstack1)) {
                    player.a(StatisticList.av);
                    return EnumInteractionResult.b;
                }
                return EnumInteractionResult.c;
            }
        }
        return EnumInteractionResult.f;
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (state.c(c).booleanValue() && entity instanceof EntityLiving) {
            entity.a(world.aj().b().directBlock(world, pos), (float)this.j);
        }
        super.a(state, world, pos, entity);
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (!state.a(newState.b())) {
            TileEntity tileentity = world.c_(pos);
            if (tileentity instanceof TileEntityCampfire) {
                InventoryUtils.a(world, pos, ((TileEntityCampfire)tileentity).b());
            }
            super.a(state, world, pos, newState, moved);
        }
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext ctx) {
        BlockPosition blockposition;
        World world = ctx.q();
        boolean flag = world.b_(blockposition = ctx.a()).a() == FluidTypes.c;
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.m().b(e, flag)).b(d, this.o(world.a_(blockposition.e())))).b(c, !flag)).b(f, ctx.g());
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader world, ScheduledTickAccess tickView, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(e).booleanValue()) {
            tickView.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return direction == EnumDirection.a ? (IBlockData)state.b(d, this.o(neighborState)) : super.a(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    private boolean o(IBlockData state) {
        return state.a(Blocks.iA);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return b;
    }

    @Override
    protected EnumRenderType a_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
        if (state.c(c).booleanValue()) {
            if (random.a(10) == 0) {
                world.a((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, SoundEffects.dK, SoundCategory.e, 0.5f + random.i(), random.i() * 0.7f + 0.6f, false);
            }
            if (this.i && random.a(5) == 0) {
                for (int i2 = 0; i2 < random.a(1) + 1; ++i2) {
                    world.a(Particles.Z, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, (double)(random.i() / 2.0f), 5.0E-5, random.i() / 2.0f);
                }
            }
        }
    }

    public static void a(@Nullable net.minecraft.world.entity.Entity entity, GeneratorAccess world, BlockPosition pos, IBlockData state) {
        TileEntity tileentity;
        if (world.B_()) {
            for (int i2 = 0; i2 < 20; ++i2) {
                BlockCampfire.a((World)world, pos, state.c(d), true);
            }
        }
        if ((tileentity = world.c_(pos)) instanceof TileEntityCampfire) {
            ((TileEntityCampfire)tileentity).d();
        }
        world.a(entity, GameEvent.c, pos);
    }

    @Override
    public boolean a(GeneratorAccess world, BlockPosition pos, IBlockData state, Fluid fluidState) {
        if (!state.c(BlockProperties.D).booleanValue() && fluidState.a() == FluidTypes.c) {
            boolean flag = state.c(c);
            if (flag) {
                if (!world.B_()) {
                    world.a((EntityHuman)null, pos, SoundEffects.kz, SoundCategory.e, 1.0f, 1.0f);
                }
                BlockCampfire.a((net.minecraft.world.entity.Entity)null, world, pos, state);
            }
            world.a(pos, (IBlockData)((IBlockData)state.b(e, true)).b(c, false), 3);
            world.a(pos, fluidState.a(), fluidState.a().a(world));
            return true;
        }
        return false;
    }

    @Override
    protected void a(World world, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        BlockPosition blockposition = hit.b();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (projectile.bY() && projectile.c(worldserver, blockposition) && !state.c(c).booleanValue() && !state.c(e).booleanValue()) {
                if (CraftEventFactory.callBlockIgniteEvent(world, blockposition, projectile).isCancelled()) {
                    return;
                }
                world.a(blockposition, (IBlockData)state.b(BlockProperties.r, true), 11);
            }
        }
    }

    public static void a(World world, BlockPosition pos, boolean isSignal, boolean lotsOfSmoke) {
        RandomSource randomsource = world.H_();
        ParticleType particletype = isSignal ? Particles.av : Particles.au;
        world.b(particletype, true, (double)pos.u() + 0.5 + randomsource.j() / 3.0 * (double)(randomsource.h() ? 1 : -1), (double)pos.v() + randomsource.j() + randomsource.j(), (double)pos.w() + 0.5 + randomsource.j() / 3.0 * (double)(randomsource.h() ? 1 : -1), 0.0, 0.07, 0.0);
        if (lotsOfSmoke) {
            world.a(Particles.af, (double)pos.u() + 0.5 + randomsource.j() / 4.0 * (double)(randomsource.h() ? 1 : -1), (double)pos.v() + 0.4, (double)pos.w() + 0.5 + randomsource.j() / 4.0 * (double)(randomsource.h() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    public static boolean a(World world, BlockPosition pos) {
        for (int i2 = 1; i2 <= 5; ++i2) {
            BlockPosition blockposition1 = pos.c(i2);
            IBlockData iblockdata = world.a_(blockposition1);
            if (BlockCampfire.h(iblockdata)) {
                return true;
            }
            boolean flag = VoxelShapes.c(g, iblockdata.b((IBlockAccess)world, pos, VoxelShapeCollision.a()), OperatorBoolean.i);
            if (!flag) continue;
            IBlockData iblockdata1 = world.a_(blockposition1.e());
            return BlockCampfire.h(iblockdata1);
        }
        return false;
    }

    public static boolean h(IBlockData state) {
        return state.b(c) && state.a(TagsBlock.aX) && state.c(c) != false;
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(e) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(f, rotation.a(state.c(f)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(f)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(c, d, e, f);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityCampfire(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData state, TileEntityTypes<T> type) {
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (state.c(c).booleanValue()) {
                CraftingManager.a craftingmanager_a = CraftingManager.a(Recipes.e);
                return BlockCampfire.a(type, TileEntityTypes.H, (World world1, BlockPosition blockposition, IBlockData iblockdata1, ? super E tileentitycampfire) -> TileEntityCampfire.a(worldserver, blockposition, iblockdata1, tileentitycampfire, craftingmanager_a));
            }
            return BlockCampfire.a(type, TileEntityTypes.H, TileEntityCampfire::a);
        }
        return state.c(c) != false ? BlockCampfire.a(type, TileEntityTypes.H, TileEntityCampfire::b) : null;
    }

    @Override
    protected boolean a(IBlockData state, PathMode type) {
        return false;
    }

    public static boolean i(IBlockData state) {
        return state.a(TagsBlock.aX, (BlockBase.BlockData blockbase_blockdata) -> blockbase_blockdata.b(e) && blockbase_blockdata.b(c)) && state.c(e) == false && state.c(c) == false;
    }
}

