/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.slf4j.Logger;

public class BlockCommand
extends BlockTileEntity
implements GameMasterBlock {
    public static final MapCodec<BlockCommand> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("automatic").forGetter(blockcommand -> blockcommand.e), BlockCommand.t()).apply((Applicative)instance, BlockCommand::new));
    private static final Logger d = LogUtils.getLogger();
    public static final BlockStateEnum<EnumDirection> b = BlockDirectional.a;
    public static final BlockStateBoolean c = BlockProperties.c;
    private final boolean e;

    public MapCodec<BlockCommand> a() {
        return a;
    }

    public BlockCommand(boolean auto, BlockBase.Info settings) {
        super(settings);
        this.l((IBlockData)((IBlockData)this.F.b().b(b, EnumDirection.c)).b(c, false));
        this.e = auto;
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        TileEntityCommand tileentitycommand = new TileEntityCommand(pos, state);
        tileentitycommand.b(this.e);
        return tileentitycommand;
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
        TileEntity tileentity;
        if (!world.C && (tileentity = world.c_(pos)) instanceof TileEntityCommand) {
            TileEntityCommand tileentitycommand = (TileEntityCommand)tileentity;
            this.a(world, pos, tileentitycommand, world.C(pos));
        }
    }

    private void a(World world, BlockPosition pos, TileEntityCommand blockEntity, boolean powered) {
        boolean flag1 = blockEntity.c();
        org.bukkit.block.Block bukkitBlock = world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
        int old = flag1 ? 15 : 0;
        int current = powered ? 15 : 0;
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(bukkitBlock, old, current);
        world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        boolean bl = powered = eventRedstone.getNewCurrent() > 0;
        if (powered != flag1) {
            blockEntity.a(powered);
            if (powered) {
                if (blockEntity.d() || blockEntity.t() == TileEntityCommand.Type.a) {
                    return;
                }
                blockEntity.k();
                world.a(pos, (Block)this, 1);
            }
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof TileEntityCommand) {
            TileEntityCommand tileentitycommand = (TileEntityCommand)tileentity;
            CommandBlockListenerAbstract commandblocklistenerabstract = tileentitycommand.b();
            boolean flag = !UtilColor.b(commandblocklistenerabstract.m());
            TileEntityCommand.Type tileentitycommand_type = tileentitycommand.t();
            boolean flag1 = tileentitycommand.j();
            if (tileentitycommand_type == TileEntityCommand.Type.b) {
                tileentitycommand.k();
                if (flag1) {
                    this.a(state, world, pos, commandblocklistenerabstract, flag);
                } else if (tileentitycommand.u()) {
                    commandblocklistenerabstract.a(0);
                }
                if (tileentitycommand.c() || tileentitycommand.d()) {
                    world.a(pos, (Block)this, 1);
                }
            } else if (tileentitycommand_type == TileEntityCommand.Type.c) {
                if (flag1) {
                    this.a(state, world, pos, commandblocklistenerabstract, flag);
                } else if (tileentitycommand.u()) {
                    commandblocklistenerabstract.a(0);
                }
            }
            world.c(pos, this);
        }
    }

    private void a(IBlockData state, WorldServer world, BlockPosition pos, CommandBlockListenerAbstract executor, boolean hasCommand) {
        if (hasCommand) {
            executor.a(world);
        } else {
            executor.a(0);
        }
        BlockCommand.a(world, pos, state.c(b));
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hit) {
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof TileEntityCommand && (player.gG() || player.b() && player.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            player.a((TileEntityCommand)tileentity);
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World world, BlockPosition pos) {
        TileEntity tileentity = world.c_(pos);
        return tileentity instanceof TileEntityCommand ? ((TileEntityCommand)tileentity).b().k() : 0;
    }

    @Override
    public void a(World world, BlockPosition pos, IBlockData state, EntityLiving placer, ItemStack itemStack) {
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof TileEntityCommand) {
            TileEntityCommand tileentitycommand = (TileEntityCommand)tileentity;
            CommandBlockListenerAbstract commandblocklistenerabstract = tileentitycommand.b();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (!itemStack.b(DataComponents.Y)) {
                    commandblocklistenerabstract.a(worldserver.N().b(GameRules.p));
                    tileentitycommand.b(this.e);
                }
                boolean flag = world.C(pos);
                this.a(world, pos, tileentitycommand, flag);
            }
        }
    }

    @Override
    protected EnumRenderType a_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c);
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return (IBlockData)this.m().b(b, ctx.d().g());
    }

    private static void a(WorldServer world, BlockPosition pos, EnumDirection facing) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = pos.k();
        GameRules gamerules = world.N();
        int i2 = gamerules.c(GameRules.y);
        while (i2-- > 0) {
            TileEntityCommand tileentitycommand;
            TileEntity tileentity;
            blockposition_mutableblockposition.c(facing);
            IBlockData iblockdata = world.a_(blockposition_mutableblockposition);
            Block block = iblockdata.b();
            if (!iblockdata.a(Blocks.lc) || !((tileentity = world.c_(blockposition_mutableblockposition)) instanceof TileEntityCommand) || (tileentitycommand = (TileEntityCommand)tileentity).t() != TileEntityCommand.Type.a) break;
            if (tileentitycommand.c() || tileentitycommand.d()) {
                CommandBlockListenerAbstract commandblocklistenerabstract = tileentitycommand.b();
                if (tileentitycommand.k()) {
                    if (!commandblocklistenerabstract.a(world)) break;
                    world.c((BlockPosition)blockposition_mutableblockposition, block);
                } else if (tileentitycommand.u()) {
                    commandblocklistenerabstract.a(0);
                }
            }
            facing = iblockdata.c(b);
        }
        if (i2 <= 0) {
            int j2 = Math.max(gamerules.c(GameRules.y), 0);
            d.warn("Command Block chain tried to execute more than {} steps!", (Object)j2);
        }
    }
}

