/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRedstoneWire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.ticks.TickListPriority;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;

public abstract class BlockDiodeAbstract
extends BlockFacingHorizontal {
    protected static final VoxelShape c = Block.a(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    public static final BlockStateBoolean d = BlockProperties.x;

    protected BlockDiodeAbstract(BlockBase.Info settings) {
        super(settings);
    }

    protected abstract MapCodec<? extends BlockDiodeAbstract> a();

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return c;
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.e();
        return this.b(world, blockposition1, world.a_(blockposition1));
    }

    protected boolean b(IWorldReader world, BlockPosition pos, IBlockData state) {
        return state.a((IBlockAccess)world, pos, EnumDirection.b, EnumBlockSupport.c);
    }

    @Override
    protected void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (!this.c((IWorldReader)world, pos, state)) {
            boolean flag = state.c(d);
            boolean flag1 = this.a((World)world, pos, state);
            if (flag && !flag1) {
                if (CraftEventFactory.callRedstoneChange(world, pos, 15, 0).getNewCurrent() != 0) {
                    return;
                }
                world.a(pos, (IBlockData)state.b(d, false), 2);
            } else if (!flag) {
                if (CraftEventFactory.callRedstoneChange(world, pos, 0, 15).getNewCurrent() != 15) {
                    return;
                }
                world.a(pos, (IBlockData)state.b(d, true), 2);
                if (!flag1) {
                    world.a(pos, (Block)this, this.h(state), TickListPriority.b);
                }
            }
        }
    }

    @Override
    protected int b(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return state.a(world, pos, direction);
    }

    @Override
    protected int a(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return state.c(d) == false ? 0 : (state.c(BlockFacingHorizontal.aF) == direction ? this.a(world, pos, state) : 0);
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
        if (state.a((IWorldReader)world, pos)) {
            this.c(world, pos, state);
        } else {
            TileEntity tileentity = state.x() ? world.c_(pos) : null;
            BlockDiodeAbstract.a(state, world, pos, tileentity);
            world.a(pos, false);
            for (EnumDirection enumdirection : EnumDirection.values()) {
                world.a(pos.a(enumdirection), this);
            }
        }
    }

    protected void c(World world, BlockPosition pos, IBlockData state) {
        boolean flag1;
        boolean flag;
        if (!this.c((IWorldReader)world, pos, state) && (flag = state.c(d).booleanValue()) != (flag1 = this.a(world, pos, state)) && !world.T().b(pos, this)) {
            TickListPriority ticklistpriority = TickListPriority.c;
            if (this.b((IBlockAccess)world, pos, state)) {
                ticklistpriority = TickListPriority.a;
            } else if (flag) {
                ticklistpriority = TickListPriority.b;
            }
            world.a(pos, (Block)this, this.h(state), ticklistpriority);
        }
    }

    public boolean c(IWorldReader world, BlockPosition pos, IBlockData state) {
        return false;
    }

    protected boolean a(World world, BlockPosition pos, IBlockData state) {
        return this.b(world, pos, state) > 0;
    }

    protected int b(World world, BlockPosition pos, IBlockData state) {
        EnumDirection enumdirection = state.c(BlockFacingHorizontal.aF);
        BlockPosition blockposition1 = pos.a(enumdirection);
        int i2 = world.c(blockposition1, enumdirection);
        if (i2 >= 15) {
            return i2;
        }
        IBlockData iblockdata1 = world.a_(blockposition1);
        return Math.max(i2, iblockdata1.a(Blocks.cE) ? iblockdata1.c(BlockRedstoneWire.f) : 0);
    }

    protected int a(SignalGetter world, BlockPosition pos, IBlockData state) {
        EnumDirection enumdirection = state.c(BlockFacingHorizontal.aF);
        EnumDirection enumdirection1 = enumdirection.h();
        EnumDirection enumdirection2 = enumdirection.i();
        boolean flag = this.b();
        return Math.max(world.a(pos.a(enumdirection1), enumdirection1, flag), world.a(pos.a(enumdirection2), enumdirection2, flag));
    }

    @Override
    protected boolean f_(IBlockData state) {
        return true;
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return (IBlockData)this.m().b(BlockFacingHorizontal.aF, ctx.g().g());
    }

    @Override
    public void a(World world, BlockPosition pos, IBlockData state, EntityLiving placer, ItemStack itemStack) {
        if (this.a(world, pos, state)) {
            world.a(pos, (Block)this, 1);
        }
    }

    @Override
    protected void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        this.d(world, pos, state);
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (!moved && !state.a(newState.b())) {
            super.a(state, world, pos, newState, moved);
            this.d(world, pos, state);
        }
    }

    protected void d(World world, BlockPosition pos, IBlockData state) {
        EnumDirection enumdirection = state.c(BlockFacingHorizontal.aF);
        BlockPosition blockposition1 = pos.a(enumdirection.g());
        Orientation orientation = ExperimentalRedstoneUtils.a(world, enumdirection.g(), EnumDirection.b);
        world.b(blockposition1, this, orientation);
        world.a(blockposition1, (Block)this, enumdirection, orientation);
    }

    protected boolean b() {
        return false;
    }

    protected int a(IBlockAccess world, BlockPosition pos, IBlockData state) {
        return 15;
    }

    public static boolean n(IBlockData state) {
        return state.b() instanceof BlockDiodeAbstract;
    }

    public boolean b(IBlockAccess world, BlockPosition pos, IBlockData state) {
        EnumDirection enumdirection = state.c(BlockFacingHorizontal.aF).g();
        IBlockData iblockdata1 = world.a_(pos.a(enumdirection));
        return BlockDiodeAbstract.n(iblockdata1) && iblockdata1.c(BlockFacingHorizontal.aF) != enumdirection;
    }

    protected abstract int h(IBlockData var1);
}

