/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyWood;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class BlockFenceGate
extends BlockFacingHorizontal {
    public static final MapCodec<BlockFenceGate> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockPropertyWood.a.fieldOf("wood_type").forGetter(blockfencegate -> blockfencegate.H), BlockFenceGate.t()).apply((Applicative)instance, BlockFenceGate::new));
    public static final BlockStateBoolean b = BlockProperties.v;
    public static final BlockStateBoolean c = BlockProperties.x;
    public static final BlockStateBoolean d = BlockProperties.q;
    protected static final VoxelShape e = Block.a(0.0, 0.0, 6.0, 16.0, 16.0, 10.0);
    protected static final VoxelShape f = Block.a(6.0, 0.0, 0.0, 10.0, 16.0, 16.0);
    protected static final VoxelShape g = Block.a(0.0, 0.0, 6.0, 16.0, 13.0, 10.0);
    protected static final VoxelShape h = Block.a(6.0, 0.0, 0.0, 10.0, 13.0, 16.0);
    protected static final VoxelShape i = Block.a(0.0, 0.0, 6.0, 16.0, 24.0, 10.0);
    protected static final VoxelShape j = Block.a(6.0, 0.0, 0.0, 10.0, 24.0, 16.0);
    protected static final VoxelShape k = Block.a(0.0, 5.0, 6.0, 16.0, 24.0, 10.0);
    protected static final VoxelShape l = Block.a(6.0, 5.0, 0.0, 10.0, 24.0, 16.0);
    protected static final VoxelShape m = VoxelShapes.a(Block.a(0.0, 5.0, 7.0, 2.0, 16.0, 9.0), Block.a(14.0, 5.0, 7.0, 16.0, 16.0, 9.0));
    protected static final VoxelShape n = VoxelShapes.a(Block.a(7.0, 5.0, 0.0, 9.0, 16.0, 2.0), Block.a(7.0, 5.0, 14.0, 9.0, 16.0, 16.0));
    protected static final VoxelShape o = VoxelShapes.a(Block.a(0.0, 2.0, 7.0, 2.0, 13.0, 9.0), Block.a(14.0, 2.0, 7.0, 16.0, 13.0, 9.0));
    protected static final VoxelShape G = VoxelShapes.a(Block.a(7.0, 2.0, 0.0, 9.0, 13.0, 2.0), Block.a(7.0, 2.0, 14.0, 9.0, 13.0, 16.0));
    private final BlockPropertyWood H;

    public MapCodec<BlockFenceGate> a() {
        return a;
    }

    public BlockFenceGate(BlockPropertyWood type, BlockBase.Info settings) {
        super(settings.a(type.d()));
        this.H = type;
        this.l((IBlockData)((IBlockData)((IBlockData)this.F.b().b(b, false)).b(c, false)).b(d, false));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return state.c(d).booleanValue() ? (state.c(BlockFacingHorizontal.aF).o() == EnumDirection.EnumAxis.a ? h : g) : (state.c(BlockFacingHorizontal.aF).o() == EnumDirection.EnumAxis.a ? f : e);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader world, ScheduledTickAccess tickView, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        EnumDirection.EnumAxis enumdirection_enumaxis = direction.o();
        if (state.c(BlockFacingHorizontal.aF).h().o() != enumdirection_enumaxis) {
            return super.a(state, world, tickView, pos, direction, neighborPos, neighborState, random);
        }
        boolean flag = this.o(neighborState) || this.o(world.a_(pos.a(direction.g())));
        return (IBlockData)state.b(d, flag);
    }

    @Override
    protected VoxelShape b_(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return state.c(b) != false ? VoxelShapes.a() : (state.c(BlockFacingHorizontal.aF).o() == EnumDirection.EnumAxis.c ? k : l);
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return state.c(b) != false ? VoxelShapes.a() : (state.c(BlockFacingHorizontal.aF).o() == EnumDirection.EnumAxis.c ? i : j);
    }

    @Override
    protected VoxelShape d_(IBlockData state) {
        return state.c(d).booleanValue() ? (state.c(BlockFacingHorizontal.aF).o() == EnumDirection.EnumAxis.a ? G : o) : (state.c(BlockFacingHorizontal.aF).o() == EnumDirection.EnumAxis.a ? n : m);
    }

    @Override
    protected boolean a(IBlockData state, PathMode type) {
        switch (type) {
            case a: {
                return state.c(b);
            }
            case b: {
                return false;
            }
            case c: {
                return state.c(b);
            }
        }
        return false;
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        World world = ctx.q();
        BlockPosition blockposition = ctx.a();
        boolean flag = world.C(blockposition);
        EnumDirection enumdirection = ctx.g();
        EnumDirection.EnumAxis enumdirection_enumaxis = enumdirection.o();
        boolean flag1 = enumdirection_enumaxis == EnumDirection.EnumAxis.c && (this.o(world.a_(blockposition.h())) || this.o(world.a_(blockposition.i()))) || enumdirection_enumaxis == EnumDirection.EnumAxis.a && (this.o(world.a_(blockposition.f())) || this.o(world.a_(blockposition.g())));
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.m().b(BlockFacingHorizontal.aF, enumdirection)).b(b, flag)).b(c, flag)).b(d, flag1);
    }

    private boolean o(IBlockData state) {
        return state.a(TagsBlock.N);
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hit) {
        if (state.c(b).booleanValue()) {
            state = (IBlockData)state.b(b, false);
            world.a(pos, state, 10);
        } else {
            EnumDirection enumdirection = player.cO();
            if (state.c(BlockFacingHorizontal.aF) == enumdirection.g()) {
                state = (IBlockData)state.b(BlockFacingHorizontal.aF, enumdirection);
            }
            state = (IBlockData)state.b(b, true);
            world.a(pos, state, 10);
        }
        boolean flag = state.c(b);
        world.a(player, pos, flag ? this.H.g() : this.H.f(), SoundCategory.e, 1.0f, world.H_().i() * 0.1f + 0.9f);
        world.a((Entity)player, flag ? GameEvent.h : GameEvent.d, pos);
        return EnumInteractionResult.a;
    }

    @Override
    protected void a(IBlockData state, WorldServer world, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> stackMerger) {
        if (explosion.g() && !state.c(c).booleanValue()) {
            boolean flag = state.c(b);
            world.b(pos, (IBlockData)state.b(b, !flag));
            world.a((EntityHuman)null, pos, flag ? this.H.f() : this.H.g(), SoundCategory.e, 1.0f, world.H_().i() * 0.1f + 0.9f);
            world.a(flag ? GameEvent.d : GameEvent.h, pos, GameEvent.a.a(state));
        }
        super.a(state, world, pos, explosion, stackMerger);
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
        if (!world.C) {
            boolean flag1 = world.C(pos);
            boolean oldPowered = state.c(c);
            if (oldPowered != flag1) {
                int newPower = flag1 ? 15 : 0;
                int oldPower = oldPowered ? 15 : 0;
                CraftBlock bukkitBlock = CraftBlock.at(world, pos);
                BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)bukkitBlock, oldPower, newPower);
                world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
                boolean bl = flag1 = eventRedstone.getNewCurrent() > 0;
            }
            if (state.c(c) != flag1) {
                world.a(pos, (IBlockData)((IBlockData)state.b(c, flag1)).b(b, flag1), 2);
                if (state.c(b) != flag1) {
                    world.a((EntityHuman)null, pos, flag1 ? this.H.g() : this.H.f(), SoundCategory.e, 1.0f, world.H_().i() * 0.1f + 0.9f);
                    world.a((Entity)null, flag1 ? GameEvent.h : GameEvent.d, pos);
                }
            }
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockFacingHorizontal.aF, b, c, d);
    }

    public static boolean a(IBlockData state, EnumDirection side) {
        return state.c(BlockFacingHorizontal.aF).o() == side.h().o();
    }
}

