/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.destroystokyo.paper.event.block.TNTPrimeEvent;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.TNTPrimeEvent;

public class BlockFire
extends BlockFireAbstract {
    public static final MapCodec<BlockFire> c = BlockFire.b(BlockFire::new);
    public static final int d = 15;
    public static final BlockStateInteger e = BlockProperties.ax;
    public static final BlockStateBoolean f = BlockSprawling.b;
    public static final BlockStateBoolean g = BlockSprawling.c;
    public static final BlockStateBoolean h = BlockSprawling.d;
    public static final BlockStateBoolean i = BlockSprawling.e;
    public static final BlockStateBoolean j = BlockSprawling.f;
    private static final Map<EnumDirection, BlockStateBoolean> k = BlockSprawling.h.entrySet().stream().filter(entry -> entry.getKey() != EnumDirection.a).collect(SystemUtils.a());
    private static final VoxelShape l = Block.a(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape m = Block.a(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape n = Block.a(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape o = Block.a(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape G = Block.a(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private final Map<IBlockData, VoxelShape> H;
    private static final int I = 60;
    private static final int J = 30;
    private static final int K = 15;
    private static final int L = 5;
    private static final int M = 100;
    private static final int N = 60;
    private static final int O = 20;
    private static final int P = 5;
    public final Object2IntMap<Block> Q = new Object2IntOpenHashMap();
    private final Object2IntMap<Block> R = new Object2IntOpenHashMap();

    public MapCodec<BlockFire> a() {
        return c;
    }

    public BlockFire(BlockBase.Info settings) {
        super(settings, 1.0f);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.F.b().b(e, 0)).b(f, false)).b(g, false)).b(h, false)).b(i, false)).b(j, false));
        this.H = ImmutableMap.copyOf(this.F.a().stream().filter(iblockdata -> iblockdata.c(e) == 0).collect(Collectors.toMap(Function.identity(), BlockFire::o)));
    }

    private static VoxelShape o(IBlockData state) {
        VoxelShape voxelshape = VoxelShapes.a();
        if (state.c(j).booleanValue()) {
            voxelshape = l;
        }
        if (state.c(f).booleanValue()) {
            voxelshape = VoxelShapes.a(voxelshape, o);
        }
        if (state.c(h).booleanValue()) {
            voxelshape = VoxelShapes.a(voxelshape, G);
        }
        if (state.c(g).booleanValue()) {
            voxelshape = VoxelShapes.a(voxelshape, n);
        }
        if (state.c(i).booleanValue()) {
            voxelshape = VoxelShapes.a(voxelshape, m);
        }
        return voxelshape.c() ? BlockFireAbstract.b : voxelshape;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader world, ScheduledTickAccess tickView, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (!(world instanceof WorldServer)) {
            return this.a(state, world, pos) ? this.a(world, pos, (int)state.c(e)) : Blocks.a.m();
        }
        if (!this.a(state, world, pos)) {
            if (!(world instanceof World)) {
                return Blocks.a.m();
            }
            World world1 = (World)world;
            CraftBlockState blockState = CraftBlockStates.getBlockState(world1, pos);
            blockState.setData(Blocks.a.m());
            BlockFadeEvent event = new BlockFadeEvent((org.bukkit.block.Block)blockState.getBlock(), (BlockState)blockState);
            world1.getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                return blockState.getHandle();
            }
        }
        return this.a(world, pos, (int)state.c(e));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.H.get(state.b(e, 0));
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return this.b(ctx.q(), ctx.a());
    }

    protected IBlockData b(IBlockAccess world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.e();
        IBlockData iblockdata = world.a_(blockposition1);
        if (!this.g(iblockdata) && !iblockdata.c(world, blockposition1, EnumDirection.b)) {
            IBlockData iblockdata1 = this.m();
            for (EnumDirection enumdirection : EnumDirection.values()) {
                BlockStateBoolean blockstateboolean = k.get(enumdirection);
                if (blockstateboolean == null) continue;
                iblockdata1 = (IBlockData)iblockdata1.b(blockstateboolean, this.g(world.a_(pos.a(enumdirection))));
            }
            return iblockdata1;
        }
        return this.m();
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.e();
        return world.a_(blockposition1).c((IBlockAccess)world, blockposition1, EnumDirection.b) || this.d(world, pos);
    }

    @Override
    protected void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        world.a(pos, (Block)this, BlockFire.getFireTickDelay(world));
        if (world.N().b(GameRules.b)) {
            if (!state.a((IWorldReader)world, pos)) {
                this.fireExtinguished(world, pos);
            }
            IBlockData iblockdata1 = world.a_(pos.e());
            boolean flag = iblockdata1.a(world.G_().q());
            int i2 = state.c(e);
            if (!flag && world.af() && this.a(world, pos) && random.i() < 0.2f + (float)i2 * 0.03f) {
                this.fireExtinguished(world, pos);
            } else {
                boolean flag1;
                int j2 = Math.min(15, i2 + random.a(3) / 2);
                if (i2 != j2) {
                    state = (IBlockData)state.b(e, j2);
                    world.a(pos, state, 4);
                }
                if (!flag) {
                    if (!this.d(world, pos)) {
                        BlockPosition blockposition1 = pos.e();
                        if (!world.a_(blockposition1).c((IBlockAccess)world, blockposition1, EnumDirection.b) || i2 > 3) {
                            this.fireExtinguished(world, pos);
                        }
                        return;
                    }
                    if (i2 == 15 && random.a(4) == 0 && !this.g(world.a_(pos.e()))) {
                        this.fireExtinguished(world, pos);
                        return;
                    }
                }
                int k2 = (flag1 = world.t(pos).a(BiomeTags.ad)) ? -50 : 0;
                this.trySpread(world, pos.i(), 300 + k2, random, i2, pos);
                this.trySpread(world, pos.h(), 300 + k2, random, i2, pos);
                this.trySpread(world, pos.e(), 250 + k2, random, i2, pos);
                this.trySpread(world, pos.d(), 250 + k2, random, i2, pos);
                this.trySpread(world, pos.f(), 300 + k2, random, i2, pos);
                this.trySpread(world, pos.g(), 300 + k2, random, i2, pos);
                BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
                for (int l2 = -1; l2 <= 1; ++l2) {
                    for (int i1 = -1; i1 <= 1; ++i1) {
                        for (int j1 = -1; j1 <= 4; ++j1) {
                            if (l2 == 0 && j1 == 0 && i1 == 0) continue;
                            int k1 = 100;
                            if (j1 > 1) {
                                k1 += (j1 - 1) * 100;
                            }
                            blockposition_mutableblockposition.a(pos, l2, j1, i1);
                            int l1 = this.a((IWorldReader)world, (BlockPosition)blockposition_mutableblockposition);
                            if (l1 <= 0) continue;
                            int i22 = (l1 + 40 + world.al().a() * 7) / (i2 + 30);
                            if (flag1) {
                                i22 /= 2;
                            }
                            if (i22 <= 0 || random.a(k1) > i22 || world.af() && this.a(world, (BlockPosition)blockposition_mutableblockposition)) continue;
                            int j22 = Math.min(15, i2 + random.a(5) / 4);
                            if (world.a_(blockposition_mutableblockposition).b() == Blocks.cy || CraftEventFactory.callBlockIgniteEvent((World)world, (BlockPosition)blockposition_mutableblockposition, pos).isCancelled()) continue;
                            CraftEventFactory.handleBlockSpreadEvent(world, pos, blockposition_mutableblockposition, this.a((IWorldReader)world, (BlockPosition)blockposition_mutableblockposition, j22), 3);
                        }
                    }
                }
            }
        }
    }

    protected boolean a(World world, BlockPosition pos) {
        return world.r(pos) || world.r(pos.h()) || world.r(pos.i()) || world.r(pos.f()) || world.r(pos.g());
    }

    private int q(IBlockData state) {
        return state.b(BlockProperties.D) && state.c(BlockProperties.D) != false ? 0 : this.R.getInt((Object)state.b());
    }

    private int r(IBlockData state) {
        return state.b(BlockProperties.D) && state.c(BlockProperties.D) != false ? 0 : this.Q.getInt((Object)state.b());
    }

    private void trySpread(World world, BlockPosition blockposition, int i2, RandomSource randomsource, int j2, BlockPosition sourceposition) {
        int k2 = this.q(world.a_(blockposition));
        if (randomsource.a(i2) < k2) {
            IBlockData iblockdata = world.a_(blockposition);
            org.bukkit.block.Block theBlock = world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w());
            org.bukkit.block.Block sourceBlock = world.getWorld().getBlockAt(sourceposition.u(), sourceposition.v(), sourceposition.w());
            BlockBurnEvent event = new BlockBurnEvent(theBlock, sourceBlock);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            if (iblockdata.b() instanceof BlockTNT && !CraftEventFactory.callTNTPrimeEvent(world, blockposition, TNTPrimeEvent.PrimeCause.FIRE, null, sourceposition)) {
                return;
            }
            if (randomsource.a(j2 + 10) < 5 && !world.r(blockposition)) {
                int l2 = Math.min(j2 + randomsource.a(5) / 4, 15);
                world.a(blockposition, this.a((IWorldReader)world, blockposition, l2), 3);
            } else if (iblockdata.b() != Blocks.cr) {
                world.a(blockposition, false);
            }
            Block block = iblockdata.b();
            if (block instanceof BlockTNT) {
                CraftBlock tntBlock = CraftBlock.at(world, blockposition);
                if (!new TNTPrimeEvent((org.bukkit.block.Block)tntBlock, TNTPrimeEvent.PrimeReason.FIRE, null).callEvent()) {
                    return;
                }
                world.a(blockposition, false);
                BlockTNT.a(world, blockposition);
            }
        }
    }

    private IBlockData a(IWorldReader world, BlockPosition pos, int age) {
        IBlockData iblockdata = BlockFire.a(world, pos);
        return iblockdata.a(Blocks.cy) ? (IBlockData)iblockdata.b(e, age) : iblockdata;
    }

    private boolean d(IBlockAccess world, BlockPosition pos) {
        for (EnumDirection enumdirection : EnumDirection.values()) {
            if (!this.g(world.a_(pos.a(enumdirection)))) continue;
            return true;
        }
        return false;
    }

    private int a(IWorldReader world, BlockPosition pos) {
        if (!world.u(pos)) {
            return 0;
        }
        int i2 = 0;
        for (EnumDirection enumdirection : EnumDirection.values()) {
            IBlockData iblockdata = world.a_(pos.a(enumdirection));
            i2 = Math.max(this.r(iblockdata), i2);
        }
        return i2;
    }

    @Override
    protected boolean g(IBlockData state) {
        return this.r(state) > 0;
    }

    @Override
    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag, ItemActionContext context) {
        super.onPlace(iblockdata, world, blockposition, iblockdata1, flag, context);
        world.a(blockposition, (Block)this, BlockFire.getFireTickDelay(world));
    }

    private static int getFireTickDelay(World world) {
        return world.paperConfig().environment.fireTickDelay + world.A.a(10);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(e, f, g, h, i, j);
    }

    public void a(Block block, int burnChance, int spreadChance) {
        this.Q.put((Object)block, burnChance);
        this.R.put((Object)block, spreadChance);
    }

    public static void b() {
        BlockFire blockfire = (BlockFire)Blocks.cy;
        blockfire.a(Blocks.n, 5, 20);
        blockfire.a(Blocks.o, 5, 20);
        blockfire.a(Blocks.p, 5, 20);
        blockfire.a(Blocks.q, 5, 20);
        blockfire.a(Blocks.r, 5, 20);
        blockfire.a(Blocks.s, 5, 20);
        blockfire.a(Blocks.t, 5, 20);
        blockfire.a(Blocks.v, 5, 20);
        blockfire.a(Blocks.w, 5, 20);
        blockfire.a(Blocks.x, 5, 20);
        blockfire.a(Blocks.y, 5, 20);
        blockfire.a(Blocks.jK, 5, 20);
        blockfire.a(Blocks.jL, 5, 20);
        blockfire.a(Blocks.jM, 5, 20);
        blockfire.a(Blocks.jN, 5, 20);
        blockfire.a(Blocks.jO, 5, 20);
        blockfire.a(Blocks.jP, 5, 20);
        blockfire.a(Blocks.jQ, 5, 20);
        blockfire.a(Blocks.jR, 5, 20);
        blockfire.a(Blocks.jS, 5, 20);
        blockfire.a(Blocks.jT, 5, 20);
        blockfire.a(Blocks.jU, 5, 20);
        blockfire.a(Blocks.fv, 5, 20);
        blockfire.a(Blocks.kn, 5, 20);
        blockfire.a(Blocks.ko, 5, 20);
        blockfire.a(Blocks.kp, 5, 20);
        blockfire.a(Blocks.kq, 5, 20);
        blockfire.a(Blocks.kr, 5, 20);
        blockfire.a(Blocks.ks, 5, 20);
        blockfire.a(Blocks.kt, 5, 20);
        blockfire.a(Blocks.ku, 5, 20);
        blockfire.a(Blocks.kv, 5, 20);
        blockfire.a(Blocks.eh, 5, 20);
        blockfire.a(Blocks.kw, 5, 20);
        blockfire.a(Blocks.kx, 5, 20);
        blockfire.a(Blocks.ky, 5, 20);
        blockfire.a(Blocks.kz, 5, 20);
        blockfire.a(Blocks.kA, 5, 20);
        blockfire.a(Blocks.kB, 5, 20);
        blockfire.a(Blocks.kC, 5, 20);
        blockfire.a(Blocks.kD, 5, 20);
        blockfire.a(Blocks.kE, 5, 20);
        blockfire.a(Blocks.cC, 5, 20);
        blockfire.a(Blocks.fZ, 5, 20);
        blockfire.a(Blocks.fY, 5, 20);
        blockfire.a(Blocks.ga, 5, 20);
        blockfire.a(Blocks.if, 5, 20);
        blockfire.a(Blocks.ig, 5, 20);
        blockfire.a(Blocks.ih, 5, 20);
        blockfire.a(Blocks.ii, 5, 20);
        blockfire.a(Blocks.ij, 5, 20);
        blockfire.a(Blocks.ik, 5, 20);
        blockfire.a(Blocks.il, 5, 20);
        blockfire.a(Blocks.X, 5, 5);
        blockfire.a(Blocks.Y, 5, 5);
        blockfire.a(Blocks.Z, 5, 5);
        blockfire.a(Blocks.aa, 5, 5);
        blockfire.a(Blocks.ab, 5, 5);
        blockfire.a(Blocks.ac, 5, 5);
        blockfire.a(Blocks.ae, 5, 5);
        blockfire.a(Blocks.ad, 5, 5);
        blockfire.a(Blocks.af, 5, 5);
        blockfire.a(Blocks.ai, 5, 5);
        blockfire.a(Blocks.aq, 5, 5);
        blockfire.a(Blocks.aj, 5, 5);
        blockfire.a(Blocks.ak, 5, 5);
        blockfire.a(Blocks.al, 5, 5);
        blockfire.a(Blocks.am, 5, 5);
        blockfire.a(Blocks.an, 5, 5);
        blockfire.a(Blocks.ao, 5, 5);
        blockfire.a(Blocks.ap, 5, 5);
        blockfire.a(Blocks.ar, 5, 5);
        blockfire.a(Blocks.as, 5, 5);
        blockfire.a(Blocks.aB, 5, 5);
        blockfire.a(Blocks.aC, 5, 5);
        blockfire.a(Blocks.aD, 5, 5);
        blockfire.a(Blocks.aE, 5, 5);
        blockfire.a(Blocks.aF, 5, 5);
        blockfire.a(Blocks.aG, 5, 5);
        blockfire.a(Blocks.aH, 5, 5);
        blockfire.a(Blocks.aI, 5, 5);
        blockfire.a(Blocks.aJ, 5, 5);
        blockfire.a(Blocks.at, 5, 5);
        blockfire.a(Blocks.au, 5, 5);
        blockfire.a(Blocks.av, 5, 5);
        blockfire.a(Blocks.aw, 5, 5);
        blockfire.a(Blocks.ax, 5, 5);
        blockfire.a(Blocks.ay, 5, 5);
        blockfire.a(Blocks.u, 5, 5);
        blockfire.a(Blocks.az, 5, 5);
        blockfire.a(Blocks.aA, 5, 5);
        blockfire.a(Blocks.ag, 5, 20);
        blockfire.a(Blocks.aK, 30, 60);
        blockfire.a(Blocks.aL, 30, 60);
        blockfire.a(Blocks.aM, 30, 60);
        blockfire.a(Blocks.aN, 30, 60);
        blockfire.a(Blocks.aO, 30, 60);
        blockfire.a(Blocks.aP, 30, 60);
        blockfire.a(Blocks.aQ, 30, 60);
        blockfire.a(Blocks.aR, 30, 60);
        blockfire.a(Blocks.aS, 30, 60);
        blockfire.a(Blocks.cs, 30, 20);
        blockfire.a(Blocks.cr, 15, 100);
        blockfire.a(Blocks.bA, 60, 100);
        blockfire.a(Blocks.bB, 60, 100);
        blockfire.a(Blocks.bC, 60, 100);
        blockfire.a(Blocks.iU, 60, 100);
        blockfire.a(Blocks.iV, 60, 100);
        blockfire.a(Blocks.iW, 60, 100);
        blockfire.a(Blocks.iX, 60, 100);
        blockfire.a(Blocks.iY, 60, 100);
        blockfire.a(Blocks.iZ, 60, 100);
        blockfire.a(Blocks.bY, 60, 100);
        blockfire.a(Blocks.ca, 60, 100);
        blockfire.a(Blocks.cb, 60, 100);
        blockfire.a(Blocks.cc, 60, 100);
        blockfire.a(Blocks.cd, 60, 100);
        blockfire.a(Blocks.ce, 60, 100);
        blockfire.a(Blocks.cf, 60, 100);
        blockfire.a(Blocks.cg, 60, 100);
        blockfire.a(Blocks.ch, 60, 100);
        blockfire.a(Blocks.ci, 60, 100);
        blockfire.a(Blocks.cj, 60, 100);
        blockfire.a(Blocks.cl, 60, 100);
        blockfire.a(Blocks.bZ, 60, 100);
        blockfire.a(Blocks.kX, 60, 100);
        blockfire.a(Blocks.ck, 60, 100);
        blockfire.a(Blocks.sW, 60, 100);
        blockfire.a(Blocks.bH, 30, 60);
        blockfire.a(Blocks.bI, 30, 60);
        blockfire.a(Blocks.bJ, 30, 60);
        blockfire.a(Blocks.bK, 30, 60);
        blockfire.a(Blocks.bL, 30, 60);
        blockfire.a(Blocks.bM, 30, 60);
        blockfire.a(Blocks.bN, 30, 60);
        blockfire.a(Blocks.bO, 30, 60);
        blockfire.a(Blocks.bP, 30, 60);
        blockfire.a(Blocks.bQ, 30, 60);
        blockfire.a(Blocks.bR, 30, 60);
        blockfire.a(Blocks.bS, 30, 60);
        blockfire.a(Blocks.bT, 30, 60);
        blockfire.a(Blocks.bU, 30, 60);
        blockfire.a(Blocks.bV, 30, 60);
        blockfire.a(Blocks.bW, 30, 60);
        blockfire.a(Blocks.ft, 15, 100);
        blockfire.a(Blocks.iS, 5, 5);
        blockfire.a(Blocks.iA, 60, 20);
        blockfire.a(Blocks.py, 15, 20);
        blockfire.a(Blocks.iB, 60, 20);
        blockfire.a(Blocks.iC, 60, 20);
        blockfire.a(Blocks.iD, 60, 20);
        blockfire.a(Blocks.iE, 60, 20);
        blockfire.a(Blocks.iF, 60, 20);
        blockfire.a(Blocks.iG, 60, 20);
        blockfire.a(Blocks.iH, 60, 20);
        blockfire.a(Blocks.iI, 60, 20);
        blockfire.a(Blocks.iJ, 60, 20);
        blockfire.a(Blocks.iK, 60, 20);
        blockfire.a(Blocks.iL, 60, 20);
        blockfire.a(Blocks.iM, 60, 20);
        blockfire.a(Blocks.iN, 60, 20);
        blockfire.a(Blocks.iO, 60, 20);
        blockfire.a(Blocks.iP, 60, 20);
        blockfire.a(Blocks.iQ, 60, 20);
        blockfire.a(Blocks.tP, 60, 20);
        blockfire.a(Blocks.tQ, 60, 20);
        blockfire.a(Blocks.tR, 60, 100);
        blockfire.a(Blocks.mz, 30, 60);
        blockfire.a(Blocks.nu, 60, 60);
        blockfire.a(Blocks.on, 60, 60);
        blockfire.a(Blocks.ov, 30, 20);
        blockfire.a(Blocks.px, 5, 20);
        blockfire.a(Blocks.oD, 60, 100);
        blockfire.a(Blocks.pA, 5, 20);
        blockfire.a(Blocks.pz, 30, 20);
        blockfire.a(Blocks.aT, 30, 60);
        blockfire.a(Blocks.aU, 30, 60);
        blockfire.a(Blocks.sQ, 15, 60);
        blockfire.a(Blocks.sR, 15, 60);
        blockfire.a(Blocks.sS, 60, 100);
        blockfire.a(Blocks.sT, 30, 60);
        blockfire.a(Blocks.sU, 30, 60);
        blockfire.a(Blocks.sY, 60, 100);
        blockfire.a(Blocks.sZ, 60, 100);
        blockfire.a(Blocks.ta, 60, 100);
        blockfire.a(Blocks.tb, 30, 60);
        blockfire.a(Blocks.fu, 15, 100);
    }
}

