/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFire;
import net.minecraft.world.level.block.BlockSoulFire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByBlockEvent;

public abstract class BlockFireAbstract
extends Block {
    private static final int c = 8;
    private static final int d = 1;
    private static final int e = 3;
    private final float f;
    protected static final float a = 1.0f;
    protected static final VoxelShape b = Block.a(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);

    public BlockFireAbstract(BlockBase.Info settings, float damage) {
        super(settings);
        this.f = damage;
    }

    protected abstract MapCodec<? extends BlockFireAbstract> a();

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return BlockFireAbstract.a(ctx.q(), ctx.a());
    }

    public static IBlockData a(IBlockAccess world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.e();
        IBlockData iblockdata = world.a_(blockposition1);
        return BlockSoulFire.o(iblockdata) ? Blocks.cz.m() : ((BlockFire)Blocks.cy).b(world, pos);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return b;
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
        block12: {
            block11: {
                double d2;
                double d1;
                double d0;
                int i2;
                BlockPosition blockposition1;
                IBlockData iblockdata1;
                if (random.a(24) == 0) {
                    world.a((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, SoundEffects.jn, SoundCategory.e, 1.0f + random.i(), random.i() * 0.7f + 0.3f, false);
                }
                if (this.g(iblockdata1 = world.a_(blockposition1 = pos.e())) || iblockdata1.c((IBlockAccess)world, blockposition1, EnumDirection.b)) break block11;
                if (this.g(world.a_(pos.h()))) {
                    for (i2 = 0; i2 < 2; ++i2) {
                        d0 = (double)pos.u() + random.j() * (double)0.1f;
                        d1 = (double)pos.v() + random.j();
                        d2 = (double)pos.w() + random.j();
                        world.a(Particles.Y, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (this.g(world.a_(pos.i()))) {
                    for (i2 = 0; i2 < 2; ++i2) {
                        d0 = (double)(pos.u() + 1) - random.j() * (double)0.1f;
                        d1 = (double)pos.v() + random.j();
                        d2 = (double)pos.w() + random.j();
                        world.a(Particles.Y, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (this.g(world.a_(pos.f()))) {
                    for (i2 = 0; i2 < 2; ++i2) {
                        d0 = (double)pos.u() + random.j();
                        d1 = (double)pos.v() + random.j();
                        d2 = (double)pos.w() + random.j() * (double)0.1f;
                        world.a(Particles.Y, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (this.g(world.a_(pos.g()))) {
                    for (i2 = 0; i2 < 2; ++i2) {
                        d0 = (double)pos.u() + random.j();
                        d1 = (double)pos.v() + random.j();
                        d2 = (double)(pos.w() + 1) - random.j() * (double)0.1f;
                        world.a(Particles.Y, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (!this.g(world.a_(pos.d()))) break block12;
                for (i2 = 0; i2 < 2; ++i2) {
                    d0 = (double)pos.u() + random.j();
                    d1 = (double)(pos.v() + 1) - random.j() * (double)0.1f;
                    d2 = (double)pos.w() + random.j();
                    world.a(Particles.Y, d0, d1, d2, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            for (int i3 = 0; i3 < 3; ++i3) {
                double d0 = (double)pos.u() + random.j();
                double d1 = (double)pos.v() + random.j() * 0.5 + 0.5;
                double d2 = (double)pos.w() + random.j();
                world.a(Particles.Y, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    protected abstract boolean g(IBlockData var1);

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (!entity.bi()) {
            if (entity.aG() < 0) {
                entity.h(entity.aG() + 1);
            } else if (entity instanceof EntityPlayer) {
                int i2 = world.H_().b(1, 3);
                entity.h(entity.aG() + i2);
            }
            if (entity.aG() >= 0) {
                EntityCombustByBlockEvent event = new EntityCombustByBlockEvent((org.bukkit.block.Block)CraftBlock.at(world, pos), (Entity)entity.getBukkitEntity(), 8.0f);
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    entity.igniteForSeconds(event.getDuration(), false);
                } else {
                    entity.h(entity.aG() - 1);
                }
            }
        }
        entity.a(world.aj().a(), this.f);
        super.a(state, world, pos, entity);
    }

    @Override
    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag, ItemActionContext context) {
        if (!iblockdata1.a(iblockdata.b())) {
            Optional<BlockPortalShape> optional;
            if (BlockFireAbstract.a(world) && (optional = BlockPortalShape.a(world, blockposition, EnumDirection.EnumAxis.a)).isPresent()) {
                optional.get().createPortalBlocks(world, context == null ? null : context.o());
                return;
            }
            if (!iblockdata.a((IWorldReader)world, blockposition)) {
                this.fireExtinguished(world, blockposition);
            }
        }
    }

    private static boolean a(World world) {
        return world.getTypeKey() == WorldDimension.b || world.getTypeKey() == WorldDimension.c;
    }

    @Override
    protected void a(World world, EntityHuman player, BlockPosition pos, IBlockData state) {
    }

    @Override
    public IBlockData a(World world, BlockPosition pos, IBlockData state, EntityHuman player) {
        if (!world.B_()) {
            world.a((EntityHuman)null, 1009, pos, 0);
        }
        return super.a(world, pos, state, player);
    }

    public static boolean a(World world, BlockPosition pos, EnumDirection direction) {
        IBlockData iblockdata = world.a_(pos);
        return !iblockdata.l() ? false : BlockFireAbstract.a(world, pos).a((IWorldReader)world, pos) || BlockFireAbstract.b(world, pos, direction);
    }

    private static boolean b(World world, BlockPosition pos, EnumDirection direction) {
        if (!BlockFireAbstract.a(world)) {
            return false;
        }
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = pos.k();
        boolean flag = false;
        for (EnumDirection enumdirection1 : EnumDirection.values()) {
            if (!world.a_(blockposition_mutableblockposition.g(pos).c(enumdirection1)).a(Blocks.cv)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        EnumDirection.EnumAxis enumdirection_enumaxis = direction.o().d() ? direction.i().o() : EnumDirection.EnumDirectionLimit.a.b(world.A);
        return BlockPortalShape.a(world, pos, enumdirection_enumaxis).isPresent();
    }

    protected void fireExtinguished(GeneratorAccess world, BlockPosition position) {
        if (!CraftEventFactory.callBlockFadeEvent(world, position, Blocks.a.m()).isCancelled()) {
            world.a(position, false);
        }
    }
}

