/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.entity.Entity;

public class BlockHopper
extends BlockTileEntity {
    public static final MapCodec<BlockHopper> a = BlockHopper.b(BlockHopper::new);
    public static final BlockStateEnum<EnumDirection> b = BlockProperties.R;
    public static final BlockStateBoolean c = BlockProperties.f;
    private static final VoxelShape d = Block.a(0.0, 10.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape e = Block.a(4.0, 4.0, 4.0, 12.0, 10.0, 12.0);
    private static final VoxelShape f = VoxelShapes.a(e, d);
    private static final VoxelShape g = BlockHopper.a(2.0, 11.0, 2.0, 14.0, 16.0, 14.0);
    private static final VoxelShape h = VoxelShapes.a(f, g, OperatorBoolean.e);
    private static final VoxelShape i = VoxelShapes.a(h, Block.a(6.0, 0.0, 6.0, 10.0, 4.0, 10.0));
    private static final VoxelShape j = VoxelShapes.a(h, Block.a(12.0, 4.0, 6.0, 16.0, 8.0, 10.0));
    private static final VoxelShape k = VoxelShapes.a(h, Block.a(6.0, 4.0, 0.0, 10.0, 8.0, 4.0));
    private static final VoxelShape l = VoxelShapes.a(h, Block.a(6.0, 4.0, 12.0, 10.0, 8.0, 16.0));
    private static final VoxelShape m = VoxelShapes.a(h, Block.a(0.0, 4.0, 6.0, 4.0, 8.0, 10.0));
    private static final VoxelShape n = g;
    private static final VoxelShape o = VoxelShapes.a(g, Block.a(12.0, 8.0, 6.0, 16.0, 10.0, 10.0));
    private static final VoxelShape G = VoxelShapes.a(g, Block.a(6.0, 8.0, 0.0, 10.0, 10.0, 4.0));
    private static final VoxelShape H = VoxelShapes.a(g, Block.a(6.0, 8.0, 12.0, 10.0, 10.0, 16.0));
    private static final VoxelShape I = VoxelShapes.a(g, Block.a(0.0, 8.0, 6.0, 4.0, 10.0, 10.0));

    public MapCodec<BlockHopper> a() {
        return a;
    }

    public BlockHopper(BlockBase.Info settings) {
        super(settings);
        this.l((IBlockData)((IBlockData)this.F.b().b(b, EnumDirection.a)).b(c, true));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        switch (state.c(b)) {
            case a: {
                return i;
            }
            case c: {
                return k;
            }
            case d: {
                return l;
            }
            case e: {
                return m;
            }
            case f: {
                return j;
            }
        }
        return h;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos) {
        switch (state.c(b)) {
            case a: {
                return n;
            }
            case c: {
                return G;
            }
            case d: {
                return H;
            }
            case e: {
                return I;
            }
            case f: {
                return o;
            }
        }
        return g;
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        EnumDirection direction = ctx.k().g();
        return (IBlockData)((IBlockData)this.m().b(b, direction.o() == EnumDirection.EnumAxis.b ? EnumDirection.a : direction)).b(c, true);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityHopper(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData state, TileEntityTypes<T> type) {
        return world.C ? null : BlockHopper.a(type, TileEntityTypes.s, TileEntityHopper::a);
    }

    @Override
    protected void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        if (!oldState.a(state.b())) {
            this.a(world, pos, state);
        }
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hit) {
        TileEntityHopper hopperBlockEntity;
        TileEntity tileEntity;
        if (!world.C && (tileEntity = world.c_(pos)) instanceof TileEntityHopper && player.a(hopperBlockEntity = (TileEntityHopper)tileEntity).isPresent()) {
            player.a(StatisticList.ad);
        }
        return EnumInteractionResult.a;
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
        this.a(world, pos, state);
    }

    private void a(World world, BlockPosition pos, IBlockData state) {
        boolean bl;
        boolean bl2 = bl = !world.C(pos);
        if (bl != state.c(c)) {
            world.a(pos, (IBlockData)state.b(c, bl), 2);
        }
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        InventoryUtils.a(state, newState, world, pos);
        super.a(state, world, pos, newState, moved);
    }

    @Override
    protected EnumRenderType a_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World world, BlockPosition pos) {
        return Container.a(world.c_(pos));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c);
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        TileEntity blockEntity = world.c_(pos);
        if (blockEntity instanceof TileEntityHopper) {
            TileEntityHopper.a(world, pos, state, entity, (TileEntityHopper)blockEntity);
        }
    }

    @Override
    protected boolean a(IBlockData state, PathMode type) {
        return false;
    }
}

