/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class BlockMonsterEggs
extends Block {
    public static final MapCodec<BlockMonsterEggs> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.e.q().fieldOf("host").forGetter(BlockMonsterEggs::b), BlockMonsterEggs.t()).apply((Applicative)instance, BlockMonsterEggs::new));
    private final Block b;
    private static final Map<Block, Block> c = Maps.newIdentityHashMap();
    private static final Map<IBlockData, IBlockData> d = Maps.newIdentityHashMap();
    private static final Map<IBlockData, IBlockData> e = Maps.newIdentityHashMap();

    public MapCodec<? extends BlockMonsterEggs> a() {
        return a;
    }

    public BlockMonsterEggs(Block regularBlock, BlockBase.Info settings) {
        super(settings.e(regularBlock.x() / 2.0f).f(0.75f));
        this.b = regularBlock;
        c.put(regularBlock, this);
    }

    public Block b() {
        return this.b;
    }

    public static boolean o(IBlockData block) {
        return c.containsKey(block.b());
    }

    private void a(WorldServer world, BlockPosition pos) {
        EntitySilverfish entitysilverfish = EntityTypes.be.a(world, EntitySpawnReason.k);
        if (entitysilverfish != null) {
            entitysilverfish.b((double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5, 0.0f, 0.0f);
            world.addFreshEntity(entitysilverfish, CreatureSpawnEvent.SpawnReason.SILVERFISH_BLOCK);
            entitysilverfish.S();
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer world, BlockPosition pos, ItemStack tool, boolean dropExperience) {
        super.a(state, world, pos, tool, dropExperience);
        if (world.N().b(GameRules.h) && !EnchantmentManager.a(tool, EnchantmentTags.t)) {
            this.a(world, pos);
        }
    }

    public static IBlockData p(IBlockData regularState) {
        return BlockMonsterEggs.a(d, regularState, () -> c.get(regularState.b()).m());
    }

    public IBlockData q(IBlockData infestedState) {
        return BlockMonsterEggs.a(e, infestedState, () -> this.b().m());
    }

    private static IBlockData a(Map<IBlockData, IBlockData> stateMap, IBlockData fromState, Supplier<IBlockData> toStateSupplier) {
        return stateMap.computeIfAbsent(fromState, iblockdata1 -> {
            IBlockData iblockdata2 = (IBlockData)toStateSupplier.get();
            for (IBlockState<?> iblockstate : iblockdata1.F()) {
                iblockdata2 = iblockdata2.b(iblockstate) ? (IBlockData)iblockdata2.b(iblockstate, iblockdata1.c(iblockstate)) : iblockdata2;
            }
            return iblockdata2;
        });
    }
}

