/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.TreeType;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;

public class BlockMushroom
extends BlockPlant
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockMushroom> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.a(Registries.aL).fieldOf("feature").forGetter(blockmushroom -> blockmushroom.d), BlockMushroom.t()).apply((Applicative)instance, BlockMushroom::new));
    protected static final float b = 3.0f;
    protected static final VoxelShape c = Block.a(5.0, 0.0, 5.0, 11.0, 6.0, 11.0);
    private final ResourceKey<WorldGenFeatureConfigured<?, ?>> d;

    public MapCodec<BlockMushroom> a() {
        return a;
    }

    public BlockMushroom(ResourceKey<WorldGenFeatureConfigured<?, ?>> featureKey, BlockBase.Info settings) {
        super(settings);
        this.d = featureKey;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return c;
    }

    @Override
    protected void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (random.i() < (float)world.spigotConfig.mushroomModifier / 2500.0f) {
            int i2 = 5;
            boolean flag = true;
            for (BlockPosition blockposition1 : BlockPosition.c(pos.b(-4, -1, -4), pos.b(4, 1, 4))) {
                if (!world.a_(blockposition1).a(this) || --i2 > 0) continue;
                return;
            }
            BlockPosition blockposition2 = pos.b(random.a(3) - 1, random.a(2) - random.a(2), random.a(3) - 1);
            BlockPosition sourcePos = pos;
            for (int j2 = 0; j2 < 4; ++j2) {
                if (world.u(blockposition2) && state.a((IWorldReader)world, blockposition2)) {
                    pos = blockposition2;
                }
                blockposition2 = pos.b(random.a(3) - 1, random.a(2) - random.a(2), random.a(3) - 1);
            }
            if (world.u(blockposition2) && state.a((IWorldReader)world, blockposition2)) {
                CraftEventFactory.handleBlockSpreadEvent(world, sourcePos, blockposition2, state, 2);
            }
        }
    }

    @Override
    protected boolean b(IBlockData floor, IBlockAccess world, BlockPosition pos) {
        return floor.s();
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.e();
        IBlockData iblockdata1 = world.a_(blockposition1);
        return iblockdata1.a(TagsBlock.bc) ? true : world.b(pos, 0) < 13 && this.b(iblockdata1, world, blockposition1);
    }

    public boolean a(WorldServer world, BlockPosition pos, IBlockData state, RandomSource random) {
        Optional optional = world.K_().e(Registries.aL).a(this.d);
        if (optional.isEmpty()) {
            return false;
        }
        world.a(pos, false);
        TreeType treeType = BlockSapling.treeType = this == Blocks.cm ? TreeType.BROWN_MUSHROOM : TreeType.RED_MUSHROOM;
        if (((WorldGenFeatureConfigured)((Holder)optional.get()).a()).a(world, world.m().g(), random, pos)) {
            return true;
        }
        world.a(pos, state, 3);
        return false;
    }

    @Override
    public boolean b(IWorldReader world, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public boolean a(World world, RandomSource random, BlockPosition pos, IBlockData state) {
        return (double)random.i() < 0.4;
    }

    @Override
    public void a(WorldServer world, RandomSource random, BlockPosition pos, IBlockData state) {
        this.a(world, pos, state, random);
    }
}

