/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.configuration.GlobalConfiguration;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.craftbukkit.v1_21_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.event.block.NotePlayEvent;

public class BlockNote
extends Block {
    public static final MapCodec<BlockNote> a = BlockNote.b(BlockNote::new);
    public static final BlockStateEnum<BlockPropertyInstrument> b = BlockProperties.bg;
    public static final BlockStateBoolean c = BlockProperties.x;
    public static final BlockStateInteger d = BlockProperties.aS;
    public static final int e = 3;

    public MapCodec<BlockNote> a() {
        return a;
    }

    public BlockNote(BlockBase.Info settings) {
        super(settings);
        this.l((IBlockData)((IBlockData)((IBlockData)this.F.b().b(b, BlockPropertyInstrument.a)).b(d, 0)).b(c, false));
    }

    private IBlockData b(IWorldReader world, BlockPosition pos, IBlockData state) {
        BlockPropertyInstrument blockpropertyinstrument = world.a_(pos.d()).E();
        if (blockpropertyinstrument.e()) {
            return (IBlockData)state.b(b, blockpropertyinstrument);
        }
        BlockPropertyInstrument blockpropertyinstrument1 = world.a_(pos.e()).E();
        BlockPropertyInstrument blockpropertyinstrument2 = blockpropertyinstrument1.e() ? BlockPropertyInstrument.a : blockpropertyinstrument1;
        return (IBlockData)state.b(b, blockpropertyinstrument2);
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        if (GlobalConfiguration.get().blockUpdates.disableNoteblockUpdates) {
            return this.m();
        }
        return this.b(ctx.q(), ctx.a(), this.m());
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader world, ScheduledTickAccess tickView, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (GlobalConfiguration.get().blockUpdates.disableNoteblockUpdates) {
            return state;
        }
        boolean flag = direction.o() == EnumDirection.EnumAxis.b;
        return flag ? this.b(world, pos, state) : super.a(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
        if (GlobalConfiguration.get().blockUpdates.disableNoteblockUpdates) {
            return;
        }
        boolean flag1 = world.C(pos);
        if (flag1 != state.c(c)) {
            if (flag1) {
                this.a((Entity)null, state, world, pos);
                state = world.a_(pos);
            }
            world.a(pos, (IBlockData)state.b(c, flag1), 3);
        }
    }

    private void a(@Nullable Entity entity, IBlockData state, World world, BlockPosition pos) {
        if (state.c(b).e() || world.a_(pos.d()).l()) {
            world.a(pos, (Block)this, 0, 0);
            world.a(entity, GameEvent.H, pos);
        }
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        return stack.a(TagsItem.by) && hit.c() == EnumDirection.b ? EnumInteractionResult.e : super.a(stack, state, world, pos, player, hand, hit);
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hit) {
        if (!world.C) {
            if (!GlobalConfiguration.get().blockUpdates.disableNoteblockUpdates) {
                state = (IBlockData)state.a(d);
            }
            world.a(pos, state, 3);
            this.a(player, state, world, pos);
            player.a(StatisticList.ag);
        }
        return EnumInteractionResult.a;
    }

    @Override
    protected void a_(IBlockData state, World world, BlockPosition pos, EntityHuman player) {
        if (!world.C) {
            this.a(player, state, world, pos);
            player.a(StatisticList.af);
        }
    }

    public static float b(int note) {
        return (float)Math.pow(2.0, (double)(note - 12) / 12.0);
    }

    @Override
    protected boolean a(IBlockData state, World world, BlockPosition pos, int type, int data) {
        Holder<SoundEffect> holder;
        float f2;
        BlockPropertyInstrument blockpropertyinstrument = state.c(b);
        NotePlayEvent event = CraftEventFactory.callNotePlayEvent(world, pos, blockpropertyinstrument, state.c(d));
        if (event.isCancelled()) {
            return false;
        }
        if (blockpropertyinstrument.b()) {
            byte k2 = event.getNote().getId();
            f2 = BlockNote.b(k2);
            world.a(Particles.ab, (double)pos.u() + 0.5, (double)pos.v() + 1.2, (double)pos.w() + 0.5, (double)k2 / 24.0, 0.0, 0.0);
        } else {
            f2 = 1.0f;
        }
        if (blockpropertyinstrument.d()) {
            MinecraftKey minecraftkey = this.a(world, pos);
            if (minecraftkey == null) {
                return false;
            }
            holder = Holder.a(SoundEffect.a(minecraftkey));
        } else {
            holder = CraftBlockData.toNMS(event.getInstrument(), BlockPropertyInstrument.class).a();
        }
        world.a((EntityHuman)null, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, holder, SoundCategory.c, 3.0f, f2, world.A.g());
        return true;
    }

    @Nullable
    private MinecraftKey a(World world, BlockPosition pos) {
        TileEntity tileentity = world.c_(pos.d());
        if (tileentity instanceof TileEntitySkull) {
            TileEntitySkull tileentityskull = (TileEntitySkull)tileentity;
            return tileentityskull.d();
        }
        return null;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d);
    }
}

