/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPressurePlateAbstract;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class BlockPressurePlateWeighted
extends BlockPressurePlateAbstract {
    public static final MapCodec<BlockPressurePlateWeighted> e = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)1, (int)1024).fieldOf("max_weight").forGetter(blockpressureplateweighted -> blockpressureplateweighted.g), (App)BlockSetType.a.fieldOf("block_set_type").forGetter(blockpressureplateweighted -> blockpressureplateweighted.d), BlockPressurePlateWeighted.t()).apply((Applicative)instance, BlockPressurePlateWeighted::new));
    public static final BlockStateInteger f = BlockProperties.aU;
    private final int g;

    public MapCodec<BlockPressurePlateWeighted> a() {
        return e;
    }

    protected BlockPressurePlateWeighted(int weight, BlockSetType type, BlockBase.Info settings) {
        super(settings, type);
        this.l((IBlockData)this.F.b().b(f, 0));
        this.g = weight;
    }

    @Override
    protected int b(World world, BlockPosition pos) {
        int i2 = 0;
        for (net.minecraft.world.entity.Entity entity : BlockPressurePlateWeighted.getEntities(world, BlockPressurePlateAbstract.c.a(pos), net.minecraft.world.entity.Entity.class)) {
            PlayerInteractEvent cancellable;
            if (entity instanceof EntityHuman) {
                cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, pos, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w()));
                world.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
            }
            if (cancellable.isCancelled()) continue;
            ++i2;
        }
        if ((i2 = Math.min(i2, this.g)) > 0) {
            float f2 = (float)Math.min(this.g, i2) / (float)this.g;
            return MathHelper.f(f2 * 15.0f);
        }
        return 0;
    }

    @Override
    protected int h(IBlockData state) {
        return state.c(f);
    }

    @Override
    protected IBlockData a(IBlockData state, int rsOut) {
        return (IBlockData)state.b(f, rsOut);
    }

    @Override
    protected int b() {
        return 10;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{f});
    }
}

