/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.ArrayDeque;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BaseTorchBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.plugin.PluginManager;

public class BlockRedstoneTorch
extends BaseTorchBlock {
    public static final MapCodec<BlockRedstoneTorch> c = BlockRedstoneTorch.b(BlockRedstoneTorch::new);
    public static final BlockStateBoolean d = BlockProperties.r;
    public static final int e = 60;
    public static final int f = 8;
    public static final int g = 160;
    private static final int i = 2;

    public MapCodec<? extends BlockRedstoneTorch> a() {
        return c;
    }

    protected BlockRedstoneTorch(BlockBase.Info settings) {
        super(settings);
        this.l((IBlockData)this.F.b().b(d, true));
    }

    @Override
    protected void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        this.b(world, pos, state);
    }

    private void b(World world, BlockPosition pos, IBlockData state) {
        Orientation orientation = this.a(world, state);
        for (EnumDirection enumdirection : EnumDirection.values()) {
            world.a(pos.a(enumdirection), (Block)this, ExperimentalRedstoneUtils.a(orientation, enumdirection));
        }
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (!moved) {
            this.b(world, pos, state);
        }
    }

    @Override
    protected int a(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return state.c(d) != false && EnumDirection.b != direction ? 15 : 0;
    }

    protected boolean a(World world, BlockPosition pos, IBlockData state) {
        return world.b(pos.e(), EnumDirection.a);
    }

    @Override
    protected void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        boolean flag = this.a((World)world, pos, state);
        ArrayDeque<RedstoneUpdateInfo> redstoneUpdateInfos = world.redstoneUpdateInfos;
        if (redstoneUpdateInfos != null) {
            RedstoneUpdateInfo curr;
            while ((curr = redstoneUpdateInfos.peek()) != null && world.ac() - curr.b > 60L) {
                redstoneUpdateInfos.poll();
            }
        }
        PluginManager manager = world.getCraftServer().getPluginManager();
        org.bukkit.block.Block block = world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
        int oldCurrent = state.c(d) != false ? 15 : 0;
        BlockRedstoneEvent event = new BlockRedstoneEvent(block, oldCurrent, oldCurrent);
        if (state.c(d).booleanValue()) {
            if (flag) {
                if (oldCurrent != 0) {
                    event.setNewCurrent(0);
                    manager.callEvent((Event)event);
                    if (event.getNewCurrent() != 0) {
                        return;
                    }
                }
                world.a(pos, (IBlockData)state.b(d, false), 3);
                if (BlockRedstoneTorch.a((World)world, pos, true)) {
                    world.c(1502, pos, 0);
                    world.a(pos, world.a_(pos).b(), 160);
                }
            }
        } else if (!flag && !BlockRedstoneTorch.a((World)world, pos, false)) {
            if (oldCurrent != 15) {
                event.setNewCurrent(15);
                manager.callEvent((Event)event);
                if (event.getNewCurrent() != 15) {
                    return;
                }
            }
            world.a(pos, (IBlockData)state.b(d, true), 3);
        }
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
        if (state.c(d).booleanValue() == this.a(world, pos, state) && !world.T().b(pos, this)) {
            world.a(pos, (Block)this, 2);
        }
    }

    @Override
    protected int b(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return direction == EnumDirection.a ? state.a(world, pos, direction) : 0;
    }

    @Override
    protected boolean f_(IBlockData state) {
        return true;
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
        if (state.c(d).booleanValue()) {
            double d0 = (double)pos.u() + 0.5 + (random.j() - 0.5) * 0.2;
            double d1 = (double)pos.v() + 0.7 + (random.j() - 0.5) * 0.2;
            double d2 = (double)pos.w() + 0.5 + (random.j() - 0.5) * 0.2;
            world.a(ParticleParamRedstone.b, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{d});
    }

    private static boolean a(World world, BlockPosition pos, boolean addNew) {
        ArrayDeque<RedstoneUpdateInfo> list = world.redstoneUpdateInfos;
        if (list == null) {
            list = world.redstoneUpdateInfos = new ArrayDeque();
        }
        if (addNew) {
            list.add(new RedstoneUpdateInfo(pos.j(), world.ac()));
        }
        int i2 = 0;
        for (RedstoneUpdateInfo blockredstonetorch_redstoneupdateinfo : list) {
            if (!blockredstonetorch_redstoneupdateinfo.a.equals(pos) || ++i2 < 8) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected Orientation a(World world, IBlockData state) {
        return ExperimentalRedstoneUtils.a(world, null, EnumDirection.b);
    }

    public static class RedstoneUpdateInfo {
        final BlockPosition a;
        final long b;

        public RedstoneUpdateInfo(BlockPosition pos, long time) {
            this.a = pos;
            this.b = time;
        }
    }
}

