/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.destroystokyo.paper.util.RedstoneWireTurbo;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.configuration.WorldConfiguration;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyRedstoneSide;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.redstone.DefaultRedstoneWireEvaluator;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.ExperimentalRedstoneWireEvaluator;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.redstone.RedstoneWireEvaluator;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class BlockRedstoneWire
extends Block {
    public static final MapCodec<BlockRedstoneWire> a = BlockRedstoneWire.b(BlockRedstoneWire::new);
    public static final BlockStateEnum<BlockPropertyRedstoneSide> b = BlockProperties.ac;
    public static final BlockStateEnum<BlockPropertyRedstoneSide> c = BlockProperties.ab;
    public static final BlockStateEnum<BlockPropertyRedstoneSide> d = BlockProperties.ad;
    public static final BlockStateEnum<BlockPropertyRedstoneSide> e = BlockProperties.ae;
    public static final BlockStateInteger f = BlockProperties.aU;
    public static final Map<EnumDirection, BlockStateEnum<BlockPropertyRedstoneSide>> g = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumDirection.c, b, (Object)EnumDirection.f, c, (Object)EnumDirection.d, d, (Object)EnumDirection.e, e));
    protected static final int h = 1;
    protected static final int i = 3;
    protected static final int j = 13;
    protected static final int k = 3;
    protected static final int l = 13;
    private static final VoxelShape m = Block.a(3.0, 0.0, 3.0, 13.0, 1.0, 13.0);
    private static final Map<EnumDirection, VoxelShape> n = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumDirection.c, (Object)Block.a(3.0, 0.0, 0.0, 13.0, 1.0, 13.0), (Object)EnumDirection.d, (Object)Block.a(3.0, 0.0, 3.0, 13.0, 1.0, 16.0), (Object)EnumDirection.f, (Object)Block.a(3.0, 0.0, 3.0, 16.0, 1.0, 13.0), (Object)EnumDirection.e, (Object)Block.a(0.0, 0.0, 3.0, 13.0, 1.0, 13.0)));
    private static final Map<EnumDirection, VoxelShape> o = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumDirection.c, (Object)VoxelShapes.a(n.get(EnumDirection.c), Block.a(3.0, 0.0, 0.0, 13.0, 16.0, 1.0)), (Object)EnumDirection.d, (Object)VoxelShapes.a(n.get(EnumDirection.d), Block.a(3.0, 0.0, 15.0, 13.0, 16.0, 16.0)), (Object)EnumDirection.f, (Object)VoxelShapes.a(n.get(EnumDirection.f), Block.a(15.0, 0.0, 3.0, 16.0, 16.0, 13.0)), (Object)EnumDirection.e, (Object)VoxelShapes.a(n.get(EnumDirection.e), Block.a(0.0, 0.0, 3.0, 1.0, 16.0, 13.0))));
    private static final Map<IBlockData, VoxelShape> G = Maps.newHashMap();
    private static final int[] H = SystemUtils.a(new int[16], (? super T colors) -> {
        for (int i2 = 0; i2 <= 15; ++i2) {
            float f2;
            float g2 = f2 * 0.6f + ((f2 = (float)i2 / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float h2 = MathHelper.a(f2 * f2 * 0.7f - 0.5f, 0.0f, 1.0f);
            float j2 = MathHelper.a(f2 * f2 * 0.6f - 0.7f, 0.0f, 1.0f);
            colors[i2] = ARGB.a(1.0f, g2, h2, j2);
        }
    });
    private static final float I = 0.2f;
    private final IBlockData J;
    private final RedstoneWireEvaluator K = new DefaultRedstoneWireEvaluator(this);
    public boolean L = true;
    RedstoneWireTurbo turbo = new RedstoneWireTurbo(this);

    public MapCodec<BlockRedstoneWire> a() {
        return a;
    }

    public BlockRedstoneWire(BlockBase.Info settings) {
        super(settings);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.F.b().b(b, BlockPropertyRedstoneSide.c)).b(c, BlockPropertyRedstoneSide.c)).b(d, BlockPropertyRedstoneSide.c)).b(e, BlockPropertyRedstoneSide.c)).b(f, 0));
        this.J = (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.m().b(b, BlockPropertyRedstoneSide.b)).b(c, BlockPropertyRedstoneSide.b)).b(d, BlockPropertyRedstoneSide.b)).b(e, BlockPropertyRedstoneSide.b);
        for (IBlockData blockState : this.l().a()) {
            if (blockState.c(f) != 0) continue;
            G.put(blockState, this.q(blockState));
        }
    }

    private VoxelShape q(IBlockData state) {
        VoxelShape voxelShape = m;
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            BlockPropertyRedstoneSide redstoneSide = (BlockPropertyRedstoneSide)state.c(g.get(direction));
            if (redstoneSide == BlockPropertyRedstoneSide.b) {
                voxelShape = VoxelShapes.a(voxelShape, n.get(direction));
                continue;
            }
            if (redstoneSide != BlockPropertyRedstoneSide.a) continue;
            voxelShape = VoxelShapes.a(voxelShape, o.get(direction));
        }
        return voxelShape;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return G.get(state.b(f, 0));
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return this.a((IBlockAccess)ctx.q(), this.J, ctx.a());
    }

    private IBlockData a(IBlockAccess world, IBlockData state, BlockPosition pos) {
        boolean bl7;
        boolean bl = BlockRedstoneWire.s(state);
        state = this.b(world, (IBlockData)this.m().b(f, state.c(f)), pos);
        if (bl && BlockRedstoneWire.s(state)) {
            return state;
        }
        boolean bl2 = state.c(b).a();
        boolean bl3 = state.c(d).a();
        boolean bl4 = state.c(c).a();
        boolean bl5 = state.c(e).a();
        boolean bl6 = !bl2 && !bl3;
        boolean bl8 = bl7 = !bl4 && !bl5;
        if (!bl5 && bl6) {
            state = (IBlockData)state.b(e, BlockPropertyRedstoneSide.b);
        }
        if (!bl4 && bl6) {
            state = (IBlockData)state.b(c, BlockPropertyRedstoneSide.b);
        }
        if (!bl2 && bl7) {
            state = (IBlockData)state.b(b, BlockPropertyRedstoneSide.b);
        }
        if (!bl3 && bl7) {
            state = (IBlockData)state.b(d, BlockPropertyRedstoneSide.b);
        }
        return state;
    }

    private IBlockData b(IBlockAccess world, IBlockData state, BlockPosition pos) {
        boolean bl = !world.a_(pos.d()).d(world, pos);
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            if (((BlockPropertyRedstoneSide)state.c(g.get(direction))).a()) continue;
            BlockPropertyRedstoneSide redstoneSide = this.a(world, pos, direction, bl);
            state = (IBlockData)state.b(g.get(direction), redstoneSide);
        }
        return state;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader world, ScheduledTickAccess tickView, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (direction == EnumDirection.a) {
            return !this.a((IBlockAccess)world, neighborPos, neighborState) ? Blocks.a.m() : state;
        }
        if (direction == EnumDirection.b) {
            return this.a((IBlockAccess)world, state, pos);
        }
        BlockPropertyRedstoneSide redstoneSide = this.a((IBlockAccess)world, pos, direction);
        return redstoneSide.a() == ((BlockPropertyRedstoneSide)state.c(g.get(direction))).a() && !BlockRedstoneWire.r(state) ? (IBlockData)state.b(g.get(direction), redstoneSide) : this.a((IBlockAccess)world, (IBlockData)((IBlockData)this.J.b(f, state.c(f))).b(g.get(direction), redstoneSide), pos);
    }

    private static boolean r(IBlockData state) {
        return state.c(b).a() && state.c(d).a() && state.c(c).a() && state.c(e).a();
    }

    private static boolean s(IBlockData state) {
        return !state.c(b).a() && !state.c(d).a() && !state.c(c).a() && !state.c(e).a();
    }

    @Override
    protected void a(IBlockData state, GeneratorAccess world, BlockPosition pos, int flags, int maxUpdateDepth) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            BlockPropertyRedstoneSide redstoneSide = (BlockPropertyRedstoneSide)state.c(g.get(direction));
            if (redstoneSide == BlockPropertyRedstoneSide.c || world.a_(mutableBlockPos.a((BaseBlockPosition)pos, direction)).a(this)) continue;
            mutableBlockPos.c(EnumDirection.a);
            IBlockData blockState = world.a_(mutableBlockPos);
            if (blockState.a(this)) {
                BlockPosition blockPos = mutableBlockPos.a(direction.g());
                world.a(direction.g(), (BlockPosition)mutableBlockPos, blockPos, world.a_(blockPos), flags, maxUpdateDepth);
            }
            mutableBlockPos.a((BaseBlockPosition)pos, direction).c(EnumDirection.b);
            IBlockData blockState2 = world.a_(mutableBlockPos);
            if (!blockState2.a(this)) continue;
            BlockPosition blockPos2 = mutableBlockPos.a(direction.g());
            world.a(direction.g(), (BlockPosition)mutableBlockPos, blockPos2, world.a_(blockPos2), flags, maxUpdateDepth);
        }
    }

    private BlockPropertyRedstoneSide a(IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return this.a(world, pos, direction, !world.a_(pos.d()).d(world, pos));
    }

    private BlockPropertyRedstoneSide a(IBlockAccess world, BlockPosition pos, EnumDirection direction, boolean bl) {
        BlockPosition blockPos = pos.a(direction);
        IBlockData blockState = world.a_(blockPos);
        if (bl) {
            boolean bl2;
            boolean bl3 = bl2 = blockState.b() instanceof BlockTrapdoor || this.a(world, blockPos, blockState);
            if (bl2 && BlockRedstoneWire.o(world.a_(blockPos.d()))) {
                if (blockState.c(world, blockPos, direction.g())) {
                    return BlockPropertyRedstoneSide.a;
                }
                return BlockPropertyRedstoneSide.b;
            }
        }
        return !BlockRedstoneWire.a(blockState, direction) && (blockState.d(world, blockPos) || !BlockRedstoneWire.o(world.a_(blockPos.e()))) ? BlockPropertyRedstoneSide.c : BlockPropertyRedstoneSide.b;
    }

    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        BlockPosition blockPos = pos.e();
        IBlockData blockState = world.a_(blockPos);
        return this.a((IBlockAccess)world, blockPos, blockState);
    }

    private boolean a(IBlockAccess world, BlockPosition pos, IBlockData floor) {
        return floor.c(world, pos, EnumDirection.b) || floor.a(Blocks.hs);
    }

    private void updateSurroundingRedstone(World worldIn, BlockPosition pos, IBlockData state, @Nullable Orientation orientation, boolean blockAdded) {
        if (worldIn.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.EIGENCRAFT) {
            BlockPosition source = null;
            if (orientation != null) {
                source = pos.a(orientation.b().g());
            }
            this.turbo.updateSurroundingRedstone(worldIn, pos, state, source);
            return;
        }
        this.a(worldIn, pos, state, orientation, blockAdded);
    }

    public IBlockData calculateCurrentChanges(World level, BlockPosition pos, IBlockData state) {
        int newPower;
        int oldPower = state.c(f);
        if (oldPower != (newPower = ((DefaultRedstoneWireEvaluator)this.K).c(level, pos))) {
            BlockRedstoneEvent event = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), oldPower, newPower);
            level.getCraftServer().getPluginManager().callEvent((Event)event);
            newPower = event.getNewCurrent();
            if (level.a_(pos) == state && level.a(pos, state = (IBlockData)state.b(f, newPower), 18)) {
                this.turbo.updateNeighborShapes(level, pos, state);
            }
        }
        return state;
    }

    private void a(World world, BlockPosition pos, IBlockData state, @Nullable Orientation orientation, boolean blockAdded) {
        if (BlockRedstoneWire.a(world)) {
            new ExperimentalRedstoneWireEvaluator(this).a(world, pos, state, orientation, blockAdded);
        } else {
            this.K.a(world, pos, state, orientation, blockAdded);
        }
    }

    public int a(World world, BlockPosition pos) {
        this.L = false;
        int i2 = world.D(pos);
        this.L = true;
        return i2;
    }

    private void b(World world, BlockPosition pos) {
        if (world.a_(pos).a(this)) {
            world.a(pos, this);
            for (EnumDirection direction : EnumDirection.values()) {
                world.a(pos.a(direction), this);
            }
        }
    }

    @Override
    protected void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        if (!oldState.a(state.b()) && !world.C) {
            if (world.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.ALTERNATE_CURRENT) {
                world.getWireHandler().onWireAdded(pos, state);
            } else {
                this.updateSurroundingRedstone(world, pos, state, null, true);
            }
            for (EnumDirection direction : EnumDirection.EnumDirectionLimit.b) {
                world.a(pos.a(direction), this);
            }
            this.c(world, pos);
        }
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (!moved && !state.a(newState.b())) {
            super.a(state, world, pos, newState, moved);
            if (!world.C) {
                for (EnumDirection direction : EnumDirection.values()) {
                    world.a(pos.a(direction), this);
                }
                if (world.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.ALTERNATE_CURRENT) {
                    world.getWireHandler().onWireRemoved(pos, state);
                } else {
                    this.updateSurroundingRedstone(world, pos, state, null, false);
                }
                this.c(world, pos);
            }
        }
    }

    private void c(World world, BlockPosition pos) {
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            this.b(world, pos.a(direction));
        }
        for (EnumDirection direction2 : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockPos = pos.a(direction2);
            if (world.a_(blockPos).d(world, blockPos)) {
                this.b(world, blockPos.d());
                continue;
            }
            this.b(world, blockPos.e());
        }
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
        if (!world.C) {
            if (world.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.ALTERNATE_CURRENT) {
                world.getWireHandler().onWireUpdated(pos, state, wireOrientation);
            } else if (sourceBlock != this || !BlockRedstoneWire.a(world)) {
                if (state.a((IWorldReader)world, pos)) {
                    this.updateSurroundingRedstone(world, pos, state, wireOrientation, false);
                } else {
                    BlockRedstoneWire.c(state, world, pos);
                    world.a(pos, false);
                }
            }
        }
    }

    private static boolean a(World world) {
        return world.J().b(FeatureFlags.d);
    }

    @Override
    protected int b(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return !this.L ? 0 : state.a(world, pos, direction);
    }

    @Override
    protected int a(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        if (this.L && direction != EnumDirection.a) {
            int i2 = state.c(f);
            if (i2 == 0) {
                return 0;
            }
            return direction != EnumDirection.b && !((BlockPropertyRedstoneSide)this.a(world, state, pos).c(g.get(direction.g()))).a() ? 0 : i2;
        }
        return 0;
    }

    protected static boolean o(IBlockData state) {
        return BlockRedstoneWire.a(state, null);
    }

    protected static boolean a(IBlockData state, @Nullable EnumDirection dir) {
        if (state.a(Blocks.cE)) {
            return true;
        }
        if (state.a(Blocks.eu)) {
            EnumDirection direction = state.c(BlockFacingHorizontal.aF);
            return direction == dir || direction.g() == dir;
        }
        return state.a(Blocks.lj) ? dir == state.c(BlockDirectional.a) : state.p() && dir != null;
    }

    @Override
    protected boolean f_(IBlockData state) {
        return this.L;
    }

    public static int b(int powerLevel) {
        return H[powerLevel];
    }

    private static void a(World world, RandomSource random, BlockPosition pos, int color, EnumDirection perpendicular, EnumDirection direction, float minOffset, float maxOffset) {
        float f2 = maxOffset - minOffset;
        if (!(random.i() >= 0.2f * f2)) {
            float g2 = 0.4375f;
            float h2 = minOffset + f2 * random.i();
            double d2 = 0.5 + (double)(0.4375f * (float)perpendicular.j()) + (double)(h2 * (float)direction.j());
            double e2 = 0.5 + (double)(0.4375f * (float)perpendicular.k()) + (double)(h2 * (float)direction.k());
            double i2 = 0.5 + (double)(0.4375f * (float)perpendicular.l()) + (double)(h2 * (float)direction.l());
            world.a(new ParticleParamRedstone(color, 1.0f), (double)pos.u() + d2, (double)pos.v() + e2, (double)pos.w() + i2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
        int i2 = state.c(f);
        if (i2 != 0) {
            block4: for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
                BlockPropertyRedstoneSide redstoneSide = (BlockPropertyRedstoneSide)state.c(g.get(direction));
                switch (redstoneSide) {
                    case a: {
                        BlockRedstoneWire.a(world, random, pos, H[i2], direction, EnumDirection.b, -0.5f, 0.5f);
                    }
                    case b: {
                        BlockRedstoneWire.a(world, random, pos, H[i2], EnumDirection.a, direction, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                BlockRedstoneWire.a(world, random, pos, H[i2], EnumDirection.a, direction, 0.0f, 0.3f);
            }
        }
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        switch (rotation) {
            case c: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(b, state.c(d))).b(c, state.c(e))).b(d, state.c(b))).b(e, state.c(c));
            }
            case d: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(b, state.c(c))).b(c, state.c(d))).b(d, state.c(e))).b(e, state.c(b));
            }
            case b: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(b, state.c(e))).b(c, state.c(b))).b(d, state.c(c))).b(e, state.c(d));
            }
        }
        return state;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        switch (mirror) {
            case b: {
                return (IBlockData)((IBlockData)state.b(b, state.c(d))).b(d, state.c(b));
            }
            case c: {
                return (IBlockData)((IBlockData)state.b(c, state.c(e))).b(e, state.c(c));
            }
        }
        return super.a(state, mirror);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d, e, f);
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hit) {
        if (!player.gj().e) {
            return EnumInteractionResult.e;
        }
        if (BlockRedstoneWire.r(state) || BlockRedstoneWire.s(state)) {
            IBlockData blockState = BlockRedstoneWire.r(state) ? this.m() : this.J;
            blockState = (IBlockData)blockState.b(f, state.c(f));
            if ((blockState = this.a((IBlockAccess)world, blockState, pos)) != state) {
                world.a(pos, blockState, 3);
                this.a(world, pos, state, blockState);
                return EnumInteractionResult.a;
            }
        }
        return EnumInteractionResult.e;
    }

    private void a(World world, BlockPosition pos, IBlockData oldState, IBlockData newState) {
        Orientation orientation = ExperimentalRedstoneUtils.a(world, null, EnumDirection.b);
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockPos = pos.a(direction);
            if (((BlockPropertyRedstoneSide)oldState.c(g.get(direction))).a() == ((BlockPropertyRedstoneSide)newState.c(g.get(direction))).a() || !world.a_(blockPos).d(world, blockPos)) continue;
            world.a(blockPos, newState.b(), direction.g(), ExperimentalRedstoneUtils.a(orientation, direction));
        }
    }
}

