/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityShulkerBox;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockShulkerBox
extends BlockTileEntity {
    public static final MapCodec<BlockShulkerBox> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EnumColor.q.optionalFieldOf("color").forGetter(block -> Optional.ofNullable(block.m)), BlockShulkerBox.t()).apply((Applicative)instance, (color, settings) -> new BlockShulkerBox(color.orElse(null), (BlockBase.Info)settings)));
    private static final IChatBaseComponent d = IChatBaseComponent.c("container.shulkerBox.unknownContents");
    private static final float e = 1.0f;
    private static final VoxelShape f = Block.a(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape g = Block.a(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);
    private static final VoxelShape h = Block.a(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape i = Block.a(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape j = Block.a(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape k = Block.a(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private static final Map<EnumDirection, VoxelShape> l = SystemUtils.a(Maps.newEnumMap(EnumDirection.class), (? super T map) -> {
        map.put(EnumDirection.c, j);
        map.put(EnumDirection.f, i);
        map.put(EnumDirection.d, k);
        map.put(EnumDirection.e, h);
        map.put(EnumDirection.b, f);
        map.put(EnumDirection.a, g);
    });
    public static final BlockStateEnum<EnumDirection> b = BlockDirectional.a;
    public static final MinecraftKey c = MinecraftKey.b("contents");
    @Nullable
    public final EnumColor m;

    public MapCodec<BlockShulkerBox> a() {
        return a;
    }

    public BlockShulkerBox(@Nullable EnumColor color, BlockBase.Info settings) {
        super(settings);
        this.m = color;
        this.l((IBlockData)this.F.b().b(b, EnumDirection.b));
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityShulkerBox(this.m, pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData state, TileEntityTypes<T> type) {
        return BlockShulkerBox.a(type, TileEntityTypes.y, TileEntityShulkerBox::a);
    }

    @Override
    protected EnumRenderType a_(IBlockData state) {
        return EnumRenderType.b;
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hit) {
        if (world instanceof WorldServer) {
            TileEntityShulkerBox shulkerBoxBlockEntity;
            WorldServer serverLevel = (WorldServer)world;
            TileEntity tileEntity = world.c_(pos);
            if (tileEntity instanceof TileEntityShulkerBox && BlockShulkerBox.a(state, world, pos, shulkerBoxBlockEntity = (TileEntityShulkerBox)tileEntity) && player.a(shulkerBoxBlockEntity).isPresent()) {
                player.a(StatisticList.aq);
                PiglinAI.a(serverLevel, player, true);
            }
        }
        return EnumInteractionResult.a;
    }

    private static boolean a(IBlockData state, World world, BlockPosition pos, TileEntityShulkerBox entity) {
        if (entity.k() != TileEntityShulkerBox.AnimationPhase.a) {
            return true;
        }
        AxisAlignedBB aABB = EntityShulker.a(1.0f, state.c(b), 0.0f, 0.5f).a(pos).h(1.0E-6);
        return world.b(aABB);
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return (IBlockData)this.m().b(b, ctx.k());
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }

    @Override
    public IBlockData a(World world, BlockPosition pos, IBlockData state, EntityHuman player) {
        TileEntity blockEntity = world.c_(pos);
        if (blockEntity instanceof TileEntityShulkerBox) {
            TileEntityShulkerBox shulkerBoxBlockEntity = (TileEntityShulkerBox)blockEntity;
            if (!world.C && player.b() && !shulkerBoxBlockEntity.c()) {
                ItemStack itemStack = BlockShulkerBox.b(this.b());
                itemStack.b(blockEntity.r());
                EntityItem itemEntity = new EntityItem(world, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, itemStack);
                itemEntity.s();
                world.b(itemEntity);
            } else {
                shulkerBoxBlockEntity.unpackLootTable(player, true);
            }
        }
        return super.a(world, pos, state, player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<ItemStack> a(IBlockData state, LootParams.a builder) {
        TileEntity blockEntity = builder.b(LootContextParameters.h);
        Runnable reAdd = null;
        if (blockEntity instanceof TileEntityShulkerBox) {
            TileEntityShulkerBox shulkerBoxBlockEntity = (TileEntityShulkerBox)blockEntity;
            if (shulkerBoxBlockEntity.lootableData().getLastFill() != -1L || !builder.a().paperConfig().lootables.retainUnlootedShulkerBoxLootTableOnNonPlayerBreak) {
                ResourceKey<LootTable> lootTableResourceKey = shulkerBoxBlockEntity.ax_();
                reAdd = () -> shulkerBoxBlockEntity.a(lootTableResourceKey);
                shulkerBoxBlockEntity.a((ResourceKey<LootTable>)null);
            }
            builder = builder.a(c, (Consumer<ItemStack> lootConsumer) -> {
                for (int i2 = 0; i2 < shulkerBoxBlockEntity.b(); ++i2) {
                    lootConsumer.accept(shulkerBoxBlockEntity.a(i2));
                }
            });
        }
        try {
            List<ItemStack> list = super.a(state, builder);
            return list;
        }
        finally {
            if (reAdd != null) {
                reAdd.run();
            }
        }
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (!state.a(newState.b())) {
            TileEntity blockEntity = world.c_(pos);
            super.a(state, world, pos, newState, moved);
            if (blockEntity instanceof TileEntityShulkerBox) {
                world.c(pos, state.b());
            }
        }
    }

    @Override
    public void a(ItemStack stack, Item.b context, List<IChatBaseComponent> tooltip, TooltipFlag options) {
        super.a(stack, context, tooltip, options);
        if (stack.b(DataComponents.ap)) {
            tooltip.add(d);
        }
        int i2 = 0;
        int j2 = 0;
        for (ItemStack itemStack : stack.a(DataComponents.al, ItemContainerContents.a).d()) {
            ++j2;
            if (i2 > 4) continue;
            ++i2;
            tooltip.add(IChatBaseComponent.a("container.shulkerBox.itemCount", itemStack.y(), itemStack.L()));
        }
        if (j2 - i2 > 0) {
            tooltip.add(IChatBaseComponent.a("container.shulkerBox.more", j2 - i2).a(EnumChatFormat.u));
        }
    }

    @Override
    protected VoxelShape b_(IBlockData state, IBlockAccess world, BlockPosition pos) {
        TileEntityShulkerBox shulkerBoxBlockEntity;
        TileEntity tileEntity = world.c_(pos);
        if (tileEntity instanceof TileEntityShulkerBox && !(shulkerBoxBlockEntity = (TileEntityShulkerBox)tileEntity).u()) {
            return l.get(state.c(b).g());
        }
        return VoxelShapes.b();
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        TileEntity blockEntity = world.c_(pos);
        return blockEntity instanceof TileEntityShulkerBox ? VoxelShapes.a(((TileEntityShulkerBox)blockEntity).a(state)) : VoxelShapes.b();
    }

    @Override
    protected boolean e_(IBlockData state) {
        return false;
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World world, BlockPosition pos) {
        return Container.a(world.c_(pos));
    }

    @Override
    public ItemStack a(IWorldReader world, BlockPosition pos, IBlockData state) {
        ItemStack itemStack = super.a(world, pos, state);
        world.a(pos, TileEntityTypes.y).ifPresent(blockEntity -> blockEntity.a(itemStack, (HolderLookup.a)world.K_()));
        return itemStack;
    }

    @Nullable
    public static EnumColor b(Item item) {
        return BlockShulkerBox.a(Block.a(item));
    }

    @Nullable
    public static EnumColor a(Block block) {
        return block instanceof BlockShulkerBox ? ((BlockShulkerBox)block).b() : null;
    }

    public static Block a(@Nullable EnumColor dyeColor) {
        if (dyeColor == null) {
            return Blocks.lk;
        }
        return switch (dyeColor) {
            default -> throw new MatchException(null, null);
            case EnumColor.a -> Blocks.ll;
            case EnumColor.b -> Blocks.lm;
            case EnumColor.c -> Blocks.ln;
            case EnumColor.d -> Blocks.lo;
            case EnumColor.e -> Blocks.lp;
            case EnumColor.f -> Blocks.lq;
            case EnumColor.g -> Blocks.lr;
            case EnumColor.h -> Blocks.ls;
            case EnumColor.i -> Blocks.lt;
            case EnumColor.j -> Blocks.lu;
            case EnumColor.l -> Blocks.lw;
            case EnumColor.m -> Blocks.lx;
            case EnumColor.n -> Blocks.ly;
            case EnumColor.o -> Blocks.lz;
            case EnumColor.p -> Blocks.lA;
            case EnumColor.k -> Blocks.lv;
        };
    }

    @Nullable
    public EnumColor b() {
        return this.m;
    }

    public static ItemStack b(@Nullable EnumColor color) {
        return new ItemStack(BlockShulkerBox.a(color));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }
}

