/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.player.PlayerOpenSignEvent;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyWood;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftSign;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerSignOpenEvent;

public abstract class BlockSign
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final BlockStateBoolean f = BlockProperties.D;
    protected static final float g = 4.0f;
    protected static final VoxelShape h = Block.a(4.0, 0.0, 4.0, 12.0, 16.0, 12.0);
    private final BlockPropertyWood a;

    protected BlockSign(BlockPropertyWood type, BlockBase.Info settings) {
        super(settings);
        this.a = type;
    }

    protected abstract MapCodec<? extends BlockSign> a();

    @Override
    protected IBlockData a(IBlockData state, IWorldReader world, ScheduledTickAccess tickView, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(f).booleanValue()) {
            tickView.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return super.a(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return h;
    }

    @Override
    public boolean a(IBlockData state) {
        return true;
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntitySign(pos, state);
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof TileEntitySign) {
            boolean flag;
            SignApplicator signapplicator1;
            TileEntitySign tileentitysign = (TileEntitySign)tileentity;
            Item item = stack.h();
            SignApplicator signapplicator = item instanceof SignApplicator ? (signapplicator1 = (SignApplicator)((Object)item)) : null;
            SignApplicator signapplicator2 = signapplicator;
            boolean bl = flag = signapplicator2 != null && player.gv();
            if (!world.C) {
                if (flag && !tileentitysign.v() && !this.a(player, tileentitysign)) {
                    boolean flag1 = tileentitysign.a(player);
                    if (signapplicator2.a(tileentitysign.a(flag1), player) && signapplicator2.a(world, tileentitysign, flag1, player)) {
                        tileentitysign.a(player, world, pos, flag1);
                        player.b(StatisticList.c.b(stack.h()));
                        world.a(GameEvent.c, tileentitysign.aB_(), GameEvent.a.a(player, tileentitysign.m()));
                        stack.a(1, (EntityLiving)player);
                        return EnumInteractionResult.a;
                    }
                    return EnumInteractionResult.f;
                }
                return EnumInteractionResult.f;
            }
            return !flag && !tileentitysign.v() ? EnumInteractionResult.c : EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hit) {
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof TileEntitySign) {
            TileEntitySign tileentitysign = (TileEntitySign)tileentity;
            if (world.C) {
                SystemUtils.b(new IllegalStateException("Expected to only call this on server"));
            }
            boolean flag = tileentitysign.a(player);
            boolean flag1 = tileentitysign.a(player, world, pos, flag);
            if (tileentitysign.v()) {
                world.a((EntityHuman)null, tileentitysign.aB_(), tileentitysign.d(), SoundCategory.e);
                return EnumInteractionResult.b;
            }
            if (flag1) {
                return EnumInteractionResult.b;
            }
            if (!this.a(player, tileentitysign) && player.gv() && this.b(player, tileentitysign, flag)) {
                this.openTextEdit(player, tileentitysign, flag, PlayerOpenSignEvent.Cause.INTERACT);
                return EnumInteractionResult.b;
            }
            return EnumInteractionResult.e;
        }
        return EnumInteractionResult.e;
    }

    private boolean b(EntityHuman player, TileEntitySign blockEntity, boolean front) {
        SignText signtext = blockEntity.a(front);
        return Arrays.stream(signtext.b(player.aa())).allMatch(ichatbasecomponent -> ichatbasecomponent.equals(CommonComponents.a) || ichatbasecomponent.b() instanceof LiteralContents);
    }

    public abstract float h(IBlockData var1);

    public Vec3D o(IBlockData state) {
        return new Vec3D(0.5, 0.5, 0.5);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(f) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    public BlockPropertyWood d() {
        return this.a;
    }

    public static BlockPropertyWood a(Block block) {
        BlockPropertyWood blockpropertywood = block instanceof BlockSign ? ((BlockSign)block).d() : BlockPropertyWood.b;
        return blockpropertywood;
    }

    @DoNotUse
    @Deprecated
    public void a(EntityHuman player, TileEntitySign blockEntity, boolean front) {
        this.openTextEdit(player, blockEntity, front, PlayerOpenSignEvent.Cause.UNKNOWN);
    }

    public void openTextEdit(EntityHuman entityhuman, TileEntitySign tileentitysign, boolean flag, PlayerOpenSignEvent.Cause cause) {
        CraftBlock bukkitBlock;
        CraftSign bukkitSign;
        Player bukkitPlayer = (Player)entityhuman.getBukkitEntity();
        PlayerOpenSignEvent event = new PlayerOpenSignEvent(bukkitPlayer, (Sign)(bukkitSign = (CraftSign)CraftBlockStates.getBlockState(bukkitBlock = CraftBlock.at(tileentitysign.i(), tileentitysign.aB_()))), flag ? Side.FRONT : Side.BACK, cause);
        if (!event.callEvent()) {
            return;
        }
        if (PlayerSignOpenEvent.getHandlerList().getRegisteredListeners().length > 0) {
            PlayerSignOpenEvent.Cause legacyCause;
            switch (cause) {
                default: {
                    throw new MatchException(null, null);
                }
                case PLACE: {
                    PlayerSignOpenEvent.Cause cause2 = PlayerSignOpenEvent.Cause.PLACE;
                    break;
                }
                case PLUGIN: {
                    PlayerSignOpenEvent.Cause cause2 = PlayerSignOpenEvent.Cause.PLUGIN;
                    break;
                }
                case INTERACT: {
                    PlayerSignOpenEvent.Cause cause2 = PlayerSignOpenEvent.Cause.INTERACT;
                    break;
                }
                case UNKNOWN: {
                    PlayerSignOpenEvent.Cause cause2 = legacyCause = PlayerSignOpenEvent.Cause.UNKNOWN;
                }
            }
            if (!CraftEventFactory.callPlayerSignOpenEvent(entityhuman, tileentitysign, flag, legacyCause)) {
                return;
            }
        }
        tileentitysign.a(entityhuman.cG());
        entityhuman.a(tileentitysign, flag);
    }

    private boolean a(EntityHuman player, TileEntitySign blockEntity) {
        UUID uuid = blockEntity.u();
        return uuid != null && !uuid.equals(player.cG());
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData state, TileEntityTypes<T> type) {
        return null;
    }
}

