/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockStepAbstract;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertyStairsShape;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockStairs
extends Block
implements IBlockWaterlogged {
    public static final MapCodec<BlockStairs> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IBlockData.a.fieldOf("base_state").forGetter(block -> block.I), BlockStairs.t()).apply((Applicative)instance, BlockStairs::new));
    public static final BlockStateEnum<EnumDirection> b = BlockFacingHorizontal.aF;
    public static final BlockStateEnum<BlockPropertyHalf> c = BlockProperties.ag;
    public static final BlockStateEnum<BlockPropertyStairsShape> d = BlockProperties.bj;
    public static final BlockStateBoolean e = BlockProperties.D;
    protected static final VoxelShape f = BlockStepAbstract.e;
    protected static final VoxelShape g = BlockStepAbstract.d;
    protected static final VoxelShape h = Block.a(0.0, 0.0, 0.0, 8.0, 8.0, 8.0);
    protected static final VoxelShape i = Block.a(0.0, 0.0, 8.0, 8.0, 8.0, 16.0);
    protected static final VoxelShape j = Block.a(0.0, 8.0, 0.0, 8.0, 16.0, 8.0);
    protected static final VoxelShape k = Block.a(0.0, 8.0, 8.0, 8.0, 16.0, 16.0);
    protected static final VoxelShape l = Block.a(8.0, 0.0, 0.0, 16.0, 8.0, 8.0);
    protected static final VoxelShape m = Block.a(8.0, 0.0, 8.0, 16.0, 8.0, 16.0);
    protected static final VoxelShape n = Block.a(8.0, 8.0, 0.0, 16.0, 16.0, 8.0);
    protected static final VoxelShape o = Block.a(8.0, 8.0, 8.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape[] G = BlockStairs.a(f, h, l, i, m);
    protected static final VoxelShape[] H = BlockStairs.a(g, j, n, k, o);
    private static final int[] J = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
    private final Block K;
    protected final IBlockData I;

    @Override
    public MapCodec<? extends BlockStairs> a() {
        return a;
    }

    private static VoxelShape[] a(VoxelShape base, VoxelShape northWest, VoxelShape northEast, VoxelShape southWest, VoxelShape southEast) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(i2 -> BlockStairs.a(i2, base, northWest, northEast, southWest, southEast)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape a(int i2, VoxelShape base, VoxelShape northWest, VoxelShape northEast, VoxelShape southWest, VoxelShape southEast) {
        VoxelShape voxelShape = base;
        if ((i2 & 1) != 0) {
            voxelShape = VoxelShapes.a(voxelShape, northWest);
        }
        if ((i2 & 2) != 0) {
            voxelShape = VoxelShapes.a(voxelShape, northEast);
        }
        if ((i2 & 4) != 0) {
            voxelShape = VoxelShapes.a(voxelShape, southWest);
        }
        if ((i2 & 8) != 0) {
            voxelShape = VoxelShapes.a(voxelShape, southEast);
        }
        return voxelShape;
    }

    protected BlockStairs(IBlockData baseBlockState, BlockBase.Info settings) {
        super(settings);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.F.b().b(b, EnumDirection.c)).b(c, BlockPropertyHalf.b)).b(d, BlockPropertyStairsShape.a)).b(e, false));
        this.K = baseBlockState.b();
        this.I = baseBlockState;
    }

    @Override
    @Override
    protected boolean g_(IBlockData state) {
        return true;
    }

    @Override
    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return (state.c(c) == BlockPropertyHalf.a ? G : H)[J[this.q(state)]];
    }

    private int q(IBlockData state) {
        return state.c(d).ordinal() * 4 + state.c(b).e();
    }

    @Override
    @Override
    public float e() {
        return this.K.e();
    }

    @Override
    @Override
    public IBlockData a(BlockActionContext ctx) {
        EnumDirection direction = ctx.k();
        BlockPosition blockPos = ctx.a();
        Fluid fluidState = ctx.q().b_(blockPos);
        IBlockData blockState = (IBlockData)((IBlockData)((IBlockData)this.m().b(b, ctx.g())).b(c, direction == EnumDirection.a || direction != EnumDirection.b && ctx.l().e - (double)blockPos.v() > 0.5 ? BlockPropertyHalf.a : BlockPropertyHalf.b)).b(e, fluidState.a() == FluidTypes.c);
        return (IBlockData)blockState.b(d, BlockStairs.e(blockState, ctx.q(), blockPos));
    }

    @Override
    @Override
    protected IBlockData a(IBlockData state, IWorldReader world, ScheduledTickAccess tickView, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(e).booleanValue()) {
            tickView.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        if (direction.o().d()) {
            return (IBlockData)state.b(d, BlockStairs.e(state, world, pos));
        }
        return super.a(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    private static BlockPropertyStairsShape e(IBlockData state, IBlockAccess world, BlockPosition pos) {
        EnumDirection direction3;
        EnumDirection direction2;
        EnumDirection direction = state.c(b);
        IBlockData blockState = world.a_(pos.a(direction));
        if (BlockStairs.o(blockState) && state.c(c) == blockState.c(c) && (direction2 = blockState.c(b)).o() != state.c(b).o() && BlockStairs.c(state, world, pos, direction2.g())) {
            if (direction2 == direction.i()) {
                return BlockPropertyStairsShape.d;
            }
            return BlockPropertyStairsShape.e;
        }
        IBlockData blockState2 = world.a_(pos.a(direction.g()));
        if (BlockStairs.o(blockState2) && state.c(c) == blockState2.c(c) && (direction3 = blockState2.c(b)).o() != state.c(b).o() && BlockStairs.c(state, world, pos, direction3)) {
            if (direction3 == direction.i()) {
                return BlockPropertyStairsShape.b;
            }
            return BlockPropertyStairsShape.c;
        }
        return BlockPropertyStairsShape.a;
    }

    private static boolean c(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection dir) {
        IBlockData blockState = world.a_(pos.a(dir));
        return !BlockStairs.o(blockState) || blockState.c(b) != state.c(b) || blockState.c(c) != state.c(c);
    }

    public static boolean o(IBlockData state) {
        return state.b() instanceof BlockStairs;
    }

    @Override
    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b)));
    }

    @Override
    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        EnumDirection direction = state.c(b);
        BlockPropertyStairsShape stairsShape = state.c(d);
        switch (mirror) {
            case b: {
                if (direction.o() != EnumDirection.EnumAxis.c) break;
                switch (stairsShape) {
                    case b: {
                        return (IBlockData)state.a(EnumBlockRotation.c).b(d, BlockPropertyStairsShape.c);
                    }
                    case c: {
                        return (IBlockData)state.a(EnumBlockRotation.c).b(d, BlockPropertyStairsShape.b);
                    }
                    case d: {
                        return (IBlockData)state.a(EnumBlockRotation.c).b(d, BlockPropertyStairsShape.e);
                    }
                    case e: {
                        return (IBlockData)state.a(EnumBlockRotation.c).b(d, BlockPropertyStairsShape.d);
                    }
                }
                return state.a(EnumBlockRotation.c);
            }
            case c: {
                if (direction.o() != EnumDirection.EnumAxis.a) break;
                switch (stairsShape) {
                    case b: {
                        return (IBlockData)state.a(EnumBlockRotation.c).b(d, BlockPropertyStairsShape.b);
                    }
                    case c: {
                        return (IBlockData)state.a(EnumBlockRotation.c).b(d, BlockPropertyStairsShape.c);
                    }
                    case d: {
                        return (IBlockData)state.a(EnumBlockRotation.c).b(d, BlockPropertyStairsShape.e);
                    }
                    case e: {
                        return (IBlockData)state.a(EnumBlockRotation.c).b(d, BlockPropertyStairsShape.d);
                    }
                    case a: {
                        return state.a(EnumBlockRotation.c);
                    }
                }
                break;
            }
        }
        return super.a(state, mirror);
    }

    @Override
    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d, e);
    }

    @Override
    @Override
    protected Fluid b_(IBlockData state) {
        if (state.c(e).booleanValue()) {
            return FluidTypes.c.a(false);
        }
        return super.b_(state);
    }

    @Override
    @Override
    protected boolean a(IBlockData state, PathMode type) {
        return false;
    }
}

