/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertySlabType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockStepAbstract
extends Block
implements IBlockWaterlogged {
    public static final MapCodec<BlockStepAbstract> a = BlockStepAbstract.b(BlockStepAbstract::new);
    public static final BlockStateEnum<BlockPropertySlabType> b = BlockProperties.bi;
    public static final BlockStateBoolean c = BlockProperties.D;
    protected static final VoxelShape d = Block.a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    protected static final VoxelShape e = Block.a(0.0, 8.0, 0.0, 16.0, 16.0, 16.0);

    @Override
    public MapCodec<? extends BlockStepAbstract> a() {
        return a;
    }

    public BlockStepAbstract(BlockBase.Info settings) {
        super(settings);
        this.l((IBlockData)((IBlockData)this.m().b(b, BlockPropertySlabType.b)).b(c, false));
    }

    @Override
    @Override
    protected boolean g_(IBlockData state) {
        return state.c(b) != BlockPropertySlabType.c;
    }

    @Override
    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c);
    }

    @Override
    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        BlockPropertySlabType slabType = state.c(b);
        switch (slabType) {
            case c: {
                return VoxelShapes.b();
            }
            case a: {
                return e;
            }
        }
        return d;
    }

    @Override
    @Nullable
    @Override
    public IBlockData a(BlockActionContext ctx) {
        BlockPosition blockPos = ctx.a();
        IBlockData blockState = ctx.q().a_(blockPos);
        if (blockState.a(this)) {
            return (IBlockData)((IBlockData)blockState.b(b, BlockPropertySlabType.c)).b(c, false);
        }
        Fluid fluidState = ctx.q().b_(blockPos);
        IBlockData blockState2 = (IBlockData)((IBlockData)this.m().b(b, BlockPropertySlabType.b)).b(c, fluidState.a() == FluidTypes.c);
        EnumDirection direction = ctx.k();
        if (direction == EnumDirection.a || direction != EnumDirection.b && ctx.l().e - (double)blockPos.v() > 0.5) {
            return (IBlockData)blockState2.b(b, BlockPropertySlabType.a);
        }
        return blockState2;
    }

    @Override
    @Override
    protected boolean a(IBlockData state, BlockActionContext context) {
        ItemStack itemStack = context.n();
        BlockPropertySlabType slabType = state.c(b);
        if (slabType == BlockPropertySlabType.c || !itemStack.a(this.j())) {
            return false;
        }
        if (context.c()) {
            boolean bl = context.l().e - (double)context.a().v() > 0.5;
            EnumDirection direction = context.k();
            if (slabType == BlockPropertySlabType.b) {
                return direction == EnumDirection.b || bl && direction.o().d();
            }
            return direction == EnumDirection.a || !bl && direction.o().d();
        }
        return true;
    }

    @Override
    @Override
    protected Fluid b_(IBlockData state) {
        if (state.c(c).booleanValue()) {
            return FluidTypes.c.a(false);
        }
        return super.b_(state);
    }

    @Override
    @Override
    public boolean a(GeneratorAccess world, BlockPosition pos, IBlockData state, Fluid fluidState) {
        if (state.c(b) != BlockPropertySlabType.c) {
            return IBlockWaterlogged.super.a(world, pos, state, fluidState);
        }
        return false;
    }

    @Override
    @Override
    public boolean a(@Nullable EntityHuman player, IBlockAccess world, BlockPosition pos, IBlockData state, FluidType fluid) {
        if (state.c(b) != BlockPropertySlabType.c) {
            return IBlockWaterlogged.super.a(player, world, pos, state, fluid);
        }
        return false;
    }

    @Override
    @Override
    protected IBlockData a(IBlockData state, IWorldReader world, ScheduledTickAccess tickView, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(c).booleanValue()) {
            tickView.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return super.a(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    @Override
    protected boolean a(IBlockData state, PathMode type) {
        switch (type) {
            case a: {
                return false;
            }
            case b: {
                return state.y().a(TagsFluid.a);
            }
            case c: {
                return false;
            }
        }
        return false;
    }
}

