/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.Collections;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.inventory.ItemStack;

public class BlockSweetBerryBush
extends BlockPlant
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockSweetBerryBush> a = BlockSweetBerryBush.b(BlockSweetBerryBush::new);
    private static final float d = 0.003f;
    public static final int b = 3;
    public static final BlockStateInteger c = BlockProperties.at;
    private static final VoxelShape e = Block.a(3.0, 0.0, 3.0, 13.0, 8.0, 13.0);
    private static final VoxelShape f = Block.a(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);

    public MapCodec<BlockSweetBerryBush> a() {
        return a;
    }

    public BlockSweetBerryBush(BlockBase.Info settings) {
        super(settings);
        this.l((IBlockData)this.F.b().b(c, 0));
    }

    @Override
    public net.minecraft.world.item.ItemStack a(IWorldReader world, BlockPosition pos, IBlockData state) {
        return new net.minecraft.world.item.ItemStack(Items.xl);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return state.c(c) == 0 ? e : (state.c(c) < 3 ? f : super.a(state, world, pos, context));
    }

    @Override
    protected boolean f(IBlockData state) {
        return state.c(c) < 3;
    }

    @Override
    protected void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        int i2 = state.c(c);
        if (i2 < 3 && random.i() < (float)world.spigotConfig.sweetBerryModifier / 500.0f && world.b(pos.d(), 0) >= 9) {
            IBlockData iblockdata1 = (IBlockData)state.b(c, i2 + 1);
            if (!CraftEventFactory.handleBlockGrowEvent(world, pos, iblockdata1, 2)) {
                return;
            }
            world.a(GameEvent.c, pos, GameEvent.a.a(iblockdata1));
        }
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (entity instanceof EntityLiving && entity.aq() != EntityTypes.ab && entity.aq() != EntityTypes.l) {
            entity.a(state, new Vec3D(0.8f, 0.75, 0.8f));
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (state.c(c) != 0) {
                    Vec3D vec3d;
                    Vec3D vec3D = vec3d = entity.dj() ? entity.ah() : entity.bC().d(entity.du());
                    if (vec3d.j() > 0.0) {
                        double d0 = Math.abs(vec3d.a());
                        double d1 = Math.abs(vec3d.c());
                        if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                            entity.a(worldserver, world.aj().u().directBlock(world, pos), 1.0f);
                        }
                    }
                    return;
                }
            }
        }
    }

    @Override
    protected EnumInteractionResult a(net.minecraft.world.item.ItemStack stack, IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        int i2 = state.c(c);
        boolean flag = i2 == 3;
        return !flag && stack.a(Items.sm) ? EnumInteractionResult.e : super.a(stack, state, world, pos, player, hand, hit);
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hit) {
        boolean flag;
        int i2 = state.c(c);
        boolean bl = flag = i2 == 3;
        if (i2 > 1) {
            int j2 = 1 + world.A.a(2);
            PlayerHarvestBlockEvent event = CraftEventFactory.callPlayerHarvestBlockEvent(world, pos, player, EnumHand.a, Collections.singletonList(new net.minecraft.world.item.ItemStack(Items.xl, j2 + (flag ? 1 : 0))));
            if (event.isCancelled()) {
                return EnumInteractionResult.a;
            }
            for (ItemStack itemStack : event.getItemsHarvested()) {
                BlockSweetBerryBush.a(world, pos, CraftItemStack.asNMSCopy(itemStack));
            }
            world.a((EntityHuman)null, pos, SoundEffects.zR, SoundCategory.e, 1.0f, 0.8f + world.A.i() * 0.4f);
            IBlockData iblockdata1 = (IBlockData)state.b(c, 1);
            world.a(pos, iblockdata1, 2);
            world.a(GameEvent.c, pos, GameEvent.a.a(player, iblockdata1));
            return EnumInteractionResult.a;
        }
        return super.a(state, world, pos, player, hit);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{c});
    }

    @Override
    public boolean b(IWorldReader world, BlockPosition pos, IBlockData state) {
        return state.c(c) < 3;
    }

    @Override
    public boolean a(World world, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer world, RandomSource random, BlockPosition pos, IBlockData state) {
        int i2 = Math.min(3, state.c(c) + 1);
        world.a(pos, (IBlockData)state.b(c, i2), 2);
    }
}

