/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.BlockTall;
import net.minecraft.world.level.block.BlockTripwireHook;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.PluginManager;

public class BlockTripwire
extends Block {
    public static final MapCodec<BlockTripwire> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.e.q().fieldOf("hook").forGetter(blocktripwire -> blocktripwire.m), BlockTripwire.t()).apply((Applicative)instance, BlockTripwire::new));
    public static final BlockStateBoolean b = BlockProperties.x;
    public static final BlockStateBoolean c = BlockProperties.a;
    public static final BlockStateBoolean d = BlockProperties.d;
    public static final BlockStateBoolean e = BlockSprawling.b;
    public static final BlockStateBoolean f = BlockSprawling.c;
    public static final BlockStateBoolean g = BlockSprawling.d;
    public static final BlockStateBoolean h = BlockSprawling.e;
    private static final Map<EnumDirection, BlockStateBoolean> k = BlockTall.f;
    protected static final VoxelShape i = Block.a(0.0, 1.0, 0.0, 16.0, 2.5, 16.0);
    protected static final VoxelShape j = Block.a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    private static final int l = 10;
    private final Block m;

    public MapCodec<BlockTripwire> a() {
        return a;
    }

    public BlockTripwire(Block hookBlock, BlockBase.Info settings) {
        super(settings);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.F.b().b(b, false)).b(c, false)).b(d, false)).b(e, false)).b(f, false)).b(g, false)).b(h, false));
        this.m = hookBlock;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return state.c(c) != false ? i : j;
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return this.m();
        }
        World world = ctx.q();
        BlockPosition blockposition = ctx.a();
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.m().b(e, this.a(world.a_(blockposition.f()), EnumDirection.c))).b(f, this.a(world.a_(blockposition.i()), EnumDirection.f))).b(g, this.a(world.a_(blockposition.g()), EnumDirection.d))).b(h, this.a(world.a_(blockposition.h()), EnumDirection.e));
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader world, ScheduledTickAccess tickView, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return state;
        }
        return direction.o().d() ? (IBlockData)state.b(k.get(direction), this.a(neighborState, direction)) : super.a(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return;
        }
        if (!oldState.a(state.b())) {
            this.a(world, pos, state);
        }
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return;
        }
        if (!moved && !state.a(newState.b())) {
            this.a(world, pos, (IBlockData)state.b(b, true));
        }
    }

    @Override
    public IBlockData a(World world, BlockPosition pos, IBlockData state, EntityHuman player) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return state;
        }
        if (!world.C && !player.eZ().f() && player.eZ().a(Items.sJ)) {
            world.a(pos, (IBlockData)state.b(d, true), 4);
            world.a((net.minecraft.world.entity.Entity)player, GameEvent.M, pos);
        }
        return super.a(world, pos, state, player);
    }

    private void a(World world, BlockPosition pos, IBlockData state) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return;
        }
        block0: for (EnumDirection enumdirection : new EnumDirection[]{EnumDirection.d, EnumDirection.e}) {
            for (int k2 = 1; k2 < 42; ++k2) {
                BlockPosition blockposition1 = pos.a(enumdirection, k2);
                IBlockData iblockdata1 = world.a_(blockposition1);
                if (iblockdata1.a(this.m)) {
                    if (iblockdata1.c(BlockTripwireHook.b) != enumdirection.g()) continue block0;
                    BlockTripwireHook.a(world, blockposition1, iblockdata1, false, true, k2, state);
                    continue block0;
                }
                if (!iblockdata1.a(this)) continue block0;
            }
        }
    }

    @Override
    protected VoxelShape a_(IBlockData state, World world, BlockPosition pos) {
        return state.f(world, pos);
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return;
        }
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (!world.C && !state.c(b).booleanValue()) {
            this.a(world, pos, List.of(entity));
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return;
        }
        if (world.a_(pos).c(b).booleanValue()) {
            this.a(world, pos);
        }
    }

    private void a(World world, BlockPosition pos) {
        IBlockData iblockdata = world.a_(pos);
        List<net.minecraft.world.entity.Entity> list = world.a_(null, iblockdata.f(world, pos).a().a(pos));
        this.a(world, pos, list);
    }

    private void a(World world, BlockPosition pos, List<? extends net.minecraft.world.entity.Entity> entities) {
        IBlockData iblockdata = world.a_(pos);
        boolean flag = iblockdata.c(b);
        boolean flag1 = false;
        if (!entities.isEmpty()) {
            for (net.minecraft.world.entity.Entity entity : entities) {
                if (entity.s_()) continue;
                flag1 = true;
                break;
            }
        }
        if (flag != flag1 && flag1 && iblockdata.c(c).booleanValue()) {
            CraftWorld bworld = world.getWorld();
            PluginManager pluginManager = world.getCraftServer().getPluginManager();
            org.bukkit.block.Block block = bworld.getBlockAt(pos.u(), pos.v(), pos.w());
            boolean allowed = false;
            for (net.minecraft.world.entity.Entity entity : entities) {
                PlayerInteractEvent cancellable;
                if (entity == null) continue;
                if (entity instanceof EntityHuman) {
                    cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, pos, null, null, null);
                } else {
                    if (!(entity instanceof net.minecraft.world.entity.Entity)) continue;
                    cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), block);
                    pluginManager.callEvent((Event)((EntityInteractEvent)cancellable));
                }
                if (cancellable.isCancelled()) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                return;
            }
        }
        if (flag1 != flag) {
            iblockdata = (IBlockData)iblockdata.b(b, flag1);
            world.a(pos, iblockdata, 3);
            this.a(world, pos, iblockdata);
        }
        if (flag1) {
            world.a(new BlockPosition(pos), (Block)this, 10);
        }
    }

    public boolean a(IBlockData state, EnumDirection facing) {
        return state.a(this.m) ? state.c(BlockTripwireHook.b) == facing.g() : state.a(this);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        switch (rotation) {
            case c: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(e, state.c(g))).b(f, state.c(h))).b(g, state.c(e))).b(h, state.c(f));
            }
            case d: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(e, state.c(f))).b(f, state.c(g))).b(g, state.c(h))).b(h, state.c(e));
            }
            case b: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(e, state.c(h))).b(f, state.c(e))).b(g, state.c(f))).b(h, state.c(g));
            }
        }
        return state;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        switch (mirror) {
            case b: {
                return (IBlockData)((IBlockData)state.b(e, state.c(g))).b(g, state.c(e));
            }
            case c: {
                return (IBlockData)((IBlockData)state.b(f, state.c(h))).b(h, state.c(f));
            }
        }
        return super.a(state, mirror);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d, e, f, h, g);
    }
}

