/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;

public class BlockVine
extends Block {
    public static final MapCodec<BlockVine> a = BlockVine.b(BlockVine::new);
    public static final BlockStateBoolean b = BlockSprawling.f;
    public static final BlockStateBoolean c = BlockSprawling.b;
    public static final BlockStateBoolean d = BlockSprawling.c;
    public static final BlockStateBoolean e = BlockSprawling.d;
    public static final BlockStateBoolean f = BlockSprawling.e;
    public static final Map<EnumDirection, BlockStateBoolean> g = BlockSprawling.h.entrySet().stream().filter(entry -> entry.getKey() != EnumDirection.a).collect(SystemUtils.a());
    protected static final float h = 1.0f;
    private static final VoxelShape i = Block.a(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape j = Block.a(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape k = Block.a(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape l = Block.a(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape m = Block.a(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private final Map<IBlockData, VoxelShape> n;

    public MapCodec<BlockVine> a() {
        return a;
    }

    public BlockVine(BlockBase.Info settings) {
        super(settings);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.F.b().b(b, false)).b(c, false)).b(d, false)).b(e, false)).b(f, false));
        this.n = ImmutableMap.copyOf(this.F.a().stream().collect(Collectors.toMap(Function.identity(), BlockVine::o)));
    }

    private static VoxelShape o(IBlockData state) {
        VoxelShape voxelshape = VoxelShapes.a();
        if (state.c(b).booleanValue()) {
            voxelshape = i;
        }
        if (state.c(c).booleanValue()) {
            voxelshape = VoxelShapes.a(voxelshape, l);
        }
        if (state.c(e).booleanValue()) {
            voxelshape = VoxelShapes.a(voxelshape, m);
        }
        if (state.c(d).booleanValue()) {
            voxelshape = VoxelShapes.a(voxelshape, k);
        }
        if (state.c(f).booleanValue()) {
            voxelshape = VoxelShapes.a(voxelshape, j);
        }
        return voxelshape.c() ? VoxelShapes.b() : voxelshape;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.n.get(state);
    }

    @Override
    protected boolean e_(IBlockData state) {
        return true;
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        return this.q(this.e(state, world, pos));
    }

    private boolean q(IBlockData state) {
        return this.r(state) > 0;
    }

    private int r(IBlockData state) {
        int i2 = 0;
        for (BlockStateBoolean blockstateboolean : g.values()) {
            if (!state.c(blockstateboolean).booleanValue()) continue;
            ++i2;
        }
        return i2;
    }

    private boolean b(IBlockAccess world, BlockPosition pos, EnumDirection side) {
        if (side == EnumDirection.a) {
            return false;
        }
        BlockPosition blockposition1 = pos.a(side);
        if (BlockVine.a(world, blockposition1, side)) {
            return true;
        }
        if (side.o() == EnumDirection.EnumAxis.b) {
            return false;
        }
        BlockStateBoolean blockstateboolean = g.get(side);
        IBlockData iblockdata = world.a_(pos.d());
        return iblockdata.a(this) && iblockdata.c(blockstateboolean) != false;
    }

    public static boolean a(IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return MultifaceBlock.a(world, direction, pos, world.a_(pos));
    }

    private IBlockData e(IBlockData state, IBlockAccess world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.d();
        if (state.c(b).booleanValue()) {
            state = (IBlockData)state.b(b, BlockVine.a(world, blockposition1, EnumDirection.a));
        }
        BlockBase.BlockData iblockdata1 = null;
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            BlockStateBoolean blockstateboolean = BlockVine.a(enumdirection);
            if (!state.c(blockstateboolean).booleanValue()) continue;
            boolean flag = this.b(world, pos, enumdirection);
            if (!flag) {
                if (iblockdata1 == null) {
                    iblockdata1 = world.a_(blockposition1);
                }
                flag = iblockdata1.a(this) && iblockdata1.c(blockstateboolean) != false;
            }
            state = (IBlockData)state.b(blockstateboolean, flag);
        }
        return state;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader world, ScheduledTickAccess tickView, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (direction == EnumDirection.a) {
            return super.a(state, world, tickView, pos, direction, neighborPos, neighborState, random);
        }
        IBlockData iblockdata2 = this.e(state, world, pos);
        return !this.q(iblockdata2) ? Blocks.a.m() : iblockdata2;
    }

    @Override
    protected void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (world.N().b(GameRules.Y) && random.i() < (float)world.spigotConfig.vineModifier / 400.0f) {
            EnumDirection enumdirection = EnumDirection.b(random);
            BlockPosition blockposition1 = pos.d();
            if (enumdirection.o().d() && !state.c(BlockVine.a(enumdirection)).booleanValue()) {
                if (this.a((IBlockAccess)world, pos)) {
                    BlockPosition blockposition2 = pos.a(enumdirection);
                    IBlockData iblockdata1 = world.a_(blockposition2);
                    if (iblockdata1.l()) {
                        EnumDirection enumdirection1 = enumdirection.h();
                        EnumDirection enumdirection2 = enumdirection.i();
                        boolean flag = state.c(BlockVine.a(enumdirection1));
                        boolean flag1 = state.c(BlockVine.a(enumdirection2));
                        BlockPosition blockposition3 = blockposition2.a(enumdirection1);
                        BlockPosition blockposition4 = blockposition2.a(enumdirection2);
                        BlockPosition source = pos;
                        if (flag && BlockVine.a((IBlockAccess)world, blockposition3, enumdirection1)) {
                            CraftEventFactory.handleBlockSpreadEvent(world, source, blockposition2, (IBlockData)this.m().b(BlockVine.a(enumdirection1), true), 2);
                        } else if (flag1 && BlockVine.a((IBlockAccess)world, blockposition4, enumdirection2)) {
                            CraftEventFactory.handleBlockSpreadEvent(world, source, blockposition2, (IBlockData)this.m().b(BlockVine.a(enumdirection2), true), 2);
                        } else {
                            EnumDirection enumdirection3 = enumdirection.g();
                            if (flag && world.u(blockposition3) && BlockVine.a((IBlockAccess)world, pos.a(enumdirection1), enumdirection3)) {
                                CraftEventFactory.handleBlockSpreadEvent(world, source, blockposition3, (IBlockData)this.m().b(BlockVine.a(enumdirection3), true), 2);
                            } else if (flag1 && world.u(blockposition4) && BlockVine.a((IBlockAccess)world, pos.a(enumdirection2), enumdirection3)) {
                                CraftEventFactory.handleBlockSpreadEvent(world, source, blockposition4, (IBlockData)this.m().b(BlockVine.a(enumdirection3), true), 2);
                            } else if ((double)random.i() < 0.05 && BlockVine.a((IBlockAccess)world, blockposition2.d(), EnumDirection.b)) {
                                CraftEventFactory.handleBlockSpreadEvent(world, source, blockposition2, (IBlockData)this.m().b(b, true), 2);
                            }
                        }
                    } else if (BlockVine.a((IBlockAccess)world, blockposition2, enumdirection)) {
                        CraftEventFactory.handleBlockGrowEvent(world, pos, (IBlockData)state.b(BlockVine.a(enumdirection), true), 2);
                    }
                }
            } else {
                IBlockData iblockdata4;
                IBlockData iblockdata3;
                BlockPosition blockposition2;
                IBlockData iblockdata1;
                if (enumdirection == EnumDirection.b && pos.v() < world.am()) {
                    if (this.b(world, pos, enumdirection)) {
                        CraftEventFactory.handleBlockGrowEvent(world, pos, (IBlockData)state.b(b, true), 2);
                        return;
                    }
                    if (world.u(blockposition1)) {
                        if (!this.a((IBlockAccess)world, pos)) {
                            return;
                        }
                        IBlockData iblockdata2 = state;
                        for (EnumDirection enumdirection1 : EnumDirection.EnumDirectionLimit.a) {
                            if (!random.h() && BlockVine.a((IBlockAccess)world, blockposition1.a(enumdirection1), enumdirection1)) continue;
                            iblockdata2 = (IBlockData)iblockdata2.b(BlockVine.a(enumdirection1), false);
                        }
                        if (this.s(iblockdata2)) {
                            CraftEventFactory.handleBlockSpreadEvent(world, pos, blockposition1, iblockdata2, 2);
                        }
                        return;
                    }
                }
                if (pos.v() > world.L_() && ((iblockdata1 = world.a_(blockposition2 = pos.e())).l() || iblockdata1.a(this)) && (iblockdata3 = iblockdata1.l() ? this.m() : iblockdata1) != (iblockdata4 = this.a(state, iblockdata3, random)) && this.s(iblockdata4)) {
                    CraftEventFactory.handleBlockSpreadEvent(world, pos, blockposition2, iblockdata4, 2);
                }
            }
        }
    }

    private IBlockData a(IBlockData above, IBlockData state, RandomSource random) {
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            BlockStateBoolean blockstateboolean;
            if (!random.h() || !above.c(blockstateboolean = BlockVine.a(enumdirection)).booleanValue()) continue;
            state = (IBlockData)state.b(blockstateboolean, true);
        }
        return state;
    }

    private boolean s(IBlockData state) {
        return state.c(c) != false || state.c(d) != false || state.c(e) != false || state.c(f) != false;
    }

    private boolean a(IBlockAccess world, BlockPosition pos) {
        boolean flag = true;
        Iterable<BlockPosition> iterable = BlockPosition.b(pos.u() - 4, pos.v() - 1, pos.w() - 4, pos.u() + 4, pos.v() + 1, pos.w() + 4);
        int i2 = 5;
        for (BlockPosition blockposition1 : iterable) {
            if (!world.a_(blockposition1).a(this) || --i2 > 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean a(IBlockData state, BlockActionContext context) {
        IBlockData iblockdata1 = context.q().a_(context.a());
        return iblockdata1.a(this) ? this.r(iblockdata1) < g.size() : super.a(state, context);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext ctx) {
        IBlockData iblockdata = ctx.q().a_(ctx.a());
        boolean flag = iblockdata.a(this);
        IBlockData iblockdata1 = flag ? iblockdata : this.m();
        for (EnumDirection enumdirection : ctx.f()) {
            boolean flag1;
            if (enumdirection == EnumDirection.a) continue;
            BlockStateBoolean blockstateboolean = BlockVine.a(enumdirection);
            boolean bl = flag1 = flag && iblockdata.c(blockstateboolean) != false;
            if (flag1 || !this.b(ctx.q(), ctx.a(), enumdirection)) continue;
            return (IBlockData)iblockdata1.b(blockstateboolean, true);
        }
        return flag ? iblockdata1 : null;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d, e, f);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        switch (rotation) {
            case c: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(c, state.c(e))).b(d, state.c(f))).b(e, state.c(c))).b(f, state.c(d));
            }
            case d: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(c, state.c(d))).b(d, state.c(e))).b(e, state.c(f))).b(f, state.c(c));
            }
            case b: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(c, state.c(f))).b(d, state.c(c))).b(e, state.c(d))).b(f, state.c(e));
            }
        }
        return state;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        switch (mirror) {
            case b: {
                return (IBlockData)((IBlockData)state.b(c, state.c(e))).b(e, state.c(c));
            }
            case c: {
                return (IBlockData)((IBlockData)state.b(d, state.c(f))).b(f, state.c(d));
            }
        }
        return super.a(state, mirror);
    }

    public static BlockStateBoolean a(EnumDirection direction) {
        return g.get(direction);
    }
}

