/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;

public class BrushableBlock
extends BlockTileEntity
implements Fallable {
    public static final MapCodec<BrushableBlock> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.e.q().fieldOf("turns_into").forGetter(BrushableBlock::b), (App)BuiltInRegistries.b.q().fieldOf("brush_sound").forGetter(BrushableBlock::c), (App)BuiltInRegistries.b.q().fieldOf("brush_completed_sound").forGetter(BrushableBlock::d), BrushableBlock.t()).apply((Applicative)instance, BrushableBlock::new));
    private static final BlockStateInteger c = BlockProperties.bw;
    public static final int b = 2;
    private final Block d;
    private final SoundEffect e;
    private final SoundEffect f;

    @Override
    public MapCodec<BrushableBlock> a() {
        return a;
    }

    public BrushableBlock(Block baseBlock, SoundEffect brushingSound, SoundEffect brushingCompleteSound, BlockBase.Info settings) {
        super(settings);
        this.d = baseBlock;
        this.e = brushingSound;
        this.f = brushingCompleteSound;
        this.l((IBlockData)this.F.b().b(c, 0));
    }

    @Override
    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{c});
    }

    @Override
    @Override
    public EnumRenderType a_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    @Override
    public void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        world.a(pos, (Block)this, 2);
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, IWorldReader world, ScheduledTickAccess tickView, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        tickView.a(pos, this, 2);
        return super.a(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        TileEntity tileEntity = world.c_(pos);
        if (tileEntity instanceof BrushableBlockEntity) {
            BrushableBlockEntity brushableBlockEntity = (BrushableBlockEntity)tileEntity;
            brushableBlockEntity.a(world);
        }
        if (!BlockFalling.n(world.a_(pos.e())) || pos.v() < world.L_()) {
            return;
        }
        EntityFallingBlock fallingBlockEntity = EntityFallingBlock.a(world, pos, state);
        fallingBlockEntity.m();
    }

    @Override
    @Override
    public void a(World world, BlockPosition pos, EntityFallingBlock fallingBlockEntity) {
        Vec3D vec3 = fallingBlockEntity.cR().f();
        world.c(2001, BlockPosition.a(vec3), Block.j(fallingBlockEntity.p()));
        world.a((Entity)fallingBlockEntity, GameEvent.f, vec3);
    }

    @Override
    @Override
    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
        BlockPosition blockPos;
        if (random.a(16) == 0 && BlockFalling.n(world.a_(blockPos = pos.e()))) {
            double d2 = (double)pos.u() + random.j();
            double e2 = (double)pos.v() - 0.05;
            double f2 = (double)pos.w() + random.j();
            world.a(new ParticleParamBlock(Particles.C, state), d2, e2, f2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    @Nullable
    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new BrushableBlockEntity(pos, state);
    }

    public Block b() {
        return this.d;
    }

    public SoundEffect c() {
        return this.e;
    }

    public SoundEffect d() {
        return this.f;
    }
}

