/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyWallHeight;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class MossyCarpetBlock
extends Block
implements IBlockFragilePlantElement {
    public static final MapCodec<MossyCarpetBlock> a = MossyCarpetBlock.b(MossyCarpetBlock::new);
    public static final BlockStateBoolean b = BlockProperties.b;
    private static final BlockStateEnum<BlockPropertyWallHeight> c = BlockProperties.Y;
    private static final BlockStateEnum<BlockPropertyWallHeight> d = BlockProperties.X;
    private static final BlockStateEnum<BlockPropertyWallHeight> e = BlockProperties.Z;
    private static final BlockStateEnum<BlockPropertyWallHeight> f = BlockProperties.aa;
    private static final Map<EnumDirection, BlockStateEnum<BlockPropertyWallHeight>> g = ImmutableMap.copyOf((Map)SystemUtils.a(Maps.newEnumMap(EnumDirection.class), (? super T map) -> {
        map.put(EnumDirection.c, c);
        map.put(EnumDirection.f, d);
        map.put(EnumDirection.d, e);
        map.put(EnumDirection.e, f);
    }));
    private static final float h = 1.0f;
    private static final VoxelShape i = Block.a(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);
    private static final VoxelShape j = Block.a(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape k = Block.a(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape l = Block.a(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape m = Block.a(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private static final int n = 10;
    private static final VoxelShape o = Block.a(0.0, 0.0, 0.0, 1.0, 10.0, 16.0);
    private static final VoxelShape G = Block.a(15.0, 0.0, 0.0, 16.0, 10.0, 16.0);
    private static final VoxelShape H = Block.a(0.0, 0.0, 0.0, 16.0, 10.0, 1.0);
    private static final VoxelShape I = Block.a(0.0, 0.0, 15.0, 16.0, 10.0, 16.0);
    private final Map<IBlockData, VoxelShape> J;

    @Override
    public MapCodec<MossyCarpetBlock> a() {
        return a;
    }

    public MossyCarpetBlock(BlockBase.Info settings) {
        super(settings);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.F.b().b(b, true)).b(c, BlockPropertyWallHeight.a)).b(d, BlockPropertyWallHeight.a)).b(e, BlockPropertyWallHeight.a)).b(f, BlockPropertyWallHeight.a));
        this.J = ImmutableMap.copyOf(this.F.a().stream().collect(Collectors.toMap(Function.identity(), MossyCarpetBlock::o)));
    }

    @Override
    @Override
    protected VoxelShape d_(IBlockData state) {
        return VoxelShapes.a();
    }

    private static VoxelShape o(IBlockData state) {
        VoxelShape voxelShape = VoxelShapes.a();
        if (state.c(b).booleanValue()) {
            voxelShape = i;
        }
        voxelShape = switch (state.c(c)) {
            default -> throw new MatchException(null, null);
            case BlockPropertyWallHeight.a -> voxelShape;
            case BlockPropertyWallHeight.b -> VoxelShapes.a(voxelShape, H);
            case BlockPropertyWallHeight.c -> VoxelShapes.a(voxelShape, l);
        };
        voxelShape = switch (state.c(e)) {
            default -> throw new MatchException(null, null);
            case BlockPropertyWallHeight.a -> voxelShape;
            case BlockPropertyWallHeight.b -> VoxelShapes.a(voxelShape, I);
            case BlockPropertyWallHeight.c -> VoxelShapes.a(voxelShape, m);
        };
        voxelShape = switch (state.c(d)) {
            default -> throw new MatchException(null, null);
            case BlockPropertyWallHeight.a -> voxelShape;
            case BlockPropertyWallHeight.b -> VoxelShapes.a(voxelShape, G);
            case BlockPropertyWallHeight.c -> VoxelShapes.a(voxelShape, k);
        };
        voxelShape = switch (state.c(f)) {
            default -> throw new MatchException(null, null);
            case BlockPropertyWallHeight.a -> voxelShape;
            case BlockPropertyWallHeight.b -> VoxelShapes.a(voxelShape, o);
            case BlockPropertyWallHeight.c -> VoxelShapes.a(voxelShape, j);
        };
        return voxelShape.c() ? VoxelShapes.b() : voxelShape;
    }

    @Override
    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.J.get(state);
    }

    @Override
    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return state.c(b) != false ? i : VoxelShapes.a();
    }

    @Override
    @Override
    protected boolean e_(IBlockData state) {
        return true;
    }

    @Override
    @Override
    protected boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        IBlockData blockState = world.a_(pos.e());
        if (state.c(b).booleanValue()) {
            return !blockState.l();
        }
        return blockState.a(this) && blockState.c(b) != false;
    }

    private static boolean q(IBlockData state) {
        if (state.c(b).booleanValue()) {
            return true;
        }
        for (BlockStateEnum<BlockPropertyWallHeight> enumProperty : g.values()) {
            if (state.c(enumProperty) == BlockPropertyWallHeight.a) continue;
            return true;
        }
        return false;
    }

    private static boolean a(IBlockAccess world, BlockPosition pos, EnumDirection face) {
        if (face == EnumDirection.b) {
            return false;
        }
        BlockPosition blockPos = pos.a(face);
        return MultifaceBlock.a(world, face, blockPos, world.a_(blockPos));
    }

    private static IBlockData a(IBlockData state, IBlockAccess world, BlockPosition pos, boolean bl) {
        BlockBase.BlockData blockState = null;
        BlockBase.BlockData blockState2 = null;
        bl |= state.c(b).booleanValue();
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            BlockPropertyWallHeight wallSide;
            BlockStateEnum<BlockPropertyWallHeight> enumProperty = MossyCarpetBlock.a(direction);
            BlockPropertyWallHeight blockPropertyWallHeight = MossyCarpetBlock.a(world, pos, direction) ? (bl ? BlockPropertyWallHeight.b : state.c(enumProperty)) : (wallSide = BlockPropertyWallHeight.a);
            if (wallSide == BlockPropertyWallHeight.b) {
                if (blockState == null) {
                    blockState = world.a_(pos.d());
                }
                if (blockState.a(Blocks.tQ) && blockState.c(enumProperty) != BlockPropertyWallHeight.a && !blockState.c(b).booleanValue()) {
                    wallSide = BlockPropertyWallHeight.c;
                }
                if (!state.c(b).booleanValue()) {
                    if (blockState2 == null) {
                        blockState2 = world.a_(pos.e());
                    }
                    if (blockState2.a(Blocks.tQ) && blockState2.c(enumProperty) == BlockPropertyWallHeight.a) {
                        wallSide = BlockPropertyWallHeight.a;
                    }
                }
            }
            state = (IBlockData)state.b(enumProperty, wallSide);
        }
        return state;
    }

    @Override
    @Nullable
    @Override
    public IBlockData a(BlockActionContext ctx) {
        return MossyCarpetBlock.a(this.m(), (IBlockAccess)ctx.q(), ctx.a(), true);
    }

    public static void a(GeneratorAccess world, BlockPosition pos, RandomSource random, int flags) {
        IBlockData blockState = Blocks.tQ.m();
        IBlockData blockState2 = MossyCarpetBlock.a(blockState, (IBlockAccess)world, pos, true);
        world.a(pos, blockState2, 3);
        IBlockData blockState3 = MossyCarpetBlock.a((IBlockAccess)world, pos, random::h);
        if (!blockState3.l()) {
            world.a(pos.d(), blockState3, flags);
        }
    }

    @Override
    @Override
    public void a(World world, BlockPosition pos, IBlockData state, @Nullable EntityLiving placer, ItemStack itemStack) {
        if (world.C) {
            return;
        }
        RandomSource randomSource = world.H_();
        IBlockData blockState = MossyCarpetBlock.a((IBlockAccess)world, pos, randomSource::h);
        if (!blockState.l()) {
            world.a(pos.d(), blockState, 3);
        }
    }

    private static IBlockData a(IBlockAccess world, BlockPosition pos, BooleanSupplier booleanSupplier) {
        BlockPosition blockPos = pos.d();
        IBlockData blockState = world.a_(blockPos);
        boolean bl = blockState.a(Blocks.tQ);
        if (bl && blockState.c(b).booleanValue() || !bl && !blockState.v()) {
            return Blocks.a.m();
        }
        IBlockData blockState2 = (IBlockData)Blocks.tQ.m().b(b, false);
        IBlockData blockState3 = MossyCarpetBlock.a(blockState2, world, pos.d(), true);
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            BlockStateEnum<BlockPropertyWallHeight> enumProperty = MossyCarpetBlock.a(direction);
            if (blockState3.c(enumProperty) == BlockPropertyWallHeight.a || booleanSupplier.getAsBoolean()) continue;
            blockState3 = (IBlockData)blockState3.b(enumProperty, BlockPropertyWallHeight.a);
        }
        if (MossyCarpetBlock.q(blockState3) && blockState3 != blockState) {
            return blockState3;
        }
        return Blocks.a.m();
    }

    @Override
    @Override
    protected IBlockData a(IBlockData state, IWorldReader world, ScheduledTickAccess tickView, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (!state.a(world, pos)) {
            return Blocks.a.m();
        }
        IBlockData blockState = MossyCarpetBlock.a(state, world, pos, false);
        if (!MossyCarpetBlock.q(blockState)) {
            return Blocks.a.m();
        }
        return blockState;
    }

    @Override
    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d, e, f);
    }

    @Override
    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return switch (rotation) {
            case EnumBlockRotation.c -> (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(c, state.c(e))).b(d, state.c(f))).b(e, state.c(c))).b(f, state.c(d));
            case EnumBlockRotation.d -> (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(c, state.c(d))).b(d, state.c(e))).b(e, state.c(f))).b(f, state.c(c));
            case EnumBlockRotation.b -> (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(c, state.c(f))).b(d, state.c(c))).b(e, state.c(d))).b(f, state.c(e));
            default -> state;
        };
    }

    @Override
    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return switch (mirror) {
            case EnumBlockMirror.b -> (IBlockData)((IBlockData)state.b(c, state.c(e))).b(e, state.c(c));
            case EnumBlockMirror.c -> (IBlockData)((IBlockData)state.b(d, state.c(f))).b(f, state.c(d));
            default -> super.a(state, mirror);
        };
    }

    @Nullable
    public static BlockStateEnum<BlockPropertyWallHeight> a(EnumDirection face) {
        return g.get(face);
    }

    @Override
    @Override
    public boolean b(IWorldReader world, BlockPosition pos, IBlockData state) {
        return state.c(b);
    }

    @Override
    @Override
    public boolean a(World world, RandomSource random, BlockPosition pos, IBlockData state) {
        return !MossyCarpetBlock.a((IBlockAccess)world, pos, () -> true).l();
    }

    @Override
    @Override
    public void a(WorldServer world, RandomSource random, BlockPosition pos, IBlockData state) {
        IBlockData blockState = MossyCarpetBlock.a((IBlockAccess)world, pos, () -> true);
        if (!blockState.l()) {
            world.a(pos.d(), blockState, 3);
        }
    }
}

