/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.MapCodec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;

public class PointedDripstoneBlock
extends Block
implements Fallable,
IBlockWaterlogged {
    public static final MapCodec<PointedDripstoneBlock> a = PointedDripstoneBlock.b(PointedDripstoneBlock::new);
    public static final BlockStateEnum<EnumDirection> b = BlockProperties.bn;
    public static final BlockStateEnum<DripstoneThickness> c = BlockProperties.bo;
    public static final BlockStateBoolean d = BlockProperties.D;
    private static final int e = 11;
    private static final int f = 2;
    private static final float g = 0.02f;
    private static final float h = 0.12f;
    private static final int i = 11;
    private static final float j = 0.17578125f;
    private static final float k = 0.05859375f;
    private static final double l = 0.6;
    private static final float m = 1.0f;
    private static final int n = 40;
    private static final int o = 6;
    private static final float G = 2.0f;
    private static final int H = 2;
    private static final float I = 5.0f;
    private static final float J = 0.011377778f;
    private static final int K = 7;
    private static final int L = 10;
    private static final float M = 0.6875f;
    private static final VoxelShape N = Block.a(5.0, 0.0, 5.0, 11.0, 16.0, 11.0);
    private static final VoxelShape O = Block.a(5.0, 0.0, 5.0, 11.0, 11.0, 11.0);
    private static final VoxelShape P = Block.a(5.0, 5.0, 5.0, 11.0, 16.0, 11.0);
    private static final VoxelShape Q = Block.a(4.0, 0.0, 4.0, 12.0, 16.0, 12.0);
    private static final VoxelShape R = Block.a(3.0, 0.0, 3.0, 13.0, 16.0, 13.0);
    private static final VoxelShape S = Block.a(2.0, 0.0, 2.0, 14.0, 16.0, 14.0);
    private static final float T = 0.125f;
    private static final VoxelShape U = Block.a(6.0, 0.0, 6.0, 10.0, 16.0, 10.0);

    public MapCodec<PointedDripstoneBlock> a() {
        return a;
    }

    public PointedDripstoneBlock(BlockBase.Info settings) {
        super(settings);
        this.l((IBlockData)((IBlockData)((IBlockData)this.F.b().b(b, EnumDirection.b)).b(c, DripstoneThickness.b)).b(d, false));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d);
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        return PointedDripstoneBlock.c(world, pos, state.c(b));
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader world, ScheduledTickAccess tickView, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(d).booleanValue()) {
            tickView.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        if (direction != EnumDirection.b && direction != EnumDirection.a) {
            return state;
        }
        EnumDirection enumdirection1 = state.c(b);
        if (enumdirection1 == EnumDirection.a && tickView.T().a(pos, this)) {
            return state;
        }
        if (direction == enumdirection1.g() && !this.a(state, world, pos)) {
            if (enumdirection1 == EnumDirection.a) {
                tickView.a(pos, this, 2);
            } else {
                tickView.a(pos, this, 1);
            }
            return state;
        }
        boolean flag = state.c(c) == DripstoneThickness.a;
        DripstoneThickness dripstonethickness = PointedDripstoneBlock.a(world, pos, enumdirection1, flag);
        return (IBlockData)state.b(c, dripstonethickness);
    }

    @Override
    protected void a(World world, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        if (!world.C) {
            WorldServer worldserver;
            BlockPosition blockposition = hit.b();
            if (world instanceof WorldServer && projectile.c(worldserver = (WorldServer)world, blockposition) && projectile.a(worldserver) && projectile instanceof EntityThrownTrident && projectile.dz().g() > 0.6) {
                if (!CraftEventFactory.callEntityChangeBlockEvent(projectile, blockposition, state.y().g())) {
                    return;
                }
                world.b(blockposition, true);
            }
        }
    }

    @Override
    public void a(World world, IBlockData state, BlockPosition pos, Entity entity, float fallDistance) {
        if (state.c(b) == EnumDirection.b && state.c(c) == DripstoneThickness.b) {
            entity.a(fallDistance + 2.0f, 2.0f, world.aj().w().directBlock(world, pos));
        } else {
            super.a(world, state, pos, entity, fallDistance);
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
        float f2;
        if (PointedDripstoneBlock.o(state) && (f2 = random.i()) <= 0.12f) {
            PointedDripstoneBlock.b(world, pos, state).filter(pointeddripstoneblock_a -> f2 < 0.02f || PointedDripstoneBlock.a(pointeddripstoneblock_a.b)).ifPresent(pointeddripstoneblock_a -> PointedDripstoneBlock.a(world, pos, state, pointeddripstoneblock_a.b));
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (PointedDripstoneBlock.r(state) && !this.a(state, (IWorldReader)world, pos)) {
            world.b(pos, true);
        } else {
            PointedDripstoneBlock.a(state, world, pos);
        }
    }

    @Override
    protected void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        PointedDripstoneBlock.a(state, world, pos, random.i());
        if (random.i() < 0.011377778f && PointedDripstoneBlock.b(state, (IWorldReader)world, pos)) {
            PointedDripstoneBlock.c(state, world, pos, random);
        }
    }

    @VisibleForTesting
    public static void a(IBlockData state, WorldServer world, BlockPosition pos, float dripChance) {
        Optional<a> optional;
        if ((dripChance <= 0.17578125f || dripChance <= 0.05859375f) && PointedDripstoneBlock.b(state, (IWorldReader)world, pos) && !(optional = PointedDripstoneBlock.b(world, pos, state)).isEmpty()) {
            BlockPosition blockposition1;
            float f1;
            FluidType fluidtype = optional.get().b;
            if (fluidtype == FluidTypes.c) {
                f1 = 0.17578125f;
            } else {
                if (fluidtype != FluidTypes.e) {
                    return;
                }
                f1 = 0.05859375f;
            }
            if (dripChance < f1 && (blockposition1 = PointedDripstoneBlock.a(state, world, pos, 11, false)) != null) {
                if (optional.get().c.a(Blocks.td) && fluidtype == FluidTypes.c) {
                    IBlockData iblockdata1 = Blocks.ee.m();
                    if (CraftEventFactory.handleBlockFormEvent(world, optional.get().a, iblockdata1)) {
                        Block.a(optional.get().c, iblockdata1, world, optional.get().a);
                        world.a(GameEvent.c, optional.get().a, GameEvent.a.a(iblockdata1));
                        world.c(1504, blockposition1, 0);
                    }
                } else {
                    BlockPosition blockposition2 = PointedDripstoneBlock.a((World)world, blockposition1, fluidtype);
                    if (blockposition2 != null) {
                        world.c(1504, blockposition1, 0);
                        int i2 = blockposition1.v() - blockposition2.v();
                        int j2 = 50 + i2;
                        IBlockData iblockdata2 = world.a_(blockposition2);
                        world.a(blockposition2, iblockdata2.b(), j2);
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext ctx) {
        EnumDirection enumdirection;
        BlockPosition blockposition;
        World world = ctx.q();
        EnumDirection enumdirection1 = PointedDripstoneBlock.b((IWorldReader)world, blockposition = ctx.a(), enumdirection = ctx.e().g());
        if (enumdirection1 == null) {
            return null;
        }
        boolean flag = !ctx.h();
        DripstoneThickness dripstonethickness = PointedDripstoneBlock.a((IWorldReader)world, blockposition, enumdirection1, flag);
        return dripstonethickness == null ? null : (IBlockData)((IBlockData)((IBlockData)this.m().b(b, enumdirection1)).b(c, dripstonethickness)).b(d, world.b_(blockposition).a() == FluidTypes.c);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(d) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected VoxelShape d_(IBlockData state) {
        return VoxelShapes.a();
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        DripstoneThickness dripstonethickness = state.c(c);
        VoxelShape voxelshape = dripstonethickness == DripstoneThickness.a ? N : (dripstonethickness == DripstoneThickness.b ? (state.c(b) == EnumDirection.a ? P : O) : (dripstonethickness == DripstoneThickness.c ? Q : (dripstonethickness == DripstoneThickness.d ? R : S)));
        Vec3D vec3d = state.a(pos);
        return voxelshape.a(vec3d.d, 0.0, vec3d.f);
    }

    @Override
    protected boolean a_(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return false;
    }

    @Override
    protected float as_() {
        return 0.125f;
    }

    @Override
    public void a(World world, BlockPosition pos, EntityFallingBlock fallingBlockEntity) {
        if (!fallingBlockEntity.bb()) {
            world.c(1045, pos, 0);
        }
    }

    @Override
    public DamageSource a(Entity attacker) {
        return attacker.dX().c(attacker);
    }

    private static void a(IBlockData state, WorldServer world, BlockPosition pos) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = pos.k();
        IBlockData iblockdata1 = state;
        while (PointedDripstoneBlock.q(iblockdata1)) {
            EntityFallingBlock entityfallingblock = EntityFallingBlock.a(world, blockposition_mutableblockposition, iblockdata1);
            if (PointedDripstoneBlock.a(iblockdata1, true)) {
                int i2 = Math.max(1 + pos.v() - blockposition_mutableblockposition.v(), 6);
                float f2 = 1.0f * (float)i2;
                entityfallingblock.b(f2, 40);
                break;
            }
            blockposition_mutableblockposition.c(EnumDirection.a);
            iblockdata1 = world.a_(blockposition_mutableblockposition);
        }
    }

    @VisibleForTesting
    public static void c(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        IBlockData iblockdata3;
        BlockPosition blockposition1;
        IBlockData iblockdata2;
        IBlockData iblockdata1 = world.a_(pos.b(1));
        if (PointedDripstoneBlock.a(iblockdata1, iblockdata2 = world.a_(pos.b(2))) && (blockposition1 = PointedDripstoneBlock.a(state, world, pos, 7, false)) != null && PointedDripstoneBlock.o(iblockdata3 = world.a_(blockposition1)) && PointedDripstoneBlock.b(iblockdata3, world, blockposition1)) {
            if (random.h()) {
                PointedDripstoneBlock.a(world, blockposition1, EnumDirection.a);
            } else {
                PointedDripstoneBlock.b(world, blockposition1);
            }
        }
    }

    private static void b(WorldServer world, BlockPosition pos) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = pos.k();
        for (int i2 = 0; i2 < 10; ++i2) {
            blockposition_mutableblockposition.c(EnumDirection.a);
            IBlockData iblockdata = world.a_(blockposition_mutableblockposition);
            if (!iblockdata.y().c()) {
                return;
            }
            if (PointedDripstoneBlock.a(iblockdata, EnumDirection.b) && PointedDripstoneBlock.b(iblockdata, world, (BlockPosition)blockposition_mutableblockposition)) {
                PointedDripstoneBlock.a(world, (BlockPosition)blockposition_mutableblockposition, EnumDirection.b);
                return;
            }
            if (PointedDripstoneBlock.c(world, blockposition_mutableblockposition, EnumDirection.b) && !world.z(blockposition_mutableblockposition.e())) {
                PointedDripstoneBlock.a(world, blockposition_mutableblockposition.e(), EnumDirection.b);
                return;
            }
            if (PointedDripstoneBlock.a((IBlockAccess)world, (BlockPosition)blockposition_mutableblockposition, iblockdata)) continue;
            return;
        }
    }

    private static void a(WorldServer world, BlockPosition pos, EnumDirection direction) {
        BlockPosition blockposition1 = pos.a(direction);
        IBlockData iblockdata = world.a_(blockposition1);
        if (PointedDripstoneBlock.a(iblockdata, direction.g())) {
            PointedDripstoneBlock.a(iblockdata, (GeneratorAccess)world, blockposition1);
        } else if (iblockdata.l() || iblockdata.a(Blocks.J)) {
            PointedDripstoneBlock.createDripstone(world, blockposition1, direction, DripstoneThickness.b, pos);
        }
    }

    private static void createDripstone(GeneratorAccess generatoraccess, BlockPosition blockposition, EnumDirection enumdirection, DripstoneThickness dripstonethickness, BlockPosition source) {
        IBlockData iblockdata = (IBlockData)((IBlockData)((IBlockData)Blocks.sO.m().b(b, enumdirection)).b(c, dripstonethickness)).b(d, generatoraccess.b_(blockposition).a() == FluidTypes.c);
        CraftEventFactory.handleBlockSpreadEvent(generatoraccess, source, blockposition, iblockdata, 3);
    }

    private static void a(IBlockData state, GeneratorAccess world, BlockPosition pos) {
        BlockPosition blockposition2;
        BlockPosition blockposition1;
        if (state.c(b) == EnumDirection.b) {
            blockposition1 = pos;
            blockposition2 = pos.d();
        } else {
            blockposition2 = pos;
            blockposition1 = pos.e();
        }
        PointedDripstoneBlock.createDripstone(world, blockposition2, EnumDirection.a, DripstoneThickness.a, pos);
        PointedDripstoneBlock.createDripstone(world, blockposition1, EnumDirection.b, DripstoneThickness.a, pos);
    }

    public static void a(World world, BlockPosition pos, IBlockData state) {
        PointedDripstoneBlock.b(world, pos, state).ifPresent(pointeddripstoneblock_a -> PointedDripstoneBlock.a(world, pos, state, pointeddripstoneblock_a.b));
    }

    private static void a(World world, BlockPosition pos, IBlockData state, FluidType fluid) {
        Vec3D vec3d = state.a(pos);
        double d0 = 0.0625;
        double d1 = (double)pos.u() + 0.5 + vec3d.d;
        double d2 = (double)((float)(pos.v() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)pos.w() + 0.5 + vec3d.f;
        FluidType fluidtype1 = PointedDripstoneBlock.a(world, fluid);
        ParticleType particletype = fluidtype1.a(TagsFluid.b) ? Particles.aM : Particles.aO;
        world.a(particletype, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPosition a(IBlockData state, GeneratorAccess world, BlockPosition pos, int range, boolean allowMerged) {
        if (PointedDripstoneBlock.a(state, allowMerged)) {
            return pos;
        }
        EnumDirection enumdirection = state.c(b);
        BiPredicate<BlockPosition, IBlockData> bipredicate = (blockposition1, iblockdata1) -> iblockdata1.a(Blocks.sO) && iblockdata1.c(b) == enumdirection;
        return PointedDripstoneBlock.a(world, pos, enumdirection.f(), bipredicate, (IBlockData iblockdata1) -> PointedDripstoneBlock.a(iblockdata1, allowMerged), range).orElse(null);
    }

    @Nullable
    private static EnumDirection b(IWorldReader world, BlockPosition pos, EnumDirection direction) {
        EnumDirection enumdirection1;
        if (PointedDripstoneBlock.c(world, pos, direction)) {
            enumdirection1 = direction;
        } else {
            if (!PointedDripstoneBlock.c(world, pos, direction.g())) {
                return null;
            }
            enumdirection1 = direction.g();
        }
        return enumdirection1;
    }

    private static DripstoneThickness a(IWorldReader world, BlockPosition pos, EnumDirection direction, boolean tryMerge) {
        EnumDirection enumdirection1 = direction.g();
        IBlockData iblockdata = world.a_(pos.a(direction));
        if (PointedDripstoneBlock.b(iblockdata, enumdirection1)) {
            return !tryMerge && iblockdata.c(c) != DripstoneThickness.a ? DripstoneThickness.b : DripstoneThickness.a;
        }
        if (!PointedDripstoneBlock.b(iblockdata, direction)) {
            return DripstoneThickness.b;
        }
        DripstoneThickness dripstonethickness = iblockdata.c(c);
        if (dripstonethickness != DripstoneThickness.b && dripstonethickness != DripstoneThickness.a) {
            IBlockData iblockdata1 = world.a_(pos.a(enumdirection1));
            return !PointedDripstoneBlock.b(iblockdata1, direction) ? DripstoneThickness.e : DripstoneThickness.d;
        }
        return DripstoneThickness.c;
    }

    public static boolean o(IBlockData state) {
        return PointedDripstoneBlock.q(state) && state.c(c) == DripstoneThickness.b && state.c(d) == false;
    }

    private static boolean b(IBlockData state, WorldServer world, BlockPosition pos) {
        EnumDirection enumdirection = state.c(b);
        BlockPosition blockposition1 = pos.a(enumdirection);
        IBlockData iblockdata1 = world.a_(blockposition1);
        return !iblockdata1.y().c() ? false : (iblockdata1.l() ? true : PointedDripstoneBlock.a(iblockdata1, enumdirection.g()));
    }

    private static Optional<BlockPosition> a(World world, BlockPosition pos, IBlockData state, int range) {
        EnumDirection enumdirection = state.c(b);
        BiPredicate<BlockPosition, IBlockData> bipredicate = (blockposition1, iblockdata1) -> iblockdata1.a(Blocks.sO) && iblockdata1.c(b) == enumdirection;
        return PointedDripstoneBlock.a(world, pos, enumdirection.g().f(), bipredicate, (IBlockData iblockdata1) -> !iblockdata1.a(Blocks.sO), range);
    }

    private static boolean c(IWorldReader world, BlockPosition pos, EnumDirection direction) {
        BlockPosition blockposition1 = pos.a(direction.g());
        IBlockData iblockdata = world.a_(blockposition1);
        return iblockdata.c((IBlockAccess)world, blockposition1, direction) || PointedDripstoneBlock.b(iblockdata, direction);
    }

    private static boolean a(IBlockData state, boolean allowMerged) {
        if (!state.a(Blocks.sO)) {
            return false;
        }
        DripstoneThickness dripstonethickness = state.c(c);
        return dripstonethickness == DripstoneThickness.b || allowMerged && dripstonethickness == DripstoneThickness.a;
    }

    private static boolean a(IBlockData state, EnumDirection direction) {
        return PointedDripstoneBlock.a(state, false) && state.c(b) == direction;
    }

    private static boolean q(IBlockData state) {
        return PointedDripstoneBlock.b(state, EnumDirection.a);
    }

    private static boolean r(IBlockData state) {
        return PointedDripstoneBlock.b(state, EnumDirection.b);
    }

    private static boolean b(IBlockData state, IWorldReader world, BlockPosition pos) {
        return PointedDripstoneBlock.q(state) && !world.a_(pos.d()).a(Blocks.sO);
    }

    @Override
    protected boolean a(IBlockData state, PathMode type) {
        return false;
    }

    private static boolean b(IBlockData state, EnumDirection direction) {
        return state.a(Blocks.sO) && state.c(b) == direction;
    }

    @Nullable
    private static BlockPosition a(World world, BlockPosition pos, FluidType fluid) {
        Predicate<IBlockData> predicate = iblockdata -> iblockdata.b() instanceof AbstractCauldronBlock && ((AbstractCauldronBlock)iblockdata.b()).a(fluid);
        BiPredicate<BlockPosition, IBlockData> bipredicate = (blockposition1, iblockdata) -> PointedDripstoneBlock.a((IBlockAccess)world, blockposition1, iblockdata);
        return PointedDripstoneBlock.a(world, pos, EnumDirection.a.f(), bipredicate, predicate, 11).orElse(null);
    }

    @Nullable
    public static BlockPosition a(World world, BlockPosition pos) {
        BiPredicate<BlockPosition, IBlockData> bipredicate = (blockposition1, iblockdata) -> PointedDripstoneBlock.a((IBlockAccess)world, blockposition1, iblockdata);
        return PointedDripstoneBlock.a(world, pos, EnumDirection.b.f(), bipredicate, PointedDripstoneBlock::o, 11).orElse(null);
    }

    public static FluidType a(WorldServer world, BlockPosition pos) {
        return PointedDripstoneBlock.b(world, pos, world.a_(pos)).map(pointeddripstoneblock_a -> pointeddripstoneblock_a.b).filter(PointedDripstoneBlock::a).orElse(FluidTypes.a);
    }

    private static Optional<a> b(World world, BlockPosition pos, IBlockData state) {
        return !PointedDripstoneBlock.q(state) ? Optional.empty() : PointedDripstoneBlock.a(world, pos, state, 11).map(blockposition1 -> {
            BlockPosition blockposition2 = blockposition1.d();
            IBlockData iblockdata1 = world.a_(blockposition2);
            FluidType object = iblockdata1.a(Blocks.td) && !world.G_().i() ? FluidTypes.c : world.b_(blockposition2).a();
            return new a(blockposition2, object, iblockdata1);
        });
    }

    private static boolean a(FluidType fluid) {
        return fluid == FluidTypes.e || fluid == FluidTypes.c;
    }

    private static boolean a(IBlockData dripstoneBlockState, IBlockData waterState) {
        return dripstoneBlockState.a(Blocks.sP) && waterState.a(Blocks.J) && waterState.y().b();
    }

    private static FluidType a(World world, FluidType fluid) {
        return fluid.a(FluidTypes.a) ? (world.G_().i() ? FluidTypes.e : FluidTypes.c) : fluid;
    }

    private static Optional<BlockPosition> a(GeneratorAccess world, BlockPosition pos, EnumDirection.EnumAxisDirection direction, BiPredicate<BlockPosition, IBlockData> continuePredicate, Predicate<IBlockData> stopPredicate, int range) {
        EnumDirection enumdirection = EnumDirection.a(direction, EnumDirection.EnumAxis.b);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = pos.k();
        for (int j2 = 1; j2 < range; ++j2) {
            blockposition_mutableblockposition.c(enumdirection);
            IBlockData iblockdata = world.a_(blockposition_mutableblockposition);
            if (stopPredicate.test(iblockdata)) {
                return Optional.of(blockposition_mutableblockposition.j());
            }
            if (!world.e(blockposition_mutableblockposition.v()) && continuePredicate.test(blockposition_mutableblockposition, iblockdata)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean a(IBlockAccess world, BlockPosition pos, IBlockData state) {
        if (state.l()) {
            return true;
        }
        if (state.s()) {
            return false;
        }
        if (!state.y().c()) {
            return false;
        }
        VoxelShape voxelshape = state.g(world, pos);
        return !VoxelShapes.c(U, voxelshape, OperatorBoolean.i);
    }

    record a(BlockPosition a, FluidType b, IBlockData c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "pos;fluid;sourceState", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "pos;fluid;sourceState", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "pos;fluid;sourceState", "a", "b", "c"}, this, o2);
        }
    }
}

