/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public class SculkShriekerBlockEntity
extends TileEntity
implements GameEventListener.b<VibrationSystem.b>,
VibrationSystem {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 10;
    private static final int c = 20;
    private static final int d = 5;
    private static final int h = 6;
    private static final int i = 40;
    private static final int j = 90;
    private static final Int2ObjectMap<SoundEffect> k = (Int2ObjectMap)SystemUtils.a(new Int2ObjectOpenHashMap(), (? super T warningSounds) -> {
        warningSounds.put(1, (Object)SoundEffects.Cq);
        warningSounds.put(2, (Object)SoundEffects.Cr);
        warningSounds.put(3, (Object)SoundEffects.Cs);
        warningSounds.put(4, (Object)SoundEffects.Cp);
    });
    public int l;
    private final VibrationSystem.d m = new a();
    private VibrationSystem.a n = new VibrationSystem.a();
    private final VibrationSystem.b r = new VibrationSystem.b(this);

    public SculkShriekerBlockEntity(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.M, pos, state);
    }

    @Override
    public VibrationSystem.a gp() {
        return this.n;
    }

    @Override
    public VibrationSystem.d gq() {
        return this.m;
    }

    @Override
    protected void a(NBTTagCompound nbt, HolderLookup.a registries) {
        super.a(nbt, registries);
        if (nbt.b("warning_level", 99)) {
            this.l = nbt.h("warning_level");
        }
        RegistryOps<NBTBase> registryOps = registries.a(DynamicOpsNBT.a);
        if (nbt.b("listener", 10)) {
            VibrationSystem.a.a.parse(registryOps, (Object)nbt.p("listener")).resultOrPartial(string -> a.error("Failed to parse vibration listener for Sculk Shrieker: '{}'", string)).ifPresent(vibrationListener -> {
                this.n = vibrationListener;
            });
        }
    }

    @Override
    protected void b(NBTTagCompound nbt, HolderLookup.a registries) {
        super.b(nbt, registries);
        nbt.a("warning_level", this.l);
        RegistryOps<NBTBase> registryOps = registries.a(DynamicOpsNBT.a);
        VibrationSystem.a.a.encodeStart(registryOps, (Object)this.n).resultOrPartial(string -> a.error("Failed to encode vibration listener for Sculk Shrieker: '{}'", string)).ifPresent(tag -> nbt.a("listener", (NBTBase)tag));
    }

    @Nullable
    public static EntityPlayer a(@Nullable Entity entity) {
        EntityPlayer player = SculkShriekerBlockEntity.tryGetPlayer0(entity);
        return player != null && player.dW() == entity.dW() ? player : null;
    }

    @Nullable
    private static EntityPlayer tryGetPlayer0(@Nullable Entity entity) {
        EntityItem itemEntity;
        Entity var9;
        IProjectile projectile;
        Entity var3;
        EntityLiving serverPlayer4;
        if (entity instanceof EntityPlayer) {
            return (EntityPlayer)entity;
        }
        if (entity != null && (serverPlayer4 = entity.cX()) instanceof EntityPlayer) {
            return (EntityPlayer)serverPlayer4;
        }
        if (entity instanceof IProjectile && (var3 = (projectile = (IProjectile)entity).p()) instanceof EntityPlayer) {
            return (EntityPlayer)var3;
        }
        if (entity instanceof EntityItem && (var9 = (itemEntity = (EntityItem)entity).p()) instanceof EntityPlayer) {
            return (EntityPlayer)var9;
        }
        return null;
    }

    public void a(WorldServer world, @Nullable EntityPlayer player) {
        IBlockData blockState;
        if (player != null && !(blockState = this.m()).c(SculkShriekerBlock.b).booleanValue()) {
            this.l = 0;
            if (!this.b(world) || this.b(world, player)) {
                this.a(world, (Entity)player);
            }
        }
    }

    private boolean b(WorldServer world, EntityPlayer player) {
        OptionalInt optionalInt = WardenSpawnTracker.a(world, this.aB_(), player);
        optionalInt.ifPresent(warningLevel -> {
            this.l = warningLevel;
        });
        return optionalInt.isPresent();
    }

    private void a(WorldServer world, @Nullable Entity entity) {
        BlockPosition blockPos = this.aB_();
        IBlockData blockState = this.m();
        world.a(blockPos, (IBlockData)blockState.b(SculkShriekerBlock.b, true), 2);
        world.a(blockPos, blockState.b(), 90);
        world.c(3007, blockPos, 0);
        world.a(GameEvent.N, blockPos, GameEvent.a.a(entity));
    }

    private boolean b(WorldServer world) {
        return this.m().c(SculkShriekerBlock.d) != false && world.al() != EnumDifficulty.a && world.N().b(GameRules.N);
    }

    public void a(WorldServer world) {
        if (this.b(world) && this.l > 0) {
            if (!this.c(world)) {
                this.b((World)world);
            }
            Warden.a(world, Vec3D.b(this.aB_()), null, 40);
        }
    }

    private void b(World world) {
        SoundEffect soundEvent = (SoundEffect)k.get(this.l);
        if (soundEvent != null) {
            BlockPosition blockPos = this.aB_();
            int i2 = blockPos.u() + MathHelper.b(world.A, -10, 10);
            int j2 = blockPos.v() + MathHelper.b(world.A, -10, 10);
            int k2 = blockPos.w() + MathHelper.b(world.A, -10, 10);
            world.a(null, (double)i2, (double)j2, (double)k2, soundEvent, SoundCategory.f, 5.0f, 1.0f);
        }
    }

    private boolean c(WorldServer world) {
        return this.l >= 4 && SpawnUtil.trySpawnMob(EntityTypes.bG, EntitySpawnReason.k, world, this.aB_(), 20, 5, 6, SpawnUtil.a.b, CreatureSpawnEvent.SpawnReason.NATURAL, null).isPresent();
    }

    public VibrationSystem.b b() {
        return this.r;
    }

    class a
    implements VibrationSystem.d {
        private static final int b = 8;
        private final PositionSource c;

        public a() {
            this.c = new BlockPositionSource(SculkShriekerBlockEntity.this.p);
        }

        @Override
        public int a() {
            return 8;
        }

        @Override
        public PositionSource b() {
            return this.c;
        }

        @Override
        public TagKey<GameEvent> c() {
            return GameEventTags.c;
        }

        @Override
        public boolean a(WorldServer world, BlockPosition pos, Holder<GameEvent> event, GameEvent.a emitter) {
            return SculkShriekerBlockEntity.this.m().c(SculkShriekerBlock.b) == false && SculkShriekerBlockEntity.a(emitter.a()) != null;
        }

        @Override
        public void a(WorldServer world, BlockPosition pos, Holder<GameEvent> event, @Nullable Entity sourceEntity, @Nullable Entity entity, float distance) {
            SculkShriekerBlockEntity.this.a(world, SculkShriekerBlockEntity.a(entity != null ? entity : sourceEntity));
        }

        @Override
        public void e() {
            SculkShriekerBlockEntity.this.e();
        }

        @Override
        public boolean f() {
            return true;
        }
    }
}

