/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R2.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R2.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.inventory.InventoryHolder;
import org.slf4j.Logger;

public abstract class TileEntity {
    static boolean ignoreTileUpdates;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY;
    public CraftPersistentDataContainer persistentDataContainer;
    private static final Logger d;
    private final TileEntityTypes<?> e;
    @Nullable
    protected World o;
    protected final BlockPosition p;
    protected boolean q;
    private IBlockData f;
    private DataComponentMap g = DataComponentMap.a;

    public TileEntity(TileEntityTypes<?> type, BlockPosition pos, IBlockData state) {
        this.e = type;
        this.p = pos.j();
        this.a(state);
        this.f = state;
        this.persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    }

    private void a(IBlockData state) {
        if (!this.b(state)) {
            String s2 = this.k();
            throw new IllegalStateException("Invalid block entity " + s2 + " state at " + String.valueOf(this.p) + ", got " + String.valueOf(state));
        }
    }

    public boolean b(IBlockData state) {
        return this.e.a(state);
    }

    public static BlockPosition b(NBTTagCompound nbt) {
        return new BlockPosition(nbt.h("x"), nbt.h("y"), nbt.h("z"));
    }

    @Nullable
    public World i() {
        return this.o;
    }

    public void a(World world) {
        this.o = world;
    }

    public boolean l() {
        return this.o != null;
    }

    protected void a(NBTTagCompound nbt, HolderLookup.a registries) {
        this.persistentDataContainer.clear();
        NBTBase persistentDataTag = nbt.c("PublicBukkitValues");
        if (persistentDataTag instanceof NBTTagCompound) {
            this.persistentDataContainer.putAll((NBTTagCompound)persistentDataTag);
        }
    }

    public final void c(NBTTagCompound nbt, HolderLookup.a registries) {
        this.a(nbt, registries);
        a.a.parse(registries.a(DynamicOpsNBT.a), (Object)nbt).resultOrPartial(s2 -> d.warn("Failed to load components: {}", s2)).ifPresent(datacomponentmap -> {
            this.g = datacomponentmap;
        });
    }

    public final void d(NBTTagCompound nbt, HolderLookup.a registries) {
        this.a(nbt, registries);
    }

    protected void b(NBTTagCompound nbt, HolderLookup.a registries) {
    }

    public final NBTTagCompound b(HolderLookup.a registries) {
        NBTTagCompound nbttagcompound = this.d(registries);
        this.d(nbttagcompound);
        return nbttagcompound;
    }

    public final NBTTagCompound c(HolderLookup.a registries) {
        NBTTagCompound nbttagcompound = this.d(registries);
        this.c(nbttagcompound);
        return nbttagcompound;
    }

    public final NBTTagCompound d(HolderLookup.a registries) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.b(nbttagcompound, registries);
        a.a.encodeStart(registries.a(DynamicOpsNBT.a), (Object)this.g).resultOrPartial(s2 -> d.warn("Failed to save components: {}", s2)).ifPresent(nbtbase -> nbttagcompound.a((NBTTagCompound)nbtbase));
        if (this.persistentDataContainer != null && !this.persistentDataContainer.isEmpty()) {
            nbttagcompound.a("PublicBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return nbttagcompound;
    }

    public final NBTTagCompound e(HolderLookup.a registries) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.b(nbttagcompound, registries);
        if (this.persistentDataContainer != null && !this.persistentDataContainer.isEmpty()) {
            nbttagcompound.a("PublicBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return nbttagcompound;
    }

    public final NBTTagCompound f(HolderLookup.a registries) {
        NBTTagCompound nbttagcompound = this.e(registries);
        this.d(nbttagcompound);
        return nbttagcompound;
    }

    public void c(NBTTagCompound nbt) {
        MinecraftKey minecraftkey = TileEntityTypes.a(this.q());
        if (minecraftkey == null) {
            throw new RuntimeException(String.valueOf(this.getClass()) + " is missing a mapping! This is a bug!");
        }
        nbt.a("id", minecraftkey.toString());
    }

    public static void a(NBTTagCompound nbt, TileEntityTypes<?> type) {
        nbt.a("id", TileEntityTypes.a(type).toString());
    }

    public void a(ItemStack stack, HolderLookup.a registries) {
        NBTTagCompound nbttagcompound = this.e(registries);
        this.a(nbttagcompound);
        stack.c();
        ItemBlock.a(stack, this.q(), nbttagcompound);
        stack.b(this.r());
    }

    private void d(NBTTagCompound nbt) {
        this.c(nbt);
        nbt.a("x", this.p.u());
        nbt.a("y", this.p.v());
        nbt.a("z", this.p.w());
    }

    @Nullable
    public static TileEntity a(BlockPosition pos, IBlockData state, NBTTagCompound nbt, HolderLookup.a registries) {
        String s2 = nbt.l("id");
        MinecraftKey minecraftkey = MinecraftKey.c(s2);
        if (minecraftkey == null) {
            d.error("Block entity has invalid type: {}", (Object)s2);
            return null;
        }
        return BuiltInRegistries.j.b(minecraftkey).map(tileentitytypes -> {
            try {
                return tileentitytypes.a(pos, state);
            }
            catch (Throwable throwable) {
                d.error("Failed to create block entity {}", (Object)s2, (Object)throwable);
                return null;
            }
        }).map(tileentity -> {
            try {
                tileentity.c(nbt, registries);
                return tileentity;
            }
            catch (Throwable throwable) {
                d.error("Failed to load data for block entity {}", (Object)s2, (Object)throwable);
                return null;
            }
        }).orElseGet(() -> {
            d.warn("Skipping BlockEntity with id {}", (Object)s2);
            return null;
        });
    }

    public void e() {
        if (this.o != null) {
            if (ignoreTileUpdates) {
                return;
            }
            TileEntity.a(this.o, this.p, this.f);
        }
    }

    protected static void a(World world, BlockPosition pos, IBlockData state) {
        world.q(pos);
        if (!state.l()) {
            world.c(pos, state.b());
        }
    }

    public BlockPosition aB_() {
        return this.p;
    }

    public IBlockData m() {
        return this.f;
    }

    @Nullable
    public Packet<PacketListenerPlayOut> ay_() {
        return null;
    }

    public NBTTagCompound a(HolderLookup.a registries) {
        return new NBTTagCompound();
    }

    public boolean n() {
        return this.q;
    }

    public void aw_() {
        this.q = true;
    }

    public void o() {
        this.q = false;
    }

    public boolean a_(int type, int data) {
        return false;
    }

    public void a(CrashReportSystemDetails crashReportSection) {
        crashReportSection.a("Name", this::k);
        if (this.o != null) {
            IBlockData block = this.m();
            if (block != null) {
                CrashReportSystemDetails.a(crashReportSection, this.o, this.p, block);
            }
            CrashReportSystemDetails.a(crashReportSection, this.o, this.p, this.o.a_(this.p));
        }
    }

    private String k() {
        String s2 = String.valueOf(BuiltInRegistries.j.b(this.q()));
        return s2 + " // " + this.getClass().getCanonicalName();
    }

    public boolean p() {
        return false;
    }

    public TileEntityTypes<?> q() {
        return this.e;
    }

    @Deprecated
    public void c(IBlockData state) {
        this.a(state);
        this.f = state;
    }

    protected void a(b components) {
    }

    public final void a(ItemStack stack) {
        this.a(stack.d(), stack.e());
    }

    public final void a(DataComponentMap defaultComponents, DataComponentPatch components) {
        this.applyComponentsSet(defaultComponents, components);
    }

    public final Set<DataComponentType<?>> applyComponentsSet(DataComponentMap datacomponentmap, DataComponentPatch datacomponentpatch) {
        final HashSet set = new HashSet();
        set.add(DataComponents.Y);
        final PatchedDataComponentMap patcheddatacomponentmap = PatchedDataComponentMap.a(datacomponentmap, datacomponentpatch);
        this.a(new b(){

            @Override
            @Nullable
            public <T> T a(DataComponentType<T> type) {
                set.add(type);
                return patcheddatacomponentmap.a(type);
            }

            @Override
            public <T> T a(DataComponentType<? extends T> type, T fallback) {
                set.add(type);
                return patcheddatacomponentmap.a(type, fallback);
            }
        });
        Objects.requireNonNull(set);
        DataComponentPatch datacomponentpatch1 = datacomponentpatch.a(set::contains);
        this.g = datacomponentpatch1.e().a();
        set.remove(DataComponents.Y);
        return set;
    }

    protected void a(DataComponentMap.a builder) {
    }

    @Deprecated
    public void a(NBTTagCompound nbt) {
    }

    public final DataComponentMap r() {
        DataComponentMap.a datacomponentmap_a = DataComponentMap.a();
        datacomponentmap_a.a(this.g);
        this.a(datacomponentmap_a);
        return datacomponentmap_a.a();
    }

    public DataComponentMap s() {
        return this.g;
    }

    public void a(DataComponentMap components) {
        this.g = components;
    }

    @Nullable
    public static IChatBaseComponent a(String json, HolderLookup.a registries) {
        try {
            return IChatBaseComponent.ChatSerializer.a(json, registries);
        }
        catch (Exception exception) {
            d.warn("Failed to parse custom name from string '{}', discarding", (Object)json, (Object)exception);
            return null;
        }
    }

    public InventoryHolder getOwner() {
        return this.getOwner(true);
    }

    public InventoryHolder getOwner(boolean useSnapshot) {
        if (this.o == null) {
            return null;
        }
        Block block = this.o.getWorld().getBlockAt(this.p.u(), this.p.v(), this.p.w());
        BlockState state = block.getState(useSnapshot);
        if (state instanceof InventoryHolder) {
            return (InventoryHolder)state;
        }
        return null;
    }

    public NBTTagCompound sanitizeSentNbt(NBTTagCompound tag) {
        tag.r("PublicBukkitValues");
        return tag;
    }

    static {
        DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
        d = LogUtils.getLogger();
    }

    private static class a {
        public static final Codec<DataComponentMap> a = DataComponentMap.b.optionalFieldOf("components", (Object)DataComponentMap.a).codec();

        private a() {
        }
    }

    protected static interface b {
        @Nullable
        public <T> T a(DataComponentType<T> var1);

        public <T> T a(DataComponentType<? extends T> var1, T var2);
    }
}

