/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BlockBanner;
import net.minecraft.world.level.block.BlockBannerAbstract;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.slf4j.Logger;

public class TileEntityBanner
extends TileEntity
implements INamableTileEntity {
    private static final Logger b = LogUtils.getLogger();
    public static final int a = 6;
    private static final String c = "patterns";
    @Nullable
    public IChatBaseComponent d;
    public EnumColor e;
    private BannerPatternLayers f;
    ThreadLocal<Boolean> serialisingForNetwork = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public TileEntityBanner(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.u, pos, state);
        this.f = BannerPatternLayers.a;
        this.e = ((BlockBannerAbstract)state.b()).b();
    }

    public TileEntityBanner(BlockPosition pos, IBlockData state, EnumColor baseColor) {
        this(pos, state);
        this.e = baseColor;
    }

    public void a(ItemStack stack, EnumColor baseColor) {
        this.e = baseColor;
        this.a(stack);
    }

    @Override
    public IChatBaseComponent al() {
        return this.d != null ? this.d : IChatBaseComponent.c("block.minecraft.banner");
    }

    @Override
    @Nullable
    public IChatBaseComponent an() {
        return this.d;
    }

    @Override
    protected void b(NBTTagCompound nbt, HolderLookup.a registries) {
        super.b(nbt, registries);
        if (!this.f.equals(BannerPatternLayers.a) || this.serialisingForNetwork.get().booleanValue()) {
            nbt.a(c, (NBTBase)BannerPatternLayers.b.encodeStart(registries.a(DynamicOpsNBT.a), (Object)this.f).getOrThrow());
        }
        if (this.d != null) {
            nbt.a("CustomName", IChatBaseComponent.ChatSerializer.a(this.d, registries));
        }
    }

    @Override
    protected void a(NBTTagCompound nbt, HolderLookup.a registries) {
        super.a(nbt, registries);
        if (nbt.b("CustomName", 8)) {
            this.d = TileEntityBanner.a(nbt.l("CustomName"), registries);
        }
        if (nbt.e(c)) {
            BannerPatternLayers.b.parse(registries.a(DynamicOpsNBT.a), (Object)nbt.c(c)).resultOrPartial(s2 -> b.error("Failed to parse banner patterns: '{}'", s2)).ifPresent(bannerpatternlayers -> this.setPatterns((BannerPatternLayers)bannerpatternlayers));
        }
    }

    public PacketPlayOutTileEntityData a() {
        return PacketPlayOutTileEntityData.a(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        Boolean wasSerialisingForNetwork = this.serialisingForNetwork.get();
        try {
            this.serialisingForNetwork.set(Boolean.TRUE);
            NBTTagCompound nBTTagCompound = this.d(registries);
            return nBTTagCompound;
        }
        finally {
            this.serialisingForNetwork.set(wasSerialisingForNetwork);
        }
    }

    public BannerPatternLayers b() {
        return this.f;
    }

    public ItemStack c() {
        ItemStack itemstack = new ItemStack(BlockBanner.a(this.e));
        itemstack.b(this.r());
        return itemstack;
    }

    public EnumColor f() {
        return this.e;
    }

    @Override
    protected void a(TileEntity.b components) {
        super.a(components);
        this.setPatterns(components.a(DataComponents.ai, BannerPatternLayers.a));
        this.d = components.a(DataComponents.g);
    }

    @Override
    protected void a(DataComponentMap.a builder) {
        super.a(builder);
        builder.a(DataComponents.ai, this.f);
        builder.a(DataComponents.g, this.d);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        nbt.r(c);
        nbt.r("CustomName");
    }

    public void setPatterns(BannerPatternLayers bannerpatternlayers) {
        if (bannerpatternlayers.b().size() > 20) {
            bannerpatternlayers = new BannerPatternLayers(List.copyOf(bannerpatternlayers.b().subList(0, 20)));
        }
        this.f = bannerpatternlayers;
    }
}

