/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFurnace;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;

public abstract class TileEntityFurnace
extends TileEntityContainer
implements IWorldInventory,
RecipeCraftingHolder,
AutoRecipeOutput {
    protected static final int b = 0;
    protected static final int c = 1;
    protected static final int d = 2;
    public static final int e = 0;
    private static final int[] r = new int[]{0};
    private static final int[] s = new int[]{2, 1};
    private static final int[] t = new int[]{1};
    public static final int f = 1;
    public static final int g = 2;
    public static final int h = 3;
    public static final int i = 4;
    public static final int j = 200;
    public static final int k = 2;
    public static final int l = 0;
    protected NonNullList<net.minecraft.world.item.ItemStack> m;
    public int u;
    int v = 0;
    public double cookSpeedMultiplier = 1.0;
    public int w;
    public int x;
    protected final IContainerProperties n;
    public final Reference2IntOpenHashMap<ResourceKey<IRecipe<?>>> y;
    private final CraftingManager.a<SingleRecipeInput, ? extends RecipeCooking> z;
    public final Recipes<? extends RecipeCooking> recipeType;
    private int maxStack = 99;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();

    protected TileEntityFurnace(TileEntityTypes<?> blockEntityType, BlockPosition pos, IBlockData state, Recipes<? extends RecipeCooking> recipeType) {
        super(blockEntityType, pos, state);
        this.m = NonNullList.a(3, net.minecraft.world.item.ItemStack.j);
        this.n = new IContainerProperties(){

            @Override
            public int a(int index) {
                switch (index) {
                    case 0: {
                        return TileEntityFurnace.this.u;
                    }
                    case 1: {
                        return TileEntityFurnace.this.v;
                    }
                    case 2: {
                        return TileEntityFurnace.this.w;
                    }
                    case 3: {
                        return TileEntityFurnace.this.x;
                    }
                }
                return 0;
            }

            @Override
            public void a(int index, int value) {
                switch (index) {
                    case 0: {
                        TileEntityFurnace.this.u = value;
                        break;
                    }
                    case 1: {
                        TileEntityFurnace.this.v = value;
                        break;
                    }
                    case 2: {
                        TileEntityFurnace.this.w = value;
                        break;
                    }
                    case 3: {
                        TileEntityFurnace.this.x = value;
                    }
                }
            }

            @Override
            public int a() {
                return 4;
            }
        };
        this.y = new Reference2IntOpenHashMap();
        this.z = CraftingManager.a(recipeType);
        this.recipeType = recipeType;
    }

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.m;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int ao_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    private boolean k() {
        return this.u > 0;
    }

    @Override
    protected void a(NBTTagCompound nbt, HolderLookup.a registries) {
        super.a(nbt, registries);
        this.m = NonNullList.a(this.b(), net.minecraft.world.item.ItemStack.j);
        ContainerUtil.b(nbt, this.m, registries);
        this.u = nbt.g("BurnTime");
        this.w = nbt.g("CookTime");
        this.x = nbt.g("CookTimeTotal");
        this.v = 0;
        NBTTagCompound nbttagcompound1 = nbt.p("RecipesUsed");
        for (String s2 : nbttagcompound1.e()) {
            MinecraftKey resourceLocation = MinecraftKey.c(s2);
            if (resourceLocation == null) continue;
            this.y.put(ResourceKey.a(Registries.bk, resourceLocation), nbttagcompound1.h(s2));
        }
        if (nbt.e("Paper.CookSpeedMultiplier")) {
            this.cookSpeedMultiplier = nbt.k("Paper.CookSpeedMultiplier");
        }
    }

    @Override
    protected void b(NBTTagCompound nbt, HolderLookup.a registries) {
        super.b(nbt, registries);
        nbt.a("BurnTime", (short)this.u);
        nbt.a("CookTime", (short)this.w);
        nbt.a("CookTimeTotal", (short)this.x);
        nbt.a("Paper.CookSpeedMultiplier", this.cookSpeedMultiplier);
        ContainerUtil.a(nbt, this.m, registries);
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        this.y.forEach((resourcekey, integer) -> nbttagcompound1.a(resourcekey.a().toString(), (int)integer));
        nbt.a("RecipesUsed", nbttagcompound1);
    }

    public static void a(WorldServer world, BlockPosition pos, IBlockData state, TileEntityFurnace blockEntity) {
        boolean flag3;
        boolean flag = blockEntity.k();
        boolean flag1 = false;
        if (blockEntity.k()) {
            --blockEntity.u;
        }
        net.minecraft.world.item.ItemStack itemstack = blockEntity.m.get(1);
        net.minecraft.world.item.ItemStack itemstack1 = blockEntity.m.get(0);
        boolean flag2 = !itemstack1.f();
        boolean bl = flag3 = !itemstack.f();
        if (blockEntity.v == 0) {
            blockEntity.v = blockEntity.a(world.L(), itemstack);
        }
        if (!(blockEntity.k() || flag3 && flag2)) {
            if (!blockEntity.k() && blockEntity.w > 0) {
                blockEntity.w = MathHelper.a(blockEntity.w - 2, 0, blockEntity.x);
            }
        } else {
            SingleRecipeInput singlerecipeinput = new SingleRecipeInput(itemstack1);
            RecipeHolder recipeholder = flag2 ? (RecipeHolder)blockEntity.z.a(singlerecipeinput, world).orElse(null) : null;
            int i2 = blockEntity.ao_();
            if (!blockEntity.k() && TileEntityFurnace.a(world.K_(), recipeholder, singlerecipeinput, blockEntity.m, i2)) {
                CraftItemStack fuel = CraftItemStack.asCraftMirror(itemstack);
                FurnaceBurnEvent furnaceBurnEvent = new FurnaceBurnEvent((Block)CraftBlock.at(world, pos), (ItemStack)fuel, blockEntity.a(world.L(), itemstack));
                world.getCraftServer().getPluginManager().callEvent((Event)furnaceBurnEvent);
                if (furnaceBurnEvent.isCancelled()) {
                    return;
                }
                blockEntity.v = blockEntity.u = furnaceBurnEvent.getBurnTime();
                if (blockEntity.k() && furnaceBurnEvent.isBurning()) {
                    flag1 = true;
                    if (flag3 && furnaceBurnEvent.willConsumeFuel()) {
                        Item item = itemstack.h();
                        itemstack.h(1);
                        if (itemstack.f()) {
                            blockEntity.m.set(1, item.k());
                        }
                    }
                }
            }
            if (blockEntity.k() && TileEntityFurnace.a(world.K_(), recipeholder, singlerecipeinput, blockEntity.m, i2)) {
                if (recipeholder != null && blockEntity.w == 0) {
                    CraftItemStack source = CraftItemStack.asCraftMirror(blockEntity.m.get(0));
                    CookingRecipe recipe = (CookingRecipe)recipeholder.toBukkitRecipe();
                    FurnaceStartSmeltEvent event = new FurnaceStartSmeltEvent((Block)CraftBlock.at(world, pos), (ItemStack)source, recipe, TileEntityFurnace.getTotalCookTime(world, blockEntity, blockEntity.recipeType, blockEntity.cookSpeedMultiplier));
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                    blockEntity.x = event.getTotalCookTime();
                }
                ++blockEntity.w;
                if (blockEntity.w >= blockEntity.x) {
                    blockEntity.w = 0;
                    blockEntity.x = TileEntityFurnace.getTotalCookTime(world, blockEntity, blockEntity.recipeType, blockEntity.cookSpeedMultiplier);
                    if (TileEntityFurnace.burn(blockEntity.o, blockEntity.p, world.K_(), recipeholder, singlerecipeinput, blockEntity.m, i2)) {
                        blockEntity.a(recipeholder);
                    }
                    flag1 = true;
                }
            } else {
                blockEntity.w = 0;
            }
        }
        if (flag != blockEntity.k()) {
            flag1 = true;
            state = (IBlockData)state.b(BlockFurnace.b, blockEntity.k());
            world.a(pos, state, 3);
        }
        if (flag1) {
            TileEntityFurnace.a(world, pos, state);
        }
    }

    private static boolean a(IRegistryCustom dynamicRegistryManager, @Nullable RecipeHolder<? extends RecipeCooking> recipe, SingleRecipeInput input, NonNullList<net.minecraft.world.item.ItemStack> inventory, int maxCount) {
        if (!inventory.get(0).f() && recipe != null) {
            net.minecraft.world.item.ItemStack itemstack = recipe.b().a(input, (HolderLookup.a)dynamicRegistryManager);
            if (itemstack.f()) {
                return false;
            }
            net.minecraft.world.item.ItemStack itemstack1 = inventory.get(2);
            return itemstack1.f() ? true : (!net.minecraft.world.item.ItemStack.c(itemstack1, itemstack) ? false : (itemstack1.L() < maxCount && itemstack1.L() < itemstack1.k() ? true : itemstack1.L() < itemstack.k()));
        }
        return false;
    }

    private static boolean burn(World world, BlockPosition blockposition, IRegistryCustom iregistrycustom, @Nullable RecipeHolder<? extends RecipeCooking> recipeholder, SingleRecipeInput singlerecipeinput, NonNullList<net.minecraft.world.item.ItemStack> nonnulllist, int i2) {
        if (recipeholder != null && TileEntityFurnace.a(iregistrycustom, recipeholder, singlerecipeinput, nonnulllist, i2)) {
            net.minecraft.world.item.ItemStack itemstack = nonnulllist.get(0);
            net.minecraft.world.item.ItemStack itemstack1 = recipeholder.b().a(singlerecipeinput, (HolderLookup.a)iregistrycustom);
            net.minecraft.world.item.ItemStack itemstack2 = nonnulllist.get(2);
            CraftItemStack source = CraftItemStack.asCraftMirror(itemstack);
            ItemStack result = CraftItemStack.asBukkitCopy(itemstack1);
            FurnaceSmeltEvent furnaceSmeltEvent = new FurnaceSmeltEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)source, result, (CookingRecipe)recipeholder.toBukkitRecipe());
            world.getCraftServer().getPluginManager().callEvent((Event)furnaceSmeltEvent);
            if (furnaceSmeltEvent.isCancelled()) {
                return false;
            }
            result = furnaceSmeltEvent.getResult();
            itemstack1 = CraftItemStack.asNMSCopy(result);
            if (!itemstack1.f()) {
                if (itemstack2.f()) {
                    nonnulllist.set(2, itemstack1.v());
                } else if (CraftItemStack.asCraftMirror(itemstack2).isSimilar(result)) {
                    itemstack2.g(itemstack1.L());
                } else {
                    return false;
                }
            }
            if (itemstack.a(Blocks.aW.j()) && !nonnulllist.get(1).f() && nonnulllist.get(1).a(Items.qW)) {
                nonnulllist.set(1, new net.minecraft.world.item.ItemStack(Items.qX));
            }
            itemstack.h(1);
            return true;
        }
        return false;
    }

    protected int a(FuelValues fuelRegistry, net.minecraft.world.item.ItemStack stack) {
        return fuelRegistry.b(stack);
    }

    public static int getTotalCookTime(@Nullable WorldServer world, TileEntityFurnace furnace, Recipes<? extends RecipeCooking> recipeType, double cookSpeedMultiplier) {
        SingleRecipeInput singlerecipeinput = new SingleRecipeInput(furnace.a(0));
        int cookTime = world != null ? furnace.z.a(singlerecipeinput, world).map(holder -> ((RecipeCooking)holder.b()).d()).orElse(200) : MinecraftServer.getServer().aI().a(recipeType, singlerecipeinput, world).map(holder -> ((RecipeCooking)holder.b()).d()).orElse(200);
        return (int)Math.ceil((double)cookTime / cookSpeedMultiplier);
    }

    @Override
    public int[] a(EnumDirection side) {
        return side == EnumDirection.a ? s : (side == EnumDirection.b ? r : t);
    }

    @Override
    public boolean a(int slot, net.minecraft.world.item.ItemStack stack, @Nullable EnumDirection dir) {
        return this.b(slot, stack);
    }

    @Override
    public boolean b(int slot, net.minecraft.world.item.ItemStack stack, EnumDirection dir) {
        return dir == EnumDirection.a && slot == 1 ? stack.a(Items.qX) || stack.a(Items.qW) : true;
    }

    @Override
    public int b() {
        return this.m.size();
    }

    @Override
    protected NonNullList<net.minecraft.world.item.ItemStack> f() {
        return this.m;
    }

    @Override
    protected void a(NonNullList<net.minecraft.world.item.ItemStack> inventory) {
        this.m = inventory;
    }

    @Override
    public void a(int slot, net.minecraft.world.item.ItemStack stack) {
        World world;
        net.minecraft.world.item.ItemStack itemstack1 = this.m.get(slot);
        boolean flag = !stack.f() && net.minecraft.world.item.ItemStack.c(itemstack1, stack);
        this.m.set(slot, stack);
        stack.f(this.e_(stack));
        if (slot == 0 && !flag && (world = this.o) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.x = TileEntityFurnace.getTotalCookTime(worldserver, this, this.recipeType, this.cookSpeedMultiplier);
            this.w = 0;
            this.e();
        }
    }

    @Override
    public boolean b(int slot, net.minecraft.world.item.ItemStack stack) {
        if (slot == 2) {
            return false;
        }
        if (slot != 1) {
            return true;
        }
        net.minecraft.world.item.ItemStack itemstack1 = this.m.get(1);
        return this.o.L().a(stack) || stack.a(Items.qW) && !itemstack1.a(Items.qW);
    }

    @Override
    public void a(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceKey<IRecipe<?>> resourcekey = recipe.a();
            this.y.addTo(resourcekey, 1);
        }
    }

    @Override
    @Nullable
    public RecipeHolder<?> d() {
        return null;
    }

    @Override
    public void a(EntityHuman player, List<net.minecraft.world.item.ItemStack> ingredients) {
    }

    public void awardUsedRecipesAndPopExperience(EntityPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        List<RecipeHolder<?>> list = this.getRecipesToAwardAndPopExperience(entityplayer.y(), entityplayer.du(), this.p, entityplayer, itemstack, amount);
        entityplayer.a((Collection<RecipeHolder<?>>)list);
        for (RecipeHolder<?> recipeholder : list) {
            if (recipeholder == null) continue;
            entityplayer.a(recipeholder, this.m);
        }
        this.y.clear();
    }

    public List<RecipeHolder<?>> a(WorldServer world, Vec3D pos) {
        return this.getRecipesToAwardAndPopExperience(world, pos, this.p, null, null, 0);
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(WorldServer worldserver, Vec3D vec3d, BlockPosition blockposition, EntityPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        ArrayList list = Lists.newArrayList();
        for (Reference2IntMap.Entry entry : this.y.reference2IntEntrySet()) {
            worldserver.s().b((ResourceKey)entry.getKey()).ifPresent(recipeholder -> {
                if (!(recipeholder.b() instanceof RecipeCooking)) {
                    return;
                }
                list.add(recipeholder);
                TileEntityFurnace.createExperience(worldserver, vec3d, entry.getIntValue(), ((RecipeCooking)recipeholder.b()).c(), blockposition, entityplayer, itemstack, amount);
            });
        }
        return list;
    }

    private static void createExperience(WorldServer worldserver, Vec3D vec3d, int i2, float f2, BlockPosition blockposition, EntityHuman entityhuman, net.minecraft.world.item.ItemStack itemstack, int amount) {
        int j2 = MathHelper.d((float)i2 * f2);
        float f1 = MathHelper.i((float)i2 * f2);
        if (f1 != 0.0f && Math.random() < (double)f1) {
            ++j2;
        }
        Object event = amount != 0 ? new FurnaceExtractEvent((Player)entityhuman.getBukkitEntity(), (Block)CraftBlock.at(worldserver, blockposition), CraftItemType.minecraftToBukkit(itemstack.h()), amount, j2) : new BlockExpEvent((Block)CraftBlock.at(worldserver, blockposition), j2);
        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
        j2 = event.getExpToDrop();
        EntityExperienceOrb.award(worldserver, vec3d, j2, ExperienceOrb.SpawnReason.FURNACE, entityhuman);
    }

    @Override
    public void fillStackedContents(StackedItemContents finder) {
        finder.b(this.m.get(0));
        finder.b(this.m.get(2));
    }
}

