/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.commands.DelegatingCommandSource;
import io.papermc.paper.event.player.PlayerSignCommandPreprocessEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.UtilColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftSign;
import org.bukkit.craftbukkit.v1_21_R2.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R2.util.LazyPlayerSet;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.SignChangeEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class TileEntitySign
extends TileEntity {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 90;
    private static final int c = 10;
    @Nullable
    public UUID d;
    private SignText e;
    private SignText f;
    private boolean g;
    private final ICommandListener commandSource = new ICommandListener(){

        @Override
        public void a(IChatBaseComponent message) {
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
            return wrapper.f() != null ? wrapper.f().getBukkitEntity() : new CraftBlockCommandSender(wrapper, TileEntitySign.this);
        }

        @Override
        public boolean y_() {
            return false;
        }

        @Override
        public boolean z_() {
            return false;
        }

        @Override
        public boolean c() {
            return false;
        }
    };

    public TileEntitySign(BlockPosition pos, IBlockData state) {
        this((TileEntityTypes)TileEntityTypes.h, pos, state);
    }

    public TileEntitySign(TileEntityTypes type, BlockPosition pos, IBlockData state) {
        super(type, pos, state);
        this.e = this.f();
        this.f = this.f();
    }

    protected SignText f() {
        return new SignText();
    }

    public boolean a(EntityHuman player) {
        return this.isFacingFrontText(player.dB(), player.dH());
    }

    public boolean isFacingFrontText(double x2, double z2) {
        Block block = this.m().b();
        if (block instanceof BlockSign) {
            float f1;
            BlockSign blocksign = (BlockSign)block;
            Vec3D vec3d = blocksign.o(this.m());
            double d0 = x2 - ((double)this.aB_().u() + vec3d.d);
            double d1 = z2 - ((double)this.aB_().w() + vec3d.f);
            float f2 = blocksign.h(this.m());
            return MathHelper.d(f2, f1 = (float)(MathHelper.d(d1, d0) * 57.2957763671875) - 90.0f) <= 90.0f;
        }
        return false;
    }

    public SignText a(boolean front) {
        return front ? this.e : this.f;
    }

    public SignText j() {
        return this.e;
    }

    public SignText k() {
        return this.f;
    }

    public int b() {
        return 10;
    }

    public int c() {
        return 90;
    }

    @Override
    protected void b(NBTTagCompound nbt, HolderLookup.a registries) {
        super.b(nbt, registries);
        RegistryOps<NBTBase> dynamicops = registries.a(DynamicOpsNBT.a);
        DataResult dataresult = SignText.a.encodeStart(dynamicops, (Object)this.e);
        Logger logger = a;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("front_text", (NBTBase)nbtbase));
        dataresult = SignText.a.encodeStart(dynamicops, (Object)this.f);
        logger = a;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("back_text", (NBTBase)nbtbase));
        nbt.a("is_waxed", this.g);
    }

    @Override
    protected void a(NBTTagCompound nbt, HolderLookup.a registries) {
        Logger logger;
        DataResult dataresult;
        super.a(nbt, registries);
        RegistryOps<NBTBase> dynamicops = registries.a(DynamicOpsNBT.a);
        if (nbt.e("front_text")) {
            dataresult = SignText.a.parse(dynamicops, (Object)nbt.p("front_text"));
            logger = a;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(signtext -> {
                this.e = this.a((SignText)signtext);
            });
        }
        if (nbt.e("back_text")) {
            dataresult = SignText.a.parse(dynamicops, (Object)nbt.p("back_text"));
            logger = a;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(signtext -> {
                this.f = this.a((SignText)signtext);
            });
        }
        this.g = nbt.q("is_waxed");
    }

    private SignText a(SignText signText) {
        for (int i2 = 0; i2 < 4; ++i2) {
            IChatBaseComponent ichatbasecomponent = this.a(signText.a(i2, false));
            IChatBaseComponent ichatbasecomponent1 = this.a(signText.a(i2, true));
            signText = signText.a(i2, ichatbasecomponent, ichatbasecomponent1);
        }
        return signText;
    }

    private IChatBaseComponent a(IChatBaseComponent text) {
        World world = this.o;
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            try {
                return ChatComponentUtils.a(this.a((EntityHuman)null, (World)worldserver, this.p), text, (Entity)null, 0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return text;
    }

    public void a(EntityHuman player, boolean front, List<FilteredText> messages) {
        if (!this.v() && player.cG().equals(this.u()) && this.o != null) {
            this.a(signtext -> this.setMessages(player, messages, (SignText)signtext, front), front);
            this.a((UUID)null);
            this.o.a(this.aB_(), this.m(), this.m(), 3);
        } else {
            a.warn("Player {} just tried to change non-editable sign", (Object)player.al().getString());
            if (player.i(this.aB_().u(), this.aB_().v(), this.aB_().w()) < 1024.0) {
                ((EntityPlayer)player).f.b(this.t());
            }
        }
    }

    public boolean a(UnaryOperator<SignText> textChanger, boolean front) {
        SignText signtext = this.a(front);
        return this.a((SignText)textChanger.apply(signtext), front);
    }

    private SignText setMessages(EntityHuman entityhuman, List<FilteredText> list, SignText signtext, boolean front) {
        SignText originalText = signtext;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            FilteredText filteredtext = list.get(i2);
            ChatModifier chatmodifier = signtext.a(i2, entityhuman.aa()).a();
            signtext = entityhuman.aa() ? signtext.a(i2, IChatBaseComponent.b(UtilColor.g(filteredtext.b())).b(chatmodifier)) : signtext.a(i2, IChatBaseComponent.b(UtilColor.g(filteredtext.d())).b(chatmodifier), IChatBaseComponent.b(UtilColor.g(filteredtext.b())).b(chatmodifier));
        }
        CraftPlayer player = ((EntityPlayer)entityhuman).getBukkitEntity();
        ArrayList<Component> lines = new ArrayList<Component>();
        for (int i3 = 0; i3 < list.size(); ++i3) {
            lines.add(PaperAdventure.asAdventure(signtext.a(i3, entityhuman.aa())));
        }
        SignChangeEvent event = new SignChangeEvent((org.bukkit.block.Block)CraftBlock.at(this.o, this.p), (Player)player, new ArrayList(lines), front ? Side.FRONT : Side.BACK);
        entityhuman.dW().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return originalText;
        }
        IChatBaseComponent[] components = CraftSign.sanitizeLines(event.lines());
        for (int i4 = 0; i4 < components.length; ++i4) {
            if (Objects.equals(lines.get(i4), event.line(i4))) continue;
            signtext = signtext.a(i4, components[i4]);
        }
        return signtext;
    }

    public boolean a(SignText text, boolean front) {
        return front ? this.c(text) : this.b(text);
    }

    private boolean b(SignText backText) {
        if (backText != this.f) {
            this.f = backText;
            this.w();
            return true;
        }
        return false;
    }

    private boolean c(SignText frontText) {
        if (frontText != this.e) {
            this.e = frontText;
            this.w();
            return true;
        }
        return false;
    }

    public boolean a(boolean front, EntityHuman player) {
        return this.v() && this.a(front).b(player);
    }

    public boolean a(EntityHuman player, World world, BlockPosition pos, boolean front) {
        boolean flag1 = false;
        for (IChatBaseComponent ichatbasecomponent : this.a(front).b(player.aa())) {
            PlayerSignCommandPreprocessEvent event;
            Object command;
            ChatModifier chatmodifier = ichatbasecomponent.a();
            ChatClickable chatclickable = chatmodifier.h();
            if (chatclickable == null || chatclickable.a() != ChatClickable.EnumClickAction.c) continue;
            Object object = command = chatclickable.b().startsWith("/") ? chatclickable.b() : "/" + chatclickable.b();
            if (SpigotConfig.logCommands) {
                a.info("{} issued server command: {}", (Object)player.cI(), command);
            }
            if (!(event = new PlayerSignCommandPreprocessEvent((Player)player.getBukkitEntity(), (String)command, (Set)new LazyPlayerSet(player.cV()), (Sign)CraftBlock.at(this.o, this.p).getState(), front ? Side.FRONT : Side.BACK)).callEvent()) {
                return false;
            }
            player.cV().aG().a(this.a((EntityHuman)((CraftPlayer)event.getPlayer()).getHandle(), world, pos), event.getMessage());
            flag1 = true;
        }
        return flag1;
    }

    private CommandListenerWrapper a(final @Nullable EntityHuman player, World world, BlockPosition pos) {
        String s2 = player == null ? "Sign" : player.al().getString();
        IChatBaseComponent object = player == null ? IChatBaseComponent.b("Sign") : player.p_();
        ICommandListener commandSource = this.o.paperConfig().misc.showSignClickCommandFailureMsgsToPlayer ? new DelegatingCommandSource(this, this.commandSource){

            @Override
            public void a(IChatBaseComponent message) {
                if (player instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)player;
                    serverPlayer.a(message);
                }
            }

            @Override
            public boolean z_() {
                return true;
            }
        } : this.commandSource;
        return new CommandListenerWrapper(commandSource, Vec3D.b(pos), Vec2F.a, (WorldServer)world, 2, s2, object, world.p(), player);
    }

    public PacketPlayOutTileEntityData t() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        return this.e(registries);
    }

    @Override
    public boolean p() {
        return true;
    }

    public void a(@Nullable UUID editor) {
        this.d = editor;
    }

    @Nullable
    public UUID u() {
        if (this.o != null && this.d != null) {
            this.a(this, this.o, this.d);
        }
        return this.d;
    }

    private void w() {
        this.e();
        if (this.o != null) {
            this.o.a(this.aB_(), this.m(), this.m(), 3);
        }
    }

    public boolean v() {
        return this.g;
    }

    public boolean b(boolean waxed) {
        if (this.g != waxed) {
            this.g = waxed;
            this.w();
            return true;
        }
        return false;
    }

    public boolean b(UUID uuid) {
        EntityHuman entityhuman = this.o.b(uuid);
        return entityhuman == null || !entityhuman.a(this.aB_(), 4.0);
    }

    public static void a(World world, BlockPosition pos, IBlockData state, TileEntitySign blockEntity) {
        UUID uuid = blockEntity.u();
        if (uuid != null) {
            blockEntity.a(blockEntity, world, uuid);
        }
    }

    private void a(TileEntitySign blockEntity, World world, UUID uuid) {
        if (blockEntity.b(uuid)) {
            blockEntity.a((UUID)null);
        }
    }

    public SoundEffect d() {
        return SoundEffects.CA;
    }
}

