/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.entity.CalibratedSculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.SculkCatalystBlockEntity;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.SculkShriekerBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBanner;
import net.minecraft.world.level.block.entity.TileEntityBarrel;
import net.minecraft.world.level.block.entity.TileEntityBeacon;
import net.minecraft.world.level.block.entity.TileEntityBed;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityBell;
import net.minecraft.world.level.block.entity.TileEntityBlastFurnace;
import net.minecraft.world.level.block.entity.TileEntityBrewingStand;
import net.minecraft.world.level.block.entity.TileEntityCampfire;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityChestTrapped;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityComparator;
import net.minecraft.world.level.block.entity.TileEntityConduit;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityEnchantTable;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.entity.TileEntityFurnaceFurnace;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntityJukeBox;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import net.minecraft.world.level.block.entity.TileEntityLightDetector;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.entity.TileEntityShulkerBox;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.entity.TileEntitySmoker;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.entity.vault.VaultBlockEntity;
import net.minecraft.world.level.block.piston.TileEntityPiston;
import net.minecraft.world.level.block.state.IBlockData;
import org.slf4j.Logger;

public class TileEntityTypes<T extends TileEntity> {
    private static final Logger T = LogUtils.getLogger();
    public static final TileEntityTypes<TileEntityFurnaceFurnace> a = TileEntityTypes.a("furnace", TileEntityFurnaceFurnace::new, Blocks.cL);
    public static final TileEntityTypes<TileEntityChest> b = TileEntityTypes.a("chest", TileEntityChest::new, Blocks.cD);
    public static final TileEntityTypes<TileEntityChestTrapped> c = TileEntityTypes.a("trapped_chest", TileEntityChestTrapped::new, Blocks.hl);
    public static final TileEntityTypes<TileEntityEnderChest> d = TileEntityTypes.a("ender_chest", TileEntityEnderChest::new, Blocks.fU);
    public static final TileEntityTypes<TileEntityJukeBox> e = TileEntityTypes.a("jukebox", TileEntityJukeBox::new, Blocks.eg);
    public static final TileEntityTypes<TileEntityDispenser> f = TileEntityTypes.a("dispenser", TileEntityDispenser::new, Blocks.bb);
    public static final TileEntityTypes<TileEntityDropper> g = TileEntityTypes.a("dropper", TileEntityDropper::new, Blocks.hy);
    public static final TileEntityTypes<TileEntitySign> h = TileEntityTypes.a("sign", TileEntitySign::new, Blocks.cM, Blocks.cN, Blocks.cO, Blocks.cP, Blocks.cQ, Blocks.cR, Blocks.cS, Blocks.cT, Blocks.da, Blocks.db, Blocks.dc, Blocks.dd, Blocks.de, Blocks.df, Blocks.dg, Blocks.dh, Blocks.pr, Blocks.pt, Blocks.ps, Blocks.pu, Blocks.cU, Blocks.di, Blocks.cV, Blocks.dj);
    public static final TileEntityTypes<HangingSignBlockEntity> i = TileEntityTypes.a("hanging_sign", HangingSignBlockEntity::new, Blocks.dk, Blocks.dl, Blocks.dm, Blocks.dn, Blocks.do, Blocks.dp, Blocks.dq, Blocks.dr, Blocks.ds, Blocks.dt, Blocks.du, Blocks.dv, Blocks.dw, Blocks.dx, Blocks.dy, Blocks.dz, Blocks.dA, Blocks.dB, Blocks.dC, Blocks.dD, Blocks.dF, Blocks.dG, Blocks.dE, Blocks.dH);
    public static final TileEntityTypes<TileEntityMobSpawner> j = TileEntityTypes.a("mob_spawner", TileEntityMobSpawner::new, Blocks.cA);
    public static final TileEntityTypes<CreakingHeartBlockEntity> k = TileEntityTypes.a("creaking_heart", CreakingHeartBlockEntity::new, Blocks.cB);
    public static final TileEntityTypes<TileEntityPiston> l = TileEntityTypes.a("piston", TileEntityPiston::new, Blocks.bX);
    public static final TileEntityTypes<TileEntityBrewingStand> m = TileEntityTypes.a("brewing_stand", TileEntityBrewingStand::new, Blocks.fG);
    public static final TileEntityTypes<TileEntityEnchantTable> n = TileEntityTypes.a("enchanting_table", TileEntityEnchantTable::new, Blocks.fF);
    public static final TileEntityTypes<TileEntityEnderPortal> o = TileEntityTypes.a("end_portal", TileEntityEnderPortal::new, Blocks.fL);
    public static final TileEntityTypes<TileEntityBeacon> p = TileEntityTypes.a("beacon", TileEntityBeacon::new, Blocks.gc);
    public static final TileEntityTypes<TileEntitySkull> q = TileEntityTypes.a("skull", TileEntitySkull::new, Blocks.gU, Blocks.gV, Blocks.hc, Blocks.hd, Blocks.he, Blocks.hf, Blocks.gY, Blocks.gZ, Blocks.gW, Blocks.gX, Blocks.ha, Blocks.hb, Blocks.hg, Blocks.hh);
    public static final TileEntityTypes<TileEntityLightDetector> r = TileEntityTypes.a("daylight_detector", TileEntityLightDetector::new, Blocks.hp);
    public static final TileEntityTypes<TileEntityHopper> s = TileEntityTypes.a("hopper", TileEntityHopper::new, Blocks.hs);
    public static final TileEntityTypes<TileEntityComparator> t = TileEntityTypes.a("comparator", TileEntityComparator::new, Blocks.ho);
    public static final TileEntityTypes<TileEntityBanner> u = TileEntityTypes.a("banner", TileEntityBanner::new, Blocks.ja, Blocks.jb, Blocks.jc, Blocks.jd, Blocks.je, Blocks.jf, Blocks.jg, Blocks.jh, Blocks.ji, Blocks.jj, Blocks.jk, Blocks.jl, Blocks.jm, Blocks.jn, Blocks.jo, Blocks.jp, Blocks.jq, Blocks.jr, Blocks.js, Blocks.jt, Blocks.ju, Blocks.jv, Blocks.jw, Blocks.jx, Blocks.jy, Blocks.jz, Blocks.jA, Blocks.jB, Blocks.jC, Blocks.jD, Blocks.jE, Blocks.jF);
    public static final TileEntityTypes<TileEntityStructure> v = TileEntityTypes.a("structure_block", TileEntityStructure::new, Blocks.pv);
    public static final TileEntityTypes<TileEntityEndGateway> w = TileEntityTypes.a("end_gateway", TileEntityEndGateway::new, Blocks.la);
    public static final TileEntityTypes<TileEntityCommand> x = TileEntityTypes.a("command_block", TileEntityCommand::new, Blocks.gb, Blocks.lc, Blocks.lb);
    public static final TileEntityTypes<TileEntityShulkerBox> y = TileEntityTypes.a("shulker_box", TileEntityShulkerBox::new, Blocks.lk, Blocks.lA, Blocks.lw, Blocks.lx, Blocks.lu, Blocks.ls, Blocks.ly, Blocks.lo, Blocks.lt, Blocks.lq, Blocks.ln, Blocks.lm, Blocks.lr, Blocks.lv, Blocks.lz, Blocks.ll, Blocks.lp);
    public static final TileEntityTypes<TileEntityBed> z = TileEntityTypes.a("bed", TileEntityBed::new, Blocks.bu, Blocks.bv, Blocks.br, Blocks.bs, Blocks.bp, Blocks.bn, Blocks.bt, Blocks.bj, Blocks.bo, Blocks.bl, Blocks.bi, Blocks.bh, Blocks.bm, Blocks.bq, Blocks.bg, Blocks.bk);
    public static final TileEntityTypes<TileEntityConduit> A = TileEntityTypes.a("conduit", TileEntityConduit::new, Blocks.ns);
    public static final TileEntityTypes<TileEntityBarrel> B = TileEntityTypes.a("barrel", TileEntityBarrel::new, Blocks.op);
    public static final TileEntityTypes<TileEntitySmoker> C = TileEntityTypes.a("smoker", TileEntitySmoker::new, Blocks.oq);
    public static final TileEntityTypes<TileEntityBlastFurnace> D = TileEntityTypes.a("blast_furnace", TileEntityBlastFurnace::new, Blocks.or);
    public static final TileEntityTypes<TileEntityLectern> E = TileEntityTypes.a("lectern", TileEntityLectern::new, Blocks.ov);
    public static final TileEntityTypes<TileEntityBell> F = TileEntityTypes.a("bell", TileEntityBell::new, Blocks.oy);
    public static final TileEntityTypes<TileEntityJigsaw> G = TileEntityTypes.a("jigsaw", TileEntityJigsaw::new, Blocks.pw);
    public static final TileEntityTypes<TileEntityCampfire> H = TileEntityTypes.a("campfire", TileEntityCampfire::new, Blocks.oB, Blocks.oC);
    public static final TileEntityTypes<TileEntityBeehive> I = TileEntityTypes.a("beehive", TileEntityBeehive::new, Blocks.pz, Blocks.pA);
    public static final TileEntityTypes<SculkSensorBlockEntity> J = TileEntityTypes.a("sculk_sensor", SculkSensorBlockEntity::new, Blocks.rl);
    public static final TileEntityTypes<CalibratedSculkSensorBlockEntity> K = TileEntityTypes.a("calibrated_sculk_sensor", CalibratedSculkSensorBlockEntity::new, Blocks.rm);
    public static final TileEntityTypes<SculkCatalystBlockEntity> L = TileEntityTypes.a("sculk_catalyst", SculkCatalystBlockEntity::new, Blocks.rp);
    public static final TileEntityTypes<SculkShriekerBlockEntity> M = TileEntityTypes.a("sculk_shrieker", SculkShriekerBlockEntity::new, Blocks.rq);
    public static final TileEntityTypes<ChiseledBookShelfBlockEntity> N = TileEntityTypes.a("chiseled_bookshelf", ChiseledBookShelfBlockEntity::new, Blocks.ct);
    public static final TileEntityTypes<BrushableBlockEntity> O = TileEntityTypes.a("brushable_block", BrushableBlockEntity::new, Blocks.M, Blocks.P);
    public static final TileEntityTypes<DecoratedPotBlockEntity> P = TileEntityTypes.a("decorated_pot", DecoratedPotBlockEntity::new, Blocks.tK);
    public static final TileEntityTypes<CrafterBlockEntity> Q = TileEntityTypes.a("crafter", CrafterBlockEntity::new, Blocks.tL);
    public static final TileEntityTypes<TrialSpawnerBlockEntity> R = TileEntityTypes.a("trial_spawner", TrialSpawnerBlockEntity::new, Blocks.tM);
    public static final TileEntityTypes<VaultBlockEntity> S = TileEntityTypes.a("vault", VaultBlockEntity::new, Blocks.tN);
    private final a<? extends T> U;
    public final Set<Block> V;
    private final Holder.c<TileEntityTypes<?>> W = BuiltInRegistries.j.f(this);

    @Nullable
    public static MinecraftKey a(TileEntityTypes<?> type) {
        return BuiltInRegistries.j.b(type);
    }

    private static <T extends TileEntity> TileEntityTypes<T> a(String id, a<? extends T> blockEntitySupplier, Block ... blocks) {
        if (blocks.length == 0) {
            T.warn("Block entity type {} requires at least one valid block to be defined!", (Object)id);
        }
        SystemUtils.a(DataConverterTypes.s, id);
        return IRegistry.a(BuiltInRegistries.j, id, new TileEntityTypes<T>(blockEntitySupplier, Set.of(blocks)));
    }

    private TileEntityTypes(a<? extends T> factory, Set<Block> blocks) {
        this.U = factory;
        this.V = blocks;
    }

    @Nullable
    public T a(BlockPosition pos, IBlockData state) {
        return this.U.create(pos, state);
    }

    public boolean a(IBlockData state) {
        return this.V.contains(state.b());
    }

    @Deprecated
    public Holder.c<TileEntityTypes<?>> a() {
        return this.W;
    }

    @Nullable
    public T a(IBlockAccess world, BlockPosition pos) {
        TileEntity blockEntity = world.c_(pos);
        if (blockEntity == null || blockEntity.q() != this) {
            return null;
        }
        return (T)blockEntity;
    }

    @FunctionalInterface
    static interface a<T extends TileEntity> {
        public T create(BlockPosition var1, IBlockData var2);
    }
}

