/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.grower;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import org.bukkit.TreeType;

public final class WorldGenTreeProvider {
    private static final Map<String, WorldGenTreeProvider> l = new Object2ObjectArrayMap();
    public static final Codec<WorldGenTreeProvider> a;
    public static final WorldGenTreeProvider b;
    public static final WorldGenTreeProvider c;
    public static final WorldGenTreeProvider d;
    public static final WorldGenTreeProvider e;
    public static final WorldGenTreeProvider f;
    public static final WorldGenTreeProvider g;
    public static final WorldGenTreeProvider h;
    public static final WorldGenTreeProvider i;
    public static final WorldGenTreeProvider j;
    public static final WorldGenTreeProvider k;
    private final String m;
    private final float n;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> o;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> p;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> q;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> r;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> s;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> t;

    public WorldGenTreeProvider(String id, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> megaVariant, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> regularVariant, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> beesVariant) {
        this(id, 0.0f, megaVariant, Optional.empty(), regularVariant, Optional.empty(), beesVariant, Optional.empty());
    }

    public WorldGenTreeProvider(String id, float rareChance, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> megaVariant, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> rareMegaVariant, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> regularVariant, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> rareRegularVariant, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> beesVariant, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> rareBeesVariant) {
        this.m = id;
        this.n = rareChance;
        this.o = megaVariant;
        this.p = rareMegaVariant;
        this.q = regularVariant;
        this.r = rareRegularVariant;
        this.s = beesVariant;
        this.t = rareBeesVariant;
        l.put(id, this);
    }

    @Nullable
    private ResourceKey<WorldGenFeatureConfigured<?, ?>> a(RandomSource random, boolean flowersNearby) {
        if (random.i() < this.n) {
            if (flowersNearby && this.t.isPresent()) {
                return this.t.get();
            }
            if (this.r.isPresent()) {
                return this.r.get();
            }
        }
        return flowersNearby && this.s.isPresent() ? this.s.get() : (ResourceKey<WorldGenFeatureConfigured<?, ?>>)this.q.orElse(null);
    }

    @Nullable
    private ResourceKey<WorldGenFeatureConfigured<?, ?>> a(RandomSource random) {
        return this.p.isPresent() && random.i() < this.n ? this.p.get() : (ResourceKey<WorldGenFeatureConfigured<?, ?>>)this.o.orElse(null);
    }

    public boolean a(WorldServer world, ChunkGenerator chunkGenerator, BlockPosition pos, IBlockData state, RandomSource random) {
        ResourceKey<WorldGenFeatureConfigured<?, ?>> resourcekey1;
        Holder holder;
        ResourceKey<WorldGenFeatureConfigured<?, ?>> resourcekey = this.a(random);
        if (resourcekey != null && (holder = (Holder)world.K_().e(Registries.aL).a(resourcekey).orElse(null)) != null) {
            this.setTreeType(holder);
            for (int i2 = 0; i2 >= -1; --i2) {
                for (int j2 = 0; j2 >= -1; --j2) {
                    if (!WorldGenTreeProvider.a(state, world, pos, i2, j2)) continue;
                    WorldGenFeatureConfigured worldgenfeatureconfigured = (WorldGenFeatureConfigured)holder.a();
                    IBlockData iblockdata1 = Blocks.a.m();
                    world.a(pos.b(i2, 0, j2), iblockdata1, 4);
                    world.a(pos.b(i2 + 1, 0, j2), iblockdata1, 4);
                    world.a(pos.b(i2, 0, j2 + 1), iblockdata1, 4);
                    world.a(pos.b(i2 + 1, 0, j2 + 1), iblockdata1, 4);
                    if (worldgenfeatureconfigured.a(world, chunkGenerator, random, pos.b(i2, 0, j2))) {
                        return true;
                    }
                    world.a(pos.b(i2, 0, j2), state, 4);
                    world.a(pos.b(i2 + 1, 0, j2), state, 4);
                    world.a(pos.b(i2, 0, j2 + 1), state, 4);
                    world.a(pos.b(i2 + 1, 0, j2 + 1), state, 4);
                    return false;
                }
            }
        }
        if ((resourcekey1 = this.a(random, this.a(world, pos))) == null) {
            return false;
        }
        Holder holder1 = world.K_().e(Registries.aL).a(resourcekey1).orElse(null);
        if (holder1 == null) {
            return false;
        }
        this.setTreeType(holder1);
        WorldGenFeatureConfigured worldgenfeatureconfigured1 = (WorldGenFeatureConfigured)holder1.a();
        IBlockData iblockdata2 = world.b_(pos).g();
        world.a(pos, iblockdata2, 4);
        if (worldgenfeatureconfigured1.a(world, chunkGenerator, random, pos)) {
            if (world.a_(pos) == iblockdata2) {
                world.a(pos, state, iblockdata2, 2);
            }
            return true;
        }
        world.a(pos, state, 4);
        return false;
    }

    private static boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, int x2, int z2) {
        Block block = state.b();
        return world.a_(pos.b(x2, 0, z2)).a(block) && world.a_(pos.b(x2 + 1, 0, z2)).a(block) && world.a_(pos.b(x2, 0, z2 + 1)).a(block) && world.a_(pos.b(x2 + 1, 0, z2 + 1)).a(block);
    }

    private boolean a(GeneratorAccess world, BlockPosition pos) {
        BlockPosition blockposition1;
        Iterator<BlockPosition> iterator = BlockPosition.MutableBlockPosition.c(pos.e().d(2).f(2), pos.d().e(2).g(2)).iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!world.a_(blockposition1 = iterator.next()).a(TagsBlock.W));
        return true;
    }

    private void setTreeType(Holder<WorldGenFeatureConfigured<?, ?>> holder) {
        ResourceKey<WorldGenFeatureConfigured<?, ?>> worldgentreeabstract = holder.e().get();
        if (worldgentreeabstract == TreeFeatures.g || worldgentreeabstract == TreeFeatures.E) {
            BlockSapling.treeType = TreeType.TREE;
        } else if (worldgentreeabstract == TreeFeatures.f) {
            BlockSapling.treeType = TreeType.RED_MUSHROOM;
        } else if (worldgentreeabstract == TreeFeatures.e) {
            BlockSapling.treeType = TreeType.BROWN_MUSHROOM;
        } else if (worldgentreeabstract == TreeFeatures.o) {
            BlockSapling.treeType = TreeType.COCOA_TREE;
        } else if (worldgentreeabstract == TreeFeatures.q) {
            BlockSapling.treeType = TreeType.SMALL_JUNGLE;
        } else if (worldgentreeabstract == TreeFeatures.n) {
            BlockSapling.treeType = TreeType.TALL_REDWOOD;
        } else if (worldgentreeabstract == TreeFeatures.m) {
            BlockSapling.treeType = TreeType.REDWOOD;
        } else if (worldgentreeabstract == TreeFeatures.l) {
            BlockSapling.treeType = TreeType.ACACIA;
        } else if (worldgentreeabstract == TreeFeatures.k || worldgentreeabstract == TreeFeatures.H) {
            BlockSapling.treeType = TreeType.BIRCH;
        } else if (worldgentreeabstract == TreeFeatures.u) {
            BlockSapling.treeType = TreeType.TALL_BIRCH;
        } else if (worldgentreeabstract == TreeFeatures.w) {
            BlockSapling.treeType = TreeType.SWAMP;
        } else if (worldgentreeabstract == TreeFeatures.p || worldgentreeabstract == TreeFeatures.K) {
            BlockSapling.treeType = TreeType.BIG_TREE;
        } else if (worldgentreeabstract == TreeFeatures.x) {
            BlockSapling.treeType = TreeType.JUNGLE_BUSH;
        } else if (worldgentreeabstract == TreeFeatures.h) {
            BlockSapling.treeType = TreeType.DARK_OAK;
        } else if (worldgentreeabstract == TreeFeatures.s) {
            BlockSapling.treeType = TreeType.MEGA_REDWOOD;
        } else if (worldgentreeabstract == TreeFeatures.t) {
            BlockSapling.treeType = TreeType.MEGA_PINE;
        } else if (worldgentreeabstract == TreeFeatures.r) {
            BlockSapling.treeType = TreeType.JUNGLE;
        } else if (worldgentreeabstract == TreeFeatures.y) {
            BlockSapling.treeType = TreeType.AZALEA;
        } else if (worldgentreeabstract == TreeFeatures.z) {
            BlockSapling.treeType = TreeType.MANGROVE;
        } else if (worldgentreeabstract == TreeFeatures.A) {
            BlockSapling.treeType = TreeType.TALL_MANGROVE;
        } else if (worldgentreeabstract == TreeFeatures.B || worldgentreeabstract == TreeFeatures.M) {
            BlockSapling.treeType = TreeType.CHERRY;
        } else if (worldgentreeabstract == TreeFeatures.i) {
            BlockSapling.treeType = TreeType.PALE_OAK;
        } else if (worldgentreeabstract == TreeFeatures.j) {
            BlockSapling.treeType = TreeType.PALE_OAK_CREAKING;
        } else {
            throw new IllegalArgumentException("Unknown tree generator " + String.valueOf(worldgentreeabstract));
        }
    }

    static {
        Function<WorldGenTreeProvider, String> function = worldgentreeprovider -> worldgentreeprovider.m;
        Map<String, WorldGenTreeProvider> map = l;
        Objects.requireNonNull(map);
        a = Codec.stringResolver(function, map::get);
        b = new WorldGenTreeProvider("oak", 0.1f, Optional.empty(), Optional.empty(), Optional.of(TreeFeatures.g), Optional.of(TreeFeatures.p), Optional.of(TreeFeatures.E), Optional.of(TreeFeatures.K));
        c = new WorldGenTreeProvider("spruce", 0.5f, Optional.of(TreeFeatures.s), Optional.of(TreeFeatures.t), Optional.of(TreeFeatures.m), Optional.empty(), Optional.empty(), Optional.empty());
        d = new WorldGenTreeProvider("mangrove", 0.85f, Optional.empty(), Optional.empty(), Optional.of(TreeFeatures.z), Optional.of(TreeFeatures.A), Optional.empty(), Optional.empty());
        e = new WorldGenTreeProvider("azalea", Optional.empty(), Optional.of(TreeFeatures.y), Optional.empty());
        f = new WorldGenTreeProvider("birch", Optional.empty(), Optional.of(TreeFeatures.k), Optional.of(TreeFeatures.H));
        g = new WorldGenTreeProvider("jungle", Optional.of(TreeFeatures.r), Optional.of(TreeFeatures.q), Optional.empty());
        h = new WorldGenTreeProvider("acacia", Optional.empty(), Optional.of(TreeFeatures.l), Optional.empty());
        i = new WorldGenTreeProvider("cherry", Optional.empty(), Optional.of(TreeFeatures.B), Optional.of(TreeFeatures.M));
        j = new WorldGenTreeProvider("dark_oak", Optional.of(TreeFeatures.h), Optional.empty(), Optional.empty());
        k = new WorldGenTreeProvider("pale_oak", Optional.of(TreeFeatures.i), Optional.empty(), Optional.empty());
    }
}

