/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.piston.BlockPistonExtension;
import net.minecraft.world.level.block.piston.BlockPistonMoving;
import net.minecraft.world.level.block.piston.PistonExtendsChecker;
import net.minecraft.world.level.block.piston.TileEntityPiston;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyPistonType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;

public class BlockPiston
extends BlockDirectional {
    public static final MapCodec<BlockPiston> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("sticky").forGetter(blockpiston -> blockpiston.n), BlockPiston.t()).apply((Applicative)instance, BlockPiston::new));
    public static final BlockStateBoolean c = BlockProperties.g;
    public static final int d = 0;
    public static final int e = 1;
    public static final int f = 2;
    public static final float g = 4.0f;
    protected static final VoxelShape h = Block.a(0.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    protected static final VoxelShape i = Block.a(4.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape j = Block.a(0.0, 0.0, 0.0, 16.0, 16.0, 12.0);
    protected static final VoxelShape k = Block.a(0.0, 0.0, 4.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape l = Block.a(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);
    protected static final VoxelShape m = Block.a(0.0, 4.0, 0.0, 16.0, 16.0, 16.0);
    private final boolean n;

    public MapCodec<BlockPiston> a() {
        return b;
    }

    public BlockPiston(boolean sticky, BlockBase.Info settings) {
        super(settings);
        this.l((IBlockData)((IBlockData)this.F.b().b(BlockDirectional.a, EnumDirection.c)).b(c, false));
        this.n = sticky;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        if (state.c(c).booleanValue()) {
            switch (state.c(BlockDirectional.a)) {
                case a: {
                    return m;
                }
                default: {
                    return l;
                }
                case c: {
                    return k;
                }
                case d: {
                    return j;
                }
                case e: {
                    return i;
                }
                case f: 
            }
            return h;
        }
        return VoxelShapes.b();
    }

    @Override
    public void a(World world, BlockPosition pos, IBlockData state, EntityLiving placer, ItemStack itemStack) {
        if (!world.C) {
            this.a(world, pos, state);
        }
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
        if (!world.C) {
            this.a(world, pos, state);
        }
    }

    @Override
    protected void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        if (!oldState.a(state.b()) && !world.C && world.c_(pos) == null) {
            this.a(world, pos, state);
        }
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return (IBlockData)((IBlockData)this.m().b(BlockDirectional.a, ctx.d().g())).b(c, false);
    }

    private void a(World world, BlockPosition pos, IBlockData state) {
        EnumDirection enumdirection = state.c(BlockDirectional.a);
        boolean flag = this.a((SignalGetter)world, pos, enumdirection);
        if (flag && !state.c(c).booleanValue()) {
            if (new PistonExtendsChecker(world, pos, enumdirection, true).a()) {
                world.a(pos, (Block)this, 0, enumdirection.d());
            }
        } else if (!flag && state.c(c).booleanValue()) {
            TileEntityPiston tileentitypiston;
            TileEntity tileentity;
            BlockPosition blockposition1 = pos.a(enumdirection, 2);
            IBlockData iblockdata1 = world.a_(blockposition1);
            int b0 = 1;
            if (iblockdata1.a(Blocks.bX) && iblockdata1.c(BlockDirectional.a) == enumdirection && (tileentity = world.c_(blockposition1)) instanceof TileEntityPiston && (tileentitypiston = (TileEntityPiston)tileentity).b() && (tileentitypiston.a(0.0f) < 0.5f || world.ac() == tileentitypiston.u() || ((WorldServer)world).d())) {
                b0 = 2;
            }
            world.a(pos, (Block)this, b0, enumdirection.d());
        }
    }

    private boolean a(SignalGetter world, BlockPosition pos, EnumDirection pistonFace) {
        for (EnumDirection enumdirection1 : EnumDirection.values()) {
            if (enumdirection1 == pistonFace || !world.b(pos.a(enumdirection1), enumdirection1)) continue;
            return true;
        }
        if (world.b(pos, EnumDirection.a)) {
            return true;
        }
        BlockPosition blockposition1 = pos.d();
        for (EnumDirection enumdirection2 : EnumDirection.values()) {
            if (enumdirection2 == EnumDirection.a || !world.b(blockposition1.a(enumdirection2), enumdirection2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean a(IBlockData state, World world, BlockPosition pos, int type, int data) {
        EnumDirection enumdirection = state.c(BlockDirectional.a);
        EnumDirection directionQueuedAs = EnumDirection.a(data & 7);
        if (!GlobalConfiguration.get().unsupportedSettings.allowPermanentBlockBreakExploits && enumdirection != directionQueuedAs) {
            return false;
        }
        IBlockData iblockdata1 = (IBlockData)state.b(c, true);
        if (!world.C) {
            boolean flag = this.a((SignalGetter)world, pos, enumdirection);
            if (flag && (type == 1 || type == 2)) {
                world.a(pos, iblockdata1, 2);
                return false;
            }
            if (!flag && type == 0) {
                return false;
            }
        }
        if (type == 0) {
            if (!this.a(world, pos, enumdirection, true)) {
                return false;
            }
            world.a(pos, iblockdata1, 67);
            world.a((EntityHuman)null, pos, SoundEffects.uu, SoundCategory.e, 0.5f, world.A.i() * 0.25f + 0.6f);
            world.a(GameEvent.a, pos, GameEvent.a.a(iblockdata1));
        } else if (type == 1 || type == 2) {
            TileEntity tileentity = world.c_(pos.a(enumdirection));
            if (tileentity instanceof TileEntityPiston) {
                ((TileEntityPiston)tileentity).k();
            }
            IBlockData iblockdata2 = (IBlockData)((IBlockData)Blocks.bX.m().b(BlockPistonMoving.b, enumdirection)).b(BlockPistonMoving.c, this.n ? BlockPropertyPistonType.b : BlockPropertyPistonType.a);
            if (!this.n && !new BlockPistonRetractEvent((org.bukkit.block.Block)CraftBlock.at(world, pos), Collections.emptyList(), CraftBlock.notchToBlockFace(enumdirection)).callEvent()) {
                return false;
            }
            world.a(pos, iblockdata2, 20);
            world.a(BlockPistonMoving.a(pos, iblockdata2, (IBlockData)this.m().b(BlockDirectional.a, EnumDirection.a(data & 7)), enumdirection, false, true));
            world.b(pos, iblockdata2.b());
            iblockdata2.a((GeneratorAccess)world, pos, 2);
            if (this.n) {
                TileEntityPiston tileentitypiston;
                TileEntity tileentity1;
                BlockPosition blockposition1 = pos.b(enumdirection.j() * 2, enumdirection.k() * 2, enumdirection.l() * 2);
                IBlockData iblockdata3 = world.a_(blockposition1);
                boolean flag1 = false;
                if (iblockdata3.a(Blocks.bX) && (tileentity1 = world.c_(blockposition1)) instanceof TileEntityPiston && (tileentitypiston = (TileEntityPiston)tileentity1).c() == enumdirection && tileentitypiston.b()) {
                    tileentitypiston.k();
                    flag1 = true;
                }
                if (!flag1) {
                    if (type == 1 && !iblockdata3.l() && BlockPiston.a(iblockdata3, world, blockposition1, enumdirection.g(), false, enumdirection) && (iblockdata3.r() == EnumPistonReaction.a || iblockdata3.a(Blocks.bF) || iblockdata3.a(Blocks.by))) {
                        this.a(world, pos, enumdirection, false);
                    } else {
                        if (type == 1 && iblockdata2.l() && !new BlockPistonRetractEvent((org.bukkit.block.Block)CraftBlock.at(world, pos), Collections.emptyList(), CraftBlock.notchToBlockFace(enumdirection)).callEvent()) {
                            return false;
                        }
                        world.a(pos.a(enumdirection), false);
                    }
                }
            } else {
                BlockPosition headPos = pos.a(enumdirection);
                if (GlobalConfiguration.get().unsupportedSettings.allowPermanentBlockBreakExploits || world.a_(headPos) == Blocks.bG.m().b(BlockDirectional.a, enumdirection)) {
                    world.a(headPos, false);
                } else {
                    ((WorldServer)world).m().a(headPos);
                }
            }
            world.a((EntityHuman)null, pos, SoundEffects.ut, SoundCategory.e, 0.5f, world.A.i() * 0.15f + 0.6f);
            world.a(GameEvent.e, pos, GameEvent.a.a(iblockdata2));
        }
        return true;
    }

    public static boolean a(IBlockData state, World world, BlockPosition pos, EnumDirection direction, boolean canBreak, EnumDirection pistonDir) {
        if (pos.v() >= world.L_() && pos.v() <= world.am() && world.F_().a(pos)) {
            if (state.l()) {
                return true;
            }
            if (!(state.a(Blocks.cv) || state.a(Blocks.pF) || state.a(Blocks.pG) || state.a(Blocks.tJ))) {
                if (direction == EnumDirection.a && pos.v() == world.L_()) {
                    return false;
                }
                if (direction == EnumDirection.b && pos.v() == world.am()) {
                    return false;
                }
                if (!state.a(Blocks.bF) && !state.a(Blocks.by)) {
                    if (state.e(world, pos) == -1.0f) {
                        return false;
                    }
                    switch (state.r()) {
                        case c: {
                            return false;
                        }
                        case b: {
                            return canBreak;
                        }
                        case e: {
                            return direction == pistonDir;
                        }
                    }
                } else if (state.c(c).booleanValue()) {
                    return false;
                }
                return !state.x();
            }
            return false;
        }
        return false;
    }

    private boolean a(World world, BlockPosition pos, EnumDirection dir, boolean extend) {
        int k2;
        IBlockData iblockdata2;
        IBlockData iblockdata1;
        BlockPosition blockposition3;
        int j2;
        PistonExtendsChecker pistonextendschecker;
        BlockPosition blockposition1 = pos.a(dir);
        if (!extend && world.a_(blockposition1).a(Blocks.bG)) {
            world.a(blockposition1, Blocks.a.m(), 20);
        }
        if (!(pistonextendschecker = new PistonExtendsChecker(world, pos, dir, extend)).a()) {
            return false;
        }
        HashMap map = Maps.newHashMap();
        List<BlockPosition> list = pistonextendschecker.c();
        ArrayList list1 = Lists.newArrayList();
        for (BlockPosition blockposition2 : list) {
            IBlockData iblockdata = world.a_(blockposition2);
            list1.add(iblockdata);
            map.put(blockposition2, iblockdata);
        }
        List<BlockPosition> list2 = pistonextendschecker.d();
        IBlockData[] aiblockdata = new IBlockData[list.size() + list2.size()];
        EnumDirection enumdirection1 = extend ? dir : dir.g();
        int i2 = 0;
        final org.bukkit.block.Block bblock = world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
        final List<BlockPosition> moved = pistonextendschecker.c();
        final List<BlockPosition> broken = pistonextendschecker.d();
        AbstractList<org.bukkit.block.Block> blocks = new AbstractList<org.bukkit.block.Block>(this){

            @Override
            public int size() {
                return moved.size() + broken.size();
            }

            @Override
            public org.bukkit.block.Block get(int index) {
                if (index >= this.size() || index < 0) {
                    throw new ArrayIndexOutOfBoundsException(index);
                }
                BlockPosition pos = index < moved.size() ? (BlockPosition)moved.get(index) : (BlockPosition)broken.get(index - moved.size());
                return bblock.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
            }
        };
        Object event = extend ? new BlockPistonExtendEvent(bblock, (List)blocks, CraftBlock.notchToBlockFace(enumdirection1)) : new BlockPistonRetractEvent(bblock, (List)blocks, CraftBlock.notchToBlockFace(enumdirection1));
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            for (BlockPosition b2 : broken) {
                world.a(b2, Blocks.a.m(), world.a_(b2), 3);
            }
            for (BlockPosition b2 : moved) {
                world.a(b2, Blocks.a.m(), world.a_(b2), 3);
                b2 = b2.a(enumdirection1);
                world.a(b2, Blocks.a.m(), world.a_(b2), 3);
            }
            return false;
        }
        for (j2 = list2.size() - 1; j2 >= 0; --j2) {
            blockposition3 = list2.get(j2);
            iblockdata1 = world.a_(blockposition3);
            TileEntity tileentity = iblockdata1.x() ? world.c_(blockposition3) : null;
            BlockPiston.dropResources(iblockdata1, world, blockposition3, tileentity, pos);
            world.a(blockposition3, Blocks.a.m(), 18);
            world.a(GameEvent.f, blockposition3, GameEvent.a.a(iblockdata1));
            if (!iblockdata1.a(TagsBlock.aN)) {
                world.a(blockposition3, iblockdata1);
            }
            aiblockdata[i2++] = iblockdata1;
        }
        for (j2 = list.size() - 1; j2 >= 0; --j2) {
            boolean allowDesync = GlobalConfiguration.get().unsupportedSettings.allowPistonDuplication;
            BlockPosition oldPos = blockposition3 = list.get(j2);
            iblockdata1 = allowDesync ? world.a_(oldPos) : null;
            blockposition3 = blockposition3.a(enumdirection1);
            map.remove(blockposition3);
            iblockdata2 = (IBlockData)Blocks.bX.m().b(BlockDirectional.a, dir);
            world.a(blockposition3, iblockdata2, 68);
            if (!allowDesync) {
                iblockdata1 = world.a_(oldPos);
                map.replace(oldPos, iblockdata1);
            }
            world.a(BlockPistonMoving.a(blockposition3, iblockdata2, allowDesync ? (IBlockData)list1.get(j2) : iblockdata1, dir, extend, false));
            if (!allowDesync) {
                world.a(oldPos, Blocks.a.m(), 1106);
            }
            aiblockdata[i2++] = iblockdata1;
        }
        if (extend) {
            BlockPropertyPistonType blockpropertypistontype = this.n ? BlockPropertyPistonType.b : BlockPropertyPistonType.a;
            IBlockData iblockdata3 = (IBlockData)((IBlockData)Blocks.bG.m().b(BlockDirectional.a, dir)).b(BlockPistonExtension.c, blockpropertypistontype);
            iblockdata1 = (IBlockData)((IBlockData)Blocks.bX.m().b(BlockPistonMoving.b, dir)).b(BlockPistonMoving.c, this.n ? BlockPropertyPistonType.b : BlockPropertyPistonType.a);
            map.remove(blockposition1);
            world.a(blockposition1, iblockdata1, 68);
            world.a(BlockPistonMoving.a(blockposition1, iblockdata1, iblockdata3, dir, true, true));
        }
        IBlockData iblockdata4 = Blocks.a.m();
        for (BlockPosition blockPosition : map.keySet()) {
            world.a(blockPosition, iblockdata4, 82);
        }
        for (Map.Entry entry : map.entrySet()) {
            BlockPosition blockposition5 = (BlockPosition)entry.getKey();
            IBlockData iblockdata5 = (IBlockData)entry.getValue();
            iblockdata5.b(world, blockposition5, 2);
            iblockdata4.a((GeneratorAccess)world, blockposition5, 2);
            iblockdata4.b(world, blockposition5, 2);
        }
        Orientation orientation = ExperimentalRedstoneUtils.a(world, pistonextendschecker.b(), null);
        i2 = 0;
        for (k2 = list2.size() - 1; k2 >= 0; --k2) {
            iblockdata2 = aiblockdata[i2++];
            BlockPosition blockposition6 = list2.get(k2);
            iblockdata2.b(world, blockposition6, 2);
            world.a(blockposition6, iblockdata2.b(), orientation);
        }
        for (k2 = list.size() - 1; k2 >= 0; --k2) {
            world.a(list.get(k2), aiblockdata[i2++].b(), orientation);
        }
        if (extend) {
            world.a(blockposition1, Blocks.bG, orientation);
        }
        return true;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(BlockDirectional.a, rotation.a(state.c(BlockDirectional.a)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(BlockDirectional.a)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockDirectional.a, c);
    }

    @Override
    protected boolean g_(IBlockData state) {
        return state.c(c);
    }

    @Override
    protected boolean a(IBlockData state, PathMode type) {
        return false;
    }
}

