/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.piston.BlockPiston;
import net.minecraft.world.level.block.piston.BlockPistonExtension;
import net.minecraft.world.level.block.piston.PistonUtil;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyPistonType;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class TileEntityPiston
extends TileEntity {
    private static final int b = 2;
    private static final double c = 0.01;
    public static final double a = 0.51;
    private IBlockData d = Blocks.a.m();
    private EnumDirection e;
    private boolean f;
    private boolean g;
    private static final ThreadLocal<EnumDirection> h = ThreadLocal.withInitial(() -> null);
    private float i;
    private float j;
    private long k;
    private int l;

    public TileEntityPiston(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.l, pos, state);
    }

    public TileEntityPiston(BlockPosition pos, IBlockData state, IBlockData pushedBlock, EnumDirection facing, boolean extending, boolean source) {
        this(pos, state);
        this.d = pushedBlock;
        this.e = facing;
        this.f = extending;
        this.g = source;
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        return this.e(registries);
    }

    public boolean b() {
        return this.f;
    }

    public EnumDirection c() {
        return this.e;
    }

    public boolean d() {
        return this.g;
    }

    public float a(float tickDelta) {
        if (tickDelta > 1.0f) {
            tickDelta = 1.0f;
        }
        return MathHelper.h(tickDelta, this.j, this.i);
    }

    public float b(float tickDelta) {
        return (float)this.e.j() * this.e(this.a(tickDelta));
    }

    public float c(float tickDelta) {
        return (float)this.e.k() * this.e(this.a(tickDelta));
    }

    public float d(float tickDelta) {
        return (float)this.e.l() * this.e(this.a(tickDelta));
    }

    private float e(float progress) {
        return this.f ? progress - 1.0f : 1.0f - progress;
    }

    private IBlockData v() {
        return !this.b() && this.d() && this.d.b() instanceof BlockPiston ? (IBlockData)((IBlockData)((IBlockData)Blocks.bG.m().b(BlockPistonExtension.d, this.i > 0.25f)).b(BlockPistonExtension.c, this.d.a(Blocks.by) ? BlockPropertyPistonType.b : BlockPropertyPistonType.a)).b(BlockDirectional.a, this.d.c(BlockDirectional.a)) : this.d;
    }

    private static void a(World world, BlockPosition pos, float f2, TileEntityPiston blockEntity) {
        AxisAlignedBB aABB;
        List<Entity> list;
        EnumDirection direction = blockEntity.f();
        double d2 = f2 - blockEntity.i;
        VoxelShape voxelShape = blockEntity.v().g(world, pos);
        if (!voxelShape.c() && !(list = world.a_(null, PistonUtil.a(aABB = TileEntityPiston.a(pos, voxelShape.a(), blockEntity), direction, d2).b(aABB))).isEmpty()) {
            List<AxisAlignedBB> list2 = voxelShape.e();
            boolean bl = blockEntity.d.a(Blocks.im);
            Iterator<Entity> var12 = list.iterator();
            while (true) {
                AxisAlignedBB aABB4;
                AxisAlignedBB aABB2;
                AxisAlignedBB aABB3;
                if (!var12.hasNext()) {
                    return;
                }
                Entity entity = var12.next();
                if (entity.n_() == EnumPistonReaction.d) continue;
                if (bl) {
                    if (entity instanceof EntityPlayer) continue;
                    Vec3D vec3 = entity.dz();
                    double e2 = vec3.d;
                    double g2 = vec3.e;
                    double h2 = vec3.f;
                    switch (direction.o()) {
                        case a: {
                            e2 = direction.j();
                            break;
                        }
                        case b: {
                            g2 = direction.k();
                            break;
                        }
                        case c: {
                            h2 = direction.l();
                        }
                    }
                    entity.n(e2, g2, h2);
                    entity.activatedTick = Math.max(entity.activatedTick, (long)(MinecraftServer.currentTick + 10));
                    entity.activatedImmunityTick = Math.max(entity.activatedImmunityTick, (long)(MinecraftServer.currentTick + 10));
                }
                double i2 = 0.0;
                Iterator<AxisAlignedBB> iterator = list2.iterator();
                while (!(!iterator.hasNext() || (aABB3 = PistonUtil.a(TileEntityPiston.a(pos, aABB2 = iterator.next(), blockEntity), direction, d2)).c(aABB4 = entity.cR()) && (i2 = Math.max(i2, TileEntityPiston.a(aABB3, direction, aABB4))) >= d2)) {
                }
                if (i2 <= 0.0) continue;
                i2 = Math.min(i2, d2) + 0.01;
                TileEntityPiston.a(direction, entity, i2, direction);
                if (blockEntity.f || !blockEntity.g) continue;
                TileEntityPiston.a(pos, entity, direction, d2);
            }
        }
    }

    private static void a(EnumDirection direction, Entity entity, double distance, EnumDirection movementDirection) {
        h.set(direction);
        entity.a(EnumMoveType.c, new Vec3D(distance * (double)movementDirection.j(), distance * (double)movementDirection.k(), distance * (double)movementDirection.l()));
        entity.aK();
        h.set(null);
    }

    private static void b(World world, BlockPosition pos, float f2, TileEntityPiston blockEntity) {
        EnumDirection direction;
        if (blockEntity.w() && (direction = blockEntity.f()).o().d()) {
            double d2 = blockEntity.d.g(world, pos).c(EnumDirection.EnumAxis.b);
            AxisAlignedBB aABB = TileEntityPiston.a(pos, new AxisAlignedBB(0.0, d2, 0.0, 1.0, 1.5000010000000001, 1.0), blockEntity);
            double e2 = f2 - blockEntity.i;
            for (Entity entity : world.a((Entity)null, aABB, entityx -> TileEntityPiston.a(aABB, entityx, pos))) {
                TileEntityPiston.a(direction, entity, e2, direction);
            }
        }
    }

    private static boolean a(AxisAlignedBB box, Entity entity, BlockPosition pos) {
        return entity.n_() == EnumPistonReaction.a && entity.aJ() && (entity.d(pos) || entity.dB() >= box.a && entity.dB() <= box.d && entity.dH() >= box.c && entity.dH() <= box.f);
    }

    private boolean w() {
        return this.d.a(Blocks.pB);
    }

    public EnumDirection f() {
        return this.f ? this.e : this.e.g();
    }

    private static double a(AxisAlignedBB aABB, EnumDirection direction, AxisAlignedBB aABB2) {
        switch (direction) {
            case f: {
                return aABB.d - aABB2.a;
            }
            case e: {
                return aABB2.d - aABB.a;
            }
            default: {
                return aABB.e - aABB2.b;
            }
            case a: {
                return aABB2.e - aABB.b;
            }
            case d: {
                return aABB.f - aABB2.c;
            }
            case c: 
        }
        return aABB2.f - aABB.c;
    }

    private static AxisAlignedBB a(BlockPosition pos, AxisAlignedBB box, TileEntityPiston blockEntity) {
        double d2 = blockEntity.e(blockEntity.i);
        return box.d((double)pos.u() + d2 * (double)blockEntity.e.j(), (double)pos.v() + d2 * (double)blockEntity.e.k(), (double)pos.w() + d2 * (double)blockEntity.e.l());
    }

    private static void a(BlockPosition pos, Entity entity, EnumDirection direction, double amount) {
        double e2;
        EnumDirection direction2;
        double d2;
        AxisAlignedBB aABB2;
        AxisAlignedBB aABB = entity.cR();
        if (aABB.c(aABB2 = VoxelShapes.b().a().a(pos)) && Math.abs((d2 = TileEntityPiston.a(aABB2, direction2 = direction.g(), aABB) + 0.01) - (e2 = TileEntityPiston.a(aABB2, direction2, aABB.a(aABB2)) + 0.01)) < 0.01) {
            d2 = Math.min(d2, amount) + 0.01;
            TileEntityPiston.a(direction, entity, d2, direction2);
        }
    }

    public IBlockData j() {
        return this.d;
    }

    public void k() {
        if (this.o != null && (this.j < 1.0f || this.o.C)) {
            this.j = this.i = 1.0f;
            this.o.o(this.p);
            this.aw_();
            if (this.o.a_(this.p).a(Blocks.bX)) {
                IBlockData blockState = this.g ? Blocks.a.m() : Block.b(this.d, this.o, this.p);
                this.o.a(this.p, blockState, 3);
                this.o.b(this.p, blockState.b(), ExperimentalRedstoneUtils.a(this.o, this.t(), null));
            }
        }
    }

    public EnumDirection t() {
        return this.f ? this.e : this.e.g();
    }

    public static void a(World world, BlockPosition pos, IBlockData state, TileEntityPiston blockEntity) {
        blockEntity.k = world.ac();
        blockEntity.j = blockEntity.i;
        if (blockEntity.j >= 1.0f) {
            if (world.C && blockEntity.l < 5) {
                ++blockEntity.l;
            } else {
                world.o(pos);
                blockEntity.aw_();
                if (world.a_(pos).a(Blocks.bX)) {
                    IBlockData blockState = Block.b(blockEntity.d, world, pos);
                    if (blockState.l()) {
                        world.a(pos, blockEntity.d, GlobalConfiguration.get().unsupportedSettings.allowPistonDuplication ? 84 : 86);
                        Block.a(blockEntity.d, blockState, world, pos, 3);
                    } else {
                        if (blockState.b(BlockProperties.D) && blockState.c(BlockProperties.D).booleanValue()) {
                            blockState = (IBlockData)blockState.b(BlockProperties.D, false);
                        }
                        world.a(pos, blockState, 67);
                        world.b(pos, blockState.b(), ExperimentalRedstoneUtils.a(world, blockEntity.t(), null));
                    }
                }
            }
        } else {
            float f2 = blockEntity.i + 0.5f;
            TileEntityPiston.a(world, pos, f2, blockEntity);
            TileEntityPiston.b(world, pos, f2, blockEntity);
            blockEntity.i = f2;
            if (blockEntity.i >= 1.0f) {
                blockEntity.i = 1.0f;
            }
        }
    }

    @Override
    protected void a(NBTTagCompound nbt, HolderLookup.a registries) {
        super.a(nbt, registries);
        RegistryBlocks<Block> holderGetter = this.o != null ? this.o.a(Registries.f) : BuiltInRegistries.e;
        this.d = GameProfileSerializer.a(holderGetter, nbt.p("blockState"));
        this.e = EnumDirection.a(nbt.h("facing"));
        this.j = this.i = nbt.j("progress");
        this.f = nbt.q("extending");
        this.g = nbt.q("source");
    }

    @Override
    protected void b(NBTTagCompound nbt, HolderLookup.a registries) {
        super.b(nbt, registries);
        nbt.a("blockState", GameProfileSerializer.a(this.d));
        nbt.a("facing", this.e.d());
        nbt.a("progress", this.j);
        nbt.a("extending", this.f);
        nbt.a("source", this.g);
    }

    public VoxelShape a(IBlockAccess world, BlockPosition pos) {
        VoxelShape voxelShape = !this.f && this.g && this.d.b() instanceof BlockPiston ? ((IBlockData)this.d.b(BlockPiston.c, true)).g(world, pos) : VoxelShapes.a();
        EnumDirection direction = h.get();
        if ((double)this.i < 1.0 && direction == this.f()) {
            return voxelShape;
        }
        IBlockData blockState = this.d() ? (IBlockData)((IBlockData)Blocks.bG.m().b(BlockDirectional.a, this.e)).b(BlockPistonExtension.d, this.f != 1.0f - this.i < 0.25f) : this.d;
        float f2 = this.e(this.i);
        double d2 = (float)this.e.j() * f2;
        double e2 = (float)this.e.k() * f2;
        double g2 = (float)this.e.l() * f2;
        return VoxelShapes.a(voxelShape, blockState.g(world, pos).a(d2, e2, g2));
    }

    public long u() {
        return this.k;
    }

    @Override
    public void a(World world) {
        super.a(world);
        if (world.a(Registries.f).a(this.d.b().p().h()).isEmpty()) {
            this.d = Blocks.a.m();
        }
    }
}

