/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import ca.spottedleaf.moonrise.patches.collisions.block.CollisionBlockState;
import ca.spottedleaf.moonrise.patches.starlight.blockstate.StarlightAbstractBlockState;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.resources.DependantName;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.material.MaterialMapColor;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R2.block.data.CraftBlockData;
import org.spigotmc.AsyncCatcher;

public abstract class BlockBase
implements FeatureElement {
    protected static final EnumDirection[] aG = new EnumDirection[]{EnumDirection.e, EnumDirection.f, EnumDirection.c, EnumDirection.d, EnumDirection.a, EnumDirection.b};
    public final boolean aH;
    protected final float aI;
    protected final boolean aJ;
    protected final SoundEffectType aK;
    protected final float aL;
    protected final float aM;
    protected final float aN;
    protected final boolean aO;
    protected final FeatureFlagSet aP;
    protected final Info aQ;
    protected final Optional<ResourceKey<LootTable>> aR;
    protected final String aS;

    public BlockBase(Info settings) {
        this.aH = settings.c;
        this.aR = settings.h();
        this.aS = settings.q();
        this.aI = settings.f;
        this.aJ = settings.i;
        this.aK = settings.d;
        this.aL = settings.j;
        this.aM = settings.k;
        this.aN = settings.l;
        this.aO = settings.F;
        this.aP = settings.G;
        this.aQ = settings;
    }

    public Info s() {
        return this.aQ;
    }

    protected abstract MapCodec<? extends Block> a();

    protected static <B extends Block> RecordCodecBuilder<B, Info> t() {
        return Info.a.fieldOf("properties").forGetter(BlockBase::s);
    }

    public static <B extends Block> MapCodec<B> b(Function<Info, B> blockFromSettings) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group(BlockBase.t()).apply((Applicative)instance, blockFromSettings));
    }

    protected void a(IBlockData state, GeneratorAccess world, BlockPosition pos, int flags, int maxUpdateDepth) {
    }

    protected boolean a(IBlockData state, PathMode type) {
        switch (type) {
            case a: {
                return !state.m(BlockAccessAir.a, BlockPosition.c);
            }
            case b: {
                return state.y().a(TagsFluid.a);
            }
            case c: {
                return !state.m(BlockAccessAir.a, BlockPosition.c);
            }
        }
        return false;
    }

    protected IBlockData a(IBlockData state, IWorldReader world, ScheduledTickAccess tickView, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        return state;
    }

    protected boolean b(IBlockData state, IBlockData stateFrom, EnumDirection direction) {
        return false;
    }

    protected void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
    }

    protected void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        AsyncCatcher.catchOp("block onPlace");
    }

    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag, @Nullable ItemActionContext context) {
        this.b(iblockdata, world, blockposition, iblockdata1, flag);
    }

    protected void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        AsyncCatcher.catchOp("block remove");
        if (state.x() && !state.a(newState.b())) {
            world.o(pos);
        }
    }

    protected void a(IBlockData state, WorldServer world, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> stackMerger) {
        if (!state.l() && explosion.b() != Explosion.Effect.d && state.isDestroyable()) {
            Block block = state.b();
            boolean flag = explosion.c() instanceof EntityHuman;
            if (block.a(explosion)) {
                TileEntity tileentity = state.x() ? world.c_(pos) : null;
                LootParams.a lootparams_a = new LootParams.a(world).a(LootContextParameters.f, Vec3D.b(pos)).a(LootContextParameters.i, ItemStack.j).b(LootContextParameters.h, tileentity).b(LootContextParameters.a, explosion.d());
                if (explosion instanceof ServerExplosion) {
                    ServerExplosion serverExplosion = (ServerExplosion)explosion;
                    if (serverExplosion.yield < 1.0f) {
                        lootparams_a.a(LootContextParameters.j, Float.valueOf(1.0f / serverExplosion.yield));
                    }
                }
                state.a(world, pos, ItemStack.j, flag);
                state.a(lootparams_a).forEach(itemstack -> stackMerger.accept((ItemStack)itemstack, pos));
            }
            world.a(pos, Blocks.a.m(), 3);
            block.a(world, pos, explosion);
        }
    }

    protected EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hit) {
        return EnumInteractionResult.e;
    }

    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        return EnumInteractionResult.f;
    }

    protected boolean a(IBlockData state, World world, BlockPosition pos, int type, int data) {
        return false;
    }

    protected EnumRenderType a_(IBlockData state) {
        return EnumRenderType.c;
    }

    protected boolean g_(IBlockData state) {
        return false;
    }

    protected boolean f_(IBlockData state) {
        return false;
    }

    protected Fluid b_(IBlockData state) {
        return FluidTypes.a.g();
    }

    protected boolean c_(IBlockData state) {
        return false;
    }

    protected float as_() {
        return 0.25f;
    }

    protected float au_() {
        return 0.2f;
    }

    @Override
    public FeatureFlagSet i() {
        return this.aP;
    }

    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return state;
    }

    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state;
    }

    protected boolean a(IBlockData state, BlockActionContext context) {
        return state.v() && (context.n().f() || !context.n().a(this.j())) && (state.isDestroyable() || context.o() != null && context.o().gj().d);
    }

    protected boolean a(IBlockData state, FluidType fluid) {
        return state.v() || !state.e();
    }

    protected List<ItemStack> a(IBlockData state, LootParams.a builder) {
        if (this.aR.isEmpty()) {
            return Collections.emptyList();
        }
        LootParams lootparams = builder.a(LootContextParameters.g, state).a(LootContextParameterSets.r);
        WorldServer worldserver = lootparams.a();
        LootTable loottable = worldserver.p().bc().b(this.aR.get());
        return loottable.a(lootparams);
    }

    protected long a(IBlockData state, BlockPosition pos) {
        return MathHelper.a(pos);
    }

    protected VoxelShape d_(IBlockData state) {
        return state.f(BlockAccessAir.a, BlockPosition.c);
    }

    protected VoxelShape b_(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return this.b(state, world, pos, VoxelShapeCollision.a());
    }

    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return VoxelShapes.a();
    }

    protected int i_(IBlockData state) {
        return state.s() ? 15 : (state.f() ? 0 : 1);
    }

    @Nullable
    public ITileInventory b(IBlockData state, World world, BlockPosition pos) {
        return null;
    }

    protected boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        return true;
    }

    protected float c(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return state.m(world, pos) ? 0.2f : 1.0f;
    }

    protected int a(IBlockData state, World world, BlockPosition pos) {
        return 0;
    }

    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return VoxelShapes.b();
    }

    protected VoxelShape b(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.aH ? state.f(world, pos) : VoxelShapes.a();
    }

    protected boolean a_(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return Block.a(state.g(world, pos));
    }

    protected VoxelShape c(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.b(state, world, pos, context);
    }

    protected void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
    }

    protected void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
    }

    protected float a(IBlockData state, EntityHuman player, IBlockAccess world, BlockPosition pos) {
        float f2 = state.e(world, pos);
        if (f2 == -1.0f) {
            return 0.0f;
        }
        int i2 = player.d(state) ? 30 : 100;
        return player.c(state) / f2 / (float)i2;
    }

    protected void a(IBlockData state, WorldServer world, BlockPosition pos, ItemStack tool, boolean dropExperience) {
    }

    protected void a_(IBlockData state, World world, BlockPosition pos, EntityHuman player) {
    }

    protected int a(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return 0;
    }

    protected void a(IBlockData state, World world, BlockPosition pos, Entity entity) {
    }

    protected VoxelShape a_(IBlockData state, World world, BlockPosition pos) {
        return VoxelShapes.b();
    }

    protected int b(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return 0;
    }

    public final Optional<ResourceKey<LootTable>> u() {
        return this.aR;
    }

    public final String v() {
        return this.aS;
    }

    protected void a(World world, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
    }

    protected boolean e_(IBlockData state) {
        return !Block.a(state.f(BlockAccessAir.a, BlockPosition.c)) && state.y().c();
    }

    protected boolean f(IBlockData state) {
        return this.aJ;
    }

    protected SoundEffectType h_(IBlockData state) {
        return this.aK;
    }

    public abstract Item j();

    protected abstract Block o();

    public MaterialMapColor w() {
        return this.aQ.b.apply(this.o().m());
    }

    public float x() {
        return this.aQ.g;
    }

    public static class Info {
        public static final Codec<Info> a = Codec.unit(() -> Info.a());
        Function<IBlockData, MaterialMapColor> b = iblockdata -> MaterialMapColor.a;
        boolean c = true;
        SoundEffectType d = SoundEffectType.f;
        ToIntFunction<IBlockData> e = iblockdata -> 0;
        float f;
        float g;
        boolean h;
        boolean i;
        float j = 0.6f;
        float k = 1.0f;
        float l = 1.0f;
        @Nullable
        private ResourceKey<Block> m;
        private DependantName<Block, Optional<ResourceKey<LootTable>>> n = resourcekey -> Optional.of(ResourceKey.a(Registries.bg, resourcekey.a().f("blocks/")));
        private DependantName<Block, String> o = resourcekey -> SystemUtils.a("block", resourcekey.a());
        boolean p = true;
        boolean q;
        boolean r;
        @Deprecated
        boolean s;
        @Deprecated
        boolean t;
        boolean u;
        EnumPistonReaction v = EnumPistonReaction.a;
        boolean w = true;
        BlockPropertyInstrument x = BlockPropertyInstrument.a;
        boolean y;
        e<EntityTypes<?>> z = (iblockdata, iblockaccess, blockposition, entitytypes) -> iblockdata.c(iblockaccess, blockposition, EnumDirection.b) && iblockdata.k() < 14;
        f A = (iblockdata, iblockaccess, blockposition) -> iblockdata.m(iblockaccess, blockposition);
        f B;
        f C = this.B = (iblockdata, iblockaccess, blockposition) -> iblockdata.d() && iblockdata.m(iblockaccess, blockposition);
        f D = (iblockdata, iblockaccess, blockposition) -> false;
        f E = (iblockdata, iblockaccess, blockposition) -> false;
        boolean F;
        FeatureFlagSet G = FeatureFlags.h;
        @Nullable
        b H;

        private Info() {
        }

        public static Info a() {
            return new Info();
        }

        public static Info a(BlockBase block) {
            Info blockbase_info = Info.b(block);
            Info blockbase_info1 = block.aQ;
            blockbase_info.l = blockbase_info1.l;
            blockbase_info.A = blockbase_info1.A;
            blockbase_info.z = blockbase_info1.z;
            blockbase_info.D = blockbase_info1.D;
            blockbase_info.B = blockbase_info1.B;
            blockbase_info.C = blockbase_info1.C;
            blockbase_info.n = blockbase_info1.n;
            blockbase_info.o = blockbase_info1.o;
            return blockbase_info;
        }

        @Deprecated
        public static Info b(BlockBase block) {
            Info blockbase_info = new Info();
            Info blockbase_info1 = block.aQ;
            blockbase_info.g = blockbase_info1.g;
            blockbase_info.f = blockbase_info1.f;
            blockbase_info.c = blockbase_info1.c;
            blockbase_info.i = blockbase_info1.i;
            blockbase_info.e = blockbase_info1.e;
            blockbase_info.b = blockbase_info1.b;
            blockbase_info.d = blockbase_info1.d;
            blockbase_info.j = blockbase_info1.j;
            blockbase_info.k = blockbase_info1.k;
            blockbase_info.F = blockbase_info1.F;
            blockbase_info.p = blockbase_info1.p;
            blockbase_info.q = blockbase_info1.q;
            blockbase_info.r = blockbase_info1.r;
            blockbase_info.s = blockbase_info1.s;
            blockbase_info.t = blockbase_info1.t;
            blockbase_info.u = blockbase_info1.u;
            blockbase_info.v = blockbase_info1.v;
            blockbase_info.h = blockbase_info1.h;
            blockbase_info.H = blockbase_info1.H;
            blockbase_info.w = blockbase_info1.w;
            blockbase_info.G = blockbase_info1.G;
            blockbase_info.E = blockbase_info1.E;
            blockbase_info.x = blockbase_info1.x;
            blockbase_info.y = blockbase_info1.y;
            return blockbase_info;
        }

        public Info a(EnumColor color) {
            this.b = iblockdata -> color.e();
            return this;
        }

        public Info a(MaterialMapColor color) {
            this.b = iblockdata -> color;
            return this;
        }

        public Info a(Function<IBlockData, MaterialMapColor> mapColorProvider) {
            this.b = mapColorProvider;
            return this;
        }

        public Info b() {
            this.c = false;
            this.p = false;
            return this;
        }

        public Info c() {
            this.p = false;
            return this;
        }

        public Info a(float slipperiness) {
            this.j = slipperiness;
            return this;
        }

        public Info b(float velocityMultiplier) {
            this.k = velocityMultiplier;
            return this;
        }

        public Info c(float jumpVelocityMultiplier) {
            this.l = jumpVelocityMultiplier;
            return this;
        }

        public Info a(SoundEffectType soundGroup) {
            this.d = soundGroup;
            return this;
        }

        public Info a(ToIntFunction<IBlockData> luminance) {
            this.e = luminance;
            return this;
        }

        public Info a(float hardness, float resistance) {
            return this.e(hardness).f(resistance);
        }

        public Info d() {
            return this.d(0.0f);
        }

        public Info d(float strength) {
            this.a(strength, strength);
            return this;
        }

        public Info e() {
            this.i = true;
            return this;
        }

        public Info f() {
            this.F = true;
            return this;
        }

        public Info g() {
            this.n = DependantName.fixed(Optional.empty());
            return this;
        }

        public Info a(Optional<ResourceKey<LootTable>> lootTableKey) {
            this.n = DependantName.fixed(lootTableKey);
            return this;
        }

        protected Optional<ResourceKey<LootTable>> h() {
            return this.n.get(Objects.requireNonNull(this.m, "Block id not set"));
        }

        public Info i() {
            this.r = true;
            return this;
        }

        public Info j() {
            this.s = true;
            return this;
        }

        public Info k() {
            this.u = true;
            return this;
        }

        @Deprecated
        public Info l() {
            this.t = true;
            return this;
        }

        public Info a(EnumPistonReaction pistonBehavior) {
            this.v = pistonBehavior;
            return this;
        }

        public Info m() {
            this.q = true;
            return this;
        }

        public Info a(e<EntityTypes<?>> predicate) {
            this.z = predicate;
            return this;
        }

        public Info a(f predicate) {
            this.A = predicate;
            return this;
        }

        public Info b(f predicate) {
            this.B = predicate;
            return this;
        }

        public Info c(f predicate) {
            this.C = predicate;
            return this;
        }

        public Info d(f predicate) {
            this.D = predicate;
            return this;
        }

        public Info e(f predicate) {
            this.E = predicate;
            return this;
        }

        public Info n() {
            this.h = true;
            return this;
        }

        public Info e(float hardness) {
            this.g = hardness;
            return this;
        }

        public Info f(float resistance) {
            this.f = Math.max(0.0f, resistance);
            return this;
        }

        public Info a(EnumRandomOffset offsetType) {
            this.H = switch (offsetType.ordinal()) {
                case 0 -> null;
                case 1 -> (iblockdata, blockposition) -> {
                    Block block = iblockdata.b();
                    long i2 = MathHelper.b(blockposition.u(), 0, blockposition.w());
                    float f2 = block.as_();
                    double d0 = MathHelper.a(((double)((float)(i2 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                    double d1 = MathHelper.a(((double)((float)(i2 >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                    return new Vec3D(d0, 0.0, d1);
                };
                case 2 -> (iblockdata, blockposition) -> {
                    Block block = iblockdata.b();
                    long i2 = MathHelper.b(blockposition.u(), 0, blockposition.w());
                    double d0 = ((double)((float)(i2 >> 4 & 0xFL) / 15.0f) - 1.0) * (double)block.au_();
                    float f2 = block.as_();
                    double d1 = MathHelper.a(((double)((float)(i2 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                    double d2 = MathHelper.a(((double)((float)(i2 >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                    return new Vec3D(d1, d0, d2);
                };
                default -> throw new MatchException(null, null);
            };
            return this;
        }

        public Info o() {
            this.w = false;
            return this;
        }

        public Info a(FeatureFlag ... features) {
            this.G = FeatureFlags.f.a(features);
            return this;
        }

        public Info a(BlockPropertyInstrument instrument) {
            this.x = instrument;
            return this;
        }

        public Info p() {
            this.y = true;
            return this;
        }

        public Info a(ResourceKey<Block> registryKey) {
            this.m = registryKey;
            return this;
        }

        public Info a(String translationKey) {
            this.o = DependantName.fixed(translationKey);
            return this;
        }

        protected String q() {
            return this.o.get(Objects.requireNonNull(this.m, "Block id not set"));
        }
    }

    public static enum EnumRandomOffset {
        a,
        b,
        c;

    }

    public static abstract class BlockData
    extends IBlockDataHolder<Block, IBlockData>
    implements StarlightAbstractBlockState,
    CollisionBlockState {
        private static final EnumDirection[] a = EnumDirection.values();
        private static final VoxelShape[] f = SystemUtils.a(new VoxelShape[a.length], (? super T avoxelshape) -> Arrays.fill(avoxelshape, VoxelShapes.a()));
        private static final VoxelShape[] g = SystemUtils.a(new VoxelShape[a.length], (? super T avoxelshape) -> Arrays.fill(avoxelshape, VoxelShapes.b()));
        private final int h;
        private final boolean i;
        private final boolean j;
        private final boolean k;
        @Deprecated
        private final boolean l;
        @Deprecated
        private boolean m;
        private final EnumPistonReaction n;
        private final MaterialMapColor o;
        public final float p;
        private final boolean q;
        private final boolean r;
        private final f s;
        private final f t;
        private final f u;
        private final f v;
        private final f w;
        @Nullable
        private final b x;
        private final boolean y;
        private final BlockPropertyInstrument z;
        private final boolean A;
        @Nullable
        private Cache B;
        private Fluid C;
        private boolean D;
        private boolean E;
        private VoxelShape F;
        private VoxelShape[] G;
        private boolean H;
        private int I;
        private boolean isConditionallyFullOpaque;
        private static final int RANDOM_OFFSET = 704237939;
        private static final EnumDirection[] DIRECTIONS_CACHED = EnumDirection.values();
        private static final AtomicInteger ID_GENERATOR = new AtomicInteger();
        private final int id1 = HashCommon.murmurHash3((int)(HashCommon.murmurHash3((int)(ID_GENERATOR.getAndIncrement() + 704237939)) + 704237939));
        private final int id2 = HashCommon.murmurHash3((int)(HashCommon.murmurHash3((int)(ID_GENERATOR.getAndIncrement() + 704237939)) + 704237939));
        private boolean occludesFullBlock;
        private boolean emptyCollisionShape;
        private boolean emptyConstantCollisionShape;
        private VoxelShape constantCollisionShape;
        private CraftBlockData cachedCraftBlockData;
        protected boolean shapeExceedsCube = true;

        @Override
        public final boolean starlight$isConditionallyFullOpaque() {
            return this.isConditionallyFullOpaque;
        }

        private static void initCaches(VoxelShape shape, boolean neighbours) {
            shape.moonrise$isFullBlock();
            shape.moonrise$occludesFullBlock();
            shape.e();
            if (!shape.c()) {
                shape.a();
            }
            if (neighbours) {
                for (EnumDirection direction : DIRECTIONS_CACHED) {
                    BlockData.initCaches(shape.moonrise$getFaceShapeClamped(direction), false);
                    BlockData.initCaches(shape.a(direction), false);
                }
            }
        }

        @Override
        public final boolean moonrise$hasCache() {
            return this.B != null;
        }

        @Override
        public final boolean moonrise$occludesFullBlock() {
            return this.occludesFullBlock;
        }

        @Override
        public final boolean moonrise$emptyCollisionShape() {
            return this.emptyCollisionShape;
        }

        @Override
        public final boolean moonrise$emptyContextCollisionShape() {
            return this.emptyConstantCollisionShape;
        }

        @Override
        public final int moonrise$uniqueId1() {
            return this.id1;
        }

        @Override
        public final int moonrise$uniqueId2() {
            return this.id2;
        }

        @Override
        public final VoxelShape moonrise$getConstantContextCollisionShape() {
            return this.constantCollisionShape;
        }

        protected BlockData(Block block, Reference2ObjectArrayMap<IBlockState<?>, Comparable<?>> propertyMap, MapCodec<IBlockData> codec) {
            super(block, propertyMap, codec);
            this.C = FluidTypes.a.g();
            Info blockbase_info = block.aQ;
            this.h = blockbase_info.e.applyAsInt(this.B());
            this.i = block.g_(this.B());
            this.j = blockbase_info.q;
            this.k = blockbase_info.r;
            this.l = blockbase_info.s;
            this.n = blockbase_info.v;
            this.o = blockbase_info.b.apply(this.B());
            this.p = blockbase_info.g;
            this.q = blockbase_info.h;
            this.r = blockbase_info.p;
            this.s = blockbase_info.A;
            this.t = blockbase_info.B;
            this.u = blockbase_info.C;
            this.v = blockbase_info.D;
            this.w = blockbase_info.E;
            this.x = blockbase_info.H;
            this.y = blockbase_info.w;
            this.z = blockbase_info.x;
            this.A = blockbase_info.y;
        }

        public CraftBlockData createCraftBlockData() {
            if (this.cachedCraftBlockData == null) {
                this.cachedCraftBlockData = CraftBlockData.createData(this.B());
            }
            return (CraftBlockData)this.cachedCraftBlockData.clone();
        }

        private boolean H() {
            if (((Block)this.d).aQ.u) {
                return true;
            }
            if (((Block)this.d).aQ.t) {
                return false;
            }
            if (this.B == null) {
                return false;
            }
            VoxelShape voxelshape = this.B.a;
            if (voxelshape.c()) {
                return false;
            }
            AxisAlignedBB axisalignedbb = voxelshape.a();
            return axisalignedbb.a() >= 0.7291666666666666 ? true : axisalignedbb.c() >= 1.0;
        }

        public void a() {
            this.C = ((Block)this.d).b_(this.B());
            this.D = ((Block)this.d).f(this.B());
            if (!this.b().n()) {
                this.B = new Cache(this.B());
            }
            this.shapeExceedsCube = this.B == null || this.B.b;
            this.m = this.H();
            this.F = this.r ? ((Block)this.d).d_(this.B()) : VoxelShapes.a();
            this.E = Block.a(this.F);
            if (this.F.c()) {
                this.G = f;
            } else if (this.E) {
                this.G = g;
            } else {
                this.G = new VoxelShape[a.length];
                for (EnumDirection enumdirection : a) {
                    this.G[enumdirection.ordinal()] = this.F.a(enumdirection);
                }
            }
            this.H = ((Block)this.d).e_(this.B());
            this.I = ((Block)this.d).i_(this.B());
            this.isConditionallyFullOpaque = this.r & this.i;
            if (this.B != null) {
                VoxelShape collisionShape = this.B.a;
                this.constantCollisionShape = this.l() ? VoxelShapes.a() : null;
                this.occludesFullBlock = collisionShape.moonrise$occludesFullBlock();
                this.emptyCollisionShape = collisionShape.c();
                this.emptyConstantCollisionShape = this.constantCollisionShape != null && this.constantCollisionShape.c();
                BlockData.initCaches(collisionShape, true);
                if (this.constantCollisionShape != null) {
                    BlockData.initCaches(this.constantCollisionShape, true);
                }
            } else {
                this.occludesFullBlock = false;
                this.emptyCollisionShape = false;
                this.emptyConstantCollisionShape = false;
                this.constantCollisionShape = null;
            }
            if (this.F != null) {
                BlockData.initCaches(this.F, true);
            }
            if (this.G != null) {
                for (VoxelShape shape : this.G) {
                    BlockData.initCaches(shape, true);
                }
            }
        }

        public Block b() {
            return (Block)this.d;
        }

        public Holder<Block> c() {
            return ((Block)this.d).p();
        }

        @Deprecated
        public boolean d() {
            Block block = this.b();
            return block != Blocks.bz && block != Blocks.nt && this.e();
        }

        @Deprecated
        public boolean e() {
            return this.m;
        }

        public final boolean isDestroyable() {
            return this.b().isDestroyable();
        }

        public boolean a(IBlockAccess world, BlockPosition pos, EntityTypes<?> type) {
            return this.b().aQ.z.test(this.B(), world, pos, type);
        }

        public boolean f() {
            return this.H;
        }

        public int g() {
            return this.I;
        }

        public VoxelShape a(EnumDirection direction) {
            return this.G[direction.ordinal()];
        }

        public VoxelShape h() {
            return this.F;
        }

        public final boolean i() {
            return this.shapeExceedsCube;
        }

        public final boolean j() {
            return this.i;
        }

        public final int k() {
            return this.h;
        }

        public final boolean l() {
            return this.j;
        }

        public boolean m() {
            return this.k;
        }

        @Deprecated
        public boolean n() {
            return this.l;
        }

        public MaterialMapColor a(IBlockAccess world, BlockPosition pos) {
            return this.o;
        }

        public IBlockData a(EnumBlockRotation rotation) {
            return this.b().a(this.B(), rotation);
        }

        public IBlockData a(EnumBlockMirror mirror) {
            return this.b().a(this.B(), mirror);
        }

        public EnumRenderType o() {
            return this.b().a_(this.B());
        }

        public boolean b(IBlockAccess world, BlockPosition pos) {
            return this.w.test(this.B(), world, pos);
        }

        public float c(IBlockAccess world, BlockPosition pos) {
            return this.b().c(this.B(), world, pos);
        }

        public boolean d(IBlockAccess world, BlockPosition pos) {
            return this.s.test(this.B(), world, pos);
        }

        public boolean p() {
            return this.b().f_(this.B());
        }

        public int a(IBlockAccess world, BlockPosition pos, EnumDirection direction) {
            return this.b().a(this.B(), world, pos, direction);
        }

        public boolean q() {
            return this.b().c_(this.B());
        }

        public int a(World world, BlockPosition pos) {
            return this.b().a(this.B(), world, pos);
        }

        public float e(IBlockAccess world, BlockPosition pos) {
            return this.p;
        }

        public float a(EntityHuman player, IBlockAccess world, BlockPosition pos) {
            return this.b().a(this.B(), player, world, pos);
        }

        public int b(IBlockAccess world, BlockPosition pos, EnumDirection direction) {
            return this.b().b(this.B(), world, pos, direction);
        }

        public EnumPistonReaction r() {
            return !this.isDestroyable() ? EnumPistonReaction.c : this.n;
        }

        public boolean s() {
            return this.E;
        }

        public final boolean t() {
            return this.r;
        }

        public boolean a(IBlockData state, EnumDirection direction) {
            return this.b().b(this.B(), state, direction);
        }

        public VoxelShape f(IBlockAccess world, BlockPosition pos) {
            return this.a(world, pos, VoxelShapeCollision.a());
        }

        public VoxelShape a(IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
            return this.b().a(this.B(), world, pos, context);
        }

        public VoxelShape g(IBlockAccess world, BlockPosition pos) {
            return this.B != null ? this.B.a : this.b(world, pos, VoxelShapeCollision.a());
        }

        public VoxelShape b(IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
            return this.b().b(this.B(), world, pos, context);
        }

        public VoxelShape h(IBlockAccess world, BlockPosition pos) {
            return this.b().b_(this.B(), world, pos);
        }

        public VoxelShape c(IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
            return this.b().c(this.B(), world, pos, context);
        }

        public VoxelShape i(IBlockAccess world, BlockPosition pos) {
            return this.b().a(this.B(), world, pos);
        }

        public final boolean a(IBlockAccess world, BlockPosition pos, Entity entity) {
            return this.a(world, pos, entity, EnumDirection.b);
        }

        public final boolean a(IBlockAccess world, BlockPosition pos, Entity entity, EnumDirection direction) {
            return Block.a(this.b(world, pos, VoxelShapeCollision.a(entity)), direction);
        }

        public Vec3D a(BlockPosition pos) {
            b blockbase_b = this.x;
            return blockbase_b != null ? blockbase_b.evaluate(this.B(), pos) : Vec3D.c;
        }

        public boolean u() {
            return this.x != null;
        }

        public boolean a(World world, BlockPosition pos, int type, int data) {
            return this.b().a(this.B(), world, pos, type, data);
        }

        public void a(World world, BlockPosition pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
            PacketDebug.a(world, pos);
            this.b().a(this.B(), world, pos, sourceBlock, wireOrientation, notify);
        }

        public final void a(GeneratorAccess world, BlockPosition pos, int flags) {
            this.a(world, pos, flags, 512);
        }

        public final void a(GeneratorAccess world, BlockPosition pos, int flags, int maxUpdateDepth) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (EnumDirection enumdirection : aG) {
                blockposition_mutableblockposition.a((BaseBlockPosition)pos, enumdirection);
                world.a(enumdirection.g(), (BlockPosition)blockposition_mutableblockposition, pos, this.B(), flags, maxUpdateDepth);
            }
        }

        public final void b(GeneratorAccess world, BlockPosition pos, int flags) {
            this.b(world, pos, flags, 512);
        }

        public void b(GeneratorAccess world, BlockPosition pos, int flags, int maxUpdateDepth) {
            this.b().a(this.B(), world, pos, flags, maxUpdateDepth);
        }

        public void a(World world, BlockPosition pos, IBlockData state, boolean notify) {
            this.onPlace(world, pos, state, notify, null);
        }

        public void onPlace(World world, BlockPosition blockposition, IBlockData iblockdata, boolean flag, @Nullable ItemActionContext context) {
            this.b().onPlace(this.B(), world, blockposition, iblockdata, flag, context);
        }

        public void b(World world, BlockPosition pos, IBlockData state, boolean moved) {
            this.b().a(this.B(), world, pos, state, moved);
        }

        public void a(WorldServer world, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> stackMerger) {
            this.b().a(this.B(), world, pos, explosion, stackMerger);
        }

        public void a(WorldServer world, BlockPosition pos, RandomSource random) {
            this.b().a(this.B(), world, pos, random);
        }

        public void b(WorldServer world, BlockPosition pos, RandomSource random) {
            this.b().b(this.B(), world, pos, random);
        }

        public void a(World world, BlockPosition pos, Entity entity) {
            this.b().a(this.B(), world, pos, entity);
        }

        public VoxelShape b(World world, BlockPosition pos) {
            return this.b().a_(this.B(), world, pos);
        }

        public void a(WorldServer world, BlockPosition pos, ItemStack tool, boolean dropExperience) {
            this.b().a(this.B(), world, pos, tool, dropExperience);
            if (dropExperience) {
                this.b().a(world, pos, this.b().getExpDrop(this.B(), world, pos, tool, true));
            }
        }

        public List<ItemStack> a(LootParams.a builder) {
            return this.b().a(this.B(), builder);
        }

        public EnumInteractionResult a(ItemStack stack, World world, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
            return this.b().a(stack, this.B(), world, hit.b(), player, hand, hit);
        }

        public EnumInteractionResult a(World world, EntityHuman player, MovingObjectPositionBlock hit) {
            return this.b().a(this.B(), world, hit.b(), player, hit);
        }

        public void a(World world, BlockPosition pos, EntityHuman player) {
            this.b().a_(this.B(), world, pos, player);
        }

        public boolean j(IBlockAccess world, BlockPosition pos) {
            return this.t.test(this.B(), world, pos);
        }

        public boolean k(IBlockAccess world, BlockPosition pos) {
            return this.u.test(this.B(), world, pos);
        }

        public IBlockData a(IWorldReader world, ScheduledTickAccess tickView, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
            return this.b().a(this.B(), world, tickView, pos, direction, neighborPos, neighborState, random);
        }

        public boolean a(PathMode type) {
            return this.b().a(this.B(), type);
        }

        public boolean a(BlockActionContext context) {
            return this.b().a(this.B(), context);
        }

        public boolean a(FluidType fluid) {
            return this.b().a(this.B(), fluid);
        }

        public boolean v() {
            return this.A;
        }

        public boolean a(IWorldReader world, BlockPosition pos) {
            return this.b().a(this.B(), world, pos);
        }

        public boolean l(IBlockAccess world, BlockPosition pos) {
            return this.v.test(this.B(), world, pos);
        }

        @Nullable
        public ITileInventory c(World world, BlockPosition pos) {
            return this.b().b(this.B(), world, pos);
        }

        @Override
        public boolean a(TagKey<Block> tag) {
            return this.b().p().a(tag);
        }

        @Override
        public boolean a(TagKey<Block> tag, Predicate<BlockData> predicate) {
            return this.a(tag) && predicate.test(this);
        }

        @Override
        public boolean a(HolderSet<Block> blocks) {
            return blocks.a(this.b().p());
        }

        @Override
        public boolean a(Holder<Block> blockEntry) {
            return this.a(blockEntry.a());
        }

        public Stream<TagKey<Block>> w() {
            return this.b().p().c();
        }

        public boolean x() {
            return this.b() instanceof ITileEntity;
        }

        @Nullable
        public <T extends TileEntity> BlockEntityTicker<T> a(World world, TileEntityTypes<T> blockEntityType) {
            return this.b() instanceof ITileEntity ? ((ITileEntity)((Object)this.b())).a(world, this.B(), blockEntityType) : null;
        }

        public boolean a(Block block) {
            return this.b() == block;
        }

        @Override
        public boolean a(ResourceKey<Block> key) {
            return this.b().p().a(key);
        }

        public final Fluid y() {
            return this.C;
        }

        public final boolean z() {
            return this.D;
        }

        public long b(BlockPosition pos) {
            return this.b().a(this.B(), pos);
        }

        public SoundEffectType A() {
            return this.b().h_(this.B());
        }

        public void a(World world, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
            this.b().a(world, state, hit, projectile);
        }

        public boolean c(IBlockAccess world, BlockPosition pos, EnumDirection direction) {
            return this.a(world, pos, direction, EnumBlockSupport.a);
        }

        public boolean a(IBlockAccess world, BlockPosition pos, EnumDirection direction, EnumBlockSupport shapeType) {
            return this.B != null ? this.B.a(direction, shapeType) : shapeType.a(this.B(), world, pos, direction);
        }

        public boolean m(IBlockAccess world, BlockPosition pos) {
            return this.B != null ? this.B.c : this.b().a_(this.B(), world, pos);
        }

        protected abstract IBlockData B();

        public boolean C() {
            return this.q;
        }

        public boolean D() {
            return this.y;
        }

        public BlockPropertyInstrument E() {
            return this.z;
        }

        private static final class Cache {
            private static final EnumDirection[] d = EnumDirection.values();
            private static final int e = EnumBlockSupport.values().length;
            protected final VoxelShape a;
            protected final boolean b;
            private final boolean[] f;
            protected final boolean c;

            Cache(IBlockData state) {
                Block block = state.b();
                this.a = block.b(state, (IBlockAccess)BlockAccessAir.a, BlockPosition.c, VoxelShapeCollision.a());
                if (!this.a.c() && state.u()) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "%s has a collision shape and an offset type, but is not marked as dynamicShape in its properties.", BuiltInRegistries.e.b(block)));
                }
                this.b = Arrays.stream(EnumDirection.EnumAxis.values()).anyMatch(enumdirection_enumaxis -> this.a.b((EnumDirection.EnumAxis)enumdirection_enumaxis) < 0.0 || this.a.c((EnumDirection.EnumAxis)enumdirection_enumaxis) > 1.0);
                this.f = new boolean[d.length * e];
                for (EnumDirection enumdirection : d) {
                    for (EnumBlockSupport enumblocksupport : EnumBlockSupport.values()) {
                        this.f[Cache.b((EnumDirection)enumdirection, (EnumBlockSupport)enumblocksupport)] = enumblocksupport.a(state, BlockAccessAir.a, BlockPosition.c, enumdirection);
                    }
                }
                this.c = Block.a(state.g(BlockAccessAir.a, BlockPosition.c));
            }

            public boolean a(EnumDirection direction, EnumBlockSupport shapeType) {
                return this.f[Cache.b(direction, shapeType)];
            }

            private static int b(EnumDirection direction, EnumBlockSupport shapeType) {
                return direction.ordinal() * e + shapeType.ordinal();
            }
        }
    }

    @FunctionalInterface
    public static interface f {
        public boolean test(IBlockData var1, IBlockAccess var2, BlockPosition var3);
    }

    @FunctionalInterface
    public static interface b {
        public Vec3D evaluate(IBlockData var1, BlockPosition var2);
    }

    @FunctionalInterface
    public static interface e<A> {
        public boolean test(IBlockData var1, IBlockAccess var2, BlockPosition var3, A var4);
    }
}

