/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.PropertyAccessStateHolder;
import ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.util.ZeroCollidingReferenceStateTable;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.properties.IBlockState;

public abstract class IBlockDataHolder<O, S>
implements PropertyAccessStateHolder {
    public static final String b = "Name";
    public static final String c = "Properties";
    public static final Function<Map.Entry<IBlockState<?>, Comparable<?>>, String> a = new Function<Map.Entry<IBlockState<?>, Comparable<?>>, String>(){

        public String a(@Nullable Map.Entry<IBlockState<?>, Comparable<?>> entry) {
            if (entry == null) {
                return "<NULL>";
            }
            IBlockState<?> property = entry.getKey();
            return property.f() + "=" + this.a(property, entry.getValue());
        }

        private <T extends Comparable<T>> String a(IBlockState<T> property, Comparable<?> value) {
            return property.b(value);
        }
    };
    protected final O d;
    private Reference2ObjectArrayMap<IBlockState<?>, Comparable<?>> f;
    private Map<IBlockState<?>, S[]> g;
    protected final MapCodec<S> e;
    protected ZeroCollidingReferenceStateTable<O, S> optimisedTable;
    protected final long tableIndex;

    @Override
    public final long moonrise$getTableIndex() {
        return this.tableIndex;
    }

    protected IBlockDataHolder(O owner, Reference2ObjectArrayMap<IBlockState<?>, Comparable<?>> propertyMap, MapCodec<S> codec) {
        this.d = owner;
        this.f = propertyMap;
        this.e = codec;
        this.optimisedTable = new ZeroCollidingReferenceStateTable((Collection<IBlockState<?>>)this.f.keySet());
        this.tableIndex = this.optimisedTable.getIndex(this);
    }

    public <T extends Comparable<T>> S a(IBlockState<T> property) {
        return this.b(property, (Comparable)IBlockDataHolder.a(property.a(), this.c(property)));
    }

    protected static <T> T a(List<T> values, T value) {
        int i2 = values.indexOf(value) + 1;
        return i2 == values.size() ? values.getFirst() : values.get(i2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.d);
        if (!this.G().isEmpty()) {
            stringBuilder.append('[');
            stringBuilder.append(this.G().entrySet().stream().map(a).collect(Collectors.joining(",")));
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    public Collection<IBlockState<?>> F() {
        return this.optimisedTable.getProperties();
    }

    public <T extends Comparable<T>> boolean b(IBlockState<T> property) {
        return property != null && this.optimisedTable.hasProperty(property);
    }

    public <T extends Comparable<T>> T c(IBlockState<T> property) {
        T ret = this.optimisedTable.get(this.tableIndex, property);
        if (ret != null) {
            return ret;
        }
        throw new IllegalArgumentException("Cannot get property " + String.valueOf(property) + " as it does not exist in " + String.valueOf(this.d));
    }

    public <T extends Comparable<T>> Optional<T> d(IBlockState<T> property) {
        return Optional.ofNullable(this.e(property));
    }

    public <T extends Comparable<T>> T a(IBlockState<T> property, T fallback) {
        return (T)((Comparable)Objects.requireNonNullElse(this.e(property), fallback));
    }

    @Nullable
    public <T extends Comparable<T>> T e(IBlockState<T> property) {
        return property == null ? null : (T)this.optimisedTable.get(this.tableIndex, property);
    }

    public <T extends Comparable<T>, V extends T> S b(IBlockState<T> property, V value) {
        S ret = this.optimisedTable.set(this.tableIndex, property, value);
        if (ret != null) {
            return ret;
        }
        throw new IllegalArgumentException("Cannot set property " + String.valueOf(property) + " to " + String.valueOf(value) + " on " + String.valueOf(this.d));
    }

    public <T extends Comparable<T>, V extends T> S c(IBlockState<T> property, V value) {
        if (property == null) {
            return (S)this;
        }
        IBlockDataHolder ret = this.optimisedTable.trySet(this.tableIndex, property, value, this);
        if (ret != null) {
            return (S)ret;
        }
        throw new IllegalArgumentException("Cannot set property " + String.valueOf(property) + " to " + String.valueOf(value) + " on " + String.valueOf(this.d));
    }

    private <T extends Comparable<T>, V extends T> S a(IBlockState<T> property, V newValue, Comparable<?> oldValue) {
        if (oldValue.equals(newValue)) {
            return (S)this;
        }
        int i2 = property.a(newValue);
        if (i2 < 0) {
            throw new IllegalArgumentException("Cannot set property " + String.valueOf(property) + " to " + String.valueOf(newValue) + " on " + String.valueOf(this.d) + ", it is not an allowed value");
        }
        return this.g.get(property)[i2];
    }

    public void a(Map<Map<IBlockState<?>, Comparable<?>>, S> states) {
        S value;
        Map<Map<IBlockState<?>, Comparable<?>>, S> map = states;
        if (this.optimisedTable.isLoaded()) {
            return;
        }
        this.optimisedTable.loadInTable(map);
        for (Map.Entry<Map<IBlockState<?>, Comparable<?>>, S> entry : map.entrySet()) {
            value = entry.getValue();
            ((IBlockDataHolder)value).optimisedTable = this.optimisedTable;
        }
        for (Map.Entry<Map<IBlockState<?>, Comparable<?>>, S> entry : map.entrySet()) {
            value = entry.getValue();
            ((IBlockDataHolder)value).f = null;
        }
    }

    private Map<IBlockState<?>, Comparable<?>> d(IBlockState<?> property, Comparable<?> value) {
        Reference2ObjectArrayMap map = new Reference2ObjectArrayMap(this.f);
        map.put(property, value);
        return map;
    }

    public Map<IBlockState<?>, Comparable<?>> G() {
        ZeroCollidingReferenceStateTable<O, S> table = this.optimisedTable;
        return table.isLoaded() ? table.getMapView(this.tableIndex) : this.f;
    }

    protected static <O, S extends IBlockDataHolder<O, S>> Codec<S> a(Codec<O> codec, Function<O, S> ownerToStateFunction) {
        return codec.dispatch(b, state -> state.d, owner -> {
            IBlockDataHolder stateHolder = (IBlockDataHolder)ownerToStateFunction.apply(owner);
            return stateHolder.G().isEmpty() ? MapCodec.unit((Object)stateHolder) : stateHolder.e.codec().lenientOptionalFieldOf(c).xmap(state -> state.orElse(stateHolder), Optional::of);
        });
    }
}

