/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.PropertyAccess;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.INamable;
import net.minecraft.world.level.block.state.properties.IBlockState;

public final class BlockStateEnum<T extends Enum<T>>
extends IBlockState<T>
implements PropertyAccess<T> {
    private final List<T> a;
    private final Map<String, T> b;
    private final int[] c;
    private int[] idLookupTable;

    @Override
    public final int moonrise$getIdFor(T value) {
        Class target = this.g();
        return value.getClass() != target && ((Enum)value).getDeclaringClass() != target ? -1 : this.idLookupTable[((Enum)value).ordinal()];
    }

    private void init() {
        List<T> values = this.a();
        Class clazz = this.g();
        int id = 0;
        this.idLookupTable = new int[((Enum[])clazz.getEnumConstants()).length];
        Arrays.fill(this.idLookupTable, -1);
        Enum[] byId = (Enum[])Array.newInstance(clazz, values.size());
        for (Enum value : values) {
            int valueId;
            this.idLookupTable[value.ordinal()] = valueId = id++;
            byId[valueId] = value;
        }
        this.moonrise$setById((Comparable[])byId);
    }

    private BlockStateEnum(String name, Class<T> type, List<T> values) {
        super(name, type);
        if (values.isEmpty()) {
            throw new IllegalArgumentException("Trying to make empty EnumProperty '" + name + "'");
        }
        this.a = List.copyOf(values);
        Enum[] enums = (Enum[])type.getEnumConstants();
        this.c = new int[enums.length];
        for (Enum enum_ : enums) {
            this.c[enum_.ordinal()] = values.indexOf(enum_);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Enum enum2 : values) {
            String string = ((INamable)((Object)enum2)).c();
            builder.put((Object)string, (Object)enum2);
        }
        this.b = builder.buildOrThrow();
        this.init();
    }

    @Override
    public List<T> a() {
        return this.a;
    }

    @Override
    public Optional<T> b(String name) {
        return Optional.ofNullable((Enum)this.b.get(name));
    }

    public String a(T enum_) {
        return ((INamable)enum_).c();
    }

    public int b(T enum_) {
        return this.c[((Enum)enum_).ordinal()];
    }

    public boolean equals_unused(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BlockStateEnum) {
            BlockStateEnum enumProperty = (BlockStateEnum)object;
            if (super.equals(object)) {
                return this.a.equals(enumProperty.a);
            }
        }
        return false;
    }

    @Override
    public int b() {
        int i2 = super.b();
        return 31 * i2 + this.a.hashCode();
    }

    public static <T extends Enum<T>> BlockStateEnum<T> a(String name, Class<T> type) {
        return BlockStateEnum.a(name, type, (T enum_) -> true);
    }

    public static <T extends Enum<T>> BlockStateEnum<T> a(String name, Class<T> type, Predicate<T> filter) {
        return BlockStateEnum.a(name, type, Arrays.stream((Enum[])type.getEnumConstants()).filter(filter).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T extends Enum<T>> BlockStateEnum<T> a(String name, Class<T> type, T ... values) {
        return BlockStateEnum.a(name, type, List.of(values));
    }

    public static <T extends Enum<T>> BlockStateEnum<T> a(String name, Class<T> type, List<T> values) {
        return new BlockStateEnum<T>(name, type, values);
    }
}

