/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemLevelChunk;
import ca.spottedleaf.moonrise.patches.getblock.GetBlockChunk;
import ca.spottedleaf.moonrise.patches.starlight.chunk.StarlightChunk;
import com.destroystokyo.paper.event.server.ServerExceptionEvent;
import com.destroystokyo.paper.exception.ServerException;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkEmpty;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.EuclideanGameEventListenerRegistry;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.TickContainerAccess;
import org.bukkit.craftbukkit.v1_21_R2.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R2.CraftServer;
import org.bukkit.craftbukkit.v1_21_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkPopulateEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.generator.BlockPopulator;
import org.slf4j.Logger;

public class Chunk
extends IChunkAccess
implements ChunkSystemLevelChunk,
StarlightChunk,
GetBlockChunk {
    static final Logger n = LogUtils.getLogger();
    private static final TickingBlockEntity o = new TickingBlockEntity(){

        @Override
        public void a() {
        }

        @Override
        public boolean b() {
            return true;
        }

        @Override
        public BlockPosition c() {
            return BlockPosition.c;
        }

        @Override
        public String d() {
            return "<null>";
        }
    };
    private final Map<BlockPosition, d> p = Maps.newHashMap();
    public boolean q;
    public final WorldServer r;
    @Nullable
    private Supplier<FullChunkStatus> s;
    @Nullable
    private c t;
    private final Int2ObjectMap<GameEventListenerRegistry> u;
    private final LevelChunkTicks<Block> v;
    private final LevelChunkTicks<FluidType> w;
    private e x = chunkcoordintpair1 -> {};
    public boolean mustNotSave;
    public boolean needsDecoration;
    boolean loadedTicketLevel;
    private boolean postProcessingDone;
    private ChunkProviderServer.a chunkAndHolder;
    private static final IBlockData AIR_BLOCKSTATE = Blocks.a.m();
    private static final Fluid AIR_FLUIDSTATE = FluidTypes.a.g();
    private static final IBlockData VOID_AIR_BLOCKSTATE = Blocks.nw.m();
    private final int minSection;
    private final int maxSection;
    private final boolean debug;
    private final IBlockData defaultBlockState;

    public Chunk(World world, ChunkCoordIntPair pos) {
        this(world, pos, ChunkConverter.a, new LevelChunkTicks<Block>(), new LevelChunkTicks<FluidType>(), 0L, null, null, null);
    }

    public Chunk(World world, ChunkCoordIntPair pos, ChunkConverter upgradeData, LevelChunkTicks<Block> blockTickScheduler, LevelChunkTicks<FluidType> fluidTickScheduler, long inhabitedTime, @Nullable ChunkSection[] sectionArrayInitializer, @Nullable c entityLoader, @Nullable BlendingData blendingData) {
        super(pos, upgradeData, world, MinecraftServer.getServer().ba().e(Registries.aI), inhabitedTime, sectionArrayInitializer, blendingData);
        this.r = (WorldServer)world;
        this.u = new Int2ObjectOpenHashMap();
        for (HeightMap.Type heightmap_type : HeightMap.Type.values()) {
            if (!ChunkStatus.n.e().contains(heightmap_type)) continue;
            this.h.put(heightmap_type, new HeightMap(this, heightmap_type));
        }
        this.t = entityLoader;
        this.v = blockTickScheduler;
        this.w = fluidTickScheduler;
        this.minSection = WorldUtil.getMinSection(this.r);
        this.maxSection = WorldUtil.getMaxSection(this.r);
        boolean empty = this instanceof ChunkEmpty;
        this.debug = !empty && this.r.ai();
        this.defaultBlockState = empty ? VOID_AIR_BLOCKSTATE : AIR_BLOCKSTATE;
    }

    @Override
    public final boolean moonrise$isPostProcessingDone() {
        return this.postProcessingDone;
    }

    @Override
    public final ChunkProviderServer.a moonrise$getChunkAndHolder() {
        return this.chunkAndHolder;
    }

    @Override
    public final void moonrise$setChunkAndHolder(ChunkProviderServer.a holder) {
        this.chunkAndHolder = holder;
    }

    @Override
    public final IBlockData moonrise$getBlock(int x2, int y2, int z2) {
        return this.getBlockStateFinal(x2, y2, z2);
    }

    /*
     * WARNING - void declaration
     */
    public Chunk(WorldServer world, ProtoChunk protoChunk, @Nullable c entityLoader) {
        this(world, protoChunk.f(), protoChunk.t(), protoChunk.K(), protoChunk.L(), protoChunk.w(), protoChunk.d(), entityLoader, protoChunk.v());
        void var5_7;
        for (TileEntity tileEntity : protoChunk.H().values()) {
            this.a(tileEntity);
        }
        this.j.putAll(protoChunk.J());
        boolean bl = false;
        while (var5_7 < protoChunk.p().length) {
            this.b[var5_7] = protoChunk.p()[var5_7];
            ++var5_7;
        }
        this.a(protoChunk.g());
        this.b(protoChunk.h());
        for (Map.Entry entry : protoChunk.e()) {
            if (!ChunkStatus.n.e().contains(entry.getKey())) continue;
            this.a((HeightMap.Type)entry.getKey(), ((HeightMap)entry.getValue()).a());
        }
        this.a(protoChunk.x());
        this.i();
        this.needsDecoration = true;
        this.persistentDataContainer = protoChunk.persistentDataContainer;
        this.starlight$setBlockNibbles(protoChunk.starlight$getBlockNibbles());
        this.starlight$setSkyNibbles(protoChunk.starlight$getSkyNibbles());
        this.starlight$setSkyEmptinessMap(protoChunk.starlight$getSkyEmptinessMap());
        this.starlight$setBlockEmptinessMap(protoChunk.starlight$getBlockEmptinessMap());
    }

    public void a(e unsavedListener) {
        this.x = unsavedListener;
        if (this.k()) {
            unsavedListener.setUnsaved(this.c);
        }
    }

    @Override
    public void i() {
        boolean flag = this.k();
        super.i();
        if (!flag) {
            this.x.setUnsaved(this.c);
        }
    }

    @Override
    public TickContainerAccess<Block> q() {
        return this.v;
    }

    @Override
    public TickContainerAccess<FluidType> r() {
        return this.w;
    }

    @Override
    public IChunkAccess.a a(long time) {
        return new IChunkAccess.a(this.v.a(time), this.w.a(time));
    }

    @Override
    public long w() {
        return this.r.paperConfig().chunks.fixedChunkInhabitedTime < 0 ? super.w() : (long)this.r.paperConfig().chunks.fixedChunkInhabitedTime;
    }

    @Override
    public GameEventListenerRegistry a(int ySectionCoord) {
        WorldServer world = this.r;
        if (world instanceof WorldServer) {
            WorldServer worldserver = world;
            return (GameEventListenerRegistry)this.u.computeIfAbsent(ySectionCoord, j2 -> new EuclideanGameEventListenerRegistry(worldserver, ySectionCoord, this::i));
        }
        return super.a(ySectionCoord);
    }

    @Override
    public IBlockData getBlockState(int x2, int y2, int z2) {
        return this.getBlockStateFinal(x2, y2, z2);
    }

    public IBlockData getBlockStateFinal(int x2, int y2, int z2) {
        int sectionIndex = this.f(y2);
        if (sectionIndex < 0 || sectionIndex >= this.m.length || this.m[sectionIndex].e == 0) {
            return Blocks.a.m();
        }
        return this.m[sectionIndex].h.a((y2 & 0xF) << 8 | (z2 & 0xF) << 4 | x2 & 0xF);
    }

    @Override
    public IBlockData a_(BlockPosition pos) {
        return this.getBlockStateFinal(pos.u(), pos.v(), pos.w());
    }

    @Override
    public final Fluid getFluidIfLoaded(BlockPosition blockposition) {
        return this.b_(blockposition);
    }

    @Override
    public final IBlockData getBlockStateIfLoaded(BlockPosition blockposition) {
        return this.a_(blockposition);
    }

    @Override
    public Fluid b_(BlockPosition pos) {
        return this.a(pos.u(), pos.v(), pos.w());
    }

    public Fluid a(int x2, int y2, int z2) {
        ChunkSection chunksection;
        int index = this.f(y2);
        if (index >= 0 && index < this.m.length && !(chunksection = this.m[index]).c()) {
            return chunksection.h.a((y2 & 0xF) << 8 | (z2 & 0xF) << 4 | x2 & 0xF).y();
        }
        return FluidTypes.a.g();
    }

    @Override
    @Nullable
    public IBlockData a(BlockPosition pos, IBlockData state, boolean moved) {
        return this.setBlockState(pos, state, moved, true);
    }

    @Nullable
    public IBlockData setBlockState(BlockPosition blockposition, IBlockData iblockdata, boolean flag, boolean doPlace) {
        int l2;
        int k2;
        int i2 = blockposition.v();
        ChunkSection chunksection = this.b(this.f(i2));
        boolean flag1 = chunksection.c();
        if (flag1 && iblockdata.l()) {
            return null;
        }
        int j2 = blockposition.u() & 0xF;
        IBlockData iblockdata1 = chunksection.a(j2, k2 = i2 & 0xF, l2 = blockposition.w() & 0xF, iblockdata);
        if (iblockdata1 == iblockdata) {
            return null;
        }
        Block block = iblockdata.b();
        this.h.get(HeightMap.Type.e).a(j2, i2, l2, iblockdata);
        this.h.get(HeightMap.Type.f).a(j2, i2, l2, iblockdata);
        this.h.get(HeightMap.Type.d).a(j2, i2, l2, iblockdata);
        this.h.get(HeightMap.Type.b).a(j2, i2, l2, iblockdata);
        boolean flag2 = chunksection.c();
        if (flag1 != flag2) {
            this.r.m().a().a(blockposition, flag2);
            this.r.m().a(this.c.h, SectionPosition.a(i2), this.c.i, flag2);
        }
        if (LightEngine.a(iblockdata1, iblockdata)) {
            GameProfilerFiller gameprofilerfiller = Profiler.a();
            gameprofilerfiller.a("updateSkyLightSources");
            gameprofilerfiller.b("queueCheckLight");
            this.r.m().a().a(blockposition);
            gameprofilerfiller.c();
        }
        boolean flag3 = iblockdata1.x();
        if (!this.r.C && !this.r.isBlockPlaceCancelled) {
            iblockdata1.b(this.r, blockposition, iblockdata, flag);
        } else if (!iblockdata1.a(block) && flag3) {
            this.d(blockposition);
        }
        if (!chunksection.a(j2, k2, l2).a(block)) {
            return null;
        }
        if (!this.r.C && doPlace && (!this.r.captureBlockStates || block instanceof BlockTileEntity)) {
            iblockdata.a((World)this.r, blockposition, iblockdata1, flag);
        }
        if (iblockdata.x()) {
            TileEntity tileentity = this.a(blockposition, EnumTileEntityState.c);
            if (tileentity != null && !tileentity.b(iblockdata)) {
                n.warn("Found mismatched block entity @ {}: type = {}, state = {}", new Object[]{blockposition, tileentity.q().a().h().a(), iblockdata});
                this.d(blockposition);
                tileentity = null;
            }
            if (tileentity == null) {
                tileentity = ((ITileEntity)((Object)block)).a(blockposition, iblockdata);
                if (tileentity != null) {
                    this.b(tileentity);
                }
            } else {
                tileentity.c(iblockdata);
                this.c(tileentity);
            }
        }
        this.i();
        return iblockdata1;
    }

    @Override
    @Deprecated
    public void a(Entity entity) {
    }

    @Nullable
    private TileEntity g(BlockPosition pos) {
        IBlockData iblockdata = this.a_(pos);
        return !iblockdata.x() ? null : ((ITileEntity)((Object)iblockdata.b())).a(pos, iblockdata);
    }

    @Override
    @Nullable
    public TileEntity c_(BlockPosition pos) {
        return this.a(pos, EnumTileEntityState.c);
    }

    @Nullable
    public TileEntity a(BlockPosition pos, EnumTileEntityState creationType) {
        TileEntity tileentity1;
        NBTTagCompound nbttagcompound;
        TileEntity tileentity = this.r.capturedTileEntities.get(pos);
        if (tileentity == null) {
            tileentity = this.k.get(pos);
        }
        if (tileentity == null && (nbttagcompound = this.j.remove(pos)) != null && (tileentity1 = this.a(pos, nbttagcompound)) != null) {
            return tileentity1;
        }
        if (tileentity == null) {
            if (creationType == EnumTileEntityState.a && (tileentity = this.g(pos)) != null) {
                this.b(tileentity);
            }
        } else if (tileentity.n()) {
            this.k.remove(pos);
            return null;
        }
        return tileentity;
    }

    public void b(TileEntity blockEntity) {
        this.a(blockEntity);
        if (this.L()) {
            WorldServer world = this.r;
            if (world instanceof WorldServer) {
                WorldServer worldserver = world;
                this.b(blockEntity, worldserver);
            }
            this.c(blockEntity);
        }
    }

    private boolean L() {
        return this.q || this.r.B_();
    }

    boolean h(BlockPosition pos) {
        if (!this.r.F_().a(pos)) {
            return false;
        }
        WorldServer world = this.r;
        if (!(world instanceof WorldServer)) {
            return true;
        }
        WorldServer worldserver = world;
        return this.F().a(FullChunkStatus.c) && worldserver.c(ChunkCoordIntPair.a(pos));
    }

    @Override
    public void a(TileEntity blockEntity) {
        BlockPosition blockposition = blockEntity.aB_();
        IBlockData iblockdata = this.a_(blockposition);
        if (!iblockdata.x()) {
            ServerInternalException e2 = new ServerInternalException("Trying to set block entity %s at position %s, but state %s does not allow it".formatted(blockEntity, blockposition, iblockdata));
            e2.printStackTrace();
            ServerInternalException.reportInternalException((Throwable)e2);
        } else {
            IBlockData iblockdata1 = blockEntity.m();
            if (iblockdata != iblockdata1) {
                if (!blockEntity.q().a(iblockdata)) {
                    n.warn("Trying to set block entity {} at position {}, but state {} does not allow it", new Object[]{blockEntity, blockposition, iblockdata});
                    return;
                }
                if (iblockdata.b() != iblockdata1.b()) {
                    n.warn("Block state mismatch on block entity {} in position {}, {} != {}, updating", new Object[]{blockEntity, blockposition, iblockdata, iblockdata1});
                }
                blockEntity.c(iblockdata);
            }
            blockEntity.a(this.r);
            blockEntity.o();
            TileEntity tileentity1 = this.k.put(blockposition.j(), blockEntity);
            if (tileentity1 != null && tileentity1 != blockEntity) {
                tileentity1.aw_();
            }
        }
    }

    @Override
    @Nullable
    public NBTTagCompound a(BlockPosition pos, HolderLookup.a registries) {
        TileEntity tileentity = this.c_(pos);
        if (tileentity != null && !tileentity.n()) {
            NBTTagCompound nbttagcompound = tileentity.b(this.r.K_());
            nbttagcompound.a("keepPacked", false);
            return nbttagcompound;
        }
        NBTTagCompound nbttagcompound = this.j.get(pos);
        if (nbttagcompound != null) {
            nbttagcompound = nbttagcompound.i();
            nbttagcompound.a("keepPacked", true);
        }
        return nbttagcompound;
    }

    @Override
    public void d(BlockPosition pos) {
        if (this.L()) {
            TileEntity tileentity = this.k.remove(pos);
            if (!this.j.isEmpty()) {
                this.j.remove(pos);
            }
            if (tileentity != null) {
                WorldServer world = this.r;
                if (world instanceof WorldServer) {
                    WorldServer worldserver = world;
                    this.a(tileentity, worldserver);
                }
                tileentity.aw_();
            }
        }
        this.k(pos);
    }

    private <T extends TileEntity> void a(T blockEntity, WorldServer world) {
        GameEventListener gameeventlistener;
        Block block = blockEntity.m().b();
        if (block instanceof ITileEntity && (gameeventlistener = ((ITileEntity)((Object)block)).a(world, blockEntity)) != null) {
            int i2 = SectionPosition.a(blockEntity.aB_().v());
            GameEventListenerRegistry gameeventlistenerregistry = this.a(i2);
            gameeventlistenerregistry.b(gameeventlistener);
        }
    }

    private void i(int ySectionCoord) {
        this.u.remove(ySectionCoord);
    }

    private void k(BlockPosition pos) {
        d chunk_d = this.p.remove(pos);
        if (chunk_d != null) {
            chunk_d.a(o);
        }
    }

    public void G() {
        if (this.t != null) {
            this.t.run(this);
            this.t = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCallback() {
        if (this.loadedTicketLevel) {
            n.error("Double calling chunk load!", new Throwable());
        }
        this.loadedTicketLevel = true;
        CraftServer server = this.r.getCraftServer();
        if (server != null) {
            CraftChunk bukkitChunk = new CraftChunk(this);
            server.getPluginManager().callEvent((Event)new ChunkLoadEvent((org.bukkit.Chunk)bukkitChunk, this.needsDecoration));
            CraftEventFactory.callEntitiesLoadEvent(this.r, this.c, this.r.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(this.locX, this.locZ).getEntityChunk().getAllEntities());
            if (this.needsDecoration) {
                this.needsDecoration = false;
                Random random = new Random();
                random.setSeed(this.r.D());
                long xRand = random.nextLong() / 2L * 2L + 1L;
                long zRand = random.nextLong() / 2L * 2L + 1L;
                random.setSeed((long)this.c.h * xRand + (long)this.c.i * zRand ^ this.r.D());
                CraftWorld world = this.r.getWorld();
                if (world != null) {
                    this.r.populating = true;
                    try {
                        for (BlockPopulator populator : world.getPopulators()) {
                            populator.populate((org.bukkit.World)world, random, (org.bukkit.Chunk)bukkitChunk);
                        }
                    }
                    finally {
                        this.r.populating = false;
                    }
                }
                server.getPluginManager().callEvent((Event)new ChunkPopulateEvent((org.bukkit.Chunk)bukkitChunk));
            }
        }
    }

    public void unloadCallback() {
        if (!this.loadedTicketLevel) {
            n.error("Double calling chunk unload!", new Throwable());
        }
        CraftServer server = this.r.getCraftServer();
        CraftEventFactory.callEntitiesUnloadEvent(this.r, this.c, this.r.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(this.locX, this.locZ).getEntityChunk().getAllEntities());
        CraftChunk bukkitChunk = new CraftChunk(this);
        ChunkUnloadEvent unloadEvent = new ChunkUnloadEvent((org.bukkit.Chunk)bukkitChunk, true);
        server.getPluginManager().callEvent((Event)unloadEvent);
        this.mustNotSave = !unloadEvent.isSaveChunk();
        this.loadedTicketLevel = false;
    }

    @Override
    public boolean k() {
        long gameTime = this.r.ac();
        if (this.v.moonrise$isDirty(gameTime) || this.w.moonrise$isDirty(gameTime)) {
            return true;
        }
        return super.k();
    }

    @Override
    public boolean j() {
        if (!this.k()) {
            return false;
        }
        this.v.moonrise$clearDirty();
        this.w.moonrise$clearDirty();
        super.j();
        return true;
    }

    public boolean E() {
        return false;
    }

    public void a(PacketDataSerializer buf, NBTTagCompound nbt, Consumer<ClientboundLevelChunkPacketData.b> blockEntityVisitorConsumer) {
        this.J();
        for (ChunkSection chunksection : this.m) {
            chunksection.a(buf);
        }
        for (HeightMap.Type heightmap_type : HeightMap.Type.values()) {
            String s2 = heightmap_type.a();
            if (!nbt.b(s2, 12)) continue;
            this.a(heightmap_type, nbt.o(s2));
        }
        this.C();
        blockEntityVisitorConsumer.accept((blockposition, tileentitytypes, nbttagcompound1) -> {
            TileEntity tileentity = this.a(blockposition, EnumTileEntityState.a);
            if (tileentity != null && nbttagcompound1 != null && tileentity.q() == tileentitytypes) {
                tileentity.c(nbttagcompound1, this.r.K_());
            }
        });
    }

    public void a(PacketDataSerializer buf) {
        for (ChunkSection chunksection : this.m) {
            chunksection.b(buf);
        }
    }

    public void b(boolean loadedToWorld) {
        this.q = loadedToWorld;
    }

    public World H() {
        return this.r;
    }

    public Map<BlockPosition, TileEntity> I() {
        return this.k;
    }

    public void a(WorldServer world) {
        ChunkCoordIntPair chunkcoordintpair = this.f();
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            if (this.b[i2] == null) continue;
            for (Short oshort : this.b[i2]) {
                IBlockData iblockdata1;
                BlockPosition blockposition = ProtoChunk.a(oshort, this.h(i2), chunkcoordintpair);
                IBlockData iblockdata = this.a_(blockposition);
                Fluid fluid = iblockdata.y();
                if (!fluid.c()) {
                    fluid.a(world, blockposition, iblockdata);
                }
                if (iblockdata.b() instanceof BlockFluids || (iblockdata1 = Block.b(iblockdata, world, blockposition)) == iblockdata) continue;
                world.a(blockposition, iblockdata1, 20);
            }
            this.b[i2].clear();
        }
        for (BlockPosition blockposition1 : ImmutableList.copyOf(this.j.keySet())) {
            this.c_(blockposition1);
        }
        this.j.clear();
        this.e.a(this);
        this.postProcessingDone = true;
    }

    @Nullable
    private TileEntity a(BlockPosition pos, NBTTagCompound nbt) {
        TileEntity tileentity;
        IBlockData iblockdata = this.a_(pos);
        if ("DUMMY".equals(nbt.l("id"))) {
            if (iblockdata.x()) {
                tileentity = ((ITileEntity)((Object)iblockdata.b())).a(pos, iblockdata);
            } else {
                tileentity = null;
                n.warn("Tried to load a DUMMY block entity @ {} but found not block entity block {} at location", (Object)pos, (Object)iblockdata);
            }
        } else {
            tileentity = TileEntity.a(pos, iblockdata, nbt, this.r.K_());
        }
        if (tileentity != null) {
            tileentity.a(this.r);
            this.b(tileentity);
        } else {
            n.warn("Tried to load a block entity for block {} but failed at location {}", (Object)iblockdata, (Object)pos);
        }
        return tileentity;
    }

    public void d(long time) {
        this.v.b(time);
        this.w.b(time);
    }

    public void b(WorldServer world) {
        world.n().a(this.c, this.v);
        world.o().a(this.c, this.w);
    }

    public void c(WorldServer world) {
        world.n().a(this.c);
        world.o().a(this.c);
    }

    @Override
    public ChunkStatus n() {
        return ChunkStatus.n;
    }

    public FullChunkStatus F() {
        return this.s == null ? FullChunkStatus.b : this.s.get();
    }

    public void b(Supplier<FullChunkStatus> levelTypeProvider) {
        this.s = levelTypeProvider;
    }

    public void J() {
        this.k.values().forEach(TileEntity::aw_);
        this.k.clear();
        this.p.values().forEach(chunk_d -> chunk_d.a(o));
        this.p.clear();
    }

    public void K() {
        this.k.values().forEach(tileentity -> {
            WorldServer world = this.r;
            if (world instanceof WorldServer) {
                WorldServer worldserver = world;
                this.b(tileentity, worldserver);
            }
            this.c(tileentity);
        });
    }

    private <T extends TileEntity> void b(T blockEntity, WorldServer world) {
        GameEventListener gameeventlistener;
        Block block = blockEntity.m().b();
        if (block instanceof ITileEntity && (gameeventlistener = ((ITileEntity)((Object)block)).a(world, blockEntity)) != null) {
            this.a(SectionPosition.a(blockEntity.aB_().v())).a(gameeventlistener);
        }
    }

    private <T extends TileEntity> void c(T blockEntity) {
        IBlockData iblockdata = blockEntity.m();
        BlockEntityTicker<?> blockentityticker = iblockdata.a((World)this.r, blockEntity.q());
        if (blockentityticker == null) {
            this.k(blockEntity.aB_());
        } else {
            this.p.compute(blockEntity.aB_(), (blockposition, chunk_d) -> {
                TickingBlockEntity tickingblockentity = this.a(blockEntity, blockentityticker);
                if (chunk_d != null) {
                    chunk_d.a(tickingblockentity);
                    return chunk_d;
                }
                if (this.L()) {
                    d chunk_d1 = new d(this, this, tickingblockentity);
                    this.r.a(chunk_d1);
                    return chunk_d1;
                }
                return null;
            });
        }
    }

    private <T extends TileEntity> TickingBlockEntity a(T blockEntity, BlockEntityTicker<T> blockEntityTicker) {
        return new a(blockEntity, blockEntityTicker);
    }

    private /* synthetic */ String lambda$getBlockState$2(int i2, int j2, int k2) throws Exception {
        return CrashReportSystemDetails.a((LevelHeightAccessor)this, i2, j2, k2);
    }

    @FunctionalInterface
    public static interface c {
        public void run(Chunk var1);
    }

    @FunctionalInterface
    public static interface e {
        public void setUnsaved(ChunkCoordIntPair var1);
    }

    public static enum EnumTileEntityState {
        a,
        b,
        c;

    }

    private class d
    implements TickingBlockEntity {
        private TickingBlockEntity a;

        d(Chunk chunk, Chunk wrapped, TickingBlockEntity tickingblockentity) {
            this.a = tickingblockentity;
        }

        void a(TickingBlockEntity wrapped) {
            this.a = wrapped;
        }

        @Override
        public void a() {
            this.a.a();
        }

        @Override
        public boolean b() {
            return this.a.b();
        }

        @Override
        public BlockPosition c() {
            return this.a.c();
        }

        @Override
        public String d() {
            return this.a.d();
        }

        public String toString() {
            return String.valueOf(this.a) + " <wrapped>";
        }
    }

    private class a<T extends TileEntity>
    implements TickingBlockEntity {
        private final T b;
        private final BlockEntityTicker<T> c;
        private boolean d;

        a(TileEntity tileentity, BlockEntityTicker blockentityticker) {
            this.b = tileentity;
            this.c = blockentityticker;
        }

        @Override
        public void a() {
            BlockPosition blockposition;
            if (!((TileEntity)this.b).n() && ((TileEntity)this.b).l() && Chunk.this.h(blockposition = ((TileEntity)this.b).aB_())) {
                try {
                    GameProfilerFiller gameprofilerfiller = Profiler.a();
                    gameprofilerfiller.a(this::d);
                    IBlockData iblockdata = Chunk.this.a_(blockposition);
                    if (((TileEntity)this.b).q().a(iblockdata)) {
                        this.c.tick(Chunk.this.r, ((TileEntity)this.b).aB_(), iblockdata, this.b);
                        this.d = false;
                    } else {
                        Chunk.this.d(this.c());
                        if (!this.d) {
                            this.d = true;
                            n.warn("Block entity {} @ {} state {} invalid for ticking:", new Object[]{LogUtils.defer(this::d), LogUtils.defer(this::c), iblockdata});
                        }
                    }
                    gameprofilerfiller.c();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadDeath) {
                        throw throwable;
                    }
                    String msg = String.format("BlockEntity threw exception at %s:%s,%s,%s", Chunk.this.H().getWorld().getName(), this.c().u(), this.c().v(), this.c().w());
                    MinecraftServer.l.error(msg, throwable);
                    Chunk.this.r.getCraftServer().getPluginManager().callEvent((Event)new ServerExceptionEvent((ServerException)new ServerInternalException(msg, throwable)));
                    Chunk.this.d(this.c());
                }
            }
        }

        @Override
        public boolean b() {
            return ((TileEntity)this.b).n();
        }

        @Override
        public BlockPosition c() {
            return ((TileEntity)this.b).aB_();
        }

        @Override
        public String d() {
            return TileEntityTypes.a(((TileEntity)this.b).q()).toString();
        }

        public String toString() {
            String s2 = this.d();
            return "Level ticker for " + s2 + "@" + String.valueOf(this.c());
        }
    }
}

