/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.EnumDirection8;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.ticks.TickListChunk;
import org.slf4j.Logger;

public class ChunkConverter {
    private static final Logger b = LogUtils.getLogger();
    public static final ChunkConverter a = new ChunkConverter(BlockAccessAir.a);
    private static final String c = "Indices";
    private static final EnumDirection8[] d = EnumDirection8.values();
    private final EnumSet<EnumDirection8> e = EnumSet.noneOf(EnumDirection8.class);
    private final List<TickListChunk<Block>> f = Lists.newArrayList();
    private final List<TickListChunk<FluidType>> g = Lists.newArrayList();
    private final int[][] h;
    static final Map<Block, a> i = new IdentityHashMap<Block, a>();
    static final Set<a> j = Sets.newHashSet();

    private ChunkConverter(LevelHeightAccessor world) {
        this.h = new int[world.an()][];
    }

    public ChunkConverter(NBTTagCompound nbt, LevelHeightAccessor world) {
        this(world);
        if (nbt.b(c, 10)) {
            NBTTagCompound compoundTag = nbt.p(c);
            for (int i2 = 0; i2 < this.h.length; ++i2) {
                String string = String.valueOf(i2);
                if (!compoundTag.b(string, 11)) continue;
                this.h[i2] = compoundTag.n(string);
            }
        }
        int j2 = nbt.h("Sides");
        for (EnumDirection8 direction8 : EnumDirection8.values()) {
            if ((j2 & 1 << direction8.ordinal()) == 0) continue;
            this.e.add(direction8);
        }
        ChunkConverter.a(nbt, "neighbor_block_ticks", id -> BuiltInRegistries.e.b(MinecraftKey.c(id)).or(() -> Optional.of(Blocks.a)), this.f);
        ChunkConverter.a(nbt, "neighbor_fluid_ticks", id -> BuiltInRegistries.c.b(MinecraftKey.c(id)).or(() -> Optional.of(FluidTypes.a)), this.g);
    }

    private ChunkConverter(ChunkConverter data) {
        this.e.addAll(data.e);
        this.f.addAll(data.f);
        this.g.addAll(data.g);
        this.h = new int[data.h.length][];
        for (int i2 = 0; i2 < data.h.length; ++i2) {
            int[] is = data.h[i2];
            this.h[i2] = is != null ? IntArrays.copy((int[])is) : null;
        }
    }

    private static <T> void a(NBTTagCompound nbt, String key, Function<String, Optional<T>> nameToType, List<TickListChunk<T>> ticks) {
        if (nbt.b(key, 9)) {
            for (NBTBase tag : nbt.c(key, 10)) {
                TickListChunk.a((NBTTagCompound)tag, nameToType).ifPresent(ticks::add);
            }
        }
    }

    private static <T> void filterTickList(int chunkX, int chunkZ, List<TickListChunk<T>> ticks) {
        Iterator<TickListChunk<T>> iterator = ticks.iterator();
        while (iterator.hasNext()) {
            TickListChunk<T> tick = iterator.next();
            BlockPosition tickPos = tick.b();
            int tickCX = tickPos.u() >> 4;
            int tickCZ = tickPos.w() >> 4;
            int dist = Math.max(Math.abs(chunkX - tickCX), Math.abs(chunkZ - tickCZ));
            if (dist == 1) continue;
            b.warn("Neighbour tick '" + String.valueOf(tick) + "' serialized in chunk (" + chunkX + "," + chunkZ + ") is too far (" + tickCX + "," + tickCZ + ")");
            iterator.remove();
        }
    }

    public void a(Chunk chunk) {
        this.b(chunk);
        for (EnumDirection8 direction8 : d) {
            ChunkConverter.a(chunk, direction8);
        }
        ChunkConverter.filterTickList(chunk.locX, chunk.locZ, this.f);
        ChunkConverter.filterTickList(chunk.locX, chunk.locZ, this.g);
        World level = chunk.H();
        this.f.forEach(tick -> {
            Block block = tick.a() == Blocks.a ? level.a_(tick.b()).b() : (Block)tick.a();
            level.a(tick.b(), block, tick.c(), tick.d());
        });
        this.g.forEach(tick -> {
            FluidType fluid = tick.a() == FluidTypes.a ? level.b_(tick.b()).a() : (FluidType)tick.a();
            level.a(tick.b(), fluid, tick.c(), tick.d());
        });
        Type.values();
        j.forEach(logic -> logic.a(level));
    }

    private static void a(Chunk chunk, EnumDirection8 side) {
        World level = chunk.H();
        if (chunk.t().e.remove((Object)side)) {
            Set<EnumDirection> set = side.a();
            boolean i2 = false;
            int j2 = 15;
            boolean bl = set.contains(EnumDirection.f);
            boolean bl2 = set.contains(EnumDirection.e);
            boolean bl3 = set.contains(EnumDirection.d);
            boolean bl4 = set.contains(EnumDirection.c);
            boolean bl5 = set.size() == 1;
            ChunkCoordIntPair chunkPos = chunk.f();
            int k2 = chunkPos.d() + (!bl5 || !bl4 && !bl3 ? (bl2 ? 0 : 15) : 1);
            int l2 = chunkPos.d() + (!bl5 || !bl4 && !bl3 ? (bl2 ? 0 : 15) : 14);
            int m2 = chunkPos.e() + (!bl5 || !bl && !bl2 ? (bl4 ? 0 : 15) : 1);
            int n2 = chunkPos.e() + (!bl5 || !bl && !bl2 ? (bl4 ? 0 : 15) : 14);
            EnumDirection[] directions = EnumDirection.values();
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            for (BlockPosition blockPos : BlockPosition.b(k2, level.L_(), m2, l2, level.am(), n2)) {
                IBlockData blockState;
                IBlockData blockState2 = blockState = level.a_(blockPos);
                for (EnumDirection direction : directions) {
                    mutableBlockPos.a((BaseBlockPosition)blockPos, direction);
                    blockState2 = ChunkConverter.a(blockState2, direction, level, blockPos, mutableBlockPos);
                }
                Block.a(blockState, blockState2, level, blockPos, 18);
            }
        }
    }

    private static IBlockData a(IBlockData oldState, EnumDirection dir, GeneratorAccess world, BlockPosition currentPos, BlockPosition otherPos) {
        return i.getOrDefault(oldState.b(), Type.b).a(oldState, dir, world.a_(otherPos), world, currentPos, otherPos);
    }

    private void b(Chunk chunk) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        BlockPosition.MutableBlockPosition mutableBlockPos2 = new BlockPosition.MutableBlockPosition();
        ChunkCoordIntPair chunkPos = chunk.f();
        World levelAccessor = chunk.H();
        for (int i2 = 0; i2 < this.h.length; ++i2) {
            ChunkSection levelChunkSection = chunk.b(i2);
            int[] is = this.h[i2];
            this.h[i2] = null;
            if (is == null || is.length <= 0) continue;
            EnumDirection[] directions = EnumDirection.values();
            DataPaletteBlock<IBlockData> palettedContainer = levelChunkSection.h();
            int j2 = chunk.h(i2);
            int k2 = SectionPosition.c(j2);
            for (int l2 : is) {
                IBlockData blockState;
                int m2 = l2 & 0xF;
                int n2 = l2 >> 8 & 0xF;
                int o2 = l2 >> 4 & 0xF;
                mutableBlockPos.d(chunkPos.d() + m2, k2 + n2, chunkPos.e() + o2);
                IBlockData blockState2 = blockState = palettedContainer.a(l2);
                for (EnumDirection direction : directions) {
                    mutableBlockPos2.a((BaseBlockPosition)mutableBlockPos, direction);
                    if (SectionPosition.a(mutableBlockPos.u()) != chunkPos.h || SectionPosition.a(mutableBlockPos.w()) != chunkPos.i) continue;
                    blockState2 = ChunkConverter.a(blockState2, direction, levelAccessor, mutableBlockPos, mutableBlockPos2);
                }
                Block.a(blockState, blockState2, levelAccessor, mutableBlockPos, 18);
            }
        }
        for (int p2 = 0; p2 < this.h.length; ++p2) {
            if (this.h[p2] != null) {
                b.warn("Discarding update data for section {} for chunk ({} {})", new Object[]{levelAccessor.h(p2), chunkPos.h, chunkPos.i});
            }
            this.h[p2] = null;
        }
    }

    public boolean a() {
        for (int[] is : this.h) {
            if (is == null) continue;
            return false;
        }
        return this.e.isEmpty();
    }

    public NBTTagCompound b() {
        NBTTagCompound compoundTag = new NBTTagCompound();
        NBTTagCompound compoundTag2 = new NBTTagCompound();
        for (int i2 = 0; i2 < this.h.length; ++i2) {
            String string = String.valueOf(i2);
            if (this.h[i2] == null || this.h[i2].length == 0) continue;
            compoundTag2.a(string, this.h[i2]);
        }
        if (!compoundTag2.g()) {
            compoundTag.a(c, compoundTag2);
        }
        int j2 = 0;
        for (EnumDirection8 direction8 : this.e) {
            j2 |= 1 << direction8.ordinal();
        }
        compoundTag.a("Sides", (byte)j2);
        if (!this.f.isEmpty()) {
            NBTTagList listTag = new NBTTagList();
            this.f.forEach(blockTick -> listTag.add(blockTick.a((T block) -> BuiltInRegistries.e.b((Block)block).toString())));
            compoundTag.a("neighbor_block_ticks", listTag);
        }
        if (!this.g.isEmpty()) {
            NBTTagList listTag2 = new NBTTagList();
            this.g.forEach(fluidTick -> listTag2.add(fluidTick.a((T fluid) -> BuiltInRegistries.c.b((FluidType)fluid).toString())));
            compoundTag.a("neighbor_fluid_ticks", listTag2);
        }
        return compoundTag;
    }

    public ChunkConverter c() {
        return this == a ? a : new ChunkConverter(this);
    }

    static abstract sealed class Type
    extends Enum<Type>
    implements a {
        public static final /* enum */ Type a = new Type(new Block[]{Blocks.lj, Blocks.eq, Blocks.mh, Blocks.mi, Blocks.mj, Blocks.mk, Blocks.ml, Blocks.mm, Blocks.mn, Blocks.mo, Blocks.mp, Blocks.mq, Blocks.mr, Blocks.ms, Blocks.mt, Blocks.mu, Blocks.mv, Blocks.mw, Blocks.hi, Blocks.hj, Blocks.hk, Blocks.fO, Blocks.O, Blocks.L, Blocks.N, Blocks.cM, Blocks.cN, Blocks.cO, Blocks.cP, Blocks.cQ, Blocks.cR, Blocks.cS, Blocks.cT, Blocks.da, Blocks.db, Blocks.dc, Blocks.dd, Blocks.df, Blocks.dg, Blocks.dh, Blocks.dk, Blocks.dl, Blocks.dm, Blocks.dn, Blocks.dp, Blocks.dq, Blocks.dr, Blocks.dw, Blocks.dx, Blocks.dy, Blocks.dz, Blocks.dB, Blocks.dC, Blocks.dD}){

            @Override
            public IBlockData a(IBlockData oldState, EnumDirection direction, IBlockData otherState, GeneratorAccess world, BlockPosition currentPos, BlockPosition otherPos) {
                return oldState;
            }
        };
        public static final /* enum */ Type b = new Type(new Block[0]){

            @Override
            public IBlockData a(IBlockData oldState, EnumDirection direction, IBlockData otherState, GeneratorAccess world, BlockPosition currentPos, BlockPosition otherPos) {
                return oldState.a(world, world, currentPos, direction, otherPos, world.a_(otherPos), world.H_());
            }
        };
        public static final /* enum */ Type c = new Type(new Block[]{Blocks.cD, Blocks.hl}){

            @Override
            public IBlockData a(IBlockData oldState, EnumDirection direction, IBlockData otherState, GeneratorAccess world, BlockPosition currentPos, BlockPosition otherPos) {
                if (otherState.a(oldState.b()) && direction.o().d() && oldState.c(BlockChest.d) == BlockPropertyChestType.a && otherState.c(BlockChest.d) == BlockPropertyChestType.a) {
                    EnumDirection direction2 = oldState.c(BlockChest.c);
                    if (direction.o() != direction2.o() && direction2 == otherState.c(BlockChest.c)) {
                        BlockPropertyChestType chestType = direction == direction2.h() ? BlockPropertyChestType.b : BlockPropertyChestType.c;
                        world.a(otherPos, (IBlockData)otherState.b(BlockChest.d, chestType.a()), 18);
                        if (direction2 == EnumDirection.c || direction2 == EnumDirection.f) {
                            TileEntity blockEntity = world.c_(currentPos);
                            TileEntity blockEntity2 = world.c_(otherPos);
                            if (blockEntity instanceof TileEntityChest && blockEntity2 instanceof TileEntityChest) {
                                TileEntityChest.a((TileEntityChest)blockEntity, (TileEntityChest)blockEntity2);
                            }
                        }
                        return (IBlockData)oldState.b(BlockChest.d, chestType);
                    }
                }
                return oldState;
            }
        };
        public static final /* enum */ Type d = new Type(true, new Block[]{Blocks.aO, Blocks.aP, Blocks.aM, Blocks.aR, Blocks.aQ, Blocks.aN, Blocks.aK, Blocks.aL}){
            private final ThreadLocal<List<ObjectSet<BlockPosition>>> g = ThreadLocal.withInitial(() -> Lists.newArrayListWithCapacity((int)7));

            @Override
            public IBlockData a(IBlockData oldState, EnumDirection direction, IBlockData otherState, GeneratorAccess world, BlockPosition currentPos, BlockPosition otherPos) {
                IBlockData blockState = oldState.a(world, world, currentPos, direction, otherPos, world.a_(otherPos), world.H_());
                if (oldState != blockState) {
                    int i2 = blockState.c(BlockProperties.aD);
                    List<ObjectSet<BlockPosition>> list = this.g.get();
                    if (list.isEmpty()) {
                        for (int j2 = 0; j2 < 7; ++j2) {
                            list.add((ObjectSet<BlockPosition>)new ObjectOpenHashSet());
                        }
                    }
                    list.get(i2).add((Object)currentPos.j());
                }
                return oldState;
            }

            @Override
            public void a(GeneratorAccess world) {
                BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
                List<ObjectSet<BlockPosition>> list = this.g.get();
                for (int i2 = 2; i2 < list.size(); ++i2) {
                    int j2 = i2 - 1;
                    ObjectSet<BlockPosition> objectSet = list.get(j2);
                    ObjectSet<BlockPosition> objectSet2 = list.get(i2);
                    for (BlockPosition blockPos : objectSet) {
                        IBlockData blockState = world.a_(blockPos);
                        if (blockState.c(BlockProperties.aD) < j2) continue;
                        world.a(blockPos, (IBlockData)blockState.b(BlockProperties.aD, j2), 18);
                        if (i2 == 7) continue;
                        for (EnumDirection direction : f) {
                            mutableBlockPos.a((BaseBlockPosition)blockPos, direction);
                            IBlockData blockState2 = world.a_(mutableBlockPos);
                            if (!blockState2.b(BlockProperties.aD) || blockState.c(BlockProperties.aD) <= i2) continue;
                            objectSet2.add((Object)mutableBlockPos.j());
                        }
                    }
                }
                list.clear();
            }
        };
        public static final /* enum */ Type e = new Type(new Block[]{Blocks.fs, Blocks.fr}){

            @Override
            public IBlockData a(IBlockData oldState, EnumDirection direction, IBlockData otherState, GeneratorAccess world, BlockPosition currentPos, BlockPosition otherPos) {
                if (oldState.c(BlockStem.c) == 7) {
                    Block block;
                    Block block2 = block = oldState.a(Blocks.fr) ? Blocks.fn : Blocks.fo;
                    if (otherState.a(block)) {
                        return (IBlockData)(oldState.a(Blocks.fr) ? Blocks.fp : Blocks.fq).m().b(BlockFacingHorizontal.aF, direction);
                    }
                }
                return oldState;
            }
        };
        public static final EnumDirection[] f;
        private static final /* synthetic */ Type[] g;

        public static Type[] values() {
            return (Type[])g.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(Block ... blocks) {
            this(false, blocks);
        }

        private Type(boolean addCallback, Block ... blocks) {
            for (Block block : blocks) {
                i.put(block, this);
            }
            if (addCallback) {
                j.add(this);
            }
        }

        private static /* synthetic */ Type[] a() {
            return new Type[]{a, b, c, d, e};
        }

        static {
            g = Type.a();
            f = EnumDirection.values();
        }
    }

    public static interface a {
        public IBlockData a(IBlockData var1, EnumDirection var2, IBlockData var3, GeneratorAccess var4, BlockPosition var5, BlockPosition var6);

        default public void a(GeneratorAccess world) {
        }
    }
}

