/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPosition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.slf4j.Logger;
import org.spigotmc.SpigotWorldConfig;

public class ChunkGeneratorStructureState {
    private static final Logger a = LogUtils.getLogger();
    private final RandomState b;
    private final WorldChunkManager c;
    private final long d;
    private final long e;
    private final Map<Structure, List<StructurePlacement>> f = new Object2ObjectOpenHashMap();
    private final Map<ConcentricRingsStructurePlacement, CompletableFuture<List<ChunkCoordIntPair>>> g = new Object2ObjectArrayMap();
    private boolean h;
    private final List<Holder<StructureSet>> i;
    public final SpigotWorldConfig conf;

    public static ChunkGeneratorStructureState createForFlat(RandomState randomstate, long i2, WorldChunkManager worldchunkmanager, Stream<Holder<StructureSet>> stream, SpigotWorldConfig conf) {
        List<Holder<StructureSet>> list = stream.filter(holder -> ChunkGeneratorStructureState.a((StructureSet)holder.a(), worldchunkmanager)).toList();
        return new ChunkGeneratorStructureState(randomstate, worldchunkmanager, i2, 0L, ChunkGeneratorStructureState.injectSpigot(list, conf), conf);
    }

    public static ChunkGeneratorStructureState createForNormal(RandomState randomstate, long i2, WorldChunkManager worldchunkmanager, HolderLookup<StructureSet> holderlookup, SpigotWorldConfig conf) {
        List<Holder<StructureSet>> list = holderlookup.c().filter(holder_c -> ChunkGeneratorStructureState.a((StructureSet)holder_c.a(), worldchunkmanager)).collect(Collectors.toUnmodifiableList());
        return new ChunkGeneratorStructureState(randomstate, worldchunkmanager, i2, i2, ChunkGeneratorStructureState.injectSpigot(list, conf), conf);
    }

    private static List<Holder<StructureSet>> injectSpigot(List<Holder<StructureSet>> list, SpigotWorldConfig conf) {
        return list.stream().map(holder -> {
            StructureSet structureset = holder.a();
            StructurePlacement patt0$temp = structureset.b();
            if (!(patt0$temp instanceof RandomSpreadStructurePlacement)) return holder;
            RandomSpreadStructurePlacement randomConfig = (RandomSpreadStructurePlacement)patt0$temp;
            if (!holder.e().orElseThrow().a().b().equals("minecraft")) return holder;
            String name = holder.e().orElseThrow().a().a();
            int seed = randomConfig.f;
            switch (name) {
                case "desert_pyramids": {
                    seed = conf.desertSeed;
                    break;
                }
                case "end_cities": {
                    seed = conf.endCitySeed;
                    break;
                }
                case "nether_complexes": {
                    seed = conf.netherSeed;
                    break;
                }
                case "igloos": {
                    seed = conf.iglooSeed;
                    break;
                }
                case "jungle_temples": {
                    seed = conf.jungleSeed;
                    break;
                }
                case "woodland_mansions": {
                    seed = conf.mansionSeed;
                    break;
                }
                case "ocean_monuments": {
                    seed = conf.monumentSeed;
                    break;
                }
                case "nether_fossils": {
                    seed = conf.fossilSeed;
                    break;
                }
                case "ocean_ruins": {
                    seed = conf.oceanSeed;
                    break;
                }
                case "pillager_outposts": {
                    seed = conf.outpostSeed;
                    break;
                }
                case "ruined_portals": {
                    seed = conf.portalSeed;
                    break;
                }
                case "shipwrecks": {
                    seed = conf.shipwreckSeed;
                    break;
                }
                case "swamp_huts": {
                    seed = conf.swampSeed;
                    break;
                }
                case "villages": {
                    seed = conf.villageSeed;
                    break;
                }
                case "ancient_cities": {
                    seed = conf.ancientCitySeed;
                    break;
                }
                case "trail_ruins": {
                    seed = conf.trailRuinsSeed;
                    break;
                }
                case "trial_chambers": {
                    seed = conf.trialChambersSeed;
                }
            }
            structureset = new StructureSet(structureset.a(), (StructurePlacement)new KeyedRandomSpreadStructurePlacement(holder.e().orElseThrow(), ((StructurePlacement)randomConfig).c, ((StructurePlacement)randomConfig).d, ((StructurePlacement)randomConfig).e, seed, randomConfig.g, randomConfig.a(), randomConfig.b(), randomConfig.c()));
            return Holder.a(structureset);
        }).collect(Collectors.toUnmodifiableList());
    }

    private static boolean a(StructureSet structureSet, WorldChunkManager biomeSource) {
        Stream stream = structureSet.a().stream().flatMap(structureset_a -> {
            Structure structure = structureset_a.a().a();
            return structure.a().a();
        });
        Set<Holder<BiomeBase>> set = biomeSource.c();
        Objects.requireNonNull(set);
        return stream.anyMatch(set::contains);
    }

    private ChunkGeneratorStructureState(RandomState noiseConfig, WorldChunkManager biomeSource, long structureSeed, long concentricRingSeed, List<Holder<StructureSet>> structureSets, SpigotWorldConfig conf) {
        this.b = noiseConfig;
        this.d = structureSeed;
        this.c = biomeSource;
        this.e = concentricRingSeed;
        this.i = structureSets;
        this.conf = conf;
    }

    public List<Holder<StructureSet>> a() {
        return this.i;
    }

    private void e() {
        Set<Holder<BiomeBase>> set = this.c.c();
        this.a().forEach(holder -> {
            StructurePlacement structureplacement;
            StructureSet structureset = (StructureSet)holder.a();
            boolean flag = false;
            for (StructureSet.a structureset_a : structureset.a()) {
                Structure structure = structureset_a.a().a();
                Stream<Holder<BiomeBase>> stream = structure.a().a();
                Objects.requireNonNull(set);
                if (!stream.anyMatch(set::contains)) continue;
                this.f.computeIfAbsent(structure, structure1 -> new ArrayList()).add(structureset.b());
                flag = true;
            }
            if (flag && (structureplacement = structureset.b()) instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)structureplacement;
                this.g.put(concentricringsstructureplacement, this.a((Holder<StructureSet>)holder, concentricringsstructureplacement));
            }
        });
    }

    private CompletableFuture<List<ChunkCoordIntPair>> a(Holder<StructureSet> structureSetEntry, ConcentricRingsStructurePlacement placement) {
        if (placement.c() == 0) {
            return CompletableFuture.completedFuture(List.of());
        }
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)SystemUtils.d);
        int i2 = placement.a();
        int j2 = placement.c();
        ArrayList<CompletableFuture<ChunkCoordIntPair>> list = new ArrayList<CompletableFuture<ChunkCoordIntPair>>(j2);
        int k2 = placement.b();
        HolderSet<BiomeBase> holderset = placement.d();
        RandomSource randomsource = RandomSource.a();
        if (this.conf.strongholdSeed != null && structureSetEntry.a(BuiltinStructureSets.r)) {
            randomsource.b(this.conf.strongholdSeed);
        } else {
            randomsource.b(this.e);
        }
        double d0 = randomsource.j() * Math.PI * 2.0;
        int l2 = 0;
        int i1 = 0;
        for (int j1 = 0; j1 < j2; ++j1) {
            double d1 = (double)(4 * i2 + i2 * i1 * 6) + (randomsource.j() - 0.5) * (double)i2 * 2.5;
            int k1 = (int)Math.round(Math.cos(d0) * d1);
            int l1 = (int)Math.round(Math.sin(d0) * d1);
            RandomSource randomsource1 = randomsource.d();
            list.add(CompletableFuture.supplyAsync(() -> {
                WorldChunkManager worldchunkmanager = this.c;
                int i2 = SectionPosition.a(k1, 8);
                int j2 = SectionPosition.a(l1, 8);
                Objects.requireNonNull(holderset);
                Pair<BlockPosition, Holder<BiomeBase>> pair = worldchunkmanager.a(i2, 0, j2, 112, holderset::a, randomsource1, this.b.b());
                if (pair != null) {
                    BlockPosition blockposition = (BlockPosition)pair.getFirst();
                    return new ChunkCoordIntPair(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()));
                }
                return new ChunkCoordIntPair(k1, l1);
            }, SystemUtils.g().a("structureRings")));
            d0 += Math.PI * 2 / (double)k2;
            if (++l2 != k2) continue;
            l2 = 0;
            k2 += 2 * k2 / (++i1 + 1);
            k2 = Math.min(k2, j2 - j1);
            d0 += randomsource.j() * Math.PI * 2.0;
        }
        return SystemUtils.d(list).thenApply(list1 -> {
            double d2 = (double)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            a.debug("Calculation for {} took {}s", (Object)structureSetEntry, (Object)d2);
            return list1;
        });
    }

    public void b() {
        if (!this.h) {
            this.e();
            this.h = true;
        }
    }

    @Nullable
    public List<ChunkCoordIntPair> a(ConcentricRingsStructurePlacement placement) {
        this.b();
        CompletableFuture<List<ChunkCoordIntPair>> completablefuture = this.g.get(placement);
        return completablefuture != null ? completablefuture.join() : null;
    }

    public List<StructurePlacement> a(Holder<Structure> structureEntry) {
        this.b();
        return this.f.getOrDefault(structureEntry.a(), List.of());
    }

    public RandomState c() {
        return this.b;
    }

    public boolean a(Holder<StructureSet> structureSetEntry, int centerChunkX, int centerChunkZ, int chunkCount) {
        StructurePlacement structureplacement = structureSetEntry.a().b();
        for (int l2 = centerChunkX - chunkCount; l2 <= centerChunkX + chunkCount; ++l2) {
            for (int i1 = centerChunkZ - chunkCount; i1 <= centerChunkZ + chunkCount; ++i1) {
                ResourceKey<StructureSet> resourceKey;
                if (structureplacement instanceof KeyedRandomSpreadStructurePlacement) {
                    KeyedRandomSpreadStructurePlacement keyed = (KeyedRandomSpreadStructurePlacement)structureplacement;
                    resourceKey = keyed.key;
                } else {
                    resourceKey = null;
                }
                if (!structureplacement.isStructureChunk(this, l2, i1, resourceKey)) continue;
                return true;
            }
        }
        return false;
    }

    public long d() {
        return this.d;
    }

    public static final class KeyedRandomSpreadStructurePlacement
    extends RandomSpreadStructurePlacement {
        public final ResourceKey<StructureSet> key;

        public KeyedRandomSpreadStructurePlacement(ResourceKey<StructureSet> key, BaseBlockPosition locateOffset, StructurePlacement.c frequencyReductionMethod, float frequency, int salt, Optional<StructurePlacement.a> exclusionZone, int spacing, int separation, RandomSpreadType spreadType) {
            super(locateOffset, frequencyReductionMethod, frequency, salt, exclusionZone, spacing, separation, spreadType);
            this.key = key;
        }
    }
}

