/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import ca.spottedleaf.moonrise.common.list.ShortList;
import ca.spottedleaf.moonrise.patches.block_counting.BlockCountingChunkSection;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.destroystokyo.paper.antixray.ChunkPacketInfo;
import io.papermc.paper.annotation.DoNotUse;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.DataBits;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.DataPalette;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.material.Fluid;

public class ChunkSection
implements BlockCountingChunkSection {
    public static final int a = 16;
    public static final int b = 16;
    public static final int c = 4096;
    public static final int d = 2;
    short e;
    private short f;
    private short g;
    public final DataPaletteBlock<IBlockData> h;
    private DataPaletteBlock<Holder<BiomeBase>> biomes;
    private static final ShortArrayList FULL_LIST = new ShortArrayList(4096);
    private boolean isClient;
    private static final short CLIENT_FORCED_SPECIAL_COLLIDING_BLOCKS = 9999;
    private short specialCollidingBlocks;
    private final ShortList tickingBlocks = new ShortList();

    @Override
    public final boolean moonrise$hasSpecialCollidingBlocks() {
        return this.specialCollidingBlocks != 0;
    }

    @Override
    public final ShortList moonrise$getTickingBlockList() {
        return this.tickingBlocks;
    }

    private ChunkSection(ChunkSection section) {
        this.e = section.e;
        this.f = section.f;
        this.g = section.g;
        this.h = section.h.d();
        this.biomes = section.biomes.d();
    }

    public ChunkSection(DataPaletteBlock<IBlockData> datapaletteblock, DataPaletteBlock<Holder<BiomeBase>> palettedcontainerro) {
        this.h = datapaletteblock;
        this.biomes = palettedcontainerro;
        this.g();
    }

    @Deprecated
    @DoNotUse
    public ChunkSection(IRegistry<BiomeBase> biomeRegistry) {
        this(biomeRegistry, null, null, 0);
    }

    public ChunkSection(IRegistry<BiomeBase> biomeRegistry, World level, ChunkCoordIntPair chunkPos, int chunkSectionY) {
        this.h = new DataPaletteBlock<IBlockData>(Block.q, Blocks.a.m(), DataPaletteBlock.d.d, level == null || level.chunkPacketBlockController == null ? null : level.chunkPacketBlockController.getPresetBlockStates(level, chunkPos, chunkSectionY));
        this.biomes = new DataPaletteBlock<Holder.c>(biomeRegistry.t(), biomeRegistry.b(Biomes.b), DataPaletteBlock.d.e, null);
    }

    public IBlockData a(int x2, int y2, int z2) {
        return this.h.a(x2, y2, z2);
    }

    public Fluid b(int x2, int y2, int z2) {
        return this.h.a(x2, y2, z2).y();
    }

    public void a() {
        this.h.a();
    }

    public void b() {
        this.h.b();
    }

    public IBlockData a(int x2, int y2, int z2, IBlockData state) {
        return this.a(x2, y2, z2, state, true);
    }

    private void updateBlockCallback(int x2, int y2, int z2, IBlockData newState, IBlockData oldState) {
        boolean newTicking;
        boolean oldTicking;
        boolean isSpecialNew;
        if (oldState == newState) {
            return;
        }
        if (this.isClient) {
            if (CollisionUtil.isSpecialCollidingBlock(newState)) {
                this.specialCollidingBlocks = (short)9999;
            }
            return;
        }
        boolean isSpecialOld = CollisionUtil.isSpecialCollidingBlock(oldState);
        if (isSpecialOld != (isSpecialNew = CollisionUtil.isSpecialCollidingBlock(newState))) {
            this.specialCollidingBlocks = isSpecialOld ? (short)(this.specialCollidingBlocks - 1) : (short)(this.specialCollidingBlocks + 1);
        }
        if ((oldTicking = oldState.z()) != (newTicking = newState.z())) {
            ShortList tickingBlocks = this.tickingBlocks;
            short position = (short)(x2 | z2 << 4 | y2 << 8);
            if (oldTicking) {
                tickingBlocks.remove(position);
            } else {
                tickingBlocks.add(position);
            }
        }
    }

    public IBlockData a(int x2, int y2, int z2, IBlockData state, boolean lock) {
        IBlockData iblockdata1 = lock ? this.h.a(x2, y2, z2, state) : this.h.b(x2, y2, z2, state);
        Fluid fluid = iblockdata1.y();
        Fluid fluid1 = state.y();
        if (!iblockdata1.l()) {
            this.e = (short)(this.e - 1);
            if (iblockdata1.z()) {
                this.f = (short)(this.f - 1);
            }
        }
        if (fluid.f()) {
            this.g = (short)(this.g - 1);
        }
        if (!state.l()) {
            this.e = (short)(this.e + 1);
            if (state.z()) {
                this.f = (short)(this.f + 1);
            }
        }
        if (fluid1.f()) {
            this.g = (short)(this.g + 1);
        }
        this.updateBlockCallback(x2, y2, z2, state, iblockdata1);
        return iblockdata1;
    }

    public boolean c() {
        return this.e == 0;
    }

    public boolean d() {
        return this.e() || this.f();
    }

    public boolean e() {
        return this.f > 0;
    }

    public boolean f() {
        return this.g > 0;
    }

    public void g() {
        this.e = 0;
        this.f = 0;
        this.g = 0;
        this.specialCollidingBlocks = 0;
        this.tickingBlocks.clear();
        if (this.a((IBlockData state) -> !state.l())) {
            Int2ObjectOpenHashMap counts;
            DataPaletteBlock.c data = this.h.d;
            DataPalette palette = data.d();
            int paletteSize = palette.b();
            DataBits storage = data.c();
            if (paletteSize == 1) {
                counts = new Int2ObjectOpenHashMap(1);
                counts.put(0, (Object)FULL_LIST);
            } else {
                counts = storage.moonrise$countEntries();
            }
            ObjectIterator iterator = counts.int2ObjectEntrySet().fastIterator();
            while (iterator.hasNext()) {
                Fluid fluid;
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
                int paletteIdx = entry.getIntKey();
                ShortArrayList coordinates = (ShortArrayList)entry.getValue();
                int paletteCount = coordinates.size();
                IBlockData state2 = (IBlockData)palette.a(paletteIdx);
                if (state2.l()) continue;
                if (CollisionUtil.isSpecialCollidingBlock(state2)) {
                    this.specialCollidingBlocks = (short)(this.specialCollidingBlocks + (short)paletteCount);
                }
                this.e = (short)(this.e + (short)paletteCount);
                if (state2.z()) {
                    this.f = (short)(this.f + (short)paletteCount);
                    short[] raw = coordinates.elements();
                    int rawLen = raw.length;
                    ShortList tickingBlocks = this.tickingBlocks;
                    tickingBlocks.setMinCapacity(Math.min((rawLen + tickingBlocks.size()) * 3 / 2, 4096));
                    Objects.checkFromToIndex(0, paletteCount, raw.length);
                    for (int i2 = 0; i2 < paletteCount; ++i2) {
                        tickingBlocks.add(raw[i2]);
                    }
                }
                if ((fluid = state2.y()).c() || !fluid.f()) continue;
                this.g = (short)(this.g + (short)paletteCount);
            }
        }
    }

    public DataPaletteBlock<IBlockData> h() {
        return this.h;
    }

    public PalettedContainerRO<Holder<BiomeBase>> i() {
        return this.biomes;
    }

    public void a(PacketDataSerializer buf) {
        this.e = buf.readShort();
        this.h.a(buf);
        DataPaletteBlock<Holder<BiomeBase>> datapaletteblock = this.biomes.e();
        datapaletteblock.a(buf);
        this.biomes = datapaletteblock;
        this.isClient = true;
        this.specialCollidingBlocks = this.e != 0 && this.a(CollisionUtil::isSpecialCollidingBlock) ? 9999 : 0;
    }

    public void b(PacketDataSerializer buf) {
        DataPaletteBlock<Holder<BiomeBase>> datapaletteblock = this.biomes.e();
        datapaletteblock.a(buf);
        this.biomes = datapaletteblock;
    }

    @Deprecated
    @DoNotUse
    public void c(PacketDataSerializer buf) {
        this.write(buf, null, 0);
    }

    public void write(PacketDataSerializer buf, ChunkPacketInfo<IBlockData> chunkPacketInfo, int chunkSectionIndex) {
        buf.m(this.e);
        this.h.write(buf, chunkPacketInfo, chunkSectionIndex);
        this.biomes.write(buf, null, chunkSectionIndex);
    }

    public int j() {
        return 2 + this.h.c() + this.biomes.c();
    }

    public boolean a(Predicate<IBlockData> predicate) {
        return this.h.a(predicate);
    }

    public Holder<BiomeBase> c(int x2, int y2, int z2) {
        return this.biomes.a(x2, y2, z2);
    }

    public void setBiome(int i2, int j2, int k2, Holder<BiomeBase> biome) {
        this.biomes.c(i2, j2, k2, biome);
    }

    public void a(BiomeResolver biomeSupplier, Climate.Sampler sampler, int x2, int y2, int z2) {
        DataPaletteBlock<Holder<BiomeBase>> datapaletteblock = this.biomes.e();
        boolean flag = true;
        for (int l2 = 0; l2 < 4; ++l2) {
            for (int i1 = 0; i1 < 4; ++i1) {
                for (int j1 = 0; j1 < 4; ++j1) {
                    datapaletteblock.b(l2, i1, j1, biomeSupplier.getNoiseBiome(x2 + l2, y2 + i1, z2 + j1, sampler));
                }
            }
        }
        this.biomes = datapaletteblock;
    }

    public ChunkSection k() {
        return new ChunkSection(this);
    }

    static {
        for (short i2 = 0; i2 < 4096; i2 = (short)(i2 + 1)) {
            FULL_LIST.add(i2);
        }
    }
}

