/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.starlight.chunk.StarlightChunk;
import ca.spottedleaf.moonrise.patches.starlight.light.SWMRNibbleArray;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightEngine;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.lighting.ChunkSkyLightSources;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.ticks.TickContainerAccess;
import net.minecraft.world.ticks.TickListChunk;
import org.bukkit.craftbukkit.v1_21_R2.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R2.persistence.DirtyCraftPersistentDataContainer;
import org.slf4j.Logger;

public abstract class IChunkAccess
implements BiomeManager.Provider,
LightChunk,
StructureAccess,
StarlightChunk {
    public static final int a = -1;
    private static final Logger n = LogUtils.getLogger();
    private static final LongSet o = new LongOpenHashSet();
    protected final ShortList[] b;
    private volatile boolean p;
    private volatile boolean q;
    protected final ChunkCoordIntPair c;
    public final long coordinateKey;
    public final int locX;
    public final int locZ;
    private long r;
    @Nullable
    @Deprecated
    private BiomeSettingsGeneration s;
    @Nullable
    protected NoiseChunk d;
    protected final ChunkConverter e;
    @Nullable
    protected BlendingData f;
    public final Map<HeightMap.Type, HeightMap> h = Maps.newEnumMap(HeightMap.Type.class);
    private final Map<Structure, StructureStart> t = Maps.newHashMap();
    private final Map<Structure, LongSet> u = Maps.newHashMap();
    protected final Map<BlockPosition, NBTTagCompound> j = Maps.newHashMap();
    public final Map<BlockPosition, TileEntity> k = new Object2ObjectOpenHashMap();
    protected final LevelHeightAccessor l;
    protected final ChunkSection[] m;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public DirtyCraftPersistentDataContainer persistentDataContainer = new DirtyCraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private volatile SWMRNibbleArray[] blockNibbles;
    private volatile SWMRNibbleArray[] skyNibbles;
    private volatile boolean[] skyEmptinessMap;
    private volatile boolean[] blockEmptinessMap;
    private final int minSection;
    private final int maxSection;
    public final IRegistry<BiomeBase> biomeRegistry;

    @Override
    public SWMRNibbleArray[] starlight$getBlockNibbles() {
        return this.blockNibbles;
    }

    @Override
    public void starlight$setBlockNibbles(SWMRNibbleArray[] nibbles) {
        this.blockNibbles = nibbles;
    }

    @Override
    public SWMRNibbleArray[] starlight$getSkyNibbles() {
        return this.skyNibbles;
    }

    @Override
    public void starlight$setSkyNibbles(SWMRNibbleArray[] nibbles) {
        this.skyNibbles = nibbles;
    }

    @Override
    public boolean[] starlight$getSkyEmptinessMap() {
        return this.skyEmptinessMap;
    }

    @Override
    public void starlight$setSkyEmptinessMap(boolean[] emptinessMap) {
        this.skyEmptinessMap = emptinessMap;
    }

    @Override
    public boolean[] starlight$getBlockEmptinessMap() {
        return this.blockEmptinessMap;
    }

    @Override
    public void starlight$setBlockEmptinessMap(boolean[] emptinessMap) {
        this.blockEmptinessMap = emptinessMap;
    }

    public IChunkAccess(ChunkCoordIntPair pos, ChunkConverter upgradeData, LevelHeightAccessor heightLimitView, IRegistry<BiomeBase> biomeRegistry, long inhabitedTime, @Nullable ChunkSection[] sectionArray, @Nullable BlendingData blendingData) {
        this.locX = pos.h;
        this.locZ = pos.i;
        this.c = pos;
        this.coordinateKey = ChunkCoordIntPair.c(this.locX, this.locZ);
        this.e = upgradeData;
        this.l = heightLimitView;
        this.m = new ChunkSection[heightLimitView.an()];
        this.r = inhabitedTime;
        this.b = new ShortList[heightLimitView.an()];
        this.f = blendingData;
        if (sectionArray != null) {
            if (this.m.length == sectionArray.length) {
                System.arraycopy(sectionArray, 0, this.m, 0, this.m.length);
            } else {
                n.warn("Could not set level chunk sections, array length is {} instead of {}", (Object)sectionArray.length, (Object)this.m.length);
            }
        }
        this.a(biomeRegistry, this.m);
        this.biomeRegistry = biomeRegistry;
        if (!(this instanceof ProtoChunkExtension)) {
            this.starlight$setBlockNibbles(StarLightEngine.getFilledEmptyLight(heightLimitView));
            this.starlight$setSkyNibbles(StarLightEngine.getFilledEmptyLight(heightLimitView));
        }
        this.minSection = WorldUtil.getMinSection(this.l);
        this.maxSection = WorldUtil.getMaxSection(this.l);
    }

    private void a(IRegistry<BiomeBase> biomeRegistry, ChunkSection[] sectionArray) {
        for (int i2 = 0; i2 < sectionArray.length; ++i2) {
            if (sectionArray[i2] != null) continue;
            sectionArray[i2] = new ChunkSection(biomeRegistry, this.l instanceof World ? (World)this.l : null, this.c, this.l.h(i2));
        }
    }

    public GameEventListenerRegistry a(int ySectionCoord) {
        return GameEventListenerRegistry.a;
    }

    public abstract IBlockData getBlockState(int var1, int var2, int var3);

    @Nullable
    public abstract IBlockData a(BlockPosition var1, IBlockData var2, boolean var3);

    public abstract void a(TileEntity var1);

    public abstract void a(Entity var1);

    public int a() {
        ChunkSection[] achunksection = this.d();
        for (int i2 = achunksection.length - 1; i2 >= 0; --i2) {
            ChunkSection chunksection = achunksection[i2];
            if (chunksection.c()) continue;
            return i2;
        }
        return -1;
    }

    @Deprecated(forRemoval=true)
    public int b() {
        int i2 = this.a();
        return i2 == -1 ? this.L_() : SectionPosition.c(this.h(i2));
    }

    public Set<BlockPosition> c() {
        HashSet set = Sets.newHashSet(this.j.keySet());
        set.addAll(this.k.keySet());
        return set;
    }

    public ChunkSection[] d() {
        return this.m;
    }

    public ChunkSection b(int yIndex) {
        return this.d()[yIndex];
    }

    public Collection<Map.Entry<HeightMap.Type, HeightMap>> e() {
        return Collections.unmodifiableSet(this.h.entrySet());
    }

    public void a(HeightMap.Type type, long[] heightmap) {
        this.a(type).a(this, type, heightmap);
    }

    public HeightMap a(HeightMap.Type type) {
        return this.h.computeIfAbsent(type, heightmap_type1 -> new HeightMap(this, (HeightMap.Type)heightmap_type1));
    }

    public boolean b(HeightMap.Type type) {
        return this.h.get(type) != null;
    }

    public int a(HeightMap.Type type, int x2, int z2) {
        HeightMap heightmap = this.h.get(type);
        if (heightmap == null) {
            if (SharedConstants.aU && this instanceof Chunk) {
                n.error("Unprimed heightmap: " + String.valueOf(type) + " " + x2 + " " + z2);
            }
            HeightMap.a(this, EnumSet.of(type));
            heightmap = this.h.get(type);
        }
        return heightmap.a(x2 & 0xF, z2 & 0xF) - 1;
    }

    public ChunkCoordIntPair f() {
        return this.c;
    }

    @Override
    @Nullable
    public StructureStart a(Structure structure) {
        return this.t.get(structure);
    }

    @Override
    public void a(Structure structure, StructureStart start) {
        this.t.put(structure, start);
        this.i();
    }

    public Map<Structure, StructureStart> g() {
        return Collections.unmodifiableMap(this.t);
    }

    public void a(Map<Structure, StructureStart> structureStarts) {
        this.t.clear();
        this.t.putAll(structureStarts);
        this.i();
    }

    @Override
    public LongSet b(Structure structure) {
        return this.u.getOrDefault(structure, o);
    }

    @Override
    public void a(Structure structure, long reference) {
        this.u.computeIfAbsent(structure, structure1 -> new LongOpenHashSet()).add(reference);
        this.i();
    }

    @Override
    public Map<Structure, LongSet> h() {
        return Collections.unmodifiableMap(this.u);
    }

    @Override
    public void b(Map<Structure, LongSet> structureReferences) {
        this.u.clear();
        this.u.putAll(structureReferences);
        this.i();
    }

    public boolean a(int lowerHeight, int upperHeight) {
        if (lowerHeight < this.L_()) {
            lowerHeight = this.L_();
        }
        if (upperHeight > this.am()) {
            upperHeight = this.am();
        }
        for (int k2 = lowerHeight; k2 <= upperHeight; k2 += 16) {
            if (this.b(this.f(k2)).c()) continue;
            return false;
        }
        return true;
    }

    public boolean c(int sectionCoord) {
        return this.b(this.g(sectionCoord)).c();
    }

    public void i() {
        this.p = true;
    }

    public boolean j() {
        if (this.p) {
            this.p = false;
            this.persistentDataContainer.dirty(false);
            return true;
        }
        return false;
    }

    public boolean k() {
        return this.p || this.persistentDataContainer.dirty();
    }

    public abstract ChunkStatus n();

    public ChunkStatus o() {
        ChunkStatus chunkstatus = this.n();
        BelowZeroRetrogen belowzeroretrogen = this.z();
        if (belowzeroretrogen != null) {
            ChunkStatus chunkstatus1 = belowzeroretrogen.a();
            return ChunkStatus.a(chunkstatus1, chunkstatus);
        }
        return chunkstatus;
    }

    public abstract void d(BlockPosition var1);

    public void e(BlockPosition pos) {
        n.warn("Trying to mark a block for PostProcessing @ {}, but this operation is not supported.", (Object)pos);
    }

    public ShortList[] p() {
        return this.b;
    }

    public void a(ShortList packedPositions, int index) {
        IChunkAccess.a(this.p(), index).addAll(packedPositions);
    }

    public void a(NBTTagCompound nbt) {
        this.j.put(TileEntity.b(nbt), nbt);
    }

    @Nullable
    public NBTTagCompound f(BlockPosition pos) {
        return this.j.get(pos);
    }

    @Nullable
    public abstract NBTTagCompound a(BlockPosition var1, HolderLookup.a var2);

    @Override
    public final void a(BiConsumer<BlockPosition, IBlockData> callback) {
        this.a((IBlockData iblockdata) -> iblockdata.k() != 0, callback);
    }

    public void a(Predicate<IBlockData> predicate, BiConsumer<BlockPosition, IBlockData> consumer) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int i2 = this.ao(); i2 <= this.ap(); ++i2) {
            ChunkSection chunksection = this.b(this.g(i2));
            if (!chunksection.a(predicate)) continue;
            BlockPosition blockposition = SectionPosition.a(this.c, i2).j();
            for (int j2 = 0; j2 < 16; ++j2) {
                for (int k2 = 0; k2 < 16; ++k2) {
                    for (int l2 = 0; l2 < 16; ++l2) {
                        IBlockData iblockdata = chunksection.a(l2, j2, k2);
                        if (!predicate.test(iblockdata)) continue;
                        consumer.accept(blockposition_mutableblockposition.a(blockposition, l2, j2, k2), iblockdata);
                    }
                }
            }
        }
    }

    public abstract TickContainerAccess<Block> q();

    public abstract TickContainerAccess<FluidType> r();

    public boolean s() {
        return true;
    }

    public abstract a a(long var1);

    public ChunkConverter t() {
        return this.e;
    }

    public boolean u() {
        return this.f != null;
    }

    @Nullable
    public BlendingData v() {
        return this.f;
    }

    public long w() {
        return this.r;
    }

    public void b(long delta) {
        this.r += delta;
    }

    public void c(long inhabitedTime) {
        this.r = inhabitedTime;
    }

    public static ShortList a(ShortList[] lists, int index) {
        if (lists[index] == null) {
            lists[index] = new ShortArrayList();
        }
        return lists[index];
    }

    public boolean x() {
        return this.q;
    }

    public void a(boolean lightOn) {
        this.q = lightOn;
        this.i();
    }

    @Override
    public int L_() {
        return this.l.L_();
    }

    @Override
    public int M_() {
        return this.l.M_();
    }

    public NoiseChunk a(Function<IChunkAccess, NoiseChunk> chunkNoiseSamplerCreator) {
        if (this.d == null) {
            this.d = chunkNoiseSamplerCreator.apply(this);
        }
        return this.d;
    }

    @Deprecated
    public BiomeSettingsGeneration a(Supplier<BiomeSettingsGeneration> generationSettingsCreator) {
        if (this.s == null) {
            this.s = generationSettingsCreator.get();
        }
        return this.s;
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int biomeX, int biomeY, int biomeZ) {
        int sectionY = (biomeY >> 2) - this.minSection;
        int rel = biomeY & 3;
        ChunkSection[] sections = this.m;
        if (sectionY < 0) {
            sectionY = 0;
            rel = 0;
        } else if (sectionY >= sections.length) {
            sectionY = sections.length - 1;
            rel = 3;
        }
        return sections[sectionY].c(biomeX & 3, rel, biomeZ & 3);
    }

    public void setBiome(int i2, int j2, int k2, Holder<BiomeBase> biome) {
        try {
            int l2 = QuartPos.a(this.L_());
            int i1 = l2 + QuartPos.a(this.M_()) - 1;
            int j1 = MathHelper.a(j2, l2, i1);
            int k1 = this.f(QuartPos.c(j1));
            this.m[k1].setBiome(i2 & 3, j1 & 3, k2 & 3, biome);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Setting biome");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Biome being set");
            crashreportsystemdetails.a("Location", () -> CrashReportSystemDetails.a((LevelHeightAccessor)this, i2, j2, k2));
            throw new ReportedException(crashreport);
        }
    }

    public void a(BiomeResolver biomeSupplier, Climate.Sampler sampler) {
        ChunkCoordIntPair chunkcoordintpair = this.f();
        int i2 = QuartPos.a(chunkcoordintpair.d());
        int j2 = QuartPos.a(chunkcoordintpair.e());
        LevelHeightAccessor levelheightaccessor = this.B();
        for (int k2 = levelheightaccessor.ao(); k2 <= levelheightaccessor.ap(); ++k2) {
            ChunkSection chunksection = this.b(this.g(k2));
            int l2 = QuartPos.d(k2);
            chunksection.a(biomeSupplier, sampler, i2, l2, j2);
        }
    }

    public boolean y() {
        return !this.h().isEmpty();
    }

    @Nullable
    public BelowZeroRetrogen z() {
        return null;
    }

    public boolean A() {
        return this.z() != null;
    }

    public LevelHeightAccessor B() {
        return this;
    }

    public void C() {
    }

    @Override
    public ChunkSkyLightSources D() {
        return null;
    }

    public record a(List<TickListChunk<Block>> a, List<TickListChunk<FluidType>> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "blocks;fluids", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "blocks;fluids", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "blocks;fluids", "a", "b"}, this, o2);
        }
    }
}

