/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTickList;
import net.minecraft.world.ticks.TickContainerAccess;

public class ProtoChunk
extends IChunkAccess {
    @Nullable
    private volatile LevelLightEngine n;
    private volatile ChunkStatus o = ChunkStatus.c;
    private final List<NBTTagCompound> p = Lists.newArrayList();
    @Nullable
    private CarvingMask q;
    @Nullable
    private BelowZeroRetrogen r;
    private final ProtoChunkTickList<Block> s;
    private final ProtoChunkTickList<FluidType> t;

    public ProtoChunk(ChunkCoordIntPair pos, ChunkConverter upgradeData, LevelHeightAccessor world, IRegistry<BiomeBase> biomeRegistry, @Nullable BlendingData blendingData) {
        this(pos, upgradeData, null, new ProtoChunkTickList<Block>(), new ProtoChunkTickList<FluidType>(), world, biomeRegistry, blendingData);
    }

    public ProtoChunk(ChunkCoordIntPair pos, ChunkConverter upgradeData, @Nullable ChunkSection[] sections, ProtoChunkTickList<Block> blockTickScheduler, ProtoChunkTickList<FluidType> fluidTickScheduler, LevelHeightAccessor world, IRegistry<BiomeBase> biomeRegistry, @Nullable BlendingData blendingData) {
        super(pos, upgradeData, world, biomeRegistry, 0L, sections, blendingData);
        this.s = blockTickScheduler;
        this.t = fluidTickScheduler;
    }

    @Override
    public TickContainerAccess<Block> q() {
        return this.s;
    }

    @Override
    public TickContainerAccess<FluidType> r() {
        return this.t;
    }

    @Override
    public IChunkAccess.a a(long time) {
        return new IChunkAccess.a(this.s.a(time), this.t.a(time));
    }

    @Override
    public final Fluid getFluidIfLoaded(BlockPosition blockposition) {
        return this.b_(blockposition);
    }

    @Override
    public final IBlockData getBlockStateIfLoaded(BlockPosition blockposition) {
        return this.a_(blockposition);
    }

    @Override
    public IBlockData a_(BlockPosition pos) {
        return this.getBlockState(pos.u(), pos.v(), pos.w());
    }

    @Override
    public IBlockData getBlockState(int x2, int y2, int z2) {
        if (this.e(y2)) {
            return Blocks.nw.m();
        }
        ChunkSection levelChunkSection = this.d()[this.f(y2)];
        return levelChunkSection.c() ? Blocks.a.m() : levelChunkSection.a(x2 & 0xF, y2 & 0xF, z2 & 0xF);
    }

    @Override
    public Fluid b_(BlockPosition pos) {
        int i2 = pos.v();
        if (this.e(i2)) {
            return FluidTypes.a.g();
        }
        ChunkSection levelChunkSection = this.b(this.f(i2));
        return levelChunkSection.c() ? FluidTypes.a.g() : levelChunkSection.b(pos.u() & 0xF, i2 & 0xF, pos.w() & 0xF);
    }

    @Override
    @Nullable
    public IBlockData a(BlockPosition pos, IBlockData state, boolean moved) {
        int i2 = pos.u();
        int j2 = pos.v();
        int k2 = pos.w();
        if (this.e(j2)) {
            return Blocks.nw.m();
        }
        int l2 = this.f(j2);
        ChunkSection levelChunkSection = this.b(l2);
        boolean bl = levelChunkSection.c();
        if (bl && state.a(Blocks.a)) {
            return state;
        }
        int m2 = SectionPosition.b(i2);
        int n2 = SectionPosition.b(j2);
        int o2 = SectionPosition.b(k2);
        IBlockData blockState = levelChunkSection.a(m2, n2, o2, state);
        if (this.o.a(ChunkStatus.k)) {
            boolean bl2 = levelChunkSection.c();
            if (bl2 != bl) {
                this.n.a(pos, bl2);
            }
            if (LightEngine.a(blockState, state)) {
                this.n.a(pos);
            }
        }
        EnumSet<HeightMap.Type> enumSet = this.n().e();
        EnumSet<HeightMap.Type> enumSet2 = null;
        for (HeightMap.Type types : enumSet) {
            HeightMap heightmap = this.h.get(types);
            if (heightmap != null) continue;
            if (enumSet2 == null) {
                enumSet2 = EnumSet.noneOf(HeightMap.Type.class);
            }
            enumSet2.add(types);
        }
        if (enumSet2 != null) {
            HeightMap.a(this, enumSet2);
        }
        for (HeightMap.Type types2 : enumSet) {
            this.h.get(types2).a(m2, j2, o2, state);
        }
        return blockState;
    }

    @Override
    public void a(TileEntity blockEntity) {
        this.k.put(blockEntity.aB_(), blockEntity);
    }

    @Override
    @Nullable
    public TileEntity c_(BlockPosition pos) {
        return this.k.get(pos);
    }

    public Map<BlockPosition, TileEntity> H() {
        return this.k;
    }

    public void b(NBTTagCompound entityNbt) {
        this.p.add(entityNbt);
    }

    @Override
    public void a(Entity entity) {
        if (!entity.bZ()) {
            NBTTagCompound compoundTag = new NBTTagCompound();
            entity.e(compoundTag);
            this.b(compoundTag);
        }
    }

    @Override
    public void a(Structure structure, StructureStart start) {
        BelowZeroRetrogen belowZeroRetrogen = this.z();
        if (belowZeroRetrogen != null && start.b()) {
            StructureBoundingBox boundingBox = start.a();
            LevelHeightAccessor levelHeightAccessor = this.B();
            if (boundingBox.i() < levelHeightAccessor.L_() || boundingBox.l() > levelHeightAccessor.am()) {
                return;
            }
        }
        super.a(structure, start);
    }

    public List<NBTTagCompound> I() {
        return this.p;
    }

    @Override
    public ChunkStatus n() {
        return this.o;
    }

    public void a(ChunkStatus status) {
        this.o = status;
        if (this.r != null && status.a(this.r.a())) {
            this.a((BelowZeroRetrogen)null);
        }
        this.i();
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int biomeX, int biomeY, int biomeZ) {
        if (this.o().a(ChunkStatus.f)) {
            return super.getNoiseBiome(biomeX, biomeY, biomeZ);
        }
        throw new IllegalStateException("Asking for biomes before we have biomes");
    }

    public static short g(BlockPosition pos) {
        int i2 = pos.u();
        int j2 = pos.v();
        int k2 = pos.w();
        int l2 = i2 & 0xF;
        int m2 = j2 & 0xF;
        int n2 = k2 & 0xF;
        return (short)(l2 | m2 << 4 | n2 << 8);
    }

    public static BlockPosition a(short sectionRel, int sectionY, ChunkCoordIntPair chunkPos) {
        int i2 = SectionPosition.a(chunkPos.h, sectionRel & 0xF);
        int j2 = SectionPosition.a(sectionY, sectionRel >>> 4 & 0xF);
        int k2 = SectionPosition.a(chunkPos.i, sectionRel >>> 8 & 0xF);
        return new BlockPosition(i2, j2, k2);
    }

    @Override
    public void e(BlockPosition pos) {
        if (!this.s(pos)) {
            IChunkAccess.a(this.b, this.f(pos.v())).add(ProtoChunk.g(pos));
        }
    }

    @Override
    public void a(ShortList packedPositions, int index) {
        IChunkAccess.a(this.b, index).addAll(packedPositions);
    }

    public Map<BlockPosition, NBTTagCompound> J() {
        return Collections.unmodifiableMap(this.j);
    }

    @Override
    @Nullable
    public NBTTagCompound a(BlockPosition pos, HolderLookup.a registries) {
        TileEntity blockEntity = this.c_(pos);
        return blockEntity != null ? blockEntity.b(registries) : this.j.get(pos);
    }

    @Override
    public void d(BlockPosition pos) {
        this.k.remove(pos);
        this.j.remove(pos);
    }

    @Nullable
    public CarvingMask E() {
        return this.q;
    }

    public CarvingMask F() {
        if (this.q == null) {
            this.q = new CarvingMask(this.M_(), this.L_());
        }
        return this.q;
    }

    public void a(CarvingMask carvingMask) {
        this.q = carvingMask;
    }

    public void a(LevelLightEngine lightingProvider) {
        this.n = lightingProvider;
    }

    public void a(@Nullable BelowZeroRetrogen belowZeroRetrogen) {
        this.r = belowZeroRetrogen;
    }

    @Override
    @Nullable
    public BelowZeroRetrogen z() {
        return this.r;
    }

    private static <T> LevelChunkTicks<T> a(ProtoChunkTickList<T> tickScheduler) {
        return new LevelChunkTicks<T>(tickScheduler.b());
    }

    public LevelChunkTicks<Block> K() {
        return ProtoChunk.a(this.s);
    }

    public LevelChunkTicks<FluidType> L() {
        return ProtoChunk.a(this.t);
    }

    @Override
    public LevelHeightAccessor B() {
        return this.A() ? BelowZeroRetrogen.b : this;
    }
}

