/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.status;

import io.papermc.paper.configuration.WorldConfiguration;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.StaticCache2D;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.Blender;
import org.bukkit.event.entity.EntityRemoveEvent;

public class ChunkStatusTasks {
    private static boolean a(IChunkAccess chunk) {
        return chunk.n().a(ChunkStatus.l) && chunk.x();
    }

    static CompletableFuture<IChunkAccess> a(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, IChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<IChunkAccess> b(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, IChunkAccess chunk) {
        WorldServer worldserver = context.a();
        if (worldserver.L.y().d()) {
            context.b().a(worldserver.K_(), worldserver.m().h(), worldserver.b(), chunk, context.c());
        }
        worldserver.a(chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<IChunkAccess> c(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, IChunkAccess chunk) {
        context.a().a(chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<IChunkAccess> d(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, IChunkAccess chunk) {
        WorldServer worldserver = context.a();
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, chunks, step, chunk);
        context.b().a((GeneratorAccessSeed)regionlimitedworldaccess, worldserver.b().a(regionlimitedworldaccess), chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<IChunkAccess> e(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, IChunkAccess chunk) {
        WorldServer worldserver = context.a();
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, chunks, step, chunk);
        return context.b().a(worldserver.m().i(), Blender.a(regionlimitedworldaccess), worldserver.b().a(regionlimitedworldaccess), chunk);
    }

    static CompletableFuture<IChunkAccess> f(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, IChunkAccess chunk) {
        WorldServer worldserver = context.a();
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, chunks, step, chunk);
        return context.b().a(Blender.a(regionlimitedworldaccess), worldserver.m().i(), worldserver.b().a(regionlimitedworldaccess), chunk).thenApply(ichunkaccess1 -> {
            ProtoChunk protochunk;
            BelowZeroRetrogen belowzeroretrogen;
            if (ichunkaccess1 instanceof ProtoChunk && (belowzeroretrogen = (protochunk = (ProtoChunk)ichunkaccess1).z()) != null) {
                BelowZeroRetrogen.a(protochunk);
                if (belowzeroretrogen.b()) {
                    belowzeroretrogen.b(protochunk);
                }
            }
            return ichunkaccess1;
        });
    }

    static CompletableFuture<IChunkAccess> g(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, IChunkAccess chunk) {
        WorldServer worldserver = context.a();
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, chunks, step, chunk);
        context.b().a(regionlimitedworldaccess, worldserver.b().a(regionlimitedworldaccess), worldserver.m().i(), chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<IChunkAccess> h(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, IChunkAccess chunk) {
        WorldServer worldserver = context.a();
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, chunks, step, chunk);
        if (chunk instanceof ProtoChunk) {
            ProtoChunk protochunk = (ProtoChunk)chunk;
            Blender.a((GeneratorAccessSeed)regionlimitedworldaccess, protochunk);
        }
        context.b().a(regionlimitedworldaccess, worldserver.D(), worldserver.m().i(), worldserver.I_(), worldserver.b().a(regionlimitedworldaccess), chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<IChunkAccess> i(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, IChunkAccess chunk) {
        WorldServer worldserver = context.a();
        HeightMap.a(chunk, EnumSet.of(HeightMap.Type.e, HeightMap.Type.f, HeightMap.Type.d, HeightMap.Type.b));
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, chunks, step, chunk);
        context.b().a((GeneratorAccessSeed)regionlimitedworldaccess, chunk, worldserver.b().a(regionlimitedworldaccess));
        Blender.a(regionlimitedworldaccess, chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<IChunkAccess> j(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, IChunkAccess chunk) {
        LightEngineThreaded lightenginethreaded = context.d();
        chunk.C();
        ((ProtoChunk)chunk).a(lightenginethreaded);
        boolean flag = ChunkStatusTasks.a(chunk);
        return lightenginethreaded.a(chunk, flag);
    }

    static CompletableFuture<IChunkAccess> k(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, IChunkAccess chunk) {
        boolean flag = ChunkStatusTasks.a(chunk);
        return context.d().b(chunk, flag);
    }

    static CompletableFuture<IChunkAccess> l(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, IChunkAccess chunk) {
        if (!chunk.A()) {
            context.b().a(new RegionLimitedWorldAccess(context.a(), chunks, step, chunk));
        }
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<IChunkAccess> m(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, IChunkAccess chunk) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        GenerationChunkHolder generationchunkholder = chunks.a(chunkcoordintpair.h, chunkcoordintpair.i);
        return CompletableFuture.supplyAsync(() -> {
            Chunk chunk1;
            ProtoChunk protochunk = (ProtoChunk)chunk;
            WorldServer worldserver = context.a();
            if (protochunk instanceof ProtoChunkExtension) {
                ProtoChunkExtension protochunkextension = (ProtoChunkExtension)protochunk;
                chunk1 = protochunkextension.G();
            } else {
                chunk1 = new Chunk(worldserver, protochunk, $ -> ChunkStatusTasks.postLoadProtoChunk(worldserver, protochunk.I(), protochunk.f()));
                generationchunkholder.a(new ProtoChunkExtension(chunk1, false));
            }
            Objects.requireNonNull(generationchunkholder);
            chunk1.b(generationchunkholder::s);
            chunk1.G();
            chunk1.b(true);
            chunk1.K();
            chunk1.b(worldserver);
            chunk1.a(context.f());
            return chunk1;
        }, context.e());
    }

    public static void postLoadProtoChunk(WorldServer world, List<NBTTagCompound> entities, ChunkCoordIntPair pos) {
        if (!entities.isEmpty()) {
            world.addWorldGenChunkEntities(EntityTypes.a(entities, (World)world, EntitySpawnReason.r).filter(entity -> {
                boolean needsRemoval = false;
                DedicatedServer server = world.getCraftServer().getServer();
                if (!world.m().k && (entity instanceof EntityAnimal || entity instanceof EntityWaterAnimal)) {
                    entity.discard(null);
                    needsRemoval = true;
                }
                ChunkStatusTasks.checkDupeUUID(world, entity);
                return !needsRemoval;
            }), pos);
        }
    }

    public static boolean checkDupeUUID(WorldServer level, Entity entity) {
        WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode mode = level.paperConfig().entities.spawning.duplicateUuid.mode;
        if (mode != WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.WARN && mode != WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.DELETE && mode != WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.SAFE_REGEN) {
            return false;
        }
        Entity other = level.a(entity.cG());
        if (other == null || other == entity) {
            return false;
        }
        if (mode == WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.SAFE_REGEN && other != null && !other.dR() && Objects.equals(other.bK(), entity.bK()) && entity.getBukkitEntity().getLocation().distance(other.getBukkitEntity().getLocation()) < (double)level.paperConfig().entities.spawning.duplicateUuid.safeRegenDeleteRange) {
            entity.discard(null);
            return true;
        }
        if (!other.dR()) {
            switch (mode) {
                case SAFE_REGEN: {
                    entity.a_(UUID.randomUUID());
                    break;
                }
                case DELETE: {
                    entity.discard(EntityRemoveEvent.Cause.DISCARD);
                    return true;
                }
            }
        }
        return false;
    }
}

