/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.status;

import ca.spottedleaf.moonrise.patches.chunk_system.status.ChunkSystemChunkStep;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkDependencies;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStatusTask;
import net.minecraft.world.level.chunk.status.ChunkStatusTasks;
import net.minecraft.world.level.chunk.status.WorldGenContext;

public final class ChunkStep
implements ChunkSystemChunkStep {
    private final ChunkStatus a;
    private final ChunkDependencies b;
    private final ChunkDependencies c;
    private final int d;
    private final ChunkStatusTask e;
    private final ChunkStatus[] byRadius;

    public ChunkStep(ChunkStatus targetStatus, ChunkDependencies directDependencies, ChunkDependencies accumulatedDependencies, int blockStateWriteRadius, ChunkStatusTask task) {
        this.a = targetStatus;
        this.b = directDependencies;
        this.c = accumulatedDependencies;
        this.d = blockStateWriteRadius;
        this.e = task;
        this.byRadius = new ChunkStatus[this.a(ChunkStatus.c) + 1];
        this.byRadius[0] = targetStatus.c();
        for (ChunkStatus status = targetStatus.c(); status != ChunkStatus.c; status = status.c()) {
            int radius = this.a(status);
            for (int j2 = 0; j2 <= radius; ++j2) {
                if (this.byRadius[j2] != null) continue;
                this.byRadius[j2] = status;
            }
        }
    }

    @Override
    public final ChunkStatus moonrise$getRequiredStatusAtRadius(int radius) {
        return this.byRadius[radius];
    }

    public int a(ChunkStatus status) {
        return status == this.a ? 0 : this.c.a(status);
    }

    public CompletableFuture<IChunkAccess> a(WorldGenContext context, StaticCache2D<GenerationChunkHolder> staticCache2D, IChunkAccess chunk) {
        if (chunk.n().d(this.a)) {
            ProfiledDuration profiledDuration = JvmProfiler.f.a(chunk.f(), context.a().ah(), this.a.f());
            return this.e.doWork(context, this, staticCache2D, chunk).thenApply(generated -> this.a((IChunkAccess)generated, profiledDuration));
        }
        return this.e.doWork(context, this, staticCache2D, chunk);
    }

    private IChunkAccess a(IChunkAccess chunk, @Nullable ProfiledDuration finishCallback) {
        ProtoChunk protoChunk;
        if (chunk instanceof ProtoChunk && (protoChunk = (ProtoChunk)chunk).n().d(this.a)) {
            protoChunk.a(this.a);
        }
        if (finishCallback != null) {
            finishCallback.finish();
        }
        return chunk;
    }

    public ChunkStatus a() {
        return this.a;
    }

    public ChunkDependencies b() {
        return this.b;
    }

    public ChunkDependencies c() {
        return this.c;
    }

    public int d() {
        return this.d;
    }

    public ChunkStatusTask e() {
        return this.e;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ChunkStep that = (ChunkStep)obj;
        return Objects.equals(this.a, that.a) && Objects.equals(this.b, that.b) && Objects.equals(this.c, that.c) && this.d == that.d && Objects.equals(this.e, that.e);
    }

    public int hashCode() {
        return Objects.hash(this.a, this.b, this.c, this.d, this.e);
    }

    public String toString() {
        return "ChunkStep[targetStatus=" + String.valueOf(this.a) + ", directDependencies=" + String.valueOf(this.b) + ", accumulatedDependencies=" + String.valueOf(this.c) + ", blockStateWriteRadius=" + this.d + ", task=" + String.valueOf(this.e) + "]";
    }

    public static class a {
        private final ChunkStatus a;
        @Nullable
        private final ChunkStep b;
        private ChunkStatus[] c;
        private int d = -1;
        private ChunkStatusTask e = ChunkStatusTasks::a;

        protected a(ChunkStatus targetStatus) {
            if (targetStatus.c() != targetStatus) {
                throw new IllegalArgumentException("Not starting with the first status: " + String.valueOf(targetStatus));
            }
            this.a = targetStatus;
            this.b = null;
            this.c = new ChunkStatus[0];
        }

        protected a(ChunkStatus blockStateWriteRadius, ChunkStep previousStep) {
            if (previousStep.a.b() != blockStateWriteRadius.b() - 1) {
                throw new IllegalArgumentException("Out of order status: " + String.valueOf(blockStateWriteRadius));
            }
            this.a = blockStateWriteRadius;
            this.b = previousStep;
            this.c = new ChunkStatus[]{previousStep.a};
        }

        public a a(ChunkStatus status, int level) {
            if (status.a(this.a)) {
                throw new IllegalArgumentException("Status " + String.valueOf(status) + " can not be required by " + String.valueOf(this.a));
            }
            int i2 = level + 1;
            ChunkStatus[] chunkStatuss = this.c;
            if (i2 > chunkStatuss.length) {
                this.c = new ChunkStatus[i2];
                Arrays.fill(this.c, status);
            }
            for (int j2 = 0; j2 < Math.min(i2, chunkStatuss.length); ++j2) {
                this.c[j2] = ChunkStatus.a(chunkStatuss[j2], status);
            }
            return this;
        }

        public a a(int blockStateWriteRadius) {
            this.d = blockStateWriteRadius;
            return this;
        }

        public a a(ChunkStatusTask task) {
            this.e = task;
            return this;
        }

        public ChunkStep a() {
            return new ChunkStep(this.a, new ChunkDependencies((ImmutableList<ChunkStatus>)ImmutableList.copyOf((Object[])this.c)), new ChunkDependencies((ImmutableList<ChunkStatus>)ImmutableList.copyOf((Object[])this.b())), this.d, this.e);
        }

        private ChunkStatus[] b() {
            if (this.b == null) {
                return this.c;
            }
            int i2 = this.a(this.b.a);
            ChunkDependencies chunkDependencies = this.b.c;
            ChunkStatus[] chunkStatuss = new ChunkStatus[Math.max(i2 + chunkDependencies.b(), this.c.length)];
            for (int j2 = 0; j2 < chunkStatuss.length; ++j2) {
                int k2 = j2 - i2;
                chunkStatuss[j2] = k2 < 0 || k2 >= chunkDependencies.b() ? this.c[j2] : (j2 >= this.c.length ? chunkDependencies.a(k2) : ChunkStatus.a(this.c[j2], chunkDependencies.a(k2)));
            }
            return chunkStatuss;
        }

        private int a(ChunkStatus status) {
            for (int i2 = this.c.length - 1; i2 >= 0; --i2) {
                if (!this.c[i2].a(status)) continue;
                return i2;
            }
            return 0;
        }
    }
}

