/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import net.minecraft.util.FastBufferedInputStream;
import org.slf4j.Logger;

public class RegionFileCompression {
    private static final Logger g = LogUtils.getLogger();
    public static final Int2ObjectMap<RegionFileCompression> h = new Int2ObjectOpenHashMap();
    private static final Object2ObjectMap<String, RegionFileCompression> i = new Object2ObjectOpenHashMap();
    public static final RegionFileCompression a = RegionFileCompression.a(new RegionFileCompression(1, null, stream -> new FastBufferedInputStream(new GZIPInputStream((InputStream)stream)), stream -> new BufferedOutputStream(new GZIPOutputStream((OutputStream)stream))));
    public static final RegionFileCompression b = RegionFileCompression.a(new RegionFileCompression(2, "deflate", stream -> new FastBufferedInputStream(new InflaterInputStream((InputStream)stream)), stream -> new BufferedOutputStream(new DeflaterOutputStream((OutputStream)stream))));
    public static final RegionFileCompression c = RegionFileCompression.a(new RegionFileCompression(3, "none", FastBufferedInputStream::new, BufferedOutputStream::new));
    public static final RegionFileCompression d = RegionFileCompression.a(new RegionFileCompression(4, "lz4", stream -> new FastBufferedInputStream((InputStream)new LZ4BlockInputStream(stream)), stream -> new BufferedOutputStream((OutputStream)new LZ4BlockOutputStream(stream))));
    public static final RegionFileCompression e = RegionFileCompression.a(new RegionFileCompression(127, null, stream -> {
        throw new UnsupportedOperationException();
    }, stream -> {
        throw new UnsupportedOperationException();
    }));
    public static final RegionFileCompression f;
    private static volatile RegionFileCompression j;
    private final int k;
    @Nullable
    private final String l;
    private final a<InputStream> m;
    private final a<OutputStream> n;

    public static RegionFileCompression getCompressionFormat() {
        return switch (GlobalConfiguration.get().unsupportedSettings.compressionFormat) {
            default -> throw new MatchException(null, null);
            case GlobalConfiguration.UnsupportedSettings.CompressionFormat.GZIP -> a;
            case GlobalConfiguration.UnsupportedSettings.CompressionFormat.ZLIB -> b;
            case GlobalConfiguration.UnsupportedSettings.CompressionFormat.NONE -> c;
        };
    }

    private RegionFileCompression(int id, @Nullable String name, a<InputStream> inputStreamWrapper, a<OutputStream> outputStreamWrapper) {
        this.k = id;
        this.l = name;
        this.m = inputStreamWrapper;
        this.n = outputStreamWrapper;
    }

    private static RegionFileCompression a(RegionFileCompression version) {
        h.put(version.k, (Object)version);
        if (version.l != null) {
            i.put((Object)version.l, (Object)version);
        }
        return version;
    }

    @Nullable
    public static RegionFileCompression a(int id) {
        return (RegionFileCompression)h.get(id);
    }

    public static void a(String name) {
        RegionFileCompression regionFileVersion = (RegionFileCompression)i.get((Object)name);
        if (regionFileVersion != null) {
            j = regionFileVersion;
        } else {
            g.error("Invalid `region-file-compression` value `{}` in server.properties. Please use one of: {}", (Object)name, (Object)String.join((CharSequence)", ", (Iterable<? extends CharSequence>)i.keySet()));
        }
    }

    public static RegionFileCompression a() {
        return j;
    }

    public static boolean b(int id) {
        return h.containsKey(id);
    }

    public int b() {
        return this.k;
    }

    public OutputStream a(OutputStream outputStream) throws IOException {
        return this.n.wrap(outputStream);
    }

    public InputStream a(InputStream inputStream) throws IOException {
        return this.m.wrap(inputStream);
    }

    static {
        j = f = b;
    }

    @FunctionalInterface
    static interface a<O> {
        public O wrap(O var1) throws IOException;
    }
}

