/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.moonrise.patches.chunk_system.level.storage.ChunkSystemSectionStorage;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTBase;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.slf4j.Logger;

public class RegionFileSection<R, P>
implements AutoCloseable,
ChunkSystemSectionStorage {
    static final Logger a = LogUtils.getLogger();
    private static final String b = "Sections";
    private final Long2ObjectMap<Optional<R>> e = new Long2ObjectOpenHashMap();
    private final LongLinkedOpenHashSet f = new LongLinkedOpenHashSet();
    private final Codec<P> g;
    private final Function<R, P> h;
    private final BiFunction<P, Runnable, R> i;
    private final Function<Runnable, R> j;
    private final IRegistryCustom k;
    private final ChunkIOErrorReporter l;
    protected final LevelHeightAccessor c;
    private final LongSet m = new LongOpenHashSet();
    private final Long2ObjectMap<CompletableFuture<Optional<a<P>>>> n = new Long2ObjectOpenHashMap();
    private final Object o = new Object();
    private final RegionFileCache regionStorage;

    @Override
    public final RegionFileCache moonrise$getRegionStorage() {
        return this.regionStorage;
    }

    @Override
    public void moonrise$close() throws IOException {
    }

    public RegionFileSection(SimpleRegionStorage storageAccess, Codec<P> codec, Function<R, P> serializer, BiFunction<P, Runnable, R> deserializer, Function<Runnable, R> factory, IRegistryCustom registryManager, ChunkIOErrorReporter errorHandler, LevelHeightAccessor world) {
        this.g = codec;
        this.h = serializer;
        this.i = deserializer;
        this.j = factory;
        this.k = registryManager;
        this.l = errorHandler;
        this.c = world;
        this.regionStorage = storageAccess.a.d;
    }

    protected void a(BooleanSupplier shouldKeepTicking) {
        LongListIterator longIterator = this.f.iterator();
        while (longIterator.hasNext() && shouldKeepTicking.getAsBoolean()) {
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(longIterator.nextLong());
            longIterator.remove();
            this.e(chunkPos);
        }
        this.c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c() {
        Object object = this.o;
        synchronized (object) {
            ObjectIterator iterator = Long2ObjectMaps.fastIterator(this.n);
            while (iterator.hasNext()) {
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
                Optional optional = ((CompletableFuture)entry.getValue()).getNow(null);
                if (optional == null) continue;
                long l2 = entry.getLongKey();
                this.a(new ChunkCoordIntPair(l2), (a<P>)optional.orElse(null));
                iterator.remove();
                this.m.add(l2);
            }
        }
    }

    public void a() {
        if (!this.f.isEmpty()) {
            this.f.forEach(chunkPos -> this.e(new ChunkCoordIntPair(chunkPos)));
            this.f.clear();
        }
    }

    public boolean b() {
        return !this.f.isEmpty();
    }

    @Nullable
    public Optional<R> c(long pos) {
        return (Optional)this.e.get(pos);
    }

    public Optional<R> d(long pos) {
        if (this.e(pos)) {
            return Optional.empty();
        }
        Optional<R> optional = this.c(pos);
        if (optional != null) {
            return optional;
        }
        this.c(SectionPosition.a(pos).r());
        optional = this.c(pos);
        if (optional == null) {
            throw SystemUtils.b(new IllegalStateException());
        }
        return optional;
    }

    protected boolean e(long pos) {
        int i2 = SectionPosition.c(SectionPosition.c(pos));
        return this.c.e(i2);
    }

    protected R f(long pos) {
        if (this.e(pos)) {
            throw SystemUtils.b(new IllegalArgumentException("sectionPos out of bounds"));
        }
        Optional<R> optional = this.d(pos);
        if (optional.isPresent()) {
            return optional.get();
        }
        R object = this.j.apply(() -> this.a(pos));
        this.e.put(pos, Optional.of(object));
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<?> a(ChunkCoordIntPair chunkPos) {
        Object object = this.o;
        synchronized (object) {
            long l2 = chunkPos.a();
            return this.m.contains(l2) ? CompletableFuture.completedFuture(null) : (CompletableFuture)this.n.computeIfAbsent(l2, pos -> this.d(chunkPos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c(ChunkCoordIntPair chunkPos) {
        CompletableFuture completableFuture;
        long l2 = chunkPos.a();
        Object object = this.o;
        synchronized (object) {
            if (!this.m.add(l2)) {
                return;
            }
            completableFuture = (CompletableFuture)this.n.computeIfAbsent(l2, pos -> this.d(chunkPos));
        }
        this.a(chunkPos, (a<P>)((Optional)completableFuture.join()).orElse(null));
        object = this.o;
        synchronized (object) {
            this.n.remove(l2);
        }
    }

    private CompletableFuture<Optional<a<P>>> d(ChunkCoordIntPair chunkPos) {
        throw new IllegalStateException("Only chunk system can write state, offending class:" + this.getClass().getName());
    }

    private void a(ChunkCoordIntPair chunkPos, @Nullable a<P> result) {
        throw new IllegalStateException("Only chunk system can load in state, offending class:" + this.getClass().getName());
    }

    private void e(ChunkCoordIntPair pos) {
        throw new IllegalStateException("Only chunk system can write state, offending class:" + this.getClass().getName());
    }

    private <T> Dynamic<T> a(ChunkCoordIntPair chunkPos, DynamicOps<T> ops) {
        HashMap map = Maps.newHashMap();
        for (int i2 = this.c.ao(); i2 <= this.c.ap(); ++i2) {
            long l2 = RegionFileSection.a(chunkPos, i2);
            Optional optional = (Optional)this.e.get(l2);
            if (optional == null || optional.isEmpty()) continue;
            DataResult dataResult = this.g.encodeStart(ops, this.h.apply(optional.get()));
            String string = Integer.toString(i2);
            dataResult.resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(value -> map.put(ops.createString(string), value));
        }
        return new Dynamic<Object>(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString(b), (Object)ops.createMap((Map)map), (Object)ops.createString("DataVersion"), (Object)ops.createInt(SharedConstants.b().d().c()))));
    }

    private static long a(ChunkCoordIntPair chunkPos, int y2) {
        return SectionPosition.b(chunkPos.h, y2, chunkPos.i);
    }

    protected void b(long pos) {
    }

    public void a(long pos) {
        Optional optional = (Optional)this.e.get(pos);
        if (optional != null && !optional.isEmpty()) {
            this.f.add(ChunkCoordIntPair.c(SectionPosition.b(pos), SectionPosition.d(pos)));
        } else {
            a.warn("No data for position: {}", (Object)SectionPosition.a(pos));
        }
    }

    static int a(Dynamic<?> dynamic) {
        return dynamic.get("DataVersion").asInt(1945);
    }

    public void b(ChunkCoordIntPair pos) {
        if (this.f.remove(pos.a())) {
            this.e(pos);
        }
    }

    @Override
    public void close() throws IOException {
        this.moonrise$close();
    }

    record a<T>(Int2ObjectMap<T> a, boolean b) {
        public static <T> a<T> a(Codec<T> sectionCodec, DynamicOps<NBTBase> ops, NBTBase nbt, SimpleRegionStorage storage, LevelHeightAccessor world) {
            int j2;
            Dynamic<NBTBase> dynamic = new Dynamic<NBTBase>(ops, nbt);
            int i2 = RegionFileSection.a(dynamic);
            boolean bl = i2 != (j2 = SharedConstants.b().d().c());
            Dynamic<NBTBase> dynamic2 = storage.a(dynamic, i2);
            OptionalDynamic<NBTBase> optionalDynamic = dynamic2.get(RegionFileSection.b);
            Int2ObjectOpenHashMap int2ObjectMap = new Int2ObjectOpenHashMap();
            for (int k2 = world.ao(); k2 <= world.ap(); ++k2) {
                Optional optional = optionalDynamic.get(Integer.toString(k2)).result().flatMap(section -> sectionCodec.parse(section).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)));
                if (!optional.isPresent()) continue;
                int2ObjectMap.put(k2, optional.get());
            }
            return new a<T>(int2ObjectMap, bl);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "sectionsByY;versionChanged", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "sectionsByY;versionChanged", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "sectionsByY;versionChanged", "a", "b"}, this, o2);
        }
    }
}

