/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.moonrise.common.util.MixinWorkarounds;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.starlight.light.SWMRNibbleArray;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightEngine;
import ca.spottedleaf.moonrise.patches.starlight.storage.StarlightSectionData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NbtException;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTickList;
import net.minecraft.world.ticks.TickListChunk;
import org.slf4j.Logger;

public final class SerializableChunkData
extends Record {
    private final IRegistry<BiomeBase> h;
    private final ChunkCoordIntPair i;
    private final int j;
    private final long k;
    private final long l;
    private final ChunkStatus m;
    @Nullable
    private final BlendingData.d n;
    @Nullable
    private final BelowZeroRetrogen o;
    private final ChunkConverter p;
    @Nullable
    private final long[] q;
    private final Map<HeightMap.Type, long[]> r;
    private final IChunkAccess.a s;
    private final ShortList[] t;
    private final boolean u;
    private final List<b> v;
    private final List<NBTTagCompound> w;
    private final List<NBTTagCompound> x;
    private final NBTTagCompound y;
    @Nullable
    private final NBTBase persistentDataContainer;
    public static final Codec<DataPaletteBlock<IBlockData>> z = DataPaletteBlock.codecRW(Block.q, IBlockData.a, DataPaletteBlock.d.d, Blocks.a.m(), null);
    private static final Logger A = LogUtils.getLogger();
    private static final String B = "UpgradeData";
    private static final String C = "block_ticks";
    private static final String D = "fluid_ticks";
    public static final String a = "xPos";
    public static final String b = "zPos";
    public static final String c = "Heightmaps";
    public static final String d = "isLightOn";
    public static final String e = "sections";
    public static final String f = "BlockLight";
    public static final String g = "SkyLight";
    private static final int CURRENT_DATA_VERSION = SharedConstants.b().d().c();
    private static final boolean JUST_CORRUPT_IT = Boolean.getBoolean("Paper.ignoreWorldDataVersion");

    public SerializableChunkData(IRegistry<BiomeBase> biomeRegistry, ChunkCoordIntPair chunkPos, int minSectionY, long lastUpdateTime, long inhabitedTime, ChunkStatus chunkStatus, @Nullable BlendingData.d blendingData, @Nullable BelowZeroRetrogen belowZeroRetrogen, ChunkConverter upgradeData, @Nullable long[] carvingMask, Map<HeightMap.Type, long[]> heightmaps, IChunkAccess.a packedTicks, ShortList[] postProcessingSections, boolean lightCorrect, List<b> sectionData, List<NBTTagCompound> entities, List<NBTTagCompound> blockEntities, NBTTagCompound structureData, @Nullable NBTBase persistentDataContainer) {
        this.h = biomeRegistry;
        this.i = chunkPos;
        this.j = minSectionY;
        this.k = lastUpdateTime;
        this.l = inhabitedTime;
        this.m = chunkStatus;
        this.n = blendingData;
        this.o = belowZeroRetrogen;
        this.p = upgradeData;
        this.q = carvingMask;
        this.r = heightmaps;
        this.s = packedTicks;
        this.t = postProcessingSections;
        this.u = lightCorrect;
        this.v = sectionData;
        this.w = entities;
        this.x = blockEntities;
        this.y = structureData;
        this.persistentDataContainer = persistentDataContainer;
    }

    public static ChunkCoordIntPair getChunkCoordinate(NBTTagCompound chunkData) {
        int dataVersion = IChunkLoader.a(chunkData);
        if (dataVersion < 2842) {
            NBTTagCompound levelData = chunkData.p("Level");
            return new ChunkCoordIntPair(levelData.h(a), levelData.h(b));
        }
        return new ChunkCoordIntPair(chunkData.h(a), chunkData.h(b));
    }

    public static long getLastWorldSaveTime(NBTTagCompound chunkData) {
        int dataVersion = IChunkLoader.a(chunkData);
        if (dataVersion < 2842) {
            NBTTagCompound levelData = chunkData.p("Level");
            return levelData.i("LastUpdate");
        }
        return chunkData.i("LastUpdate");
    }

    @Nullable
    public static SerializableChunkData a(LevelHeightAccessor world, IRegistryCustom registryManager, NBTTagCompound nbt) {
        BelowZeroRetrogen belowzeroretrogen;
        BlendingData.d blendingdata_d;
        Logger logger;
        DataResult dataresult;
        boolean flag;
        WorldServer serverLevel = (WorldServer)world;
        if (!nbt.b("Status", 8)) {
            return null;
        }
        if (nbt.b("DataVersion", 99)) {
            int dataVersion = nbt.h("DataVersion");
            if (!JUST_CORRUPT_IT && dataVersion > CURRENT_DATA_VERSION) {
                new RuntimeException("Server attempted to load chunk saved with newer version of minecraft! " + dataVersion + " > " + CURRENT_DATA_VERSION).printStackTrace();
                System.exit(1);
            }
        }
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(nbt.h(a), nbt.h(b));
        long i2 = nbt.i("LastUpdate");
        long j2 = nbt.i("InhabitedTime");
        ChunkStatus chunkstatus = ChunkStatus.a(nbt.l("Status"));
        ChunkConverter chunkconverter = nbt.b(B, 10) ? new ChunkConverter(nbt.p(B), world) : ChunkConverter.a;
        boolean bl = flag = chunkstatus.a(ChunkStatus.l) && nbt.c(d) != null && nbt.h("starlight.light_version") == 9;
        if (nbt.b("blending_data", 10)) {
            dataresult = BlendingData.d.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.p("blending_data"));
            logger = A;
            Objects.requireNonNull(logger);
            blendingdata_d = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(null);
        } else {
            blendingdata_d = null;
        }
        if (nbt.b("below_zero_retrogen", 10)) {
            dataresult = BelowZeroRetrogen.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.p("below_zero_retrogen"));
            logger = A;
            Objects.requireNonNull(logger);
            belowzeroretrogen = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(null);
        } else {
            belowzeroretrogen = null;
        }
        long[] along = nbt.b("carving_mask", 12) ? nbt.o("carving_mask") : null;
        NBTTagCompound nbttagcompound1 = nbt.p(c);
        EnumMap<HeightMap.Type, long[]> map = new EnumMap<HeightMap.Type, long[]>(HeightMap.Type.class);
        for (HeightMap.Type heightmap_type : chunkstatus.e()) {
            String s2 = heightmap_type.a();
            if (!nbttagcompound1.b(s2, 12)) continue;
            map.put(heightmap_type, nbttagcompound1.o(s2));
        }
        List<TickListChunk<Block>> list = TickListChunk.a(nbt.c(C, 10), (String s1) -> BuiltInRegistries.e.b(MinecraftKey.c(s1)), chunkcoordintpair);
        List<TickListChunk<FluidType>> list1 = TickListChunk.a(nbt.c(D, 10), (String s1) -> BuiltInRegistries.c.b(MinecraftKey.c(s1)), chunkcoordintpair);
        IChunkAccess.a ichunkaccess_a = new IChunkAccess.a(list, list1);
        NBTTagList nbttaglist = nbt.c("PostProcessing", 9);
        ShortList[] ashortlist = new ShortList[nbttaglist.size()];
        for (int k2 = 0; k2 < nbttaglist.size(); ++k2) {
            NBTTagList nbttaglist1 = nbttaglist.b(k2);
            ShortArrayList shortarraylist = new ShortArrayList(nbttaglist1.size());
            for (int l2 = 0; l2 < nbttaglist1.size(); ++l2) {
                shortarraylist.add(nbttaglist1.d(l2));
            }
            ashortlist[k2] = shortarraylist;
        }
        List list2 = Lists.transform((List)nbt.c("entities", 10), nbtbase -> (NBTTagCompound)nbtbase);
        List list3 = Lists.transform((List)nbt.c("block_entities", 10), nbtbase -> (NBTTagCompound)nbtbase);
        NBTTagCompound nbttagcompound2 = nbt.p("structures");
        NBTTagList nbttaglist2 = nbt.c(e, 10);
        ArrayList<b> list4 = new ArrayList<b>(nbttaglist2.size());
        IRegistry<BiomeBase> iregistry = registryManager.e(Registries.aI);
        Codec<DataPaletteBlock<Holder<BiomeBase>>> codec = SerializableChunkData.makeBiomeCodecRW(iregistry);
        for (int i1 = 0; i1 < nbttaglist2.size(); ++i1) {
            ChunkSection chunksection;
            NBTTagCompound nbttagcompound3;
            NBTTagCompound sectionData = nbttagcompound3 = nbttaglist2.a(i1);
            byte b0 = nbttagcompound3.f("Y");
            if (b0 >= world.ao() && b0 <= world.ap()) {
                DataPaletteBlock datapaletteblock;
                IBlockData[] presetBlockStates = serverLevel.chunkPacketBlockController.getPresetBlockStates(serverLevel, chunkcoordintpair, b0);
                if (nbttagcompound3.b("block_states", 10)) {
                    Codec<DataPaletteBlock<IBlockData>> blockStateCodec = presetBlockStates == null ? z : DataPaletteBlock.codecRW(Block.q, IBlockData.a, DataPaletteBlock.d.d, Blocks.a.m(), presetBlockStates);
                    datapaletteblock = (DataPaletteBlock)blockStateCodec.parse((DynamicOps)DynamicOpsNBT.a, (Object)sectionData.p("block_states")).promotePartial(s1 -> SerializableChunkData.a(chunkcoordintpair, b0, s1)).getOrThrow(a::new);
                } else {
                    datapaletteblock = new DataPaletteBlock(Block.q, Blocks.a.m(), DataPaletteBlock.d.d, presetBlockStates);
                }
                DataPaletteBlock object = nbttagcompound3.b("biomes", 10) ? (DataPaletteBlock)codec.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound3.p("biomes")).promotePartial(s1 -> SerializableChunkData.a(chunkcoordintpair, b0, s1)).getOrThrow(a::new) : new DataPaletteBlock(iregistry.t(), iregistry.b(Biomes.b), DataPaletteBlock.d.e, null);
                chunksection = new ChunkSection(datapaletteblock, object);
            } else {
                chunksection = null;
            }
            NibbleArray nibblearray = nbttagcompound3.b(f, 7) ? new NibbleArray(nbttagcompound3.m(f)) : null;
            NibbleArray nibblearray1 = nbttagcompound3.b(g, 7) ? new NibbleArray(nbttagcompound3.m(g)) : null;
            b serializableChunkData = new b(b0, chunksection, nibblearray, nibblearray1);
            if (sectionData.b("starlight.blocklight_state", 99)) {
                ((StarlightSectionData)serializableChunkData).starlight$setBlockLightState(sectionData.h("starlight.blocklight_state"));
            }
            if (sectionData.b("starlight.skylight_state", 99)) {
                ((StarlightSectionData)serializableChunkData).starlight$setSkyLightState(sectionData.h("starlight.skylight_state"));
            }
            list4.add(serializableChunkData);
        }
        return new SerializableChunkData(iregistry, chunkcoordintpair, world.ao(), i2, j2, chunkstatus, blendingdata_d, belowzeroretrogen, chunkconverter, along, map, ichunkaccess_a, ashortlist, flag, list4, list2, list3, nbttagcompound2, nbt.c("ChunkBukkitValues"));
    }

    private ProtoChunk loadStarlightLightData(WorldServer world, ProtoChunk ret) {
        boolean hasSkyLight = world.G_().g();
        int minSection = WorldUtil.getMinLightSection(world);
        SWMRNibbleArray[] blockNibbles = StarLightEngine.getFilledEmptyLight(world);
        SWMRNibbleArray[] skyNibbles = StarLightEngine.getFilledEmptyLight(world);
        if (!this.u) {
            ret.starlight$setBlockNibbles(blockNibbles);
            ret.starlight$setSkyNibbles(skyNibbles);
            return ret;
        }
        try {
            for (b sectionData : this.v) {
                int y2 = sectionData.a();
                NibbleArray blockLight = sectionData.c();
                NibbleArray skyLight = sectionData.d();
                int blockState = ((StarlightSectionData)sectionData).starlight$getBlockLightState();
                int skyState = ((StarlightSectionData)sectionData).starlight$getSkyLightState();
                if (blockState >= 0) {
                    blockNibbles[y2 - minSection] = blockLight != null ? new SWMRNibbleArray(MixinWorkarounds.clone(blockLight.a()), blockState) : new SWMRNibbleArray(null, blockState);
                }
                if (skyState < 0 || !hasSkyLight) continue;
                if (skyLight != null) {
                    skyNibbles[y2 - minSection] = new SWMRNibbleArray(MixinWorkarounds.clone(skyLight.a()), skyState);
                    continue;
                }
                skyNibbles[y2 - minSection] = new SWMRNibbleArray(null, skyState);
            }
            ret.starlight$setBlockNibbles(blockNibbles);
            ret.starlight$setSkyNibbles(skyNibbles);
        }
        catch (Throwable thr) {
            ret.a(false);
            A.error("Failed to parse light data for chunk " + String.valueOf(ret.f()) + " in world '" + WorldUtil.getWorldName(world) + "'", thr);
        }
        return ret;
    }

    public ProtoChunk a(WorldServer world, VillagePlace poiStorage, RegionStorageInfo key, ChunkCoordIntPair expectedPos) {
        IChunkAccess object;
        if (!Objects.equals(expectedPos, this.i)) {
            A.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{expectedPos, expectedPos, this.i});
            world.p().a(this.i, expectedPos, key);
        }
        int i2 = world.an();
        ChunkSection[] achunksection = new ChunkSection[i2];
        boolean flag = world.G_().g();
        ChunkProviderServer chunkproviderserver = world.m();
        LightEngineThreaded levellightengine = chunkproviderserver.a();
        IRegistry<BiomeBase> iregistry = world.K_().e(Registries.aI);
        boolean flag1 = false;
        for (b serializablechunkdata_b : this.v) {
            boolean flag3;
            SectionPosition sectionposition = SectionPosition.a(expectedPos, serializablechunkdata_b.a);
            if (serializablechunkdata_b.b != null) {
                achunksection[world.g((int)serializablechunkdata_b.a)] = serializablechunkdata_b.b;
            }
            boolean flag2 = serializablechunkdata_b.c != null;
            boolean bl = flag3 = flag && serializablechunkdata_b.d != null;
            if (!flag2 && !flag3) continue;
            if (!flag1) {
                ((LevelLightEngine)levellightengine).b(expectedPos, true);
                flag1 = true;
            }
            if (flag2) {
                ((LevelLightEngine)levellightengine).a(EnumSkyBlock.b, sectionposition, serializablechunkdata_b.c);
            }
            if (!flag3) continue;
            ((LevelLightEngine)levellightengine).a(EnumSkyBlock.a, sectionposition, serializablechunkdata_b.d);
        }
        ChunkType chunktype = this.m.d();
        if (chunktype == ChunkType.b) {
            LevelChunkTicks<Block> levelchunkticks = new LevelChunkTicks<Block>(this.s.a());
            LevelChunkTicks<FluidType> levelchunkticks1 = new LevelChunkTicks<FluidType>(this.s.b());
            object = new Chunk(world.a(), expectedPos, this.p, levelchunkticks, levelchunkticks1, this.l, achunksection, SerializableChunkData.a(world, this.w, this.x), BlendingData.a(this.n));
        } else {
            ProtoChunkTickList<Block> protochunkticklist = ProtoChunkTickList.a(this.s.a());
            ProtoChunkTickList<FluidType> protochunkticklist1 = ProtoChunkTickList.a(this.s.b());
            ProtoChunk protochunk = new ProtoChunk(expectedPos, this.p, achunksection, protochunkticklist, protochunkticklist1, world, iregistry, BlendingData.a(this.n));
            object = protochunk;
            protochunk.c(this.l);
            if (this.o != null) {
                protochunk.a(this.o);
            }
            protochunk.a(this.m);
            if (this.m.a(ChunkStatus.k)) {
                protochunk.a(levellightengine);
            }
        }
        if (this.persistentDataContainer instanceof NBTTagCompound) {
            ((IChunkAccess)object).persistentDataContainer.putAll((NBTTagCompound)this.persistentDataContainer);
        }
        ((IChunkAccess)object).a(this.u);
        EnumSet<HeightMap.Type> enumset = EnumSet.noneOf(HeightMap.Type.class);
        for (HeightMap.Type heightmap_type : ((IChunkAccess)object).n().e()) {
            long[] along = this.r.get(heightmap_type);
            if (along != null) {
                ((IChunkAccess)object).a(heightmap_type, along);
                continue;
            }
            enumset.add(heightmap_type);
        }
        HeightMap.a(object, enumset);
        ((IChunkAccess)object).a(SerializableChunkData.a(StructurePieceSerializationContext.a(world), this.y, world.D()));
        ((IChunkAccess)object).b(SerializableChunkData.a(world.K_(), expectedPos, this.y));
        for (int j2 = 0; j2 < this.t.length; ++j2) {
            ((IChunkAccess)object).a(this.t[j2], j2);
        }
        if (chunktype == ChunkType.b) {
            return this.loadStarlightLightData(world, new ProtoChunkExtension((Chunk)object, false));
        }
        IChunkAccess protochunk1 = object;
        for (NBTTagCompound nbttagcompound : this.w) {
            ((ProtoChunk)protochunk1).b(nbttagcompound);
        }
        for (NBTTagCompound nbttagcompound : this.x) {
            BlockPosition blockposition = TileEntity.b(nbttagcompound);
            if (blockposition.u() >> 4 != this.i.h || blockposition.w() >> 4 != this.i.i) {
                A.warn("Tile entity serialized in chunk {} in world '{}' positioned at {} is located outside of the chunk", new Object[]{this.i, world.getWorld().getName(), blockposition});
                continue;
            }
            protochunk1.a(nbttagcompound);
        }
        if (this.q != null) {
            ((ProtoChunk)protochunk1).a(new CarvingMask(this.q, object.L_()));
        }
        return this.loadStarlightLightData(world, (ProtoChunk)protochunk1);
    }

    private static void a(ChunkCoordIntPair chunkPos, int y2, String message) {
        A.error("Recoverable errors when loading section [{}, {}, {}]: {}", new Object[]{chunkPos.h, y2, chunkPos.i, message});
    }

    private static Codec<PalettedContainerRO<Holder<BiomeBase>>> a(IRegistry<BiomeBase> biomeRegistry) {
        return DataPaletteBlock.b(biomeRegistry.t(), biomeRegistry.r(), DataPaletteBlock.d.e, biomeRegistry.b(Biomes.b));
    }

    private static Codec<DataPaletteBlock<Holder<BiomeBase>>> makeBiomeCodecRW(IRegistry<BiomeBase> iregistry) {
        return DataPaletteBlock.codecRW(iregistry.t(), iregistry.r(), DataPaletteBlock.d.e, iregistry.b(Biomes.b), null);
    }

    public static SerializableChunkData a(WorldServer world, IChunkAccess chunk) {
        ArrayList<b> list;
        if (!chunk.s()) {
            throw new IllegalArgumentException("Chunk can't be serialized: " + String.valueOf(chunk));
        }
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        ArrayList<b> sections = list = new ArrayList<b>();
        ChunkSection[] achunksection = chunk.d();
        LightEngineThreaded lightenginethreaded = world.m().a();
        int minLightSection = WorldUtil.getMinLightSection(world);
        int maxLightSection = WorldUtil.getMaxLightSection(world);
        int minBlockSection = WorldUtil.getMinSection(world);
        ChunkSection[] chunkSections = chunk.d();
        SWMRNibbleArray[] blockNibbles = chunk.starlight$getBlockNibbles();
        SWMRNibbleArray[] skyNibbles = chunk.starlight$getSkyNibbles();
        for (int lightSection = minLightSection; lightSection <= maxLightSection; ++lightSection) {
            int lightSectionIdx = lightSection - minLightSection;
            int blockSectionIdx = lightSection - minBlockSection;
            ChunkSection chunkSection = blockSectionIdx >= 0 && blockSectionIdx < chunkSections.length ? chunkSections[blockSectionIdx].k() : null;
            SWMRNibbleArray.SaveState blockNibble = blockNibbles[lightSectionIdx].getSaveState();
            SWMRNibbleArray.SaveState skyNibble = skyNibbles[lightSectionIdx].getSaveState();
            if (chunkSection == null && blockNibble == null && skyNibble == null) continue;
            b sectionData = new b(lightSection, chunkSection, blockNibble == null ? null : (blockNibble.data == null ? null : new NibbleArray(blockNibble.data)), skyNibble == null ? null : (skyNibble.data == null ? null : new NibbleArray(skyNibble.data)));
            if (blockNibble != null) {
                ((StarlightSectionData)sectionData).starlight$setBlockLightState(blockNibble.state);
            }
            if (skyNibble != null) {
                ((StarlightSectionData)sectionData).starlight$setSkyLightState(skyNibble.state);
            }
            sections.add(sectionData);
        }
        ArrayList<NBTTagCompound> list1 = new ArrayList<NBTTagCompound>(chunk.c().size());
        for (BlockPosition blockposition : chunk.c()) {
            NBTTagCompound nbttagcompound = chunk.a(blockposition, world.K_());
            if (nbttagcompound == null) continue;
            list1.add(nbttagcompound);
        }
        ArrayList<NBTTagCompound> list2 = new ArrayList<NBTTagCompound>();
        long[] along = null;
        if (chunk.n().d() == ChunkType.a) {
            ProtoChunk protochunk = (ProtoChunk)chunk;
            list2.addAll(protochunk.I());
            CarvingMask carvingmask = protochunk.E();
            if (carvingmask != null) {
                along = carvingmask.a();
            }
        }
        EnumMap<HeightMap.Type, long[]> map = new EnumMap<HeightMap.Type, long[]>(HeightMap.Type.class);
        for (Map.Entry<HeightMap.Type, HeightMap> entry : chunk.e()) {
            if (!chunk.n().e().contains(entry.getKey())) continue;
            long[] along1 = entry.getValue().a();
            map.put(entry.getKey(), (long[])along1.clone());
        }
        IChunkAccess.a ichunkaccess_a = chunk.a(world.ac());
        ShortList[] ashortlist = (ShortList[])Arrays.stream(chunk.p()).map(shortlist -> shortlist != null ? new ShortArrayList(shortlist) : null).toArray(ShortList[]::new);
        NBTTagCompound nbttagcompound1 = SerializableChunkData.a(StructurePieceSerializationContext.a(world), chunkcoordintpair, chunk.g(), chunk.h());
        NBTTagCompound persistentDataContainer = null;
        if (!chunk.persistentDataContainer.isEmpty()) {
            persistentDataContainer = chunk.persistentDataContainer.toTagCompound();
        }
        return new SerializableChunkData(world.K_().e(Registries.aI), chunkcoordintpair, chunk.ao(), world.ac(), chunk.w(), chunk.n(), Optionull.a(chunk.v(), BlendingData::a), chunk.z(), chunk.t().c(), along, map, ichunkaccess_a, ashortlist, chunk.x(), list, list2, list1, nbttagcompound1, persistentDataContainer);
    }

    public NBTTagCompound a() {
        Logger logger;
        DataResult dataresult;
        NBTTagCompound nbttagcompound = GameProfileSerializer.e(new NBTTagCompound());
        nbttagcompound.a(a, this.i.h);
        nbttagcompound.a("yPos", this.j);
        nbttagcompound.a(b, this.i.i);
        nbttagcompound.a("LastUpdate", this.k);
        nbttagcompound.a("InhabitedTime", this.l);
        nbttagcompound.a("Status", BuiltInRegistries.l.b(this.m).toString());
        if (this.n != null) {
            dataresult = BlendingData.d.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.n);
            logger = A;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("blending_data", (NBTBase)nbtbase));
        }
        if (this.o != null) {
            dataresult = BelowZeroRetrogen.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.o);
            logger = A;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("below_zero_retrogen", (NBTBase)nbtbase));
        }
        if (!this.p.a()) {
            nbttagcompound.a(B, this.p.b());
        }
        NBTTagList nbttaglist = new NBTTagList();
        Codec<PalettedContainerRO<Holder<BiomeBase>>> codec = SerializableChunkData.a(this.h);
        Iterator<b> iterator = this.v.iterator();
        while (iterator.hasNext()) {
            NBTTagCompound nbttagcompound1;
            b serializablechunkdata_b;
            b sectionData = serializablechunkdata_b = iterator.next();
            NBTTagCompound sectionNBT = nbttagcompound1 = new NBTTagCompound();
            ChunkSection chunksection = serializablechunkdata_b.b;
            if (chunksection != null) {
                nbttagcompound1.a("block_states", (NBTBase)z.encodeStart((DynamicOps)DynamicOpsNBT.a, chunksection.h()).getOrThrow());
                nbttagcompound1.a("biomes", (NBTBase)codec.encodeStart((DynamicOps)DynamicOpsNBT.a, chunksection.i()).getOrThrow());
            }
            if (serializablechunkdata_b.c != null) {
                nbttagcompound1.a(f, serializablechunkdata_b.c.a());
            }
            if (serializablechunkdata_b.d != null) {
                nbttagcompound1.a(g, serializablechunkdata_b.d.a());
            }
            int blockState = ((StarlightSectionData)sectionData).starlight$getBlockLightState();
            int skyState = ((StarlightSectionData)sectionData).starlight$getSkyLightState();
            if (blockState > 0) {
                sectionNBT.a("starlight.blocklight_state", blockState);
            }
            if (skyState > 0) {
                sectionNBT.a("starlight.skylight_state", skyState);
            }
            if (nbttagcompound1.g()) continue;
            nbttagcompound1.a("Y", (byte)serializablechunkdata_b.a);
            nbttaglist.add(nbttagcompound1);
        }
        nbttagcompound.a(e, nbttaglist);
        if (this.u) {
            nbttagcompound.a(d, true);
        }
        NBTTagList nbttaglist1 = new NBTTagList();
        nbttaglist1.addAll(this.x);
        nbttagcompound.a("block_entities", nbttaglist1);
        if (this.m.d() == ChunkType.a) {
            NBTTagList nbttaglist2 = new NBTTagList();
            nbttaglist2.addAll(this.w);
            nbttagcompound.a("entities", nbttaglist2);
            if (this.q != null) {
                nbttagcompound.a("carving_mask", this.q);
            }
        }
        SerializableChunkData.a(nbttagcompound, this.s);
        nbttagcompound.a("PostProcessing", SerializableChunkData.a(this.t));
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        this.r.forEach((heightmap_type, along) -> nbttagcompound2.a(heightmap_type.a(), new NBTTagLongArray((long[])along)));
        nbttagcompound.a(c, nbttagcompound2);
        nbttagcompound.a("structures", this.y);
        if (this.persistentDataContainer != null) {
            nbttagcompound.a("ChunkBukkitValues", this.persistentDataContainer);
        }
        if (this.u && !this.m.d(ChunkStatus.l)) {
            nbttagcompound.a(d, false);
            nbttagcompound.a("starlight.light_version", 9);
        }
        return nbttagcompound;
    }

    private static void a(NBTTagCompound nbt, IChunkAccess.a schedulers) {
        NBTTagList nbttaglist = new NBTTagList();
        for (TickListChunk<Block> ticklistchunk : schedulers.a()) {
            nbttaglist.add(ticklistchunk.a(block -> BuiltInRegistries.e.b((Block)block).toString()));
        }
        nbt.a(C, nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (TickListChunk<FluidType> ticklistchunk1 : schedulers.b()) {
            nbttaglist1.add(ticklistchunk1.a(fluidtype -> BuiltInRegistries.c.b((FluidType)fluidtype).toString()));
        }
        nbt.a(D, nbttaglist1);
    }

    public static ChunkType a(@Nullable NBTTagCompound nbt) {
        return nbt != null ? ChunkStatus.a(nbt.l("Status")).d() : ChunkType.a;
    }

    @Nullable
    private static Chunk.c a(WorldServer world, List<NBTTagCompound> entities, List<NBTTagCompound> blockEntities) {
        return entities.isEmpty() && blockEntities.isEmpty() ? null : chunk -> {
            if (!entities.isEmpty()) {
                world.a(EntityTypes.a(entities, (World)world, EntitySpawnReason.r));
            }
            for (NBTTagCompound nbttagcompound : blockEntities) {
                boolean flag = nbttagcompound.q("keepPacked");
                if (flag) {
                    chunk.a(nbttagcompound);
                    continue;
                }
                BlockPosition blockposition = TileEntity.b(nbttagcompound);
                ChunkCoordIntPair chunkPos = chunk.f();
                if (blockposition.u() >> 4 != chunkPos.h || blockposition.w() >> 4 != chunkPos.i) {
                    A.warn("Tile entity serialized in chunk " + String.valueOf(chunkPos) + " in world '" + world.getWorld().getName() + "' positioned at " + String.valueOf(blockposition) + " is located outside of the chunk");
                    continue;
                }
                TileEntity tileentity = TileEntity.a(blockposition, chunk.a_(blockposition), nbttagcompound, world.K_());
                if (tileentity == null) continue;
                chunk.a(tileentity);
            }
        };
    }

    private static NBTTagCompound a(StructurePieceSerializationContext context, ChunkCoordIntPair pos, Map<Structure, StructureStart> starts, Map<Structure, LongSet> references) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        IRegistry<Structure> iregistry = context.b().e(Registries.aU);
        for (Map.Entry<Structure, StructureStart> entry : starts.entrySet()) {
            MinecraftKey minecraftkey = iregistry.b(entry.getKey());
            nbttagcompound1.a(minecraftkey.toString(), entry.getValue().a(context, pos));
        }
        nbttagcompound.a("starts", nbttagcompound1);
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        for (Map.Entry<Structure, LongSet> entry1 : references.entrySet()) {
            if (entry1.getValue().isEmpty()) continue;
            MinecraftKey minecraftkey1 = iregistry.b(entry1.getKey());
            nbttagcompound2.a(minecraftkey1.toString(), new NBTTagLongArray(entry1.getValue()));
        }
        nbttagcompound.a("References", nbttagcompound2);
        return nbttagcompound;
    }

    private static Map<Structure, StructureStart> a(StructurePieceSerializationContext context, NBTTagCompound nbt, long worldSeed) {
        HashMap map = Maps.newHashMap();
        IRegistry<Structure> iregistry = context.b().e(Registries.aU);
        NBTTagCompound nbttagcompound1 = nbt.p("starts");
        for (String s2 : nbttagcompound1.e()) {
            MinecraftKey minecraftkey = MinecraftKey.c(s2);
            Structure structure = iregistry.a(minecraftkey);
            if (structure == null) {
                A.error("Unknown structure start: {}", (Object)minecraftkey);
                continue;
            }
            StructureStart structurestart = StructureStart.a(context, nbttagcompound1.p(s2), worldSeed);
            if (structurestart == null) continue;
            NBTBase persistentBase = nbttagcompound1.p(s2).c("StructureBukkitValues");
            if (persistentBase instanceof NBTTagCompound) {
                structurestart.persistentDataContainer.putAll((NBTTagCompound)persistentBase);
            }
            map.put(structure, structurestart);
        }
        return map;
    }

    private static Map<Structure, LongSet> a(IRegistryCustom registryManager, ChunkCoordIntPair pos, NBTTagCompound nbt) {
        HashMap map = Maps.newHashMap();
        IRegistry<Structure> iregistry = registryManager.e(Registries.aU);
        NBTTagCompound nbttagcompound1 = nbt.p("References");
        for (String s2 : nbttagcompound1.e()) {
            MinecraftKey minecraftkey = MinecraftKey.c(s2);
            Structure structure = iregistry.a(minecraftkey);
            if (structure == null) {
                A.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)minecraftkey, (Object)pos);
                continue;
            }
            long[] along = nbttagcompound1.o(s2);
            if (along.length == 0) continue;
            map.put(structure, new LongOpenHashSet(Arrays.stream(along).filter(i2 -> {
                ChunkCoordIntPair chunkcoordintpair1 = new ChunkCoordIntPair(i2);
                if (chunkcoordintpair1.a(pos) > 8) {
                    A.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{minecraftkey, chunkcoordintpair1, pos});
                    return false;
                }
                return true;
            }).toArray()));
        }
        return map;
    }

    private static NBTTagList a(ShortList[] lists) {
        NBTTagList nbttaglist = new NBTTagList();
        ShortList[] ashortlist1 = lists;
        int i2 = lists.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            ShortList shortlist = ashortlist1[j2];
            NBTTagList nbttaglist1 = new NBTTagList();
            if (shortlist != null) {
                for (int k2 = 0; k2 < shortlist.size(); ++k2) {
                    nbttaglist1.add(NBTTagShort.a(shortlist.getShort(k2)));
                }
            }
            nbttaglist.add(nbttaglist1);
        }
        return nbttaglist;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SerializableChunkData.class, "biomeRegistry;chunkPos;minSectionY;lastUpdateTime;inhabitedTime;chunkStatus;blendingData;belowZeroRetrogen;upgradeData;carvingMask;heightmaps;packedTicks;postProcessingSections;lightCorrect;sectionData;entities;blockEntities;structureData;persistentDataContainer", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "persistentDataContainer"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SerializableChunkData.class, "biomeRegistry;chunkPos;minSectionY;lastUpdateTime;inhabitedTime;chunkStatus;blendingData;belowZeroRetrogen;upgradeData;carvingMask;heightmaps;packedTicks;postProcessingSections;lightCorrect;sectionData;entities;blockEntities;structureData;persistentDataContainer", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "persistentDataContainer"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SerializableChunkData.class, "biomeRegistry;chunkPos;minSectionY;lastUpdateTime;inhabitedTime;chunkStatus;blendingData;belowZeroRetrogen;upgradeData;carvingMask;heightmaps;packedTicks;postProcessingSections;lightCorrect;sectionData;entities;blockEntities;structureData;persistentDataContainer", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "persistentDataContainer"}, this, o2);
    }

    public IRegistry<BiomeBase> b() {
        return this.h;
    }

    public ChunkCoordIntPair c() {
        return this.i;
    }

    public int d() {
        return this.j;
    }

    public long e() {
        return this.k;
    }

    public long f() {
        return this.l;
    }

    public ChunkStatus g() {
        return this.m;
    }

    @Nullable
    public BlendingData.d h() {
        return this.n;
    }

    @Nullable
    public BelowZeroRetrogen i() {
        return this.o;
    }

    public ChunkConverter j() {
        return this.p;
    }

    @Nullable
    public long[] k() {
        return this.q;
    }

    public Map<HeightMap.Type, long[]> l() {
        return this.r;
    }

    public IChunkAccess.a m() {
        return this.s;
    }

    public ShortList[] n() {
        return this.t;
    }

    public boolean o() {
        return this.u;
    }

    public List<b> p() {
        return this.v;
    }

    public List<NBTTagCompound> q() {
        return this.w;
    }

    public List<NBTTagCompound> r() {
        return this.x;
    }

    public NBTTagCompound s() {
        return this.y;
    }

    @Nullable
    public NBTBase persistentDataContainer() {
        return this.persistentDataContainer;
    }

    public static final class b
    implements StarlightSectionData {
        private final int a;
        @Nullable
        private final ChunkSection b;
        @Nullable
        private final NibbleArray c;
        @Nullable
        private final NibbleArray d;
        private int blockLightState = -1;
        private int skyLightState = -1;

        @Override
        public final int starlight$getBlockLightState() {
            return this.blockLightState;
        }

        @Override
        public final void starlight$setBlockLightState(int state) {
            this.blockLightState = state;
        }

        @Override
        public final int starlight$getSkyLightState() {
            return this.skyLightState;
        }

        @Override
        public final void starlight$setSkyLightState(int state) {
            this.skyLightState = state;
        }

        public b(int y2, @Nullable ChunkSection chunkSection, @Nullable NibbleArray blockLight, @Nullable NibbleArray skyLight) {
            this.a = y2;
            this.b = chunkSection;
            this.c = blockLight;
            this.d = skyLight;
        }

        public int a() {
            return this.a;
        }

        @Nullable
        public ChunkSection b() {
            return this.b;
        }

        @Nullable
        public NibbleArray c() {
            return this.c;
        }

        @Nullable
        public NibbleArray d() {
            return this.d;
        }
    }

    public static class a
    extends NbtException {
        public a(String message) {
            super(message);
        }
    }
}

