/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.util.Optional;
import java.util.OptionalLong;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;

public final class DimensionManager
extends Record {
    private final OptionalLong l;
    private final boolean m;
    private final boolean n;
    private final boolean o;
    private final boolean p;
    private final double q;
    private final boolean r;
    private final boolean s;
    private final int t;
    private final int u;
    private final int v;
    private final TagKey<Block> w;
    private final MinecraftKey x;
    private final float y;
    private final a z;
    public static final int a = BlockPosition.e;
    public static final int b = 16;
    public static final int c = (1 << a) - 32;
    public static final int d = (c >> 1) - 1;
    public static final int e = d - c + 1;
    public static final int f = d << 4;
    public static final int g = e << 4;
    public static final Codec<DimensionManager> h = ExtraCodecs.d(RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.a((MapCodec<Optional<Long>>)Codec.LONG.lenientOptionalFieldOf("fixed_time")).forGetter(DimensionManager::f), (App)Codec.BOOL.fieldOf("has_skylight").forGetter(DimensionManager::g), (App)Codec.BOOL.fieldOf("has_ceiling").forGetter(DimensionManager::h), (App)Codec.BOOL.fieldOf("ultrawarm").forGetter(DimensionManager::i), (App)Codec.BOOL.fieldOf("natural").forGetter(DimensionManager::j), (App)Codec.doubleRange((double)1.0E-5f, (double)3.0E7).fieldOf("coordinate_scale").forGetter(DimensionManager::k), (App)Codec.BOOL.fieldOf("bed_works").forGetter(DimensionManager::l), (App)Codec.BOOL.fieldOf("respawn_anchor_works").forGetter(DimensionManager::m), (App)Codec.intRange((int)e, (int)d).fieldOf("min_y").forGetter(DimensionManager::n), (App)Codec.intRange((int)16, (int)c).fieldOf("height").forGetter(DimensionManager::o), (App)Codec.intRange((int)0, (int)c).fieldOf("logical_height").forGetter(DimensionManager::p), (App)TagKey.b(Registries.f).fieldOf("infiniburn").forGetter(DimensionManager::q), (App)MinecraftKey.a.fieldOf("effects").orElse((Object)BuiltinDimensionTypes.e).forGetter(DimensionManager::r), (App)Codec.FLOAT.fieldOf("ambient_light").forGetter(DimensionManager::s), (App)net.minecraft.world.level.dimension.DimensionManager$a.a.forGetter(DimensionManager::t)).apply((Applicative)instance, DimensionManager::new)));
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<DimensionManager>> i = ByteBufCodecs.b(Registries.aN);
    private static final int A = 8;
    public static final float[] j = new float[]{1.0f, 0.75f, 0.5f, 0.25f, 0.0f, 0.25f, 0.5f, 0.75f};
    public static final Codec<Holder<DimensionManager>> k = RegistryFileCodec.a(Registries.aN, h);

    public DimensionManager(OptionalLong fixedTime, boolean hasSkylight, boolean hasCeiling, boolean ultrawarm, boolean natural, double coordinateScale, boolean bedWorks, boolean piglinSafe, int minY, int height, int logicalHeight, TagKey<Block> infiniburn, MinecraftKey effects, float ambientLight, a monsterSettings) {
        if (height < 16) {
            throw new IllegalStateException("height has to be at least 16");
        }
        if (minY + height > d + 1) {
            throw new IllegalStateException("min_y + height cannot be higher than: " + (d + 1));
        }
        if (logicalHeight > height) {
            throw new IllegalStateException("logical_height cannot be higher than height");
        }
        if (height % 16 != 0) {
            throw new IllegalStateException("height has to be multiple of 16");
        }
        if (minY % 16 != 0) {
            throw new IllegalStateException("min_y has to be a multiple of 16");
        }
        this.l = fixedTime;
        this.m = hasSkylight;
        this.n = hasCeiling;
        this.o = ultrawarm;
        this.p = natural;
        this.q = coordinateScale;
        this.r = bedWorks;
        this.s = piglinSafe;
        this.t = minY;
        this.u = height;
        this.v = logicalHeight;
        this.w = infiniburn;
        this.x = effects;
        this.y = ambientLight;
        this.z = monsterSettings;
    }

    @Deprecated
    public static DataResult<ResourceKey<World>> a(Dynamic<?> nbt) {
        Optional optional = nbt.asNumber().result();
        if (optional.isPresent()) {
            int i2 = ((Number)optional.get()).intValue();
            if (i2 == -1) {
                return DataResult.success(World.j);
            }
            if (i2 == 0) {
                return DataResult.success(World.i);
            }
            if (i2 == 1) {
                return DataResult.success(World.k);
            }
        }
        return World.h.parse(nbt);
    }

    public static double a(DimensionManager fromDimension, DimensionManager toDimension) {
        double d2 = fromDimension.k();
        double e2 = toDimension.k();
        return d2 / e2;
    }

    public static Path a(ResourceKey<World> worldRef, Path worldDirectory) {
        if (worldRef == World.i) {
            return worldDirectory;
        }
        if (worldRef == World.k) {
            return worldDirectory.resolve("DIM1");
        }
        if (worldRef == World.j) {
            return worldDirectory.resolve("DIM-1");
        }
        return worldDirectory.resolve("dimensions").resolve(worldRef.a().b()).resolve(worldRef.a().a());
    }

    public boolean a() {
        return this.l.isPresent();
    }

    public float a(long time) {
        double d2 = MathHelper.e((double)this.l.orElse(time) / 24000.0 - 0.25);
        double e2 = 0.5 - Math.cos(d2 * Math.PI) / 2.0;
        return (float)(d2 * 2.0 + e2) / 3.0f;
    }

    public int b(long time) {
        return (int)(time / 24000L % 8L + 8L) % 8;
    }

    public boolean b() {
        return this.z.a();
    }

    public boolean c() {
        return this.z.b();
    }

    public IntProvider d() {
        return this.z.c();
    }

    public int e() {
        return this.z.d();
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{DimensionManager.class, "fixedTime;hasSkyLight;hasCeiling;ultraWarm;natural;coordinateScale;bedWorks;respawnAnchorWorks;minY;height;logicalHeight;infiniburn;effectsLocation;ambientLight;monsterSettings", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DimensionManager.class, "fixedTime;hasSkyLight;hasCeiling;ultraWarm;natural;coordinateScale;bedWorks;respawnAnchorWorks;minY;height;logicalHeight;infiniburn;effectsLocation;ambientLight;monsterSettings", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DimensionManager.class, "fixedTime;hasSkyLight;hasCeiling;ultraWarm;natural;coordinateScale;bedWorks;respawnAnchorWorks;minY;height;logicalHeight;infiniburn;effectsLocation;ambientLight;monsterSettings", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"}, this, object);
    }

    public OptionalLong f() {
        return this.l;
    }

    public boolean g() {
        return this.m;
    }

    public boolean h() {
        return this.n;
    }

    public boolean i() {
        return this.o;
    }

    public boolean j() {
        return this.p;
    }

    public double k() {
        return this.q;
    }

    public boolean l() {
        return this.r;
    }

    public boolean m() {
        return this.s;
    }

    public int n() {
        return this.t;
    }

    public int o() {
        return this.u;
    }

    public int p() {
        return this.v;
    }

    public TagKey<Block> q() {
        return this.w;
    }

    public MinecraftKey r() {
        return this.x;
    }

    public float s() {
        return this.y;
    }

    public a t() {
        return this.z;
    }

    public static final class a
    extends Record {
        private final boolean b;
        private final boolean c;
        private final IntProvider d;
        private final int e;
        public static final MapCodec<a> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("piglin_safe").forGetter(a::a), (App)Codec.BOOL.fieldOf("has_raids").forGetter(a::b), (App)IntProvider.b(0, 15).fieldOf("monster_spawn_light_level").forGetter(a::c), (App)Codec.intRange((int)0, (int)15).fieldOf("monster_spawn_block_light_limit").forGetter(a::d)).apply((Applicative)instance, a::new));

        public a(boolean bl, boolean bl2, IntProvider intProvider, int i2) {
            this.b = bl;
            this.c = bl2;
            this.d = intProvider;
            this.e = i2;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "piglinSafe;hasRaids;monsterSpawnLightTest;monsterSpawnBlockLightLimit", "b", "c", "d", "e"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "piglinSafe;hasRaids;monsterSpawnLightTest;monsterSpawnBlockLightLimit", "b", "c", "d", "e"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "piglinSafe;hasRaids;monsterSpawnLightTest;monsterSpawnBlockLightLimit", "b", "c", "d", "e"}, this, object);
        }

        public boolean a() {
            return this.b;
        }

        public boolean b() {
            return this.c;
        }

        public IntProvider c() {
            return this.d;
        }

        public int d() {
            return this.e;
        }
    }
}

