/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension.end;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.block.DragonEggFormEvent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.BossBattle;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.state.pattern.ShapeDetector;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBuilder;
import net.minecraft.world.level.block.state.predicate.BlockPredicate;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.end.EnumDragonRespawn;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.levelgen.feature.WorldGenEnder;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R2.boss.CraftDragonBattle;
import org.slf4j.Logger;

public class EnderDragonBattle {
    private static final Logger d = LogUtils.getLogger();
    private static final int e = 1200;
    private static final int f = 100;
    public static final int a = 20;
    private static final int g = 8;
    public static final int b = 9;
    public static final int h = 20;
    private static final int i = 96;
    public static final int c = 128;
    private final Predicate<Entity> j;
    private static final IChatBaseComponent DEFAULT_BOSS_EVENT_NAME = IChatBaseComponent.c("entity.minecraft.ender_dragon");
    public final BossBattleServer k = (BossBattleServer)new BossBattleServer(DEFAULT_BOSS_EVENT_NAME, BossBattle.BarColor.a, BossBattle.BarStyle.a).b(true).c(true);
    public final WorldServer l;
    private final BlockPosition m;
    public final ObjectArrayList<Integer> n = new ObjectArrayList();
    private final ShapeDetector o;
    private int p;
    private int q;
    private int r;
    private int s = 21;
    private boolean t;
    public boolean u;
    private boolean v = false;
    @Nullable
    public UUID w;
    private boolean x = true;
    @Nullable
    public BlockPosition y;
    @Nullable
    public EnumDragonRespawn z;
    private int A;
    @Nullable
    public List<EntityEnderCrystal> B;

    public EnderDragonBattle(WorldServer world, long gatewaysSeed, a data) {
        this(world, gatewaysSeed, data, BlockPosition.c);
    }

    public EnderDragonBattle(WorldServer world, long gatewaysSeed, a data, BlockPosition origin) {
        this.l = world;
        this.m = origin;
        this.j = IEntitySelector.a.and(IEntitySelector.a(origin.u(), 128 + origin.v(), origin.w(), 192.0));
        this.x = data.c;
        this.w = data.g.orElse(null);
        this.t = data.d;
        this.u = data.e;
        if (data.f) {
            this.z = EnumDragonRespawn.a;
        }
        if (data == net.minecraft.world.level.dimension.end.EnderDragonBattle$a.b && !world.paperConfig().entities.spawning.scanForLegacyEnderDragon) {
            this.x = false;
            this.t = true;
        }
        this.y = data.h.orElse(null);
        this.n.addAll((Collection)data.i.orElseGet(() -> {
            ObjectArrayList objectarraylist = new ObjectArrayList((Collection)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            SystemUtils.c(objectarraylist, RandomSource.a(gatewaysSeed));
            return objectarraylist;
        }));
        this.o = ShapeDetectorBuilder.a().a("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").a("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").a("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").a("  ###  ", " #   # ", "#     #", "#  #  #", "#     #", " #   # ", "  ###  ").a("       ", "  ###  ", " ##### ", " ##### ", " ##### ", "  ###  ", "       ").a('#', ShapeDetectorBlock.a(BlockPredicate.a(Blocks.I))).b();
    }

    @Deprecated
    @VisibleForTesting
    public void a() {
        this.v = true;
    }

    public a b() {
        return new a(this.x, this.t, this.u, false, Optional.ofNullable(this.w), Optional.ofNullable(this.y), Optional.of(this.n));
    }

    public void c() {
        this.k.d(!this.t);
        if (++this.s >= 20) {
            this.o();
            this.s = 0;
        }
        if (!this.k.g().isEmpty()) {
            this.l.m().a(TicketType.b, new ChunkCoordIntPair(0, 0), 9, Unit.a);
            boolean flag = this.n();
            if (this.x && flag) {
                this.j();
                this.x = false;
            }
            if (this.z != null) {
                if (this.B == null && flag) {
                    this.z = null;
                    this.tryRespawn();
                }
                this.z.a(this.l, this, this.B, this.A++, this.y);
            }
            if (!this.t) {
                if ((this.w == null || ++this.p >= 1200) && flag) {
                    this.k();
                    this.p = 0;
                }
                if (++this.r >= 100 && flag) {
                    this.p();
                    this.r = 0;
                }
            }
        } else {
            this.l.m().b(TicketType.b, new ChunkCoordIntPair(0, 0), 9, Unit.a);
        }
    }

    private void j() {
        d.info("Scanning for legacy world dragon fight...");
        boolean flag = this.l();
        if (flag) {
            d.info("Found that the dragon has been killed in this world already.");
            this.u = true;
        } else {
            d.info("Found that the dragon has not yet been killed in this world.");
            this.u = false;
            if (this.m() == null) {
                this.a(false);
            }
        }
        List<? extends EntityEnderDragon> list = this.l.j();
        if (list.isEmpty()) {
            this.t = true;
        } else {
            EntityEnderDragon entityenderdragon = list.get(0);
            this.w = entityenderdragon.cG();
            d.info("Found that there's a dragon still alive ({})", (Object)entityenderdragon);
            this.t = false;
            if (!flag && this.l.paperConfig().entities.behavior.shouldRemoveDragon) {
                d.info("But we didn't have a portal, let's remove it.");
                entityenderdragon.discard(null);
                this.w = null;
            }
        }
        if (!this.u && this.t) {
            this.t = false;
        }
    }

    private void k() {
        List<? extends EntityEnderDragon> list = this.l.j();
        if (list.isEmpty()) {
            d.debug("Haven't seen the dragon, respawning it");
            this.r();
        } else {
            d.debug("Haven't seen our dragon, but found another one to use.");
            this.w = list.get(0).cG();
        }
    }

    public void a(EnumDragonRespawn spawnState) {
        if (this.z == null) {
            throw new IllegalStateException("Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.A = 0;
        if (spawnState == EnumDragonRespawn.e) {
            this.z = null;
            this.t = false;
            EntityEnderDragon entityenderdragon = this.r();
            if (entityenderdragon != null) {
                for (EntityPlayer entityplayer : this.k.g()) {
                    CriterionTriggers.o.a(entityplayer, entityenderdragon);
                }
            }
        } else {
            this.z = spawnState;
        }
    }

    private boolean l() {
        for (int i2 = -8; i2 <= 8; ++i2) {
            block1: for (int j2 = -8; j2 <= 8; ++j2) {
                TileEntity tileentity;
                Chunk chunk = this.l.d(i2, j2);
                Iterator<TileEntity> iterator = chunk.I().values().iterator();
                do {
                    if (iterator.hasNext()) continue;
                    continue block1;
                } while (!((tileentity = iterator.next()) instanceof TileEntityEnderPortal));
                return true;
            }
        }
        return false;
    }

    @Nullable
    public ShapeDetector.ShapeDetectorCollection m() {
        int i2;
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(this.m);
        for (int j2 = -8 + chunkcoordintpair.h; j2 <= 8 + chunkcoordintpair.h; ++j2) {
            for (i2 = -8 + chunkcoordintpair.i; i2 <= 8 + chunkcoordintpair.i; ++i2) {
                Chunk chunk = this.l.d(j2, i2);
                for (TileEntity tileentity : chunk.I().values()) {
                    ShapeDetector.ShapeDetectorCollection shapedetector_shapedetectorcollection;
                    if (!(tileentity instanceof TileEntityEnderPortal) || (shapedetector_shapedetectorcollection = this.o.a(this.l, tileentity.aB_())) == null) continue;
                    BlockPosition blockposition = shapedetector_shapedetectorcollection.a(3, 3, 3).d();
                    if (this.y == null) {
                        this.y = blockposition;
                    }
                    return shapedetector_shapedetectorcollection;
                }
            }
        }
        BlockPosition blockposition1 = WorldGenEndTrophy.a(this.m);
        for (int k2 = i2 = this.l.a(HeightMap.Type.e, blockposition1).v(); k2 >= this.l.L_(); --k2) {
            ShapeDetector.ShapeDetectorCollection shapedetector_shapedetectorcollection1 = this.o.a(this.l, new BlockPosition(blockposition1.u(), k2, blockposition1.w()));
            if (shapedetector_shapedetectorcollection1 == null) continue;
            if (this.y == null) {
                this.y = shapedetector_shapedetectorcollection1.a(3, 3, 3).d();
            }
            return shapedetector_shapedetectorcollection1;
        }
        return null;
    }

    private boolean n() {
        if (this.v) {
            return true;
        }
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(this.m);
        for (int i2 = -8 + chunkcoordintpair.h; i2 <= 8 + chunkcoordintpair.h; ++i2) {
            for (int j2 = 8 + chunkcoordintpair.i; j2 <= 8 + chunkcoordintpair.i; ++j2) {
                IChunkAccess ichunkaccess = this.l.a(i2, j2, ChunkStatus.n, false);
                if (!(ichunkaccess instanceof Chunk)) {
                    return false;
                }
                FullChunkStatus fullchunkstatus = ((Chunk)ichunkaccess).F();
                if (fullchunkstatus.a(FullChunkStatus.c)) continue;
                return false;
            }
        }
        return true;
    }

    private void o() {
        HashSet set = Sets.newHashSet();
        for (EntityPlayer entityplayer : this.l.a(this.j)) {
            this.k.a(entityplayer);
            set.add(entityplayer);
        }
        HashSet set1 = Sets.newHashSet(this.k.g());
        set1.removeAll(set);
        for (EntityPlayer entityplayer1 : set1) {
            this.k.b(entityplayer1);
        }
    }

    private void p() {
        this.r = 0;
        this.q = 0;
        for (WorldGenEnder.Spike worldgenender_spike : WorldGenEnder.a(this.l)) {
            this.q += this.l.a(EntityEnderCrystal.class, worldgenender_spike.f()).size();
        }
        d.debug("Found {} end crystals still alive", (Object)this.q);
    }

    public void a(EntityEnderDragon dragon) {
        if (dragon.cG().equals(this.w)) {
            this.k.a(0.0f);
            this.k.d(false);
            this.a(true);
            this.q();
            BlockPosition eggPosition = this.l.a(HeightMap.Type.e, WorldGenEndTrophy.a(this.m));
            CraftBlockState eggState = CraftBlockStates.getBlockState(this.l, eggPosition);
            eggState.setData(Blocks.fO.m());
            DragonEggFormEvent eggEvent = new DragonEggFormEvent((Block)CraftBlock.at(this.l, eggPosition), (BlockState)eggState, (DragonBattle)new CraftDragonBattle(this));
            if (!this.l.paperConfig().entities.behavior.enderDragonsDeathAlwaysPlacesDragonEgg && this.u) {
                eggEvent.setCancelled(true);
            }
            if (eggEvent.callEvent()) {
                eggEvent.getNewState().update(true);
            }
            this.u = true;
            this.t = true;
        }
    }

    @Deprecated
    @VisibleForTesting
    public void d() {
        this.n.clear();
    }

    public boolean spawnNewGatewayIfPossible() {
        if (!this.n.isEmpty()) {
            this.q();
            return true;
        }
        return false;
    }

    public List<EntityEnderCrystal> getSpikeCrystals() {
        ArrayList<EntityEnderCrystal> endCrystals = new ArrayList<EntityEnderCrystal>();
        for (WorldGenEnder.Spike spike : WorldGenEnder.a(this.l)) {
            endCrystals.addAll(this.l.a(EntityEnderCrystal.class, spike.f()));
        }
        return endCrystals;
    }

    private void q() {
        if (!this.n.isEmpty()) {
            int i2 = (Integer)this.n.remove(this.n.size() - 1);
            int j2 = MathHelper.a(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)i2)));
            int k2 = MathHelper.a(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)i2)));
            this.a(new BlockPosition(j2, 75, k2));
        }
    }

    public void a(BlockPosition pos) {
        this.l.c(3000, pos, 0);
        this.l.K_().a(Registries.aL).flatMap(iregistry -> iregistry.a(EndFeatures.d)).ifPresent(holder_c -> ((WorldGenFeatureConfigured)holder_c.a()).a(this.l, this.l.m().g(), RandomSource.a(), pos));
    }

    public void a(boolean previouslyKilled) {
        WorldGenEndTrophy worldgenendtrophy = new WorldGenEndTrophy(previouslyKilled);
        if (this.y == null) {
            this.y = this.l.a(HeightMap.Type.f, WorldGenEndTrophy.a(this.m)).e();
            while (this.l.a_(this.y).a(Blocks.I) && this.y.v() > 63) {
                this.y = this.y.e();
            }
        }
        if (this.y.v() <= this.l.L_()) {
            this.y = this.y.h(this.l.L_() + 1);
        }
        if (worldgenendtrophy.a(WorldGenFeatureConfiguration.m, this.l, this.l.m().g(), RandomSource.a(), this.y)) {
            int i2 = MathHelper.e(4, 16);
            this.l.m().a.a(new ChunkCoordIntPair(this.y), i2);
        }
    }

    @Nullable
    private EntityEnderDragon r() {
        this.l.m(new BlockPosition(this.m.u(), 128 + this.m.v(), this.m.w()));
        EntityEnderDragon entityenderdragon = EntityTypes.Q.a(this.l, EntitySpawnReason.h);
        if (entityenderdragon != null) {
            entityenderdragon.a(this);
            entityenderdragon.c(this.m);
            entityenderdragon.gk().a(DragonControllerPhase.a);
            entityenderdragon.b(this.m.u(), 128 + this.m.v(), this.m.w(), this.l.A.i() * 360.0f, 0.0f);
            this.l.b(entityenderdragon);
            this.w = entityenderdragon.cG();
            this.h();
        }
        return entityenderdragon;
    }

    public void b(EntityEnderDragon dragon) {
        if (dragon.cG().equals(this.w)) {
            this.k.a(dragon.eE() / dragon.eS());
            this.p = 0;
            if (dragon.l_()) {
                this.k.a(dragon.p_());
            } else {
                this.k.a(DEFAULT_BOSS_EVENT_NAME);
            }
        }
    }

    public int e() {
        return this.q;
    }

    public void a(EntityEnderCrystal enderCrystal, DamageSource source) {
        if (this.z != null && this.B.contains(enderCrystal)) {
            d.debug("Aborting respawn sequence");
            this.z = null;
            this.A = 0;
            this.h();
            this.a(true);
        } else {
            this.p();
            Entity entity = this.l.a(this.w);
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                entityenderdragon.a(this.l, enderCrystal, enderCrystal.dw(), source);
            }
        }
    }

    public boolean f() {
        return this.u;
    }

    public boolean tryRespawn() {
        return this.tryRespawn(null);
    }

    public boolean tryRespawn(@Nullable BlockPosition placedEndCrystalPos) {
        if (this.t && this.z == null) {
            BlockPosition blockposition = this.y;
            if (blockposition == null) {
                d.debug("Tried to respawn, but need to find the portal first.");
                ShapeDetector.ShapeDetectorCollection shapedetector_shapedetectorcollection = this.m();
                if (shapedetector_shapedetectorcollection == null) {
                    d.debug("Couldn't find a portal, so we made one.");
                    this.a(true);
                } else {
                    d.debug("Found the exit portal & saved its location for next time.");
                }
                blockposition = this.y;
            }
            if (placedEndCrystalPos != null) {
                int dy = placedEndCrystalPos.v() - blockposition.v();
                if (dy != 0 && dy != 1) {
                    return false;
                }
                int dx = placedEndCrystalPos.u() - blockposition.u();
                int dz = placedEndCrystalPos.w() - blockposition.w();
                if (!(dx >= -1 && dx <= 1 && dz >= -3 && dz <= 3 || dx >= -3 && dx <= 3 && dz >= -1 && dz <= 1)) {
                    return false;
                }
            }
            ArrayList list = Lists.newArrayList();
            BlockPosition blockposition1 = blockposition.b(1);
            for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
                List<EntityEnderCrystal> list1 = this.l.a(EntityEnderCrystal.class, new AxisAlignedBB(blockposition1.a(enumdirection, 2)));
                if (list1.isEmpty()) {
                    return false;
                }
                list.addAll(list1);
            }
            d.debug("Found all crystals, respawning dragon.");
            return this.respawnDragon(list);
        }
        return false;
    }

    public boolean respawnDragon(List<EntityEnderCrystal> list) {
        if (this.t && this.z == null) {
            ShapeDetector.ShapeDetectorCollection shapedetector_shapedetectorcollection = this.m();
            while (shapedetector_shapedetectorcollection != null) {
                for (int i2 = 0; i2 < this.o.c(); ++i2) {
                    for (int j2 = 0; j2 < this.o.b(); ++j2) {
                        for (int k2 = 0; k2 < this.o.a(); ++k2) {
                            ShapeDetectorBlock shapedetectorblock = shapedetector_shapedetectorcollection.a(i2, j2, k2);
                            if (!shapedetectorblock.a().a(Blocks.I) && !shapedetectorblock.a().a(Blocks.fL)) continue;
                            this.l.b(shapedetectorblock.d(), Blocks.fN.m());
                        }
                    }
                }
                shapedetector_shapedetectorcollection = this.m();
            }
            this.z = EnumDragonRespawn.a;
            this.A = 0;
            this.a(false);
            this.B = list;
            return true;
        }
        return false;
    }

    public void h() {
        for (WorldGenEnder.Spike worldgenender_spike : WorldGenEnder.a(this.l)) {
            List<EntityEnderCrystal> list = this.l.a(EntityEnderCrystal.class, worldgenender_spike.f());
            for (EntityEnderCrystal entityendercrystal : list) {
                entityendercrystal.n(false);
                entityendercrystal.a((BlockPosition)null);
            }
        }
    }

    @Nullable
    public UUID i() {
        return this.w;
    }

    public static final class a
    extends Record {
        private final boolean c;
        private final boolean d;
        private final boolean e;
        private final boolean f;
        private final Optional<UUID> g;
        private final Optional<BlockPosition> h;
        private final Optional<List<Integer>> i;
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("NeedsStateScanning").orElse((Object)true).forGetter(a::a), (App)Codec.BOOL.fieldOf("DragonKilled").orElse((Object)false).forGetter(a::b), (App)Codec.BOOL.fieldOf("PreviouslyKilled").orElse((Object)false).forGetter(a::c), (App)Codec.BOOL.lenientOptionalFieldOf("IsRespawning", (Object)false).forGetter(a::d), (App)UUIDUtil.a.lenientOptionalFieldOf("Dragon").forGetter(a::e), (App)BlockPosition.a.lenientOptionalFieldOf("ExitPortalLocation").forGetter(a::f), (App)Codec.list((Codec)Codec.INT).lenientOptionalFieldOf("Gateways").forGetter(a::g)).apply((Applicative)instance, a::new));
        public static final a b = new a(true, false, false, false, Optional.empty(), Optional.empty(), Optional.empty());

        public a(boolean needsStateScanning, boolean dragonKilled, boolean previouslyKilled, boolean isRespawning, Optional<UUID> dragonUUID, Optional<BlockPosition> exitPortalLocation, Optional<List<Integer>> gateways) {
            this.c = needsStateScanning;
            this.d = dragonKilled;
            this.e = previouslyKilled;
            this.f = isRespawning;
            this.g = dragonUUID;
            this.h = exitPortalLocation;
            this.i = gateways;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "needsStateScanning;dragonKilled;previouslyKilled;isRespawning;dragonUUID;exitPortalLocation;gateways", "c", "d", "e", "f", "g", "h", "i"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "needsStateScanning;dragonKilled;previouslyKilled;isRespawning;dragonUUID;exitPortalLocation;gateways", "c", "d", "e", "f", "g", "h", "i"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "needsStateScanning;dragonKilled;previouslyKilled;isRespawning;dragonUUID;exitPortalLocation;gateways", "c", "d", "e", "f", "g", "h", "i"}, this, o2);
        }

        public boolean a() {
            return this.c;
        }

        public boolean b() {
            return this.d;
        }

        public boolean c() {
            return this.e;
        }

        public boolean d() {
            return this.f;
        }

        public Optional<UUID> e() {
            return this.g;
        }

        public Optional<BlockPosition> f() {
            return this.h;
        }

        public Optional<List<Integer>> g() {
            return this.i;
        }
    }
}

