/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import ca.spottedleaf.moonrise.common.util.ChunkSystem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.LevelEntityGetterAdapter;
import net.minecraft.world.level.entity.Visibility;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public class PersistentEntitySectionManager<T extends EntityAccess>
implements AutoCloseable {
    static final Logger a = LogUtils.getLogger();
    final Set<UUID> b = Sets.newHashSet();
    final LevelCallback<T> c;
    public final EntityPersistentStorage<T> d;
    private final EntityLookup<T> e = new EntityLookup();
    final EntitySectionStorage<T> f;
    private final LevelEntityGetter<T> g;
    private final Long2ObjectMap<Visibility> h = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<b> i = new Long2ObjectOpenHashMap();
    private final LongSet j = new LongOpenHashSet();
    private final Queue<ChunkEntities<T>> k = Queues.newConcurrentLinkedQueue();

    public PersistentEntitySectionManager(Class<T> entityClass, LevelCallback<T> handler, EntityPersistentStorage<T> dataAccess) {
        this.f = new EntitySectionStorage<T>(entityClass, (Long2ObjectFunction<Visibility>)this.h);
        this.h.defaultReturnValue((Object)Visibility.a);
        this.i.defaultReturnValue((Object)net.minecraft.world.level.entity.PersistentEntitySectionManager$b.a);
        this.c = handler;
        this.d = dataAccess;
        this.g = new LevelEntityGetterAdapter<T>(this.e, this.f);
    }

    public List<Entity> getEntities(ChunkCoordIntPair chunkCoordIntPair) {
        return this.f.b(chunkCoordIntPair.a()).flatMap(EntitySection::b).map(entity -> (Entity)entity).collect(Collectors.toList());
    }

    public boolean isPending(long pair) {
        return this.i.get(pair) == net.minecraft.world.level.entity.PersistentEntitySectionManager$b.b;
    }

    void a(long sectionPos, EntitySection<T> section) {
        if (section.a()) {
            this.f.e(sectionPos);
        }
    }

    private boolean b(T entity) {
        AsyncCatcher.catchOp("Entity add by UUID");
        if (!this.b.add(entity.cG())) {
            a.warn("UUID of added entity already exists: {}", entity);
            return false;
        }
        return true;
    }

    public boolean a(T entity) {
        return this.a(entity, false);
    }

    private boolean a(T entity, boolean existing) {
        Visibility visibility;
        AsyncCatcher.catchOp("Entity add");
        Entity entityCasted = (Entity)entity;
        boolean wasRemoved = entityCasted.dR();
        boolean screened = ChunkSystem.screenEntity((WorldServer)entityCasted.dW(), entityCasted, existing, true);
        if (!wasRemoved && entityCasted.dR() || !screened) {
            return false;
        }
        if (!this.b(entity)) {
            return false;
        }
        long i2 = SectionPosition.c(entity.dw());
        EntitySection<T> entitysection = this.f.c(i2);
        entitysection.a(entity);
        entity.a(new a((EntityAccess)entity, i2, entitysection));
        if (!existing) {
            this.c.g(entity);
        }
        if ((visibility = PersistentEntitySectionManager.a(entity, entitysection.c())).b()) {
            this.e(entity);
        }
        if (visibility.a()) {
            this.c(entity);
        }
        return true;
    }

    static <T extends EntityAccess> Visibility a(T entity, Visibility current) {
        return entity.dV() ? Visibility.c : current;
    }

    public void a(Stream<T> entities) {
        entities.forEach(entityaccess -> this.a(entityaccess, true));
    }

    public void b(Stream<T> entities) {
        entities.forEach(entityaccess -> this.a(entityaccess, false));
    }

    void c(T entity) {
        AsyncCatcher.catchOp("Entity start ticking");
        this.c.e(entity);
    }

    void d(T entity) {
        AsyncCatcher.catchOp("Entity stop ticking");
        this.c.d(entity);
    }

    void e(T entity) {
        AsyncCatcher.catchOp("Entity start tracking");
        this.e.a(entity);
        this.c.c(entity);
    }

    void f(T entity) {
        AsyncCatcher.catchOp("Entity stop tracking");
        this.c.b(entity);
        this.e.b(entity);
    }

    public void a(ChunkCoordIntPair chunkPos, FullChunkStatus levelType) {
        Visibility visibility = Visibility.a(levelType);
        this.a(chunkPos, visibility);
    }

    public void a(ChunkCoordIntPair chunkPos, Visibility trackingStatus) {
        AsyncCatcher.catchOp("Update chunk status");
        long i2 = chunkPos.a();
        if (trackingStatus == Visibility.a) {
            this.h.remove(i2);
            this.j.add(i2);
        } else {
            this.h.put(i2, (Object)trackingStatus);
            this.j.remove(i2);
            this.b(i2);
        }
        this.f.b(i2).forEach(entitysection -> {
            Visibility visibility1 = entitysection.a(trackingStatus);
            boolean flag = visibility1.b();
            boolean flag1 = trackingStatus.b();
            boolean flag2 = visibility1.a();
            boolean flag3 = trackingStatus.a();
            if (flag2 && !flag3) {
                entitysection.b().filter(entityaccess -> !entityaccess.dV()).forEach(this::d);
            }
            if (flag && !flag1) {
                entitysection.b().filter(entityaccess -> !entityaccess.dV()).forEach(this::f);
            } else if (!flag && flag1) {
                entitysection.b().filter(entityaccess -> !entityaccess.dV()).forEach(this::e);
            }
            if (!flag2 && flag3) {
                entitysection.b().filter(entityaccess -> !entityaccess.dV()).forEach(this::c);
            }
        });
    }

    public void b(long chunkPos) {
        AsyncCatcher.catchOp("Entity chunk save");
        b persistententitysectionmanager_b = (b)((Object)this.i.get(chunkPos));
        if (persistententitysectionmanager_b == net.minecraft.world.level.entity.PersistentEntitySectionManager$b.a) {
            this.c(chunkPos);
        }
    }

    private boolean a(long chunkPos, Consumer<T> action) {
        return this.storeChunkSections(chunkPos, action, false);
    }

    private boolean storeChunkSections(long i2, Consumer<T> consumer, boolean callEvent) {
        b persistententitysectionmanager_b = (b)((Object)this.i.get(i2));
        if (persistententitysectionmanager_b == net.minecraft.world.level.entity.PersistentEntitySectionManager$b.b) {
            return false;
        }
        List<T> list = this.f.b(i2).flatMap(entitysection -> entitysection.b().filter(EntityAccess::dU)).collect(Collectors.toList());
        if (list.isEmpty()) {
            if (persistententitysectionmanager_b == net.minecraft.world.level.entity.PersistentEntitySectionManager$b.c) {
                if (callEvent) {
                    CraftEventFactory.callEntitiesUnloadEvent(((EntityStorage)this.d).d, new ChunkCoordIntPair(i2), (List<Entity>)ImmutableList.of());
                }
                this.d.a(new ChunkEntities(new ChunkCoordIntPair(i2), ImmutableList.of()));
            }
            return true;
        }
        if (persistententitysectionmanager_b == net.minecraft.world.level.entity.PersistentEntitySectionManager$b.a) {
            this.c(i2);
            return false;
        }
        if (callEvent) {
            CraftEventFactory.callEntitiesUnloadEvent(((EntityStorage)this.d).d, new ChunkCoordIntPair(i2), list.stream().map(entity -> (Entity)entity).collect(Collectors.toList()));
        }
        this.d.a(new ChunkEntities(new ChunkCoordIntPair(i2), list));
        list.forEach(consumer);
        return true;
    }

    private void c(long chunkPos) {
        AsyncCatcher.catchOp("Entity chunk load request");
        this.i.put(chunkPos, (Object)net.minecraft.world.level.entity.PersistentEntitySectionManager$b.b);
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(chunkPos);
        CompletableFuture<ChunkEntities<T>> completablefuture = this.d.a(chunkcoordintpair);
        Queue<ChunkEntities<T>> queue = this.k;
        Objects.requireNonNull(this.k);
        ((CompletableFuture)completablefuture.thenAccept(queue::add)).exceptionally(throwable -> {
            a.error("Failed to read chunk {}", (Object)chunkcoordintpair, throwable);
            return null;
        });
    }

    private boolean d(long chunkPos) {
        AsyncCatcher.catchOp("Entity chunk unload process");
        boolean flag = this.storeChunkSections(chunkPos, entityaccess -> entityaccess.dc().forEach(this::g), true);
        if (!flag) {
            return false;
        }
        this.i.remove(chunkPos);
        return true;
    }

    private void g(EntityAccess entity) {
        entity.setRemoved(Entity.RemovalReason.c, EntityRemoveEvent.Cause.UNLOAD);
        entity.a(EntityInLevelCallback.a);
    }

    private void g() {
        this.j.removeIf(i2 -> this.h.get(i2) != Visibility.a ? true : this.d(i2));
    }

    private void h() {
        ChunkEntities<T> chunkentities;
        AsyncCatcher.catchOp("Entity chunk process pending loads");
        while ((chunkentities = this.k.poll()) != null) {
            chunkentities.b().forEach(entityaccess -> this.a(entityaccess, true));
            this.i.put(chunkentities.a().a(), (Object)net.minecraft.world.level.entity.PersistentEntitySectionManager$b.c);
            List<Entity> entities = this.getEntities(chunkentities.a());
            CraftEventFactory.callEntitiesLoadEvent(((EntityStorage)this.d).d, chunkentities.a(), entities);
        }
    }

    public void a() {
        AsyncCatcher.catchOp("Entity manager tick");
        this.h();
        this.g();
    }

    private LongSet i() {
        LongSet longset = this.f.a();
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(this.i)) {
            if (entry.getValue() != net.minecraft.world.level.entity.PersistentEntitySectionManager$b.c) continue;
            longset.add(entry.getLongKey());
        }
        return longset;
    }

    public void b() {
        AsyncCatcher.catchOp("Entity manager autosave");
        this.i().forEach(i2 -> {
            boolean flag;
            boolean bl = flag = this.h.get(i2) == Visibility.a;
            if (flag) {
                this.d(i2);
            } else {
                this.a(i2, (T entityaccess) -> {});
            }
        });
    }

    public void c() {
        AsyncCatcher.catchOp("Entity manager save");
        LongSet longset = this.i();
        while (!longset.isEmpty()) {
            this.d.a(false);
            this.h();
            longset.removeIf(i2 -> {
                boolean flag = this.h.get(i2) == Visibility.a;
                return flag ? this.d(i2) : this.a(i2, (T entityaccess) -> {});
            });
        }
        this.d.a(true);
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) throws IOException {
        if (save) {
            this.c();
        }
        this.d.close();
    }

    public boolean a(UUID uuid) {
        return this.b.contains(uuid);
    }

    public LevelEntityGetter<T> d() {
        return this.g;
    }

    public boolean a(BlockPosition pos) {
        return ((Visibility)((Object)this.h.get(ChunkCoordIntPair.a(pos)))).a();
    }

    public boolean a(ChunkCoordIntPair pos) {
        return ((Visibility)((Object)this.h.get(pos.a()))).a();
    }

    public boolean a(long chunkPos) {
        return this.i.get(chunkPos) == net.minecraft.world.level.entity.PersistentEntitySectionManager$b.c;
    }

    public void a(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("y").a("z").a("visibility").a("load_status").a("entity_count").a(writer);
        this.f.a().forEach(i2 -> {
            b persistententitysectionmanager_b = (b)((Object)((Object)this.i.get(i2)));
            this.f.a(i2).forEach(j2 -> {
                EntitySection<T> entitysection = this.f.d(j2);
                if (entitysection != null) {
                    try {
                        csvwriter.a(new Object[]{SectionPosition.b(j2), SectionPosition.c(j2), SectionPosition.d(j2), entitysection.c(), persistententitysectionmanager_b, entitysection.d()});
                    }
                    catch (IOException ioexception) {
                        throw new UncheckedIOException(ioexception);
                    }
                }
            });
        });
    }

    @VisibleForDebug
    public String e() {
        int i2 = this.b.size();
        return i2 + "," + this.e.b() + "," + this.f.b() + "," + this.i.size() + "," + this.h.size() + "," + this.k.size() + "," + this.j.size();
    }

    @VisibleForDebug
    public int f() {
        return this.e.b();
    }

    private static enum b {
        a,
        b,
        c;

    }

    private class a
    implements EntityInLevelCallback {
        private final T c;
        private long d;
        private EntitySection<T> e;

        a(EntityAccess entityaccess, long i2, EntitySection entitysection) {
            this.c = entityaccess;
            this.d = i2;
            this.e = entitysection;
        }

        @Override
        public void a() {
            BlockPosition blockposition = this.c.dw();
            long i2 = SectionPosition.c(blockposition);
            if (i2 != this.d) {
                AsyncCatcher.catchOp("Entity move");
                Visibility visibility = this.e.c();
                if (!this.e.b(this.c)) {
                    a.warn("Entity {} wasn't found in section {} (moving to {})", new Object[]{this.c, SectionPosition.a(this.d), i2});
                }
                PersistentEntitySectionManager.this.a(this.d, this.e);
                EntitySection entitysection = PersistentEntitySectionManager.this.f.c(i2);
                entitysection.a(this.c);
                this.e = entitysection;
                this.d = i2;
                this.a(visibility, entitysection.c());
            }
        }

        private void a(Visibility oldStatus, Visibility newStatus) {
            Visibility visibility3;
            Visibility visibility2 = PersistentEntitySectionManager.a(this.c, oldStatus);
            if (visibility2 == (visibility3 = PersistentEntitySectionManager.a(this.c, newStatus))) {
                if (visibility3.b()) {
                    PersistentEntitySectionManager.this.c.a(this.c);
                }
            } else {
                boolean flag = visibility2.b();
                boolean flag1 = visibility3.b();
                if (flag && !flag1) {
                    PersistentEntitySectionManager.this.f(this.c);
                } else if (!flag && flag1) {
                    PersistentEntitySectionManager.this.e(this.c);
                }
                boolean flag2 = visibility2.a();
                boolean flag3 = visibility3.a();
                if (flag2 && !flag3) {
                    PersistentEntitySectionManager.this.d(this.c);
                } else if (!flag2 && flag3) {
                    PersistentEntitySectionManager.this.c(this.c);
                }
                if (flag1) {
                    PersistentEntitySectionManager.this.c.a(this.c);
                }
            }
        }

        @Override
        public void a(Entity.RemovalReason reason) {
            Visibility visibility;
            AsyncCatcher.catchOp("Entity remove");
            if (!this.e.b(this.c)) {
                a.warn("Entity {} wasn't found in section {} (destroying due to {})", new Object[]{this.c, SectionPosition.a(this.d), reason});
            }
            if ((visibility = PersistentEntitySectionManager.a(this.c, this.e.c())).a()) {
                PersistentEntitySectionManager.this.d(this.c);
            }
            if (visibility.b()) {
                PersistentEntitySectionManager.this.f(this.c);
            }
            if (reason.a()) {
                PersistentEntitySectionManager.this.c.f(this.c);
            }
            PersistentEntitySectionManager.this.b.remove(this.c.cG());
            this.c.a(a);
            PersistentEntitySectionManager.this.a(this.d, this.e);
        }
    }
}

