/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.phys.Vec3D;

public class EntityPositionSource
implements PositionSource {
    public static final MapCodec<EntityPositionSource> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UUIDUtil.a.fieldOf("source_entity").forGetter(EntityPositionSource::b), (App)Codec.FLOAT.fieldOf("y_offset").orElse((Object)Float.valueOf(0.0f)).forGetter(entityPositionSource -> Float.valueOf(entityPositionSource.f))).apply((Applicative)instance, (uuid, yOffset) -> new EntityPositionSource(Either.right(Either.left(uuid)), yOffset.floatValue())));
    public static final StreamCodec<ByteBuf, EntityPositionSource> b = StreamCodec.a(ByteBufCodecs.h, EntityPositionSource::c, ByteBufCodecs.l, source -> Float.valueOf(source.f), (entityId, yOffset) -> new EntityPositionSource(Either.right(Either.right(entityId)), yOffset.floatValue()));
    private Either<Entity, Either<UUID, Integer>> e;
    private final float f;

    public EntityPositionSource(Entity entity, float yOffset) {
        this(Either.left(entity), yOffset);
    }

    private EntityPositionSource(Either<Entity, Either<UUID, Integer>> source, float yOffset) {
        this.e = source;
        this.f = yOffset;
    }

    @Override
    @Override
    public Optional<Vec3D> a(World world) {
        if (this.e.left().isEmpty()) {
            this.b(world);
        }
        return this.e.left().map(entity -> entity.du().b(0.0, this.f, 0.0));
    }

    private void b(World world) {
        this.e.map(Optional::of, entityId -> Optional.ofNullable(entityId.map(uuid -> {
            Entity entity;
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                entity = serverLevel.a((UUID)uuid);
            } else {
                entity = null;
            }
            return entity;
        }, world::a))).ifPresent(entity -> {
            this.e = Either.left(entity);
        });
    }

    private UUID b() {
        return this.e.map(Entity::cG, entityId -> entityId.map(Function.identity(), entityIdx -> {
            throw new RuntimeException("Unable to get entityId from uuid");
        }));
    }

    private int c() {
        return this.e.map(Entity::ar, entityId -> entityId.map(uuid -> {
            throw new IllegalStateException("Unable to get entityId from uuid");
        }, Function.identity()));
    }

    @Override
    public PositionSourceType<EntityPositionSource> a() {
        return PositionSourceType.b;
    }

    public static class a
    implements PositionSourceType<EntityPositionSource> {
        @Override
        @Override
        public MapCodec<EntityPositionSource> a() {
            return a;
        }

        @Override
        @Override
        public StreamCodec<ByteBuf, EntityPositionSource> b() {
            return b;
        }
    }
}

